/*
 * Decompiled with CFR 0.152.
 */
package daq;

import daq.RunCtlTags;
import daq.chan_descr;
import daq.chan_descriptions;
import daq.daq_xml_reply;
import daq.daq_xml_request;
import daq.read_prop;
import daq.write_prop;
import java.util.Vector;
import ttf.doocs.clnt.EqData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DAQConnect
implements RunCtlTags,
Runnable {
    private String daq_server_names;
    private daq_xml_request request;
    private daq_xml_reply reply;
    private EqData src_data;
    private EqData dst_data;
    private Vector<chan_descr> chanlist;
    private int localerror = 0;
    private boolean stop;
    private Thread timeThread = null;
    private long sleep_time;
    private int status;
    private long max_wait_time = 5000L;
    public static final int CON_ERR_OK = 0;
    public static final int CON_ERR_FSEND = 1;
    public static final int CON_ERR_FGETRR = 2;
    public static final int CON_ERR_PARSE_RR = 3;
    public static final int CON_ERR_BAD_RR = 4;
    public static final int CON_ERR_DIFF_REQ = 5;
    public static final int CON_ERR_FGETRP = 6;
    public static final int CON_ERR_PARSE_RP = 7;
    public static final int CON_ERR_BAD_RP = 8;
    public static final int CON_ERR_RP_TOO_LONG = 9;
    public static final int CON_ERR_NO_XML_FILE = 10;
    public static final int CON_ERR_XML_FILE = 11;
    public static final int CON_ERR_UNKNOWN = 12;
    public static final int CON_ERR_BAD_REQUEST = 13;
    public static final int CON_STS_IDLE = 0;
    public static final int CON_STS_ERROR = 1;
    public static final int CON_STS_READY = 2;
    public static final int CON_STS_PROGR = 3;
    public static final int CON_STS_OK = 4;
    public static final int CON_TIME_MAX = 5000;
    public static final double CON_TIME_RATIO = 1.1574074074074073E-5;
    public static String[] connect_errors = new String[]{"Ok", "Failed to send request to DAQ server", "Failed to get reqply via request", "Failed to parse reply via request", "Cannot proceed with the request due to BAD reply from DAQ server", "Requests are different", "Failed to get reply from DAQ server", "Failed to parse reply from DAQ server ", "Got BAD reply from DAQ server", "Too long waiting for reply from DAQ server", "XML file not found", "XML file parsing error", "Unknown", "BAD request"};

    public daq_xml_request get_request() {
        return this.request;
    }

    public boolean set_max_wait_time(long l) {
        if (l > 0L) {
            this.max_wait_time = l;
            return false;
        }
        return true;
    }

    public long get_max_wait_time() {
        return this.max_wait_time;
    }

    public String get_local_error() {
        return connect_errors[this.localerror];
    }

    public String get_reply() {
        if (this.reply != null) {
            return this.reply.reason;
        }
        return new String("Connect not initialized");
    }

    public int status() {
        if (this.status == 8 || this.status == 6 || this.status == 1) {
            return 1;
        }
        return this.status;
    }

    public String status_string() {
        return connect_errors[this.status];
    }

    public void set_daq_server(String string) {
        this.daq_server_names = string;
    }

    public DAQConnect() {
        this.init();
    }

    private void init() {
        this.reply = new daq_xml_reply();
        this.request = new daq_xml_request();
        this.daq_server_names = System.getenv("TTF2_DAQ_SERVERS") != null ? new String(System.getenv("TTF2_DAQ_SERVERS")) : new String("TTF2.DAQ/DAQ.SERVER/DAQ.DATA.SVR/:TTF2.DAQ/DAQ.SERVER2/DAQ.DATA.SVR/");
        this.chanlist = new Vector();
        this.stop = true;
        this.status = 0;
        this.src_data = new EqData();
        this.dst_data = new EqData();
    }

    public int set_start_time(int n) {
        if (n <= 0) {
            return -1;
        }
        if (this.request != null) {
            this.request.tstart = n;
        }
        return 0;
    }

    public int set_start_time(String string) {
        if (string == null || string.isEmpty()) {
            return -1;
        }
        int n = this.request.get_time_in_sec(string);
        if (n > 0) {
            this.request.tstart = n;
        }
        return n;
    }

    public int set_stop_time(int n) {
        if (n <= 0) {
            return -1;
        }
        if (this.request != null) {
            this.request.tstop = n;
        }
        return 0;
    }

    public int set_stop_time(String string) {
        if (string == null || string.isEmpty()) {
            return -1;
        }
        int n = this.request.get_time_in_sec(string);
        if (n > 0) {
            this.request.tstop = n;
        }
        return n;
    }

    public int set_experiment(String string) {
        if (string == null || string.isEmpty()) {
            return -1;
        }
        if (this.request != null) {
            this.request.exp = string;
        }
        return 0;
    }

    public String get_experiment() {
        return this.request.exp;
    }

    public int set_data_dir(String string) {
        if (string == null || string.isEmpty()) {
            return -1;
        }
        if (this.request != null) {
            this.request.data_dir = string;
        }
        return 0;
    }

    public String get_ctl_dir() {
        if (this.request != null) {
            return this.request.c_dir;
        }
        return null;
    }

    public int set_ctl_dir(String string) {
        if (string == null || string.isEmpty()) {
            return -1;
        }
        if (this.request != null) {
            this.request.c_dir = string;
        }
        return 0;
    }

    public int set_conf_file(String string) {
        if (string == null || string.isEmpty()) {
            return -1;
        }
        if (this.request != null) {
            this.request.conf = string;
        }
        return 0;
    }

    public int set_scan_mode(int n) {
        if (this.request != null) {
            this.request.scan_mode = n;
            System.out.println("SCAN MODE set:" + this.request.scan_mode);
            return n;
        }
        return 0;
    }

    public int set_run_first(int n) {
        if (n <= 0) {
            return -1;
        }
        if (this.request != null) {
            this.request.runfirst = n;
        }
        return 0;
    }

    public int set_run_last(int n) {
        if (n <= 0) {
            return -1;
        }
        if (this.request != null) {
            this.request.runlast = n;
        }
        return 0;
    }

    public int get_scan_mode() {
        return this.request.scan_mode;
    }

    public int set_comm_mode(int n) {
        block5: {
            block4: {
                if (n < 1) break block4;
                if (n <= 2) break block5;
            }
            return -1;
        }
        if (this.request != null) {
            this.request.comm_mode = n;
        }
        return 0;
    }

    public int set_request_type(int n) {
        block5: {
            block4: {
                if (n < 1) break block4;
                if (n <= 3) break block5;
            }
            return -1;
        }
        if (this.request != null) {
            this.request.req_type = n;
        }
        return 0;
    }

    public int add_channel(String string) {
        if (string == null || string.isEmpty()) {
            return -1;
        }
        return this.request.add_channel(string, 0);
    }

    public int add_file(String string) {
        if (string == null || string.isEmpty()) {
            return -1;
        }
        return this.request.add_file(string);
    }

    public int connect(String string) {
        int n = this.request.isValid();
        if (n != 0) {
            this.localerror = 13;
            this.status = 1;
            return n;
        }
        if (string != null) {
            this.daq_server_names = string;
        }
        this.src_data.init();
        this.dst_data.init();
        if (this.stop) {
            if (this.timeThread == null) {
                this.timeThread = new Thread(this);
                this.stop = false;
                this.timeThread.start();
            }
        } else {
            return -1;
        }
        this.status = 2;
        return 0;
    }

    @Override
    public void run() {
        int n;
        String[] stringArray = null;
        boolean bl = false;
        boolean bl2 = false;
        this.status = 3;
        if (this.daq_server_names.contains(":")) {
            int n2;
            String[] stringArray2 = this.daq_server_names.split(":");
            n = 0;
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                if (stringArray2[n2].trim().isEmpty()) continue;
                ++n;
            }
            if (n != 0) {
                stringArray = new String[n];
                n2 = 0;
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (stringArray2[i].trim().isEmpty()) continue;
                    stringArray[n2++] = stringArray2[i].trim();
                }
            }
        } else {
            stringArray = new String[]{this.daq_server_names};
        }
        if (stringArray == null || stringArray.length == 0) {
            this.status = 1;
            this.stop = true;
            return;
        }
        int n3 = stringArray.length;
        n = 0;
        while (!this.stop) {
            try {
                while (!bl) {
                    String string;
                    double d;
                    String string2 = new String(stringArray[n] + "DAQ.REQ");
                    System.out.println("CONNECT TRYING:" + string2);
                    write_prop write_prop2 = new write_prop(string2);
                    EqData eqData = new EqData();
                    eqData.set_xml(this.request.get_xml_request());
                    if (write_prop2.set_data(eqData)) {
                        if (++n != n3) continue;
                        this.status = 1;
                        bl = true;
                        continue;
                    }
                    int n4 = 5000;
                    if (this.request.tstart != -1L && this.request.tstop != -1L && n4 < (int)(d = ((double)this.request.tstop - (double)this.request.tstart) * 1.1574074074074073E-5) * 1000) {
                        n4 = (int)(d * 1000.0);
                    }
                    if (this.max_wait_time == 5000L) {
                        this.max_wait_time = n4;
                    }
                    read_prop read_prop2 = new read_prop(string2);
                    read_prop2.err_off_on(false);
                    long l = this.max_wait_time;
                    while ((l -= 10L) > 0L) {
                        string = read_prop2.get_data_string();
                        if (this.reply.parse_xml_reply(string = string.trim()) != 0) continue;
                        if (this.reply.request.req_id == this.request.req_id) {
                            if (!this.reply.reason.equals("Processing")) continue;
                            bl2 = true;
                            break;
                        }
                        Thread.sleep(10L);
                    }
                    if (bl2) {
                        bl2 = false;
                        string2 = new String(stringArray[n] + "DAQ.REP");
                        read_prop2 = new read_prop(string2);
                        read_prop2.err_off_on(false);
                        l = this.max_wait_time;
                        boolean bl3 = false;
                        while ((l -= 10L) > 0L) {
                            string = read_prop2.get_data_string();
                            if (this.reply.parse_xml_reply(string = string.trim()) != 0) continue;
                            int n5 = 0;
                            n5 = this.request.same_requests(this.reply.request);
                            if (n5 == 1) {
                                bl2 = true;
                                bl = true;
                                this.stop = true;
                                bl3 = true;
                                break;
                            }
                            Thread.sleep(10L);
                        }
                        if (bl2) continue;
                        if (!bl3) {
                            System.out.println("No REPLY from: " + string2 + "after  wait time:" + n4 + " ms");
                        } else {
                            System.out.println("INCONSISTENT REPLY from: " + string2);
                        }
                        if (++n != n3) continue;
                        this.status = 6;
                        bl = true;
                        continue;
                    }
                    System.out.println("No or bad reply after 101 tries:" + this.reply.reason);
                    if (++n != n3) continue;
                    this.status = 8;
                    bl = true;
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        if (bl2) {
            if (this.if_just_get_chan_list()) {
                if (this.reply.chan_descr != null) {
                    this.chanlist = this.reply.chan_descr.chans;
                    this.status = this.chanlist == null || this.chanlist.size() == 0 ? 1 : 4;
                } else {
                    this.status = 1;
                }
            } else if (this.reply.host != null && !this.reply.host.isEmpty() && this.reply.port > 0) {
                this.status = 4;
            } else {
                this.status = 1;
                this.localerror = 8;
            }
        }
        this.stop = true;
    }

    public int get_server_host_port(String string, int n) {
        if (this.reply.host != null && !this.reply.host.isEmpty() && this.reply.port > 0) {
            n = this.reply.port;
            string = this.reply.host;
            return 0;
        }
        return -1;
    }

    public daq_xml_reply get_server_reply() {
        return this.reply;
    }

    public void print_request() {
        this.request.print_xml_request();
    }

    public void print_reply() {
        this.reply.print();
    }

    public String get_error(int n) {
        if (n >= 0 && n <= 8) {
            return connect_errors[n];
        }
        return connect_errors[12];
    }

    String get_reply_error() {
        return this.reply.reason;
    }

    public boolean if_just_get_chan_list() {
        return this.request.req_type == 2;
    }

    public Vector<chan_descr> get_chan_list() {
        return this.chanlist;
    }

    public chan_descriptions get_chan_descriptions() {
        return this.reply.chan_descr;
    }

    public long get_start_time() {
        if (this.request.tstart > 0L) {
            return this.request.tstart;
        }
        return 0L;
    }

    public long get_stop_time() {
        if (this.request.tstop > 0L) {
            return this.request.tstop;
        }
        return 0L;
    }

    public Vector<String> get_file_list() {
        return this.reply.file_list;
    }

    public Vector<String> get_not_found_file_list() {
        return this.reply.nf_file_list;
    }

    public Vector<String> get_not_found_chan_list() {
        return this.reply.nf_chan_list;
    }
}

