/*
 * Decompiled with CFR 0.152.
 */
package tangoatk.jdoocs;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.core.AEntityList;
import fr.esrf.tangoatk.core.ATKException;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.BooleanScalarEvent;
import fr.esrf.tangoatk.core.BooleanSpectrumEvent;
import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.DevStateScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanScalarListener;
import fr.esrf.tangoatk.core.IBooleanSpectrum;
import fr.esrf.tangoatk.core.IBooleanSpectrumListener;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IDevStateScalarListener;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarHistory;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.IResultListener;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.IStringScalarListener;
import fr.esrf.tangoatk.core.IStringSpectrum;
import fr.esrf.tangoatk.core.IStringSpectrumListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.NumberSpectrumEvent;
import fr.esrf.tangoatk.core.ResultEvent;
import fr.esrf.tangoatk.core.StringScalarEvent;
import fr.esrf.tangoatk.core.StringSpectrumEvent;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import tangoatk.jddd.utils.TangoErrorHistory;
import ttf.doocs.clnt.ENSinfo;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCallback;
import ttf.doocs.clnt.EqData;
import ttf.doocs.clnt.ITangoToDoocs;
import ttf.doocs.clnt.time_t;
import ttf.doocs.clnt.u_char;

public class TangoToDoocs
implements ITangoToDoocs,
TangoConst,
INumberScalarListener,
IStringScalarListener,
IBooleanScalarListener,
IDevStateScalarListener,
ISpectrumListener,
IBooleanSpectrumListener,
IStringSpectrumListener,
IResultListener {
    private String dev_name;
    private String prop_name;
    private boolean is_cmd = false;
    private CommandInfo cmdinfo;
    private AttributeInfo attrinfo;
    private AEntityList atk_list = null;
    private IEntity list_obj = null;
    private TangoErrorHistory eh = null;
    private EqData ddIn;
    private EqData ddOut;
    private EqCallback DoocsCallback;
    private Object userDataObj;
    private volatile boolean cmd_result_available = false;
    private List cmd_outputList = null;
    private ATKException cmd_error = null;
    private boolean history_request = false;
    private boolean history_send = false;

    public TangoToDoocs(EqAdr adr, ENSinfo info, EqData dataOut) {
        dataOut.error(0);
        String tango_host = new String(info.hostname).trim();
        this.dev_name = tango_host.isEmpty() ? "tango:" + new String(info.server_name).trim() + "/" + adr.device() + "/" + adr.location() : "tango://" + new String(info.hostname).trim() + "/" + new String(info.server_name).trim() + "/" + adr.device() + "/" + adr.location();
        this.prop_name = adr.property();
        try {
            DeviceProxy dev_proxy = new DeviceProxy(this.dev_name);
            if (this.prop_name.equalsIgnoreCase("status") || this.prop_name.equalsIgnoreCase("state")) {
                this.is_cmd = false;
            } else {
                CommandInfo[] lst = dev_proxy.command_list_query();
                for (int icmds = 0; icmds < lst.length; ++icmds) {
                    if (!lst[icmds].cmd_name.equals(this.prop_name)) continue;
                    this.cmdinfo = lst[icmds];
                    this.is_cmd = true;
                    this.atk_list = new CommandList();
                    break;
                }
            }
            if (!this.is_cmd) {
                boolean is_attribute = false;
                AttributeInfo[] lst = dev_proxy.get_attribute_info();
                for (int iattrs = 0; iattrs < lst.length; ++iattrs) {
                    if (!lst[iattrs].name.equals(this.prop_name)) continue;
                    this.attrinfo = lst[iattrs];
                    is_attribute = true;
                    this.atk_list = new AttributeList();
                    break;
                }
                if (!is_attribute) {
                    String msg = this.dev_name + "/" + this.prop_name + " is not a valid Tango command or attribute name!";
                    dataOut.error(101, msg);
                    return;
                }
            }
            String adrStr = this.dev_name + "/" + this.prop_name;
            try {
                this.eh = new TangoErrorHistory();
                this.atk_list.addErrorListener((IErrorListener)this.eh.getErrorListener());
                this.list_obj = this.atk_list.add(adrStr);
            }
            catch (ConnectionException ex) {
                String msg = "Cannot connect to Tango property " + adrStr;
                Logger.getLogger(TangoToDoocs.class.getName()).log(Level.SEVERE, msg, ex);
                dataOut.error(101, msg);
            }
        }
        catch (DevFailed e) {
            Logger.getLogger(TangoToDoocs.class.getName()).log(Level.SEVERE, null, e);
            dataOut.error(101, e.errors[0].desc);
        }
    }

    public void set_model(EqData dataIn, EqData dataOut, float rate, EqCallback callBack, Object userData) {
        if (this.is_cmd) {
            String msg = "Cannot set a monitor on a Tango command!";
            Logger.getLogger(TangoToDoocs.class.getName()).log(Level.SEVERE, msg);
            dataOut.error(101, msg);
            return;
        }
        this.ddIn = dataIn;
        this.ddOut = dataOut;
        this.DoocsCallback = callBack;
        this.userDataObj = userData;
        if (this.history_request) {
            this.history_send = false;
            rate = 0.0f;
        }
        switch (this.attrinfo.data_format.value()) {
            case 0: {
                if (this.list_obj instanceof INumberScalar) {
                    ((INumberScalar)this.list_obj).addNumberScalarListener((INumberScalarListener)this);
                    break;
                }
                if (this.list_obj instanceof IStringScalar) {
                    ((IStringScalar)this.list_obj).addStringScalarListener((IStringScalarListener)this);
                    break;
                }
                if (this.list_obj instanceof IBooleanScalar) {
                    ((IBooleanScalar)this.list_obj).addBooleanScalarListener((IBooleanScalarListener)this);
                    break;
                }
                if (this.list_obj instanceof IDevStateScalar) {
                    ((IDevStateScalar)this.list_obj).addDevStateScalarListener((IDevStateScalarListener)this);
                    break;
                }
                String msg = "The requested scalar type is not implemented!";
                Logger.getLogger(TangoToDoocs.class.getName()).log(Level.SEVERE, msg);
                dataOut.error(101, msg);
                return;
            }
            case 1: {
                if (this.list_obj instanceof INumberSpectrum) {
                    ((INumberSpectrum)this.list_obj).addSpectrumListener((ISpectrumListener)this);
                    break;
                }
                if (this.list_obj instanceof IBooleanSpectrum) {
                    ((IBooleanSpectrum)this.list_obj).addBooleanSpectrumListener((IBooleanSpectrumListener)this);
                    break;
                }
                if (this.list_obj instanceof IStringSpectrum) {
                    ((IStringSpectrum)this.list_obj).addListener((IStringSpectrumListener)this);
                    break;
                }
                String msg = "The requested spectrum type is not implemented!";
                Logger.getLogger(TangoToDoocs.class.getName()).log(Level.SEVERE, msg);
                dataOut.error(101, msg);
                return;
            }
            case 2: {
                String msg = "Tango image attributes are not mapped!";
                Logger.getLogger(TangoToDoocs.class.getName()).log(Level.SEVERE, msg);
                dataOut.error(101, msg);
                return;
            }
        }
        this.atk_list.addErrorListener((IErrorListener)this);
        this.list_obj.refresh();
        if ((double)rate > 0.0) {
            this.atk_list.setRefreshInterval((int)(rate * 1000.0f));
            this.atk_list.startRefresher();
        }
    }

    public void remove_model() {
        if (this.atk_list == null || this.is_cmd) {
            return;
        }
        this.atk_list.stopRefresher();
        if (this.list_obj != null) {
            switch (this.attrinfo.data_format.value()) {
                case 0: {
                    if (this.list_obj instanceof INumberScalar) {
                        ((INumberScalar)this.list_obj).removeNumberScalarListener((INumberScalarListener)this);
                        break;
                    }
                    if (this.list_obj instanceof IStringScalar) {
                        ((IStringScalar)this.list_obj).removeStringScalarListener((IStringScalarListener)this);
                        break;
                    }
                    if (this.list_obj instanceof IBooleanScalar) {
                        ((IBooleanScalar)this.list_obj).removeBooleanScalarListener((IBooleanScalarListener)this);
                        break;
                    }
                    if (!(this.list_obj instanceof IDevStateScalar)) break;
                    ((IDevStateScalar)this.list_obj).removeDevStateScalarListener((IDevStateScalarListener)this);
                    break;
                }
                case 1: {
                    if (this.list_obj instanceof INumberSpectrum) {
                        ((INumberSpectrum)this.list_obj).removeSpectrumListener((ISpectrumListener)this);
                        break;
                    }
                    if (this.list_obj instanceof IBooleanSpectrum) {
                        ((IBooleanSpectrum)this.list_obj).removeBooleanSpectrumListener((IBooleanSpectrumListener)this);
                        break;
                    }
                    ((IStringSpectrum)this.list_obj).removeListener((IStringSpectrumListener)this);
                    break;
                }
            }
            this.atk_list.removeErrorListener((IErrorListener)this);
        }
        this.atk_list.removeAllElements();
    }

    public void get_value(EqData dataIn, EqData dataOut) {
        if (this.list_obj != null) {
            if (this.is_cmd) {
                return;
            }
            this.list_obj.refresh();
            block1 : switch (this.attrinfo.data_format.value()) {
                case 0: {
                    if (this.list_obj instanceof INumberScalar) {
                        double val = ((INumberScalar)this.list_obj).getNumberScalarValue();
                        dataOut.error(0);
                        switch (this.attrinfo.data_type) {
                            case 4: 
                            case 5: {
                                dataOut.set((float)val);
                                break block1;
                            }
                        }
                        dataOut.set((int)val);
                        break;
                    }
                    if (this.list_obj instanceof IStringScalar) {
                        String val = ((IStringScalar)this.list_obj).getStringValue();
                        dataOut.error(0);
                        dataOut.set(val);
                        break;
                    }
                    if (this.list_obj instanceof IBooleanScalar) {
                        boolean val = ((IBooleanScalar)this.list_obj).getValue();
                        dataOut.error(0);
                        if (val) {
                            dataOut.set(1);
                            break;
                        }
                        dataOut.set(0);
                        break;
                    }
                    if (this.list_obj instanceof IDevStateScalar) {
                        String val = ((IDevStateScalar)this.list_obj).getValue();
                        dataOut.error(0);
                        dataOut.set(val);
                        break;
                    }
                    String msg = "The requested scalar type is not implemented!";
                    Logger.getLogger(TangoToDoocs.class.getName()).log(Level.SEVERE, msg);
                    dataOut.error(101, msg);
                    return;
                }
                case 1: {
                    if (this.list_obj instanceof INumberSpectrum) {
                        double[] val = ((INumberSpectrum)this.list_obj).getSpectrumValue();
                        dataOut.error(0);
                        if (dataOut.type() == 19) {
                            float[] f_val = new float[val.length];
                            for (int i = 0; i < val.length; ++i) {
                                f_val[i] = (float)val[i];
                            }
                            dataOut.set("", new time_t(), 0.0f, 1.0f, 0, f_val, f_val.length);
                            break;
                        }
                        switch (this.attrinfo.data_type) {
                            case 4: 
                            case 5: {
                                dataOut.allocate_array(100, val.length, 0);
                                for (int i = 0; i < val.length; ++i) {
                                    dataOut.set((float)val[i], i);
                                }
                                break block1;
                            }
                            default: {
                                dataOut.allocate_array(105, val.length, 0);
                                for (int i = 0; i < val.length; ++i) {
                                    dataOut.set((int)val[i], i);
                                }
                                break block1;
                            }
                        }
                    }
                    if (this.list_obj instanceof IBooleanSpectrum) {
                        try {
                            boolean[] val = ((IBooleanSpectrum)this.list_obj).getValue();
                            dataOut.error(0);
                            if (dataOut.type() == 19) {
                                float[] f_val = new float[val.length];
                                for (int i = 0; i < val.length; ++i) {
                                    f_val[i] = val[i] ? 1.0f : 0.0f;
                                }
                                dataOut.set("", new time_t(), 0.0f, 1.0f, 0, f_val, f_val.length);
                                break;
                            }
                            dataOut.allocate_array(105, val.length, 0);
                            for (int i = 0; i < val.length; ++i) {
                                if (val[i]) {
                                    dataOut.set(1, i);
                                    continue;
                                }
                                dataOut.set(0, i);
                            }
                            break;
                        }
                        catch (DevFailed e) {
                            Logger.getLogger(TangoToDoocs.class.getName()).log(Level.SEVERE, null, e);
                            dataOut.error(101, e.errors[0].desc);
                            break;
                        }
                    }
                    if (this.list_obj instanceof IStringSpectrum) {
                        String[] val = ((IStringSpectrum)this.list_obj).getStringSpectrumValue();
                        dataOut.error(0);
                        dataOut.allocate_array(103, val.length, 0);
                        for (int i = 0; i < val.length; ++i) {
                            dataOut.set(val[i], i);
                        }
                        break;
                    }
                    String msg = "The requested spectrum type is not implemented!";
                    Logger.getLogger(TangoToDoocs.class.getName()).log(Level.SEVERE, msg);
                    dataOut.error(101, msg);
                    return;
                }
                case 2: {
                    String msg = "The requested image type is not implemented!";
                    Logger.getLogger(TangoToDoocs.class.getName()).log(Level.SEVERE, msg);
                    dataOut.error(101, msg);
                    return;
                }
            }
        }
    }

    public void set_value(EqData dataIn, EqData dataOut) {
        if (this.list_obj != null) {
            try {
                if (this.is_cmd) {
                    this.send_command(dataIn, dataOut);
                    return;
                }
                block1 : switch (this.attrinfo.data_format.value()) {
                    case 0: {
                        if (this.list_obj instanceof INumberScalar) {
                            float val = dataIn.get_float();
                            ((INumberScalar)this.list_obj).setValue((double)val);
                            break;
                        }
                        if (this.list_obj instanceof IStringScalar) {
                            String val = dataIn.get_string_arg();
                            ((IStringScalar)this.list_obj).setValue(val);
                            break;
                        }
                        if (this.list_obj instanceof IBooleanScalar) {
                            int val = dataIn.get_int();
                            if (val == 1) {
                                ((IBooleanScalar)this.list_obj).setValue(true);
                                break;
                            }
                            ((IBooleanScalar)this.list_obj).setValue(false);
                            break;
                        }
                        String msg = "The requested scalar type is not implemented!";
                        Logger.getLogger(TangoToDoocs.class.getName()).log(Level.SEVERE, msg);
                        dataOut.error(101, msg);
                        return;
                    }
                    case 1: {
                        if (this.list_obj instanceof INumberSpectrum) {
                            dataOut.error(0);
                            switch (this.attrinfo.data_type) {
                                case 4: 
                                case 5: {
                                    float[] val = dataIn.get_float_array();
                                    double[] d_val = new double[val.length];
                                    for (int i = 0; i < val.length; ++i) {
                                        d_val[i] = val[i];
                                    }
                                    ((INumberSpectrum)this.list_obj).setValue(d_val);
                                    break block1;
                                }
                            }
                            String msg = "The requested spectrum type is not implemented!";
                            Logger.getLogger(TangoToDoocs.class.getName()).log(Level.SEVERE, msg);
                            dataOut.error(101, msg);
                            break;
                        }
                        if (this.list_obj instanceof IBooleanSpectrum) {
                            String msg = "The requested spectrum type is not implemented!";
                            Logger.getLogger(TangoToDoocs.class.getName()).log(Level.SEVERE, msg);
                            dataOut.error(101, msg);
                            break;
                        }
                        String msg = "The requested spectrum type is not implemented!";
                        Logger.getLogger(TangoToDoocs.class.getName()).log(Level.SEVERE, msg);
                        dataOut.error(101, msg);
                        return;
                    }
                    case 2: {
                        String msg = "The requested image type is not implemented!";
                        Logger.getLogger(TangoToDoocs.class.getName()).log(Level.SEVERE, msg);
                        dataOut.error(101, msg);
                        return;
                    }
                }
            }
            catch (AttributeSetException e) {
                String msg = "Cannot apply set value to " + this.dev_name + "/" + this.prop_name;
                Logger.getLogger(TangoToDoocs.class.getName()).log(Level.SEVERE, msg);
                dataOut.error(101, msg);
                return;
            }
            dataOut.error(0);
        }
    }

    private void send_command(EqData dataIn, EqData dataOut) {
        ((ICommand)this.list_obj).addResultListener((IResultListener)this);
        this.atk_list.addErrorListener((IErrorListener)this);
        this.cmd_result_available = false;
        this.cmd_error = null;
        if (this.cmd_outputList != null) {
            this.cmd_outputList.clear();
        }
        if (((ICommand)this.list_obj).takesInput()) {
            Vector<String> inputList = new Vector<String>();
            if (((ICommand)this.list_obj).takesArrayInput()) {
                block20: for (int i = 0; i < dataIn.array_length(); ++i) {
                    switch (this.cmdinfo.in_type) {
                        case 16: {
                            inputList.add(dataIn.get_string(i));
                            continue block20;
                        }
                        case 12: {
                            Number val = Float.valueOf(dataIn.get_float(i));
                            inputList.add(((Float)val).toString());
                            continue block20;
                        }
                        default: {
                            Number val = (long)dataIn.get_int(i);
                            inputList.add(((Long)val).toString());
                            continue block20;
                        }
                    }
                }
            } else {
                switch (this.cmdinfo.in_type) {
                    case 8: {
                        inputList.add(dataIn.get_string());
                        break;
                    }
                    case 1: {
                        int val = dataIn.get_int();
                        if (val == 1) {
                            inputList.add("TRUE");
                            break;
                        }
                        inputList.add("FALSE");
                        break;
                    }
                    case 4: 
                    case 5: {
                        Float val = Float.valueOf(dataIn.get_float());
                        inputList.add(val.toString());
                        break;
                    }
                    default: {
                        Long val = dataIn.get_int();
                        inputList.add(val.toString());
                        break;
                    }
                }
            }
            ((ICommand)this.list_obj).execute(inputList);
        } else {
            ((ICommand)this.list_obj).execute();
        }
        while (!this.cmd_result_available) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
        if (this.cmd_error == null) {
            if (((ICommand)this.list_obj).doesOutput()) {
                if (((ICommand)this.list_obj).doesArrayOutput()) {
                    block22: for (int i = 0; i < this.cmd_outputList.size(); ++i) {
                        String res = (String)this.cmd_outputList.get(i);
                        switch (this.cmdinfo.in_type) {
                            case 16: {
                                if (i == 0) {
                                    dataOut.allocate_array(3, this.cmd_outputList.size(), 0);
                                }
                                dataOut.set(res, i);
                                continue block22;
                            }
                            case 12: 
                            case 13: {
                                if (i == 0) {
                                    dataOut.allocate_array(2, this.cmd_outputList.size(), 0);
                                }
                                float ret_val = Float.valueOf(res).floatValue();
                                dataOut.set(ret_val, i);
                                continue block22;
                            }
                            default: {
                                if (i == 0) {
                                    dataOut.allocate_array(1, this.cmd_outputList.size(), 0);
                                }
                                long ret_val = Long.valueOf(res);
                                dataOut.set((float)ret_val);
                                continue block22;
                            }
                        }
                    }
                } else {
                    String res = (String)this.cmd_outputList.get(0);
                    switch (this.cmdinfo.out_type) {
                        case 8: {
                            dataOut.set(res);
                            break;
                        }
                        case 1: {
                            if (res.equalsIgnoreCase("true")) {
                                dataOut.set(1);
                                break;
                            }
                            dataOut.set(0);
                            break;
                        }
                        case 4: 
                        case 5: {
                            float ret_val = Float.valueOf(res).floatValue();
                            dataOut.set(ret_val);
                            break;
                        }
                        default: {
                            long ret_val = Long.valueOf(res);
                            dataOut.set((float)ret_val);
                            break;
                        }
                    }
                }
            }
            dataOut.error(0);
        } else {
            dataOut.error(101, this.cmd_error.getDescription());
        }
    }

    public void numberScalarChange(NumberScalarEvent evt) {
        if (!this.history_request) {
            double val = evt.getValue();
            this.ddOut.error(0);
            this.ddOut.set_time((int)(System.currentTimeMillis() / 1000L));
            switch (this.attrinfo.data_type) {
                case 4: 
                case 5: {
                    this.ddOut.set((float)val);
                    break;
                }
                default: {
                    this.ddOut.set((int)val);
                }
            }
            if (this.DoocsCallback != null && this.DoocsCallback instanceof EqCallback) {
                this.DoocsCallback.dataCallback(this.ddOut, this.userDataObj);
            }
        } else if (!this.history_send) {
            INumberScalarHistory[] hist = ((INumberScalar)this.list_obj).getNumberScalarHistory();
            System.out.println("History length = " + hist.length);
            time_t mytm = new time_t((int)(System.currentTimeMillis() / 1000L));
            u_char st = new u_char(0);
            int hist_len = hist.length;
            if (hist.length > 1999) {
                hist_len = 1999;
            }
            this.ddOut.allocate_array(101, hist_len, 0);
            for (int i = 0; i < hist_len; ++i) {
                mytm.value = (int)(hist[i].getTimestamp() / 1000L);
                this.ddOut.set(mytm, (float)hist[i].getValue(), st, i);
            }
            if (this.DoocsCallback != null && this.DoocsCallback instanceof EqCallback) {
                this.DoocsCallback.dataCallback(this.ddOut, this.userDataObj);
            }
            this.history_send = true;
        }
    }

    public void stringScalarChange(StringScalarEvent evt) {
        String val = evt.getValue();
        this.ddOut.error(0);
        this.ddOut.set(val);
        if (this.DoocsCallback != null && this.DoocsCallback instanceof EqCallback) {
            this.DoocsCallback.dataCallback(this.ddOut, this.userDataObj);
        }
    }

    public void booleanScalarChange(BooleanScalarEvent evt) {
        boolean val = evt.getValue();
        this.ddOut.error(0);
        if (val) {
            this.ddOut.set(1);
        } else {
            this.ddOut.set(0);
        }
        if (this.DoocsCallback != null && this.DoocsCallback instanceof EqCallback) {
            this.DoocsCallback.dataCallback(this.ddOut, this.userDataObj);
        }
    }

    public void devStateScalarChange(DevStateScalarEvent evt) {
        String val = evt.getValue();
        this.ddOut.error(0);
        this.ddOut.set(val);
        if (this.DoocsCallback != null && this.DoocsCallback instanceof EqCallback) {
            this.DoocsCallback.dataCallback(this.ddOut, this.userDataObj);
        }
    }

    public void spectrumChange(NumberSpectrumEvent evt) {
        double[] val = ((INumberSpectrum)this.list_obj).getSpectrumValue();
        this.ddOut.error(0);
        switch (this.attrinfo.data_type) {
            case 4: 
            case 5: {
                this.ddOut.allocate_array(100, val.length, 0);
                for (int i = 0; i < val.length; ++i) {
                    this.ddOut.set((float)val[i], i);
                }
                break;
            }
            default: {
                this.ddOut.allocate_array(105, val.length, 0);
                for (int i = 0; i < val.length; ++i) {
                    this.ddOut.set((int)val[i], i);
                }
            }
        }
        if (this.DoocsCallback != null && this.DoocsCallback instanceof EqCallback) {
            this.DoocsCallback.dataCallback(this.ddOut, this.userDataObj);
        }
    }

    public void booleanSpectrumChange(BooleanSpectrumEvent evt) {
        try {
            boolean[] val = ((IBooleanSpectrum)this.list_obj).getValue();
            this.ddOut.error(0);
            this.ddOut.allocate_array(105, val.length, 0);
            for (int i = 0; i < val.length; ++i) {
                if (val[i]) {
                    this.ddOut.set(1, i);
                    continue;
                }
                this.ddOut.set(0, i);
            }
        }
        catch (DevFailed e) {
            this.ddOut.error(101, e.errors[0].desc);
            Except.print_exception((Exception)((Object)e));
        }
        if (this.DoocsCallback != null && this.DoocsCallback instanceof EqCallback) {
            this.DoocsCallback.dataCallback(this.ddOut, this.userDataObj);
        }
    }

    public void stringSpectrumChange(StringSpectrumEvent evt) {
        String[] val = ((IStringSpectrum)this.list_obj).getStringSpectrumValue();
        this.ddOut.error(0);
        this.ddOut.allocate_array(103, val.length, 0);
        for (int i = 0; i < val.length; ++i) {
            this.ddOut.set(val[i], i);
        }
        if (this.DoocsCallback != null && this.DoocsCallback instanceof EqCallback) {
            this.DoocsCallback.dataCallback(this.ddOut, this.userDataObj);
        }
    }

    public void errorChange(ErrorEvent errorevent) {
        if (this.is_cmd) {
            this.cmd_error = (ATKException)errorevent.getError();
            this.cmd_result_available = true;
            ((ICommand)this.list_obj).removeResultListener((IResultListener)this);
            return;
        }
        this.ddOut.error(101, ((ATKException)errorevent.getError()).getDescription());
        if (this.DoocsCallback != null && this.DoocsCallback instanceof EqCallback) {
            this.DoocsCallback.dataCallback(this.ddOut, this.userDataObj);
        }
    }

    public void stateChange(AttributeStateEvent e) {
    }

    public void resultChange(ResultEvent resultevent) {
        this.cmd_outputList = resultevent.getResult();
        this.cmd_result_available = true;
        ((ICommand)this.list_obj).removeResultListener((IResultListener)this);
    }
}

