/*
 * Decompiled with CFR 0.152.
 */
package runtime;

import DOOCSComponents.DOOCSLayeredPane;
import editor.about.About;
import editor.jddd;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.Monitoring;

public class FirstFrame
extends JFrame {
    JMenuBar m_MenuBar;
    JMenu m_FileMenu;
    JMenu m_ViewMenu;
    JMenu m_HelpMenu;
    JMenu submenu;
    DOOCSLayeredPane firstPanel;

    public FirstFrame(DOOCSLayeredPane lp) {
        this.setDefaultCloseOperation(3);
        this.firstPanel = lp;
        String usr = System.getProperty("user.name");
        String hostName = null;
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostName = "@" + addr.getHostName();
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        this.setTitle("jddd " + jddd.versionString + "/" + EqCall.versionString() + "  " + usr + hostName);
        this.m_MenuBar = new JMenuBar();
        this.m_FileMenu = new JMenu("File");
        this.m_ViewMenu = new JMenu("View");
        this.m_HelpMenu = new JMenu("Help");
        this.submenu = new JMenu("Visible Layers");
        JMenuItem mi = new JMenuItem("Open Local File...");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FirstFrame.this.firstPanel.evt_File_Open_ActionPerformed(e);
            }
        });
        this.m_FileMenu.add(mi);
        mi = new JMenuItem("Open Central File...");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FirstFrame.this.firstPanel.evt_File_OpenSvn_ActionPerformed(e);
            }
        });
        this.m_FileMenu.add(mi);
        this.m_FileMenu.addSeparator();
        mi = new JMenuItem("Print Panel...");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FirstFrame.this.firstPanel.printScreenshot(null);
            }
        });
        this.m_FileMenu.add(mi);
        mi = new JMenuItem("Save as png...");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FirstFrame.this.firstPanel.savePng(null);
            }
        });
        this.m_FileMenu.add(mi);
        mi = new JMenuItem("Print all monitors...");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Monitoring.printAllMonitors();
            }
        });
        this.m_FileMenu.add(mi);
        this.m_FileMenu.addSeparator();
        mi = new JMenuItem("Exit");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        this.m_FileMenu.add(mi);
        this.m_ViewMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent arg0) {
                FirstFrame.this.createViewMenu();
            }

            @Override
            public void menuDeselected(MenuEvent arg0) {
            }

            @Override
            public void menuCanceled(MenuEvent arg0) {
            }
        });
        mi = new JMenuItem("About this panel");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FirstFrame.this.firstPanel.showAbout();
            }
        });
        this.m_HelpMenu.add(mi);
        mi = new JMenuItem("About jddd");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FirstFrame.this.showJdddAbout();
            }
        });
        this.m_HelpMenu.add(mi);
        this.m_MenuBar.add(this.m_FileMenu);
        this.m_MenuBar.add(this.m_ViewMenu);
        this.m_MenuBar.add(this.m_HelpMenu);
        this.setJMenuBar(this.m_MenuBar);
    }

    private void createViewMenu() {
        this.m_ViewMenu.removeAll();
        this.submenu.removeAll();
        JCheckBoxMenuItem cmi = new JCheckBoxMenuItem("VACUUM", this.firstPanel.visibleLayer[1]);
        cmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FirstFrame.this.firstPanel.visibleLayer[1] = !FirstFrame.this.firstPanel.visibleLayer[1];
                FirstFrame.this.firstPanel.updateLayers(null);
            }
        });
        this.submenu.add(cmi);
        cmi = new JCheckBoxMenuItem("MAGNETS", this.firstPanel.visibleLayer[2]);
        cmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FirstFrame.this.firstPanel.visibleLayer[2] = !FirstFrame.this.firstPanel.visibleLayer[2];
                FirstFrame.this.firstPanel.updateLayers(null);
            }
        });
        this.submenu.add(cmi);
        cmi = new JCheckBoxMenuItem("BEAM_DIAG", this.firstPanel.visibleLayer[3]);
        cmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FirstFrame.this.firstPanel.visibleLayer[3] = !FirstFrame.this.firstPanel.visibleLayer[3];
                FirstFrame.this.firstPanel.updateLayers(null);
            }
        });
        this.submenu.add(cmi);
        cmi = new JCheckBoxMenuItem("RF", this.firstPanel.visibleLayer[4]);
        cmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FirstFrame.this.firstPanel.visibleLayer[4] = !FirstFrame.this.firstPanel.visibleLayer[4];
                FirstFrame.this.firstPanel.updateLayers(null);
            }
        });
        this.submenu.add(cmi);
        this.m_ViewMenu.add(this.submenu);
        final JCheckBoxMenuItem show = new JCheckBoxMenuItem("Show ToolTips", this.firstPanel.showToolTip);
        show.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FirstFrame.this.firstPanel.showToolTipText(show.getState());
            }
        });
        this.m_ViewMenu.add(show);
    }

    public void showJdddAbout() {
        new About((Frame)this, true).setVisible(true);
    }
}

