/*
 * Decompiled with CFR 0.152.
 */
package runtime;

import editor.ExampleFileFilter;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import java.io.File;
import javax.swing.JFileChooser;

public class EclipseFileChooser
extends PropertyEditorSupport {
    protected JFileChooser m_FileChooser;

    @Override
    public String getJavaInitializationString() {
        File f = (File)this.getValue();
        if (f == null) {
            return "null";
        }
        return "new java.io.File(\"" + f.getPath() + "\")";
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        if (this.m_FileChooser == null) {
            File currentFile = (File)this.getValue();
            if (currentFile != null) {
                this.m_FileChooser = new JFileChooser();
                this.m_FileChooser.setSelectedFile(currentFile);
            } else {
                this.m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
            }
            this.m_FileChooser.setApproveButtonText("Select");
            this.m_FileChooser.setApproveButtonMnemonic('S');
            this.m_FileChooser.setFileSelectionMode(0);
            ExampleFileFilter filter = new ExampleFileFilter();
            filter.addExtension("xml");
            filter.setDescription("xml files");
            this.m_FileChooser.setFileFilter(filter);
            this.m_FileChooser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String cmdString = e.getActionCommand();
                    if (cmdString.equals("ApproveSelection")) {
                        File newVal = EclipseFileChooser.this.m_FileChooser.getSelectedFile();
                        EclipseFileChooser.this.setValue(newVal);
                    }
                }
            });
        }
        return this.m_FileChooser;
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        File f = (File)this.getValue();
        String val = "No file";
        if (f != null) {
            val = f.getPath();
        }
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }
}

