/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot.utils;

import DOOCSPlot.utils.PlotDataTableModel;
import editor.ColorIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class PlotDataTableCellRenderer
implements TableCellRenderer {
    JLabel label = new JLabel();
    JCheckBox checkbox;

    public PlotDataTableCellRenderer() {
        this.label.setIconTextGap(4);
        this.checkbox = new JCheckBox();
    }

    public JLabel createIconLabel(String name) {
        JLabel iLabel = new JLabel();
        ImageIcon icon = null;
        URL imageUrl = this.getClass().getResource("/editor/icons/choiceIcons/" + name + ".gif");
        if (imageUrl != null) {
            icon = new ImageIcon(imageUrl);
        } else {
            imageUrl = this.getClass().getResource("/editor/icons/choiceIcons/" + name + ".png");
            if (imageUrl != null) {
                icon = new ImageIcon(imageUrl);
            }
        }
        iLabel.setIcon(icon);
        iLabel.setText(" " + name);
        iLabel.setHorizontalAlignment(2);
        return iLabel;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value != null) {
            String type = table.getModel().getValueAt(row, column).getClass().toString();
            this.label.setFont(new Font("arial", 0, 12));
            this.label.setIcon(null);
            this.label.setToolTipText(value.toString());
            if (type.endsWith("Color")) {
                Color col = (Color)value;
                this.label.setText(Integer.toString(col.getRed()) + "," + Integer.toString(col.getGreen()) + "," + Integer.toString(col.getBlue()));
                this.label.setIcon(new ColorIcon(col));
                this.label.setToolTipText("RGB value: " + col.toString());
                return this.label;
            }
            if (type.endsWith("String")) {
                this.label.setText(" " + value.toString());
                return this.label;
            }
            if (type.endsWith("BasicStroke")) {
                this.label.setText(Float.toString(((BasicStroke)value).getLineWidth()));
                return this.label;
            }
            if (type.endsWith("Boolean")) {
                if (value.toString().equalsIgnoreCase("true")) {
                    this.checkbox.setSelected(true);
                } else {
                    this.checkbox.setSelected(false);
                }
                this.checkbox.setToolTipText(value.toString());
                return this.checkbox;
            }
            if (type.endsWith("LineStyle") || type.endsWith("Marks")) {
                return (Component)((PlotDataTableModel)table.getModel()).getComponentAt(row, column);
            }
            this.label.setText(" " + value.toString());
            return this.label;
        }
        return null;
    }
}

