/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSPlot.DOOCSAdrList;
import DOOCSPlot.DOOCSChannel;
import DOOCSPlot.DOOCSPlot;
import DOOCSPlot.utils.EventNumberDialog;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;

public class DOOCSPlotSelection
extends JComponent {
    private transient DOOCSAdrList list;
    protected DOOCSPlot plot;
    public MathType mathType = MathType.NULL;
    public SelectionType type = SelectionType.NULL;
    private boolean isActiveFlag;
    public SelectionAxisType xType;
    public SelectionAxisType yType;
    private double xMin = 0.0;
    private double xMax = 0.0;
    private double yMin = 0.0;
    private double yMax = 0.0;
    private int ixMin;
    private int ixMax;
    private int iyMin;
    private int iyMax;
    public double timeRangeMin = 0.0;
    public double timeRangeMax = 0.0;
    public boolean timeRangeDefined = false;
    public double timeActual = 0.0;
    public double spectRangeMin = 0.0;
    public double spectRangeMax = 0.0;
    public boolean spectRangeDefined = false;
    public static double globalTimeRangeMin = 0.0;
    public static double globalTimeRangeMax = 0.0;
    public static boolean globalTimeRangeDefined = false;
    private boolean thisDefinesGlobalTime = false;
    public static double globalTimeActual = 0.0;
    public static double globalSpectRangeMin = 0.0;
    public static double globalSpectRangeMax = 0.0;
    public static boolean globalSpectRangeDefined = false;
    public static int eventActual = 0;
    public static int eventFirst = 0;
    public static int eventLast = 0;
    public static boolean eventDefined = false;
    public JDialog eventDialog = null;
    public Color selectionColor;
    public Stroke[] stroke;
    private int strokeIdx;
    private Point2D pt_s;
    private Point2D pt;

    public DOOCSPlotSelection(DOOCSAdrList l, DOOCSPlot p) {
        this.list = l;
        this.plot = p;
        this.pt = new Point2D.Double();
        float[] dashValues = new float[]{10.0f, 10.0f};
        this.stroke = new BasicStroke[4];
        this.stroke[0] = new BasicStroke(1.0f, 0, 2, 0.0f, dashValues, 0.0f);
        this.stroke[1] = new BasicStroke(1.0f, 0, 2, 0.0f, dashValues, 5.0f);
        this.stroke[2] = new BasicStroke(1.0f, 0, 2, 0.0f, dashValues, 10.0f);
        this.stroke[3] = new BasicStroke(1.0f, 0, 2, 0.0f, dashValues, 15.0f);
        this.strokeIdx = 0;
        this.isActiveFlag = true;
    }

    public void setLegend(List<DOOCSChannel> listCh) {
    }

    public void setType(SelectionType sel) {
        this.type = sel;
    }

    public void setRange(double xmin, double ymin, double xmax, double ymax) {
        this.xMin = xmin;
        this.xMax = xmax;
        this.yMin = ymin;
        this.yMax = ymax;
        if (this.plot.plotType == DOOCSPlot.PlotType.PLOTHIST && this.timeRangeDefined) {
            this.setTimeRange();
            if (this.thisDefinesGlobalTime) {
                this.setGlobalTimeRange();
            }
        }
        if (this.plot.plotType == DOOCSPlot.PlotType.PLOTSPECTRUM && this.spectRangeDefined) {
            this.setSpectRange();
        }
    }

    public void setGlobalRange(double xmin, double ymin, double xmax, double ymax) {
        this.xMin = xmin;
        this.xMax = xmax;
        this.yMin = ymin;
        this.yMax = ymax;
        if (globalTimeRangeDefined) {
            this.setGlobalTimeRange();
        }
        if (globalSpectRangeDefined) {
            this.setGlobalSpectRange();
        }
    }

    public void setRange(int ix1, int iy1, int ix2, int iy2, boolean doType) {
        double y2;
        double y;
        double x2;
        double x;
        int dscale = this.plot.doocsPlotAxisX.p1X - this.plot.doocsPlotAxisX.p0X;
        int mx1 = Math.min(ix1, ix2);
        int mx2 = Math.max(ix1, ix2);
        int my1 = Math.max(iy1, iy2);
        int my2 = Math.min(iy1, iy2);
        this.ixMin = mx1;
        this.iyMin = my1;
        this.ixMax = mx2;
        this.iyMax = my2;
        if (this.plot.doocsPlotAxisX.isLog) {
            x = (double)(mx1 - this.plot.doocsPlotAxisX.p0X) / (double)dscale * (Math.log10(this.plot.doocsPlotAxisX.actMax) - Math.log10(this.plot.doocsPlotAxisX.actMin)) + Math.log10(this.plot.doocsPlotAxisX.actMin);
            x = Math.pow(10.0, x);
            x2 = (double)(mx2 - this.plot.doocsPlotAxisX.p0X) / (double)dscale * (Math.log10(this.plot.doocsPlotAxisX.actMax) - Math.log10(this.plot.doocsPlotAxisX.actMin)) + Math.log10(this.plot.doocsPlotAxisX.actMin);
            x2 = Math.pow(10.0, x2);
        } else {
            x = (double)(mx1 - this.plot.doocsPlotAxisX.p0X) / (double)dscale * (this.plot.doocsPlotAxisX.actMax - this.plot.doocsPlotAxisX.actMin) + this.plot.doocsPlotAxisX.actMin;
            x2 = (double)(mx2 - this.plot.doocsPlotAxisX.p0X) / (double)dscale * (this.plot.doocsPlotAxisX.actMax - this.plot.doocsPlotAxisX.actMin) + this.plot.doocsPlotAxisX.actMin;
        }
        dscale = this.plot.doocsPlotAxisY.p1Y - this.plot.doocsPlotAxisY.p0Y;
        if (this.plot.doocsPlotAxisY.isLog) {
            y = (double)(this.plot.doocsPlotAxisY.p1Y - my1) / (double)dscale * (Math.log10(this.plot.doocsPlotAxisY.actMax) - Math.log10(this.plot.doocsPlotAxisY.actMin)) + Math.log10(this.plot.doocsPlotAxisY.actMin);
            y = Math.pow(10.0, y);
            y2 = (double)(this.plot.doocsPlotAxisY.p1Y - my2) / (double)dscale * (Math.log10(this.plot.doocsPlotAxisY.actMax) - Math.log10(this.plot.doocsPlotAxisY.actMin)) + Math.log10(this.plot.doocsPlotAxisY.actMin);
            y2 = Math.pow(10.0, y2);
        } else {
            y = (double)(this.plot.doocsPlotAxisY.p1Y - my1) / (double)dscale * (this.plot.doocsPlotAxisY.actMax - this.plot.doocsPlotAxisY.actMin) + this.plot.doocsPlotAxisY.actMin;
            y2 = (double)(this.plot.doocsPlotAxisY.p1Y - my2) / (double)dscale * (this.plot.doocsPlotAxisY.actMax - this.plot.doocsPlotAxisY.actMin) + this.plot.doocsPlotAxisY.actMin;
        }
        if (doType) {
            this.xType = mx1 <= this.plot.doocsPlotAxisX.p0X ? (mx2 >= this.plot.doocsPlotAxisX.p1X ? SelectionAxisType.MINMAXLIMIT : SelectionAxisType.MINLIMIT) : (mx2 >= this.plot.doocsPlotAxisX.p1X ? SelectionAxisType.MAXLIMIT : SelectionAxisType.BOTHIN);
            this.yType = my2 <= this.plot.doocsPlotAxisY.p0Y ? (my1 >= this.plot.doocsPlotAxisY.p1Y ? SelectionAxisType.MINMAXLIMIT : SelectionAxisType.MAXLIMIT) : (my1 >= this.plot.doocsPlotAxisY.p1Y ? SelectionAxisType.MINLIMIT : SelectionAxisType.BOTHIN);
        }
        this.setRange(x, y, x2, y2);
    }

    public boolean isIn(double x, double y) {
        double minX = this.plot.selectionXMin();
        double maxX = this.plot.selectionXMax();
        double minY = this.plot.selectionYMin();
        double maxY = this.plot.selectionYMax();
        boolean flag = y >= minY && y <= maxY;
        flag = flag && x >= minX && x <= maxX;
        return flag;
    }

    public void update() {
        if (this.eventDialog != null && this.eventDialog.isVisible()) {
            ((EventNumberDialog)this.eventDialog).updateData();
        }
    }

    public String timeToString(double sec) {
        Date date = new Date((long)sec * 1000L);
        String dateformat = "dd-MMM-yyyy";
        String timeformat = " HH:mm:ss.SSS";
        SimpleDateFormat dateFormatter = new SimpleDateFormat(dateformat);
        SimpleDateFormat timeFormatter = new SimpleDateFormat(timeformat);
        return new String("" + dateFormatter.format(date) + " " + timeFormatter.format(date));
    }

    public double getTimeRangeMin() {
        return this.timeRangeMin;
    }

    public double getTimeRangeMax() {
        return this.timeRangeMax;
    }

    public double getTimeActual() {
        return this.timeActual;
    }

    public double getGlobalTimeRangeMin() {
        return globalTimeRangeMin;
    }

    public double getGlobalTimeRangeMax() {
        return globalTimeRangeMax;
    }

    public double getGlobalTimeActual() {
        return globalTimeActual;
    }

    public int getEventActual() {
        if (eventDefined) {
            return eventActual;
        }
        return 0;
    }

    public int getEventFirst() {
        return eventFirst;
    }

    public int getEventLast() {
        return eventLast;
    }

    public double getSpectRangeMin() {
        return this.spectRangeMin;
    }

    public double getSpectRangeMax() {
        return this.spectRangeMax;
    }

    public boolean isSpectRangeDefined() {
        return this.spectRangeDefined;
    }

    public boolean isTimeRangeDefined() {
        return this.timeRangeDefined;
    }

    public boolean isGlobalTimeRangeDefined() {
        return globalTimeRangeDefined;
    }

    public boolean isEventDefined() {
        return eventDefined;
    }

    public String getTimeRangeMinString() {
        return this.timeToString(this.timeRangeMin);
    }

    public String getTimeRangeMaxString() {
        return this.timeToString(this.timeRangeMax);
    }

    public String getTimeActualString() {
        return this.timeToString(this.timeActual);
    }

    public String getGlobalTimeRangeMinString() {
        return this.timeToString(globalTimeRangeMin);
    }

    public String getGlobalTimeRangeMaxString() {
        return this.timeToString(globalTimeRangeMax);
    }

    public String getGlobalTimeActualString() {
        return this.timeToString(globalTimeActual);
    }

    public String getEventActualString() {
        return String.format("%d", eventActual);
    }

    public String getEventFirstString() {
        return String.format("%d", eventFirst);
    }

    public String getEventLastString() {
        return String.format("%d", eventLast);
    }

    public void setTimeRange() {
        this.timeRangeDefined = true;
        this.timeRangeMin = this.xMin;
        this.timeRangeMax = this.xMax;
        if (!(this.timeActual >= this.xMin) || !(this.timeActual <= this.xMax)) {
            this.timeActual = (this.xMin + this.xMax) / 2.0;
        }
        this.yType = SelectionAxisType.MINMAXLIMIT;
        this.update();
        this.plot.repaint();
    }

    public void setGlobalTimeRange() {
        this.timeRangeDefined = true;
        globalTimeRangeDefined = true;
        this.thisDefinesGlobalTime = true;
        if (globalTimeRangeMin != this.xMin || globalTimeRangeMax != this.xMax) {
            eventDefined = false;
        }
        globalTimeRangeMin = this.xMin;
        globalTimeRangeMax = this.xMax;
        if (!(globalTimeActual >= this.xMin) || !(globalTimeActual <= this.xMax)) {
            globalTimeActual = (this.xMin + this.xMax) / 2.0;
        }
        this.yType = SelectionAxisType.MINMAXLIMIT;
        this.update();
        this.plot.repaint();
    }

    public void setTimeRange(double startT, double stopT) {
        this.timeRangeDefined = true;
        if (this.timeRangeMin != startT || this.timeRangeMax != startT) {
            eventDefined = false;
        }
        this.timeRangeMin = startT;
        this.timeRangeMax = stopT;
        if (this.thisDefinesGlobalTime) {
            this.setGlobalTimeRange(startT, stopT);
        }
        this.yType = SelectionAxisType.MINMAXLIMIT;
    }

    public void setGlobalTimeRange(double startT, double stopT) {
        this.timeRangeDefined = true;
        globalTimeRangeDefined = true;
        this.thisDefinesGlobalTime = true;
        if (globalTimeRangeMin != startT || globalTimeRangeMax != startT) {
            eventDefined = false;
        }
        globalTimeRangeMin = startT;
        globalTimeRangeMax = stopT;
        this.yType = SelectionAxisType.MINMAXLIMIT;
        this.xType = SelectionAxisType.BOTHIN;
    }

    public void setSpectRange() {
        this.spectRangeDefined = true;
        this.spectRangeMin = this.xMin;
        this.spectRangeMax = this.xMax;
        this.update();
        this.plot.repaint();
    }

    public void setGlobalSpectRange() {
        globalSpectRangeDefined = true;
        globalSpectRangeMin = this.xMin;
        globalSpectRangeMax = this.xMax;
        this.update();
        this.plot.repaint();
    }

    public void setTimeActual(double t) {
        this.timeActual = t;
        this.update();
        this.plot.repaint();
    }

    public void setGlobalTimeActual(double t) {
        globalTimeActual = t;
        this.update();
        this.plot.repaint();
    }

    public void setEventActual(int evt) {
        eventActual = evt;
        if (evt != 0) {
            eventDefined = true;
        }
        this.update();
        this.plot.repaint();
    }

    public void setEventFirst(int evt) {
        eventFirst = evt;
    }

    public void setEventLast(int evt) {
        eventLast = evt;
    }

    public boolean isInSpectRange(double min, double max) {
        if (this.spectRangeDefined) {
            return min >= this.spectRangeMin && max <= this.spectRangeMax;
        }
        return true;
    }

    public boolean isInTimeRange(double min, double max) {
        if (this.timeRangeDefined) {
            return !(max < this.timeRangeMin) && (!(max > this.timeRangeMax) || !(min > this.timeRangeMax));
        }
        return true;
    }

    public boolean isInGlobalTimeRange(double min, double max) {
        if (globalTimeRangeDefined) {
            return !(max < globalTimeRangeMin) && (!(max > globalTimeRangeMax) || !(min > globalTimeRangeMax));
        }
        return true;
    }

    public double getXMin() {
        if (this.xType == SelectionAxisType.MINMAXLIMIT) {
            return this.plot.doocsPlotAxisX.actMin;
        }
        return this.xMin;
    }

    public double getXMax() {
        if (this.xType == null || this.xType == SelectionAxisType.MINMAXLIMIT) {
            return this.plot.doocsPlotAxisX.actMax;
        }
        return this.xMax;
    }

    public double getYMin() {
        if (this.yType == SelectionAxisType.MINMAXLIMIT) {
            return this.plot.doocsPlotAxisY.actMin;
        }
        return this.yMin;
    }

    public double getYMax() {
        if (this.yType == SelectionAxisType.MINMAXLIMIT) {
            return this.plot.doocsPlotAxisY.actMax;
        }
        return this.yMax;
    }

    public int getXMinAbs() {
        return this.ixMin;
    }

    public int getXMaxAbs() {
        return this.ixMax;
    }

    public int getYMinAbs() {
        return this.iyMin;
    }

    public int getYMaxAbs() {
        return this.iyMax;
    }

    public boolean isActive() {
        return this.isActiveFlag;
    }

    public void setActive(boolean flag) {
        this.isActiveFlag = flag;
        if (!flag) {
            this.setVisible(flag);
        }
    }

    public void setMathFct(MathType mt) {
        this.mathType = mt;
        this.list.createMathFct(null, this);
    }

    public MathType getMathFct() {
        return this.mathType;
    }

    public Point2D calcPoint(DOOCSPlot plot, AffineTransform tr, double x, double y) {
        Point2D.Double p = new Point2D.Double();
        if (plot.doocsPlotAxisX.isLog) {
            x = x <= 0.0 ? -20.0 : Math.log10(x);
        }
        if (plot.doocsPlotAxisY.isLog) {
            y = y <= 0.0 ? -20.0 : Math.log10(y);
        }
        this.pt_s = new Point2D.Double();
        this.pt_s.setLocation(x, y);
        tr.transform(this.pt_s, p);
        return p;
    }

    @Override
    public void paintComponent(Graphics g) {
        double ymax;
        double y;
        double xmax;
        double x;
        Graphics2D g2d = (Graphics2D)g;
        if (this.xType == SelectionAxisType.MINMAXLIMIT && this.yType == SelectionAxisType.MINMAXLIMIT) {
            return;
        }
        AffineTransform tr = this.plot.doocsAdrList.transformer;
        double xFull = x = this.plot.selectionXMin();
        double xMaxFull = xmax = this.plot.selectionXMax();
        double yFull = y = this.plot.selectionYMin();
        double yMaxFull = ymax = this.plot.selectionYMax();
        if (x < this.plot.doocsPlotAxisX.actMin) {
            x = this.plot.doocsPlotAxisX.actMin;
        }
        if (xmax > this.plot.doocsPlotAxisX.actMax) {
            xmax = this.plot.doocsPlotAxisX.actMax;
        }
        if (y < this.plot.doocsPlotAxisY.actMin) {
            y = this.plot.doocsPlotAxisY.actMin;
        }
        if (ymax > this.plot.doocsPlotAxisY.actMax) {
            ymax = this.plot.doocsPlotAxisY.actMax;
        }
        this.pt = this.calcPoint(this.plot, tr, x, y);
        int x1 = (int)this.pt.getX();
        int y1 = (int)this.pt.getY();
        if (y1 < 0) {
            y1 = 0;
        }
        if (x1 < 0) {
            x1 = 0;
        }
        this.pt = this.calcPoint(this.plot, tr, xmax, ymax);
        int x2 = (int)this.pt.getX();
        int y2 = (int)this.pt.getY();
        if (y2 < 0) {
            y2 = 0;
        }
        if (x2 < 0) {
            x2 = 0;
        }
        if (this.selectionColor == null) {
            this.selectionColor = new Color(100, 250, 100, 60);
        }
        g2d.setColor(this.selectionColor);
        if (Math.abs(x2 - x1) > 100000 || Math.abs(y2 - y1) > 100000) {
            return;
        }
        g2d.fillRect(x1, y2, Math.abs(x2 - x1), Math.abs(y2 - y1));
        int flag = 0;
        if (this.thisDefinesGlobalTime) {
            flag = 1;
        }
        if (globalSpectRangeDefined) {
            flag = 2;
        }
        if (flag > 0) {
            g2d.setColor(Color.MAGENTA);
        } else {
            g2d.setColor(Color.CYAN);
        }
        this.strokeIdx %= 4;
        g2d.setStroke(this.stroke[this.strokeIdx]);
        ++this.strokeIdx;
        g2d.drawRect(x1, y2, Math.abs(x2 - x1), Math.abs(y2 - y1));
        if (flag == 1) {
            g2d.drawString("T", Math.abs(x2 + x1) / 2, y1);
        }
        if (flag == 2) {
            g2d.drawString("t", Math.abs(x2 + x1) / 2, y1);
        }
        if (flag == 1) {
            this.pt = this.calcPoint(this.plot, tr, globalTimeActual, y);
            int xt = (int)this.pt.getX();
            if (xt >= x1 && xt <= x2) {
                g2d.drawLine(xt, y1, xt, y2);
            }
        }
        this.pt = this.calcPoint(this.plot, tr, xFull, yFull);
        x1 = (int)this.pt.getX();
        y1 = (int)this.pt.getY();
        this.pt = this.calcPoint(this.plot, tr, xMaxFull, yMaxFull);
        x2 = (int)this.pt.getX();
        y2 = (int)this.pt.getY();
        this.ixMin = x1;
        this.ixMax = x2;
        this.iyMin = Math.min(y1, y2);
        this.iyMax = Math.max(y1, y2);
    }

    public static enum SelectionAxisType {
        BOTHIN,
        MINLIMIT,
        MAXLIMIT,
        MINMAXLIMIT;

    }

    public static enum SelectionType {
        NULL,
        TIMERANGE,
        SPECTRANGE,
        POINT;

    }

    public static enum MathType {
        NULL,
        RMS,
        MINMAX,
        MEAN,
        FITLINE,
        DFT,
        GAUSS;

    }
}

