/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSPlot.DOOCSChannel;
import DOOCSPlot.DOOCSDataContainer;
import DOOCSPlot.DOOCSDataContainerSpect;
import DOOCSPlot.DOOCSPlotAxis;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import ttf.doocs.clnt.EqAdr;

public class DOOCSDataContainerSpectXY
extends DOOCSDataContainerSpect {
    private DOOCSDataContainer refContainer;
    private boolean setRequestRange = true;

    public DOOCSDataContainerSpectXY(DOOCSChannel ch) {
        super(ch);
        this.refContainer = this.channel.plot.doocsRefChannels.channels.get((int)0).dataContainer;
    }

    @Override
    public boolean update() {
        block15: {
            if (this.channel == null) {
                this.errorMsg = "Internal ERROR! No channel defined";
                return false;
            }
            if (this.firstRead) {
                this.readEGU();
                this.firstRead = false;
            }
            this.refContainer = this.channel.plot.doocsRefChannels.channels.get((int)0).dataContainer;
            try {
                int xmin = (int)this.channel.plot.doocsPlotAxisX.actMin;
                int xmax = (int)(this.channel.plot.doocsPlotAxisX.actMax + 0.5);
                int l = this.channel.plot.doocsPlotAxisX.pixelLength;
                int inc = 1;
                if ((xmax - xmin) / l > 10) {
                    inc = 16;
                } else if ((xmax - xmin) / l > 2) {
                    inc = 4;
                }
                int n = this.maxLength;
                if (xmax - xmin < n) {
                    n = xmax - xmin + 1;
                }
                this.data.init();
                if (this.setRequestRange) {
                    this.ed.set(-1, xmin, inc, n);
                    this.data.set_type(19);
                }
                this.eq.get(this.ea, this.ed, this.data);
                int i = this.data.error();
                if (i != 0) {
                    this.errorMsg = this.data.get_string();
                    this.hasData = false;
                    if (i == 73) {
                        this.setRequestRange = false;
                        this.ea.adr(this.channel.doocsAdr);
                        this.data.init();
                    }
                    break block15;
                }
                int len = this.data.array_length();
                if (len > this.maxLength) {
                    len = this.maxLength;
                }
                if (this.dataLength[1] < len) {
                    this.dataArray = new float[len];
                }
                try {
                    int code = this.data.get_spectrum(this.dataComment, this.dataLength, this.dataInc, this.dataStatus, this.dataTime, this.dataArray);
                    this.channel.plot.repaint();
                }
                catch (Exception e) {
                    boolean ixxx = false;
                }
                this.hasData = true;
                this.errorMsg = "";
            }
            catch (Exception e) {
                this.errorMsg = "Read ERROR!" + e.toString();
                this.hasData = false;
            }
        }
        this.hasNewData = this.hasData;
        return this.hasData;
    }

    @Override
    public void readEGU() {
        if (this.channel.doocsReadEGU) {
            EqAdr eaa = new EqAdr(this.channel.doocsAdr + ".EGU");
            try {
                String txt;
                this.data.init();
                this.data.set_type(16);
                this.eq.get(eaa, this.ed, this.data);
                this.eguText = this.data.error() == 0 ? ((txt = this.data.get_string_arg().trim()).length() > 0 ? "[" + txt + "]" : "") : "";
            }
            catch (Exception e) {
                this.errorMsg = "EGU read error";
            }
            this.descriptionMsg = this.facDev2Desc(this.channel.doocsAdr);
            eaa.adr(this.channel.doocsAdr + ".COMMENT");
            try {
                this.data.init();
                this.eq.get(eaa, this.ed, this.data);
                if (this.data.error() == 0) {
                    this.descriptionMsg = this.data.get_string_arg().trim();
                    if (this.descriptionMsg.length() < 2) {
                        this.descriptionMsg = this.facDev2Desc(this.channel.doocsAdr);
                    }
                } else {
                    String adr = this.ea.show_adr();
                    adr = adr.substring(adr.indexOf("/"));
                    this.descriptionMsg = adr.substring(adr.indexOf("/"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.channel.isRefChannel) {
                this.channel.plot.doocsPlotAxisX.eguText = this.eguText;
            }
        }
    }

    @Override
    public void autoScaleX(DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        if (this.channel.isRefChannel && this.hasData && this.data.error() == 0 && this.dataLength[1] > 0) {
            for (int i = 0; i < this.dataLength[1]; ++i) {
                double x = this.dataInc[0] + this.dataInc[1] * (float)i;
                if (!this.channel.plot.doocsPlotSelection.isInSpectRange(x, x) || xaxis.isLog && (double)this.dataArray[i] <= 0.0) continue;
                if ((double)this.dataArray[i] > xaxis.actMax) {
                    xaxis.actMax = this.dataArray[i];
                }
                if (!((double)this.dataArray[i] < xaxis.actMin)) continue;
                xaxis.actMin = this.dataArray[i];
            }
        }
    }

    @Override
    public void autoScaleY(DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        if (!this.channel.isRefChannel) {
            double xMin = xaxis.actMin;
            double xMax = xaxis.actMax;
            if (this.hasData && this.data.error() == 0 && this.dataLength[1] > 0) {
                for (int i = 0; i < this.dataLength[1]; ++i) {
                    double x;
                    double t = this.dataInc[0] + this.dataInc[1] * (float)i;
                    if (!this.channel.plot.doocsPlotSelection.isInSpectRange(t, t) || (x = this.getYofX(t)) < xMin || x > xMax || yaxis.isLog && (double)this.dataArray[i] <= 0.0) continue;
                    if ((double)this.dataArray[i] > yaxis.actMax) {
                        yaxis.actMax = this.dataArray[i];
                    }
                    if (!((double)this.dataArray[i] < yaxis.actMin)) continue;
                    yaxis.actMin = this.dataArray[i];
                }
            }
        }
    }

    @Override
    public double getYofX(double x) {
        if (this.refContainer == null) {
            return 0.0;
        }
        int idx = (int)Math.round((x - this.refContainer.getDataOffset()) / this.refContainer.getDataInc());
        if (idx > this.refContainer.getDataLength()) {
            return 0.0;
        }
        return this.refContainer.getYData(idx);
    }

    @Override
    public double getXData(int idx) {
        if (this.refContainer == null) {
            return 0.0;
        }
        if (idx > this.refContainer.getDataLength()) {
            return 0.0;
        }
        return this.refContainer.getYData(idx);
    }

    @Override
    void paintComponent(Graphics g, DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        if (!this.channel.isRefChannel) {
            int x2 = 0;
            int y2 = 0;
            int x0 = 0;
            double xmin = xaxis.actMin;
            double xmax = xaxis.actMax;
            Point2D.Double po = new Point2D.Double();
            Graphics2D g2d = (Graphics2D)g;
            AffineTransform tr = this.channel.plot.doocsAdrList.transformer;
            g2d.setColor(this.channel.lineColor);
            g2d.setStroke(this.channel.strokeSize);
            Color col = this.channel.lineColor;
            int intColorFg = this.prepareDraw(g, col, tr, xaxis, yaxis);
            Rectangle clip = g.getClipBounds();
            if (this.hasData && this.data.error() == 0) {
                String tmp;
                if (this.dataLength[0] > 0 && (tmp = new String(this.dataComment).substring(0, this.dataLength[0] - 1).trim()).length() > 0) {
                    this.descriptionMsg = new String(this.dataComment).substring(0, this.dataLength[0] - 1);
                }
                boolean n = false;
                if (this.dataLength[1] > 0) {
                    double t = this.dataInc[0];
                    double x = this.getYofX(t);
                    double y = yaxis.isLog ? Math.log10(yaxis.actMin) : 0.0;
                    ((Point2D)po).setLocation(x, y);
                    tr.transform(po, this.pt);
                    int y0 = (int)this.pt.getY();
                    if (xaxis.isLog) {
                        x = x <= 0.0 ? -20.0 : Math.log10(x);
                    }
                    y = this.dataArray[0];
                    if (yaxis.isLog) {
                        y = y <= 0.0 ? -20.0 : Math.log10(y);
                    }
                    this.pt_s = new Point2D.Double();
                    this.pt_s.setLocation(x, y);
                    tr.transform(this.pt_s, this.pt);
                    int x1 = (int)this.pt.getX();
                    int y1 = (int)this.pt.getY();
                    for (int i = 1; i < this.dataLength[1] && i < this.refContainer.getDataLength(); ++i) {
                        t = this.dataInc[0] + this.dataInc[1] * (float)i;
                        if (!this.channel.plot.doocsPlotSelection.isInSpectRange(t, t)) continue;
                        x = this.getYofX(t);
                        y = this.dataArray[i];
                        if (xaxis.isLog) {
                            x = x <= 0.0 ? -20.0 : Math.log10(x);
                        }
                        if (yaxis.isLog) {
                            y = y <= 0.0 ? -20.0 : Math.log10(y);
                        }
                        this.pt_s.setLocation(x, y);
                        tr.transform(this.pt_s, this.pt);
                        x2 = (int)this.pt.getX();
                        y2 = (int)this.pt.getY();
                        if (!(x1 < clip.x && x2 < clip.x || x1 > clip.x + clip.width && x2 > clip.x + clip.width)) {
                            this.drawDataPoint(g2d, x1, y1, x2, y2, y0, intColorFg, false, false);
                        }
                        x1 = x2;
                        y1 = y2;
                        x0 = x2 - x1;
                    }
                    this.drawDataPoint(g2d, x1, y1, x2 + x0, y2, y0, intColorFg, false, false);
                }
            }
        }
    }
}

