/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSPlot.DOOCSChannel;
import DOOCSPlot.DOOCSDataContainer;
import DOOCSPlot.DOOCSFindDataPoint;
import DOOCSPlot.DOOCSHistBlock;
import DOOCSPlot.DOOCSPlotAxis;
import DOOCSPlot.DOOCSPlotHist;
import DOOCSPlot.DOOCSPlotXAxisHist;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqCallback;
import ttf.doocs.clnt.EqData;
import ttf.doocs.clnt.TDS;
import ttf.doocs.clnt.time_t;

public class DOOCSDataContainerHist
extends DOOCSDataContainer
implements EqCallback {
    private static int debug = 0;
    protected EqAdr adrActual;
    protected EqAdr adrHist;
    protected EqAdr adrEgu;
    protected EqData ed;
    protected boolean singleUpdate = false;
    int defaultLength = 2048;
    int dataLength = 0;
    int[] dataStatus = new int[1];
    time_t[] dataTime = new time_t[1];
    time_t tFrom = new time_t();
    time_t tTo = new time_t();
    int tReread = 180;
    final int MAX_BIT = 24;
    protected Color bgColor;
    protected Color colorOldCross;
    protected int xPrevious;
    protected int yPrevious;
    protected int actValueX;
    protected double xMin;
    protected double xMax;
    protected final List<DOOCSHistBlock> dataBlock;
    protected volatile boolean pendingCall;
    protected volatile boolean newDataFlag;
    protected volatile int lastBlock;
    protected long oldestDataAvailable;
    protected long oldestDataRead;
    protected long callTimer;
    protected final long tTimeout = 10L;
    protected final int deltaToRefreshHist = 30;
    protected boolean isTine = false;
    protected double actMinOld = 0.0;
    protected double actMaxOld = 0.0;
    protected final Integer firstData = 0;
    protected final Integer oldData = 2;
    protected final Integer freshData = 1;
    protected final Integer refreshData = 3;
    protected final Integer actualData = 4;

    public DOOCSDataContainerHist(DOOCSChannel ch) {
        super(ch);
        this.channel = ch;
        this.color = new Color(0, 0, 0);
        this.colorOldCross = new Color(250, 250, 250);
        this.bgColor = new Color(128, 128, 128, 60);
        this.pt = new Point();
        this.adrActual = new EqAdr(ch.doocsAdr);
        this.adrHist = new EqAdr(ch.doocsAdr + ".HIST");
        this.adrEgu = new EqAdr(ch.doocsAdr + ".EGU");
        this.ed = new EqData();
        this.data = new EqData();
        this.dataBlock = Collections.synchronizedList(new ArrayList());
        this.pendingCall = false;
        this.newDataFlag = false;
        this.lastBlock = 1;
        this.oldestDataAvailable = 0L;
        this.dataBlock.add(new DOOCSHistBlock());
        this.eq = new EqCall();
        this.actValueX = 0;
        this.oldestDataRead = System.currentTimeMillis() / 1000L;
    }

    protected void init() {
        String adrStrHist;
        String adrStrActual;
        if (this.channel.doocsAdr.endsWith(".HIST")) {
            adrStrActual = this.channel.doocsAdr.substring(0, this.channel.doocsAdr.length() - 5);
            adrStrHist = this.channel.doocsAdr;
        } else {
            adrStrActual = this.channel.doocsAdr;
            adrStrHist = adrStrActual.startsWith("file:") ? this.channel.doocsAdr : this.channel.doocsAdr + ".HIST";
        }
        this.descriptionMsg = this.facDev2Desc(adrStrActual);
        this.adrHist.adr(adrStrHist);
        this.adrActual.adr(adrStrActual);
        this.readEGU(this.adrEgu);
        String protocol = this.eq.get_option(this.adrEgu, 1);
        if (protocol != null && protocol.startsWith("TINE")) {
            this.isTine = true;
            DOOCSHistBlock block = new DOOCSHistBlock();
            this.dataBlock.add(block);
            this.dataBlock.get((int)0).data.allocate_array(100, 1, 0);
            this.eq.get_monitor(this.adrActual, this.ed, this.data, 3, this.channel.plot.doocsUpdateTime, (EqCallback)this, (Object)0);
        } else {
            this.eq.get_monitor(this.adrActual, this.ed, this.data, 3, this.channel.plot.doocsUpdateTime, (EqCallback)this, (Object)0);
        }
        this.firstRead = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataCallback(EqData dataOut, Object userData) {
        int blockN = (Integer)userData;
        long old = 0L;
        int l = 0;
        this.newDataFlag = true;
        if (dataOut.error() == 0 && dataOut.type() != 0) {
            if (debug == 1 && blockN > 0) {
                int i = dataOut.array_length();
                System.out.println("HistCallback block=" + blockN + ";Length=" + dataOut.array_length() + ";Ch Base=" + this.channel.doocsAdr + ";Data[0]=" + dataOut.get_float(0) + "; T 0=" + dataOut.get_time(0) + " T n=" + dataOut.get_time(i - 1));
                if (this.dataBlock.get((int)blockN).data.array_length() > 0) {
                    old = 1L;
                }
            }
            if (blockN == 0) {
                List<DOOCSHistBlock> list = this.dataBlock;
                synchronized (list) {
                    DOOCSHistBlock block = this.dataBlock.get(blockN);
                    block.data.copy_from(dataOut);
                    block.tFrom = dataOut.get_time() / 1000L;
                }
                if (this.actValueX != 0 && this.actValueX < this.channel.plot.dataAreaX1) {
                    this.channel.plot.repaint(this.actValueX, this.channel.plot.dataAreaY0, 30, this.channel.plot.dataAreaY1 - this.channel.plot.dataAreaY0);
                    this.singleUpdate = true;
                }
            } else {
                List<DOOCSHistBlock> list = this.dataBlock;
                synchronized (list) {
                    DOOCSHistBlock block = this.dataBlock.get(blockN);
                    block.data.copy_from(dataOut);
                    this.pendingCall = false;
                    l = dataOut.array_length();
                    if (l >= 1 && (dataOut.type() == 101 || dataOut.type() == 107)) {
                        block.tFrom = dataOut.get_time(0) / 1000L;
                        block.tTo = dataOut.get_time(l - 1) / 1000L;
                        if (l < 2000 && blockN > 2 && block.tFromRequest < block.tFrom) {
                            this.oldestDataAvailable = dataOut.get_time(0) / 1000L;
                        }
                    } else if (!this.isTine) {
                        block.tFrom = dataOut.get_time() / 1000L;
                    }
                    if (this.lastBlock < blockN) {
                        this.lastBlock = blockN;
                    }
                    if (block.tFrom < this.oldestDataRead) {
                        this.oldestDataRead = block.tFrom;
                    }
                }
                long t = System.currentTimeMillis();
                if (!this.isTine && blockN > 1) {
                    this.check(t / 1000L);
                }
                if (l > 0 && !this.pendingCall) {
                    this.channel.plot.repaint();
                }
            }
            this.hasData = true;
            this.hasNewData = true;
        } else {
            this.errorMsg = dataOut.get_string();
            if (dataOut.type() == 0) {
                this.errorMsg = "NoData";
            }
            if (debug == 1 && blockN > 0) {
                System.out.println("HistCallback block=" + blockN + ";ERROR=" + this.errorMsg + ";Ch=" + this.channel.doocsAdr);
            }
            if (blockN != 0) {
                // empty if block
            }
            this.channel.plot.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readHistBlock(long from, long to, int blockN, int type) {
        if (this.pendingCall) {
            if (debug > 0) {
                System.out.println("A call is pending!!!");
            }
            return;
        }
        this.tTo.value = (int)to;
        this.tFrom.value = (int)from;
        this.ed.set(this.tFrom, this.tTo, 0, 0);
        if (this.isTine) {
            DOOCSHistBlock block = this.dataBlock.get(blockN);
            block.tFromRequest = from;
            if (block.data.type() != 101) {
                block.data.allocate_array(101, 500, 0);
            }
            block.tFrom = from;
            block.tTo = to;
            int d = (int)(to - from);
            int d2 = (int)((to - from) / 3600L);
            if (debug > 0) {
                System.out.println("dT=" + d + ";Std=" + d2);
            }
            this.eq.get(this.adrHist, this.ed, block.data);
            if (block.data.error() != 0) {
                this.errorMsg = block.data.get_string();
            } else {
                this.hasData = true;
                this.hasNewData = true;
            }
            this.channel.plot.repaint();
        } else {
            List<DOOCSHistBlock> list = this.dataBlock;
            synchronized (list) {
                int l = this.dataBlock.size();
                this.pendingCall = true;
                if (type != this.refreshData) {
                    DOOCSHistBlock block;
                    if (type == this.oldData && ++blockN < l) {
                        block = this.dataBlock.get(blockN);
                    } else {
                        block = new DOOCSHistBlock();
                        if (type == this.oldData || type == this.firstData) {
                            this.dataBlock.add(block);
                            if (debug > 0) {
                                System.out.println("AppendBlock=" + blockN);
                            }
                        } else {
                            this.dataBlock.add(--blockN, block);
                            if (debug > 0) {
                                System.out.println("InsertBlock at=" + blockN);
                            }
                        }
                    }
                    block.tFromRequest = from;
                    this.eq.get_monitor(this.adrHist, this.ed, this.data, 1, 1.01f, (EqCallback)this, (Object)blockN);
                } else {
                    DOOCSHistBlock block = this.dataBlock.get(blockN);
                    block.tFromRequest = from;
                    this.eq.get_monitor(this.adrHist, this.ed, this.data, 1, 1.01f, (EqCallback)this, (Object)blockN);
                }
            }
        }
        if (debug > 0) {
            System.out.println("ReadHistBlock=" + blockN + ";Type=" + type + ";from=" + from + ";to=" + to + ";Blocks=" + this.dataBlock.size() + ";Ch=" + this.adrHist.show_adr());
        }
        this.callTimer = System.currentTimeMillis() / 1000L;
    }

    protected void check(long tSec) {
        int tOff = (int)this.channel.plot.doocsPlotAxisX.actTimeOffset;
        if (this.pendingCall) {
            return;
        }
        if (this.isTine) {
            if (this.channel.plot.doocsPlotAxisX.actMin != this.actMinOld || this.channel.plot.doocsPlotAxisX.actMax != this.actMaxOld) {
                this.actMinOld = this.channel.plot.doocsPlotAxisX.actMin;
                this.actMaxOld = this.channel.plot.doocsPlotAxisX.actMax;
                int t = (int)(System.currentTimeMillis() / 1000L) - tOff;
                if ((double)t > this.channel.plot.doocsPlotAxisX.actMin && (double)t < this.channel.plot.doocsPlotAxisX.actMax) {
                    this.readHistBlock((int)this.channel.plot.doocsPlotAxisX.actMin + tOff, t + (int)this.channel.plot.doocsPlotAxisX.actTimeOffset, 1, this.refreshData);
                } else {
                    this.readHistBlock((int)this.channel.plot.doocsPlotAxisX.actMin + tOff, (int)this.channel.plot.doocsPlotAxisX.actMax + tOff, 1, this.refreshData);
                }
            }
        } else if (this.dataBlock.size() == 1) {
            this.readHistBlock((int)this.channel.plot.doocsPlotAxisX.actMin + tOff, (int)this.channel.plot.doocsPlotAxisX.actMax + tOff, 0, this.firstData);
        } else {
            if (this.channel.plot.doocsPlotAxisX.actMin + (double)tOff < (double)this.oldestDataRead && this.oldestDataRead > this.oldestDataAvailable) {
                this.readHistBlock((int)this.channel.plot.doocsPlotAxisX.actMin + tOff, this.oldestDataRead, this.lastBlock, this.oldData);
                return;
            }
            DOOCSHistBlock block = this.dataBlock.get(1);
            if (this.channel.plot.doocsPlotAxisX.actMax + (double)tOff > (double)block.tTo && block.tTo + 30L < tSec) {
                if ((float)block.data.array_length() > 2000.0f - this.channel.plot.doocsUpdateTime * 10.0f) {
                    this.readHistBlock(block.tTo, (int)tSec + 100, 1, this.freshData);
                    return;
                }
                this.readHistBlock(block.tFrom, (int)tSec + 100, 1, this.refreshData);
                return;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean update() {
        long tSec = System.currentTimeMillis() / 1000L;
        if (this.channel == null) {
            this.errorMsg = "Internal ERROR! No channel defined";
            return false;
        }
        if (this.firstRead) {
            this.init();
        }
        if (this.pendingCall) {
            if (this.callTimer == 0L || this.callTimer + 10L >= tSec) return false;
            this.eq.clear_monitor(this.adrHist);
            this.callTimer = 0L;
            this.pendingCall = false;
            return this.newDataFlag;
        } else {
            this.check(tSec);
        }
        return this.newDataFlag;
    }

    @Override
    void cancel() {
        this.eq.clear_monitor(this.adrActual);
        this.eq.clear_monitor(this.adrHist);
    }

    @Override
    void startMonitoring() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void autoScaleX(DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        double t = System.currentTimeMillis() / 1000L;
        if (this.dataBlock.get((int)0).data.type() != 0) {
            if (xaxis.actMin > t || t > xaxis.actMax) {
                double d = Math.abs(xaxis.actMax - xaxis.actMin);
                xaxis.actMax = t + d / 20.0;
                xaxis.actMin = xaxis.actMax - d;
            }
        } else {
            List<DOOCSHistBlock> list = this.dataBlock;
            synchronized (list) {
                for (int j = 0; j < this.dataBlock.size(); ++j) {
                    double x;
                    float y;
                    if (this.errorMsg != null && this.errorMsg.length() >= 1 || this.dataBlock.get((int)j).data.error() != 0 || this.dataBlock.get((int)j).data.type() == 0) continue;
                    if (this.dataBlock.get((int)j).data.type() == 101) {
                        int l;
                        TDS tds = this.dataBlock.get((int)j).data.get_tds(0);
                        y = tds.data;
                        x = tds.tm.value;
                        if (x < xaxis.actMin) {
                            xaxis.actMin = x;
                        }
                        if ((l = this.dataBlock.get((int)j).data.array_length()) < 1) {
                            l = 1;
                        }
                        tds = this.dataBlock.get((int)j).data.get_tds(l - 1);
                        double x2 = tds.tm.value;
                        if (!(x2 > xaxis.actMax)) continue;
                        xaxis.actMax = x2;
                        continue;
                    }
                    if (this.dataBlock.get((int)j).data.type() == 100) continue;
                    y = this.dataBlock.get((int)j).data.get_float();
                    x = this.dataBlock.get((int)j).data.get_time() / 1000L;
                    if (x < xaxis.actMin) {
                        xaxis.actMin = x;
                    }
                    if (!(x > xaxis.actMax)) continue;
                    xaxis.actMax = x;
                }
            }
        }
    }

    void checkLimits(DOOCSPlotAxis yaxis, double y) {
        if (yaxis.isLog && y <= 0.0) {
            return;
        }
        if (y > yaxis.actMax) {
            yaxis.actMax = y;
        }
        if (y < yaxis.actMin) {
            yaxis.actMin = y;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void autoScaleY(DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        double xmin = xaxis.actMin;
        double xmax = xaxis.actMax;
        double xLast = 0.0;
        double yLast = 0.0;
        if (((DOOCSPlotHist)this.channel.plot).isLogicPlot) {
            yaxis.actMin = 0.0;
        } else {
            List<DOOCSHistBlock> list = this.dataBlock;
            synchronized (list) {
                for (int j = 0; j < this.dataBlock.size(); ++j) {
                    if (!this.hasData || this.dataBlock.get((int)j).data.error() != 0) continue;
                    int l = this.dataBlock.get((int)j).data.array_length();
                    if (this.dataBlock.get((int)j).data.type() == 0) continue;
                    for (int i = 0; i < l; ++i) {
                        double x;
                        float y;
                        if (this.dataBlock.get((int)j).data.type() == 101) {
                            TDS tds = this.dataBlock.get((int)j).data.get_tds(i);
                            if (tds == null || tds.tm == null) continue;
                            y = tds.data;
                            x = tds.tm.value;
                        } else if (this.dataBlock.get((int)j).data.type() == 100) {
                            y = this.dataBlock.get((int)j).data.get_float(i);
                            yLast = y;
                            long delta = this.dataBlock.get((int)j).tTo - this.dataBlock.get((int)j).tFrom;
                            x = xLast = (double)(this.dataBlock.get((int)j).tFrom + delta * (long)i / (long)this.dataBlock.get((int)j).data.array_length());
                        } else {
                            y = this.dataBlock.get((int)j).data.get_float();
                            x = this.dataBlock.get((int)j).data.get_time() / 1000L;
                        }
                        if (x < xmin || x > xmax) {
                            yLast = y;
                            xLast = x;
                            continue;
                        }
                        if (xLast < xmin) {
                            this.checkLimits(yaxis, yLast);
                        }
                        this.checkLimits(yaxis, y);
                    }
                }
            }
        }
    }

    @Override
    public float[] getSelectedData() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDataLength() {
        int l = 0;
        List<DOOCSHistBlock> list = this.dataBlock;
        synchronized (list) {
            int blocks = this.dataBlock.size();
            for (int block = 0; block < blocks; ++block) {
                l += this.dataBlock.get((int)block).data.length();
            }
        }
        this.dataLength = l;
        return this.dataLength;
    }

    @Override
    public double getDataInc() {
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getYData(int idx) {
        double d;
        int block;
        int l;
        int blocks;
        if (idx > this.dataLength) {
            return 0.0;
        }
        List<DOOCSHistBlock> list = this.dataBlock;
        synchronized (list) {
            blocks = this.dataBlock.size();
            l = 0;
            for (block = 0; block < blocks && idx > (l = this.dataBlock.get((int)block).data.length()); ++block, idx -= l) {
            }
            l = this.dataBlock.get((int)block).data.length();
            d = this.dataBlock.get((int)block).data.get_float(idx);
        }
        if (block < blocks && idx < l) {
            return d;
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getXData(int idx) {
        double result;
        if (idx > this.dataLength) {
            return 0.0;
        }
        int l = 0;
        List<DOOCSHistBlock> list = this.dataBlock;
        synchronized (list) {
            int block;
            int blocks = this.dataBlock.size();
            for (block = 0; block < blocks && idx > (l = this.dataBlock.get((int)block).data.length()); ++block, idx -= l) {
            }
            l = this.dataBlock.get((int)block).data.length();
            if (block < blocks && idx < l) {
                if (this.isTine) {
                    long delta = this.dataBlock.get((int)block).tTo - this.dataBlock.get((int)block).tFrom;
                    result = block == 0 ? (double)this.dataBlock.get((int)block).tFrom : (double)(this.dataBlock.get((int)block).tFrom + delta * (long)idx / (long)this.dataBlock.get((int)block).data.array_length());
                } else {
                    result = (double)this.dataBlock.get((int)block).data.get_time(idx) / 1000.0;
                }
            } else {
                result = 0.0;
            }
        }
        return result;
    }

    @Override
    public boolean hasValidData() {
        return this.hasData;
    }

    @Override
    public String getToolTipText(double dataX, double dataY, String adrString) {
        double y = this.channel.plot.doocsPlotAxisY.isLog ? Math.pow(10.0, dataY) : dataY;
        String[] str = ((DOOCSPlotXAxisHist)this.channel.plot.doocsPlotAxisX).time_to_str(Math.round(dataX * 1000.0));
        if (str[1].isEmpty()) {
            return String.format("T=%s, Y=%g : %s", str[0], y, adrString);
        }
        if (((DOOCSPlotHist)this.channel.plot).isLogicPlot) {
            return String.format("T=%s %s, Y=0x%X : %s", str[0], str[1], (int)y, adrString);
        }
        return String.format("T=%s %s, Y=%g : %s", str[0], str[1], y, adrString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void findClosestDataPoint(DOOCSFindDataPoint dp, DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        double x = 0.0;
        double xLast = 0.0;
        double xmin = xaxis.actMin;
        double xmax = xaxis.actMax;
        double ymin = yaxis.actMin;
        double ymax = yaxis.actMax;
        AffineTransform tr = this.channel.plot.doocsAdrList.transformer;
        if (this.hasData) {
            List<DOOCSHistBlock> list = this.dataBlock;
            synchronized (list) {
                if (xaxis.isLog) {
                    xmin = Math.log10(xmin);
                    xmax = Math.log10(xmax);
                }
                if (yaxis.isLog) {
                    ymin = Math.log10(ymin);
                    ymax = Math.log10(ymax);
                }
                for (int j = 0; j < this.dataBlock.size(); ++j) {
                    int len = this.dataBlock.get((int)j).data.array_length();
                    if (len == 0 && this.dataBlock.get((int)j).data.type() != 101) {
                        len = 1;
                    }
                    for (int i = 0; i < len; ++i) {
                        double y;
                        if (this.dataBlock.get((int)j).data.type() == 101) {
                            TDS tds = this.dataBlock.get((int)j).data.get_tds(i);
                            if (tds != null) {
                                y = tds.data;
                                double xSec = tds.tm.value;
                                if (xSec == 0.0) continue;
                                x = xSec != xLast ? xSec : (x += 0.1);
                                xLast = xSec;
                            } else {
                                y = 0.0;
                                x = 0.0;
                            }
                        } else if (this.dataBlock.get((int)j).data.type() == 100) {
                            y = this.dataBlock.get((int)j).data.get_float(i);
                            long delta = this.dataBlock.get((int)j).tTo - this.dataBlock.get((int)j).tFrom;
                            x = this.dataBlock.get((int)j).tFrom + delta * (long)i / (long)this.dataBlock.get((int)j).data.array_length();
                        } else {
                            y = this.dataBlock.get((int)j).data.get_float();
                            x = this.dataBlock.get((int)j).data.get_time() / 1000L;
                        }
                        if (xaxis.isLog) {
                            x = x <= 0.0 ? -20.0 : Math.log10(x);
                        }
                        if (yaxis.isLog) {
                            y = y <= 0.0 ? -20.0 : Math.log10(y);
                        }
                        this.pt_s.setLocation(x, y);
                        tr.transform(this.pt_s, this.pt);
                        int x2 = (int)this.pt.getX();
                        int y2 = (int)this.pt.getY();
                        if (((DOOCSPlotHist)this.channel.plot).isLogicPlot) {
                            if (!(x >= xmin) || !(x <= xmax)) continue;
                            dp.find(x2, dp.mouseY, x, y, this.getLocationAdr(0), this.getStatusMsg(i), this.channel);
                            continue;
                        }
                        if (!(x >= xmin) || !(x <= xmax) || !(y >= ymin) || !(y <= ymax)) continue;
                        dp.find(x2, y2, x, y, this.getLocationAdr(0), this.getStatusMsg(i), this.channel);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void print(String fileName) {
        double xmin = this.channel.plot.doocsPlotAxisX.getMin();
        double xmax = this.channel.plot.doocsPlotAxisX.getMax();
        System.out.println("Data of " + this.channel.doocsAdr + "; Description=" + this.getStatusMsg(0));
        if (this.mathResult != null && this.mathResult.length() > 2) {
            System.out.println("Math result = " + this.mathResult);
        }
        int cnt = 0;
        if (this.hasData) {
            List<DOOCSHistBlock> list = this.dataBlock;
            synchronized (list) {
                for (int j = 0; j < this.dataBlock.size(); ++j) {
                    if (this.dataBlock.get((int)j).data.error() == 0) {
                        EqData dat = this.dataBlock.get((int)j).data;
                        int l = dat.array_length();
                        for (int i = 0; i < l; ++i) {
                            double x = dat.get_time(i) / 1000L;
                            if (!(x >= xmin) || !(x <= xmax)) continue;
                            System.out.println("Bl=" + j + ";Idx=" + i + " : " + dat.get_string(i));
                            ++cnt;
                        }
                        continue;
                    }
                    System.out.println("Bl=" + j + "; Error=" + this.dataBlock.get((int)j).data.get_string());
                }
            }
        }
        System.out.println("Tot number of values: " + cnt);
    }

    @Override
    void paintComponent(Graphics g, DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        if (this.channel.plot.boundsNeedsUpdate) {
            this.xPrevious = 0;
        }
        int r = (this.channel.lineColor.getRed() + 255) / 2;
        int gr = (this.channel.lineColor.getGreen() + 255) / 2;
        int b = (this.channel.lineColor.getBlue() + 255) / 2;
        this.colorOldCross = new Color(r, gr, b);
        if (((DOOCSPlotHist)this.channel.plot).isLogicPlot) {
            this.paintComponentLogic(g, xaxis, yaxis);
        } else {
            this.paintComponentHist(g, xaxis, yaxis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintComponentHist(Graphics g, DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        boolean doAll;
        int x2 = 0;
        int y2 = 0;
        byte lastSts = 0;
        byte stsSave = 0;
        byte stsCollect = 0;
        double xOffset = 0.0;
        double xmin = xaxis.actMin;
        double xmax = xaxis.actMax;
        boolean isTDS = false;
        boolean flagSave = false;
        double xi = 1000.0;
        double xx = 0.0;
        Point2D.Double po = new Point2D.Double();
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform tr = this.channel.plot.doocsAdrList.transformer;
        g2d.setColor(this.channel.lineColor);
        g2d.setStroke(this.channel.strokeSize);
        Color col = this.channel.lineColor;
        Rectangle clip = g2d.getClipBounds();
        boolean bl = doAll = !this.singleUpdate;
        if (clip.x == this.channel.plot.dataAreaX0 && clip.width == this.channel.plot.dataAreaX1 - this.channel.plot.dataAreaX0) {
            doAll = true;
        }
        if (clip.x == this.actValueX) {
            doAll = false;
        }
        if (clip.width < 0) {
            doAll = false;
        }
        if (this.channel.plot.doAll) {
            doAll = true;
        }
        this.singleUpdate = false;
        this.actValueX = 0;
        int intColorFg = this.prepareDraw(g, col, tr, xaxis, yaxis);
        if (!this.hasData) {
            return;
        }
        List<DOOCSHistBlock> list = this.dataBlock;
        synchronized (list) {
            try {
                for (int j = 0; j < this.dataBlock.size(); ++j) {
                    if (this.dataBlock.get((int)j).data.error() != 0) continue;
                    DOOCSHistBlock dOOCSHistBlock = this.dataBlock.get(j);
                    synchronized (dOOCSHistBlock) {
                        TDS tds;
                        double xLast;
                        double x = xLast = xaxis.actMin;
                        double y = yaxis.actMin;
                        if (yaxis.isLog) {
                            y = Math.log10(y);
                        }
                        ((Point2D)po).setLocation(x, y);
                        tr.transform(po, this.pt);
                        int y0 = (int)this.pt.getY();
                        if (this.dataBlock.get((int)j).data.type() == 0) {
                            continue;
                        }
                        boolean bl2 = isTDS = this.dataBlock.get((int)j).data.type() == 101;
                        if (isTDS) {
                            tds = this.dataBlock.get((int)j).data.get_tds(0);
                            if (tds != null) {
                                y = tds.data;
                                if (tds.tm == null) {
                                    continue;
                                }
                                x = (double)tds.tm.value - xOffset;
                                stsSave = stsCollect = tds.status.value;
                                g2d.setColor(this.channel.getErrorColor(stsSave));
                            } else {
                                y = 0.0;
                                x = 0.0;
                            }
                        } else if (this.dataBlock.get((int)j).data.type() == 100) {
                            y = this.dataBlock.get((int)j).data.get_float(0);
                            x = (double)this.dataBlock.get((int)j).tFrom - xOffset;
                        } else {
                            y = this.dataBlock.get((int)j).data.get_float();
                            x = (double)(this.dataBlock.get((int)j).data.get_time() / 1000L) - xOffset;
                        }
                        if (xaxis.isLog) {
                            x = x <= 0.0 ? -20.0 : Math.log10(x);
                        }
                        if (yaxis.isLog) {
                            y = y <= 0.0 ? -20.0 : Math.log10(y);
                        }
                        this.pt_s = new Point2D.Double();
                        this.pt_s.setLocation(x, y);
                        tr.transform(this.pt_s, this.pt);
                        int x1 = x2 = (int)this.pt.getX();
                        int y1 = y2 = (int)this.pt.getY();
                        flagSave = false;
                        int ySave1 = 100000;
                        int ySave2 = -100000;
                        int xSave = 0;
                        if (j > 0) {
                            int l = this.dataBlock.get((int)j).data.array_length();
                            for (int i = 1; i < l; ++i) {
                                boolean fl2;
                                double xSec;
                                tds = this.dataBlock.get((int)j).data.get_tds(i);
                                if (tds != null) {
                                    if (tds.tm == null) continue;
                                    y = tds.data;
                                    xSec = (double)tds.tm.value - xOffset;
                                    lastSts = tds.status.value;
                                    if (xSec == 0.0) continue;
                                    x = xSec != xLast ? xSec : (x += 0.1);
                                } else {
                                    y = this.dataBlock.get((int)j).data.get_float(i);
                                    long delta = this.dataBlock.get((int)j).tTo - this.dataBlock.get((int)j).tFrom;
                                    x = xSec = (double)this.dataBlock.get((int)j).tFrom - xOffset + (double)(delta * (long)i / (long)l);
                                }
                                xLast = xSec;
                                if (xaxis.isLog) {
                                    x = x <= 0.0 ? -20.0 : Math.log10(x);
                                }
                                if (yaxis.isLog) {
                                    y = y <= 0.0 ? -20.0 : Math.log10(y);
                                }
                                this.pt_s.setLocation(x, y);
                                tr.transform(this.pt_s, this.pt);
                                x2 = (int)this.pt.getX();
                                y2 = (int)this.pt.getY();
                                boolean fl1 = x1 < clip.x && x2 < clip.x;
                                boolean bl3 = fl2 = x1 > clip.x + clip.width && x2 > clip.x + clip.width;
                                if ((isTDS || this.isTine) && !fl1 && !fl2) {
                                    boolean fl4;
                                    boolean fl3 = y1 < clip.y && y2 < clip.y;
                                    boolean bl4 = fl4 = y1 > clip.y + clip.height && y2 > clip.y + clip.height;
                                    if (isTDS || this.isTine) {
                                        if (x1 == x2) {
                                            stsCollect = lastSts;
                                            flagSave = true;
                                            xSave = x1;
                                            if (y1 < ySave1) {
                                                ySave1 = y1;
                                            }
                                            if (y2 < ySave1) {
                                                ySave1 = y2;
                                            }
                                            if (y1 > ySave2) {
                                                ySave2 = y1;
                                            }
                                            if (y2 > ySave2) {
                                                ySave2 = y2;
                                            }
                                        } else {
                                            if (stsCollect != stsSave) {
                                                g2d.setColor(this.channel.getErrorColor(stsCollect));
                                                stsSave = stsCollect;
                                            }
                                            if (flagSave) {
                                                stsSave = stsCollect;
                                                this.drawDataPoint(g2d, xSave, ySave1, xSave, ySave2, y0, intColorFg, false, false);
                                                flagSave = false;
                                                ySave1 = 100000;
                                                ySave2 = -100000;
                                            }
                                            this.drawDataPoint(g2d, x1, y1, x2, y1, y0, intColorFg, false, false);
                                            this.drawDataPoint(g2d, x2, y1, x2, y2, y0, intColorFg, false, true);
                                            if (lastSts != stsSave) {
                                                g2d.setColor(this.channel.getErrorColor(lastSts));
                                            }
                                            stsSave = stsCollect = lastSts;
                                        }
                                    }
                                    if ((double)x1 < xi) {
                                        xi = x1;
                                    }
                                    if ((double)x2 > xx) {
                                        xx = x2;
                                    }
                                } else {
                                    stsCollect = lastSts;
                                }
                                x1 = x2;
                                y1 = y2;
                            }
                        }
                        if (j > 0) {
                            if (flagSave) {
                                flagSave = false;
                                this.drawDataPoint(g2d, xSave, ySave1, xSave, ySave2, y0, intColorFg, false, false);
                            }
                            this.drawDataPoint(g2d, x1, y1, x2, y2, y0, intColorFg, false, true);
                        } else {
                            int d = 3;
                            if (!(x1 < clip.x && x2 < clip.x || x1 > clip.x + clip.width && x2 > clip.x + clip.width)) {
                                this.actValueX = x1 - d * 2;
                                if (this.xPrevious != 0 && this.xPrevious != x1) {
                                    Color c = g2d.getColor();
                                    g2d.setColor(this.colorOldCross);
                                    this.drawDataPoint(g2d, this.xPrevious - d, this.yPrevious, this.xPrevious + d, this.yPrevious, y0, intColorFg, false, false);
                                    this.drawDataPoint(g2d, this.xPrevious, this.yPrevious - d, this.xPrevious, this.yPrevious + d, y0, intColorFg, false, false);
                                    g2d.setColor(c);
                                }
                                this.drawDataPoint(g2d, x1 - d, y1, x1 + d, y1, y0, intColorFg, false, false);
                                this.drawDataPoint(g2d, x1, y1 - d, x1, y1 + d, y0, intColorFg, false, false);
                                if (this.xPrevious != 0 && this.xPrevious != x1) {
                                    System.out.println("X=" + x1 + " Prev=" + this.xPrevious);
                                }
                                if (this.xPrevious != x1) {
                                    this.xPrevious = x1;
                                    this.yPrevious = y1;
                                }
                            }
                        }
                        continue;
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void paintComponentLogic(Graphics g, DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        int minBit;
        int x2 = 0;
        int y2 = 0;
        double xmin = xaxis.actMin;
        double xmax = xaxis.actMax;
        boolean isTDS = false;
        int maxBit = (int)yaxis.actMax;
        if (maxBit > 24) {
            maxBit = 24;
        }
        if ((minBit = (int)yaxis.actMin) > 23) {
            minBit = 23;
        }
        Point2D.Double po = new Point2D.Double();
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform tr = this.channel.plot.doocsAdrList.transformer;
        g2d.setColor(this.channel.lineColor);
        g2d.setStroke(this.channel.strokeSize);
        Color col = this.channel.lineColor;
        int intColorFg = this.prepareDraw(g, col, tr, xaxis, yaxis);
        Rectangle clip = g2d.getClipBounds();
        List<DOOCSHistBlock> list = this.dataBlock;
        synchronized (list) {
            try {
                int j = 0;
                while (j < this.dataBlock.size()) {
                    block14: {
                        int b;
                        int w;
                        TDS tds;
                        int dY;
                        int y;
                        double x;
                        block17: {
                            block15: {
                                block16: {
                                    if (!this.hasData || this.dataBlock.get((int)j).data.error() != 0 || this.dataBlock.get((int)j).data.type() == 0) break block14;
                                    double t0 = x = xaxis.actMin;
                                    y = 0;
                                    ((Point2D)po).setLocation(x, y);
                                    tr.transform(po, this.pt);
                                    dY = (int)this.pt.getY();
                                    ((Point2D)po).setLocation(x, 1.0);
                                    tr.transform(po, this.pt);
                                    dY = Math.abs(dY - (int)this.pt.getY()) * 2 / 3;
                                    boolean bl = isTDS = this.dataBlock.get((int)j).data.type() == 101;
                                    if (!isTDS) break block15;
                                    tds = this.dataBlock.get((int)j).data.get_tds(0);
                                    if (tds == null) break block16;
                                    y = (int)tds.data;
                                    if (tds.tm == null) break block14;
                                    x = tds.tm.value;
                                    break block17;
                                }
                                y = 0;
                                x = 0.0;
                                break block17;
                            }
                            y = this.dataBlock.get((int)j).data.get_int();
                            x = this.dataBlock.get((int)j).data.get_time() / 1000L;
                        }
                        if (xaxis.isLog) {
                            x = x <= 0.0 ? -20.0 : Math.log10(x);
                        }
                        this.pt_s = new Point2D.Double();
                        this.pt_s.setLocation(x, y);
                        tr.transform(this.pt_s, this.pt);
                        int x1 = (int)this.pt.getX();
                        int y1 = (int)this.pt.getY();
                        int yPrev = y;
                        int i = 1;
                        while (true) {
                            block19: {
                                block20: {
                                    block18: {
                                        if (i >= this.dataBlock.get((int)j).data.array_length()) break block18;
                                        tds = this.dataBlock.get((int)j).data.get_tds(i);
                                        if (tds == null || tds.tm == null) break block19;
                                        y = (int)tds.data;
                                        x = tds.tm.value;
                                        if (x == 0.0) break block19;
                                        if (!xaxis.isLog) break block20;
                                        x = x <= 0.0 ? -20.0 : Math.log10(x);
                                        break block20;
                                    }
                                    if (isTDS) break block14;
                                    if (!(x1 < clip.x && x2 < clip.x || x1 > clip.x + clip.width && x2 > clip.x + clip.width)) {
                                        w = 2;
                                        this.actValueX = x1 - w;
                                        break;
                                    }
                                    this.actValueX = 0;
                                    break block14;
                                }
                                for (b = minBit; b < maxBit; ++b) {
                                    boolean fl2;
                                    this.pt_s.setLocation(x, b);
                                    tr.transform(this.pt_s, this.pt);
                                    x2 = (int)this.pt.getX();
                                    y2 = (int)this.pt.getY();
                                    boolean fl1 = x1 < clip.x && x2 < clip.x;
                                    boolean bl = fl2 = x1 > clip.x + clip.width && x2 > clip.x + clip.width;
                                    if (!isTDS || fl1 || fl2) continue;
                                    if ((yPrev >> b & 1) == 1) {
                                        this.drawDataPoint(g2d, x1, y2 - dY, x2, y2 - dY, y2, intColorFg, false, false);
                                        if ((y >> b & 1) != 0) continue;
                                        this.drawDataPoint(g2d, x2, y2 - dY, x2, y2, y2, intColorFg, false, false);
                                        continue;
                                    }
                                    this.drawDataPoint(g2d, x1, y2, x2, y2, y2, intColorFg, false, false);
                                    if ((y >> b & 1) != 1) continue;
                                    this.drawDataPoint(g2d, x2, y2, x2, y2 - dY, y2, intColorFg, false, false);
                                }
                                x1 = x2;
                                yPrev = y;
                            }
                            ++i;
                        }
                        for (b = minBit; b < maxBit; ++b) {
                            this.pt_s.setLocation(x, b);
                            tr.transform(this.pt_s, this.pt);
                            x2 = (int)this.pt.getX();
                            y2 = (int)this.pt.getY();
                            if ((y >> b & 1) == 1) {
                                g2d.drawLine(x2 - w, y2 - dY, x2 + w, y2 - dY);
                                g2d.drawLine(x2, y2 - dY - w, x2, y2 - dY + w);
                                continue;
                            }
                            g2d.drawLine(x2 - w, y2, x2 + w, y2);
                            g2d.drawLine(x2, y2 - w, x2, y2 + w);
                        }
                    }
                    ++j;
                }
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
            return;
        }
    }
}

