/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSPlot.DOOCSChannel;
import DOOCSPlot.DOOCSFindDataPoint;
import DOOCSPlot.DOOCSPlot;
import DOOCSPlot.DOOCSPlotAxis;
import DOOCSPlot.DOOCSPlotMath;
import DOOCSPlot.DOOCSPlotSelection;
import DOOCSPlot.utils.PlotDataTable;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqData;
import xmlparser.IntegerParser;

public class DOOCSChannelList {
    public List<DOOCSChannel> channels = new ArrayList<DOOCSChannel>();
    public boolean errorFlag;
    public String doocsAddress;
    public String doocsOrigAddress;
    public DOOCSPlot plot;
    private EqAdr lAdr;
    private EqCall eq;
    private EqData lData;
    public String lineStyle;
    public int strokeSize;
    public String marks;

    public DOOCSChannelList(DOOCSPlot p, String adr, boolean createList) {
        this.plot = p;
        this.doocsAddress = adr;
        this.doocsOrigAddress = adr;
        this.lAdr = new EqAdr();
        this.eq = new EqCall();
        this.lData = new EqData();
        this.errorFlag = false;
        this.lineStyle = "Line";
        this.strokeSize = 2;
        this.marks = "None";
        if (createList) {
            this.channels.add(new DOOCSChannel(this.plot, this.doocsAddress));
        }
    }

    void init(String adr) {
        if (adr != null) {
            this.doocsAddress = adr;
        }
        this.errorFlag = false;
        if (EqAdr.isValidAdr((String)this.doocsAddress)) {
            DOOCSPlot.PlotType cfr_ignored_0 = this.plot.plotType;
            if (this.plot.plotType != DOOCSPlot.PlotType.PLOTLOCATION) {
                this.lAdr.adr(this.doocsAddress);
                if (this.lAdr.location().indexOf("*") >= 0) {
                    EqData ed = new EqData();
                    this.channels.clear();
                    String oldLoc = this.lAdr.location().replace("*", ".*");
                    this.lAdr.set_location("*");
                    if (this.plot.sysMask != 0) {
                        ed.set(this.plot.sysMask);
                    }
                    this.eq.get(this.lAdr, ed, this.lData);
                    if (this.lData.error() != 0) {
                        this.lData = this.eq.names(this.lAdr);
                    }
                    if (this.lData.error() == 0 && this.lData.length() > 0) {
                        for (int i = 0; i < this.lData.length(); ++i) {
                            String tmp = this.lData.get_string_arg(i);
                            if (tmp.indexOf("._") >= 0 || !Pattern.matches(oldLoc, tmp)) continue;
                            this.lAdr.set_location(this.lData.get_string_arg(i));
                            DOOCSChannel aNewChannel = new DOOCSChannel(this.plot, this.lAdr.show_adr());
                            this.channels.add(aNewChannel);
                            aNewChannel.init(this.marks, this.lineStyle, this.strokeSize);
                        }
                    } else {
                        this.errorFlag = true;
                        DOOCSChannel errChan = new DOOCSChannel(this.plot, this.doocsAddress);
                        errChan.chanErrorMsg = "Bad Adr: " + this.lAdr.show_adr();
                        System.out.println(errChan.chanErrorMsg);
                        this.channels.add(errChan);
                    }
                } else if (this.lAdr.location().indexOf("[") >= 0 && this.lAdr.location().indexOf("]") >= 0 && this.lAdr.location().indexOf(";") >= 0) {
                    this.channels.clear();
                    List tAdr = EqAdr.expandAdrString((String)this.doocsAddress);
                    if (tAdr.size() > 0) {
                        for (int i = 0; i < tAdr.size(); ++i) {
                            DOOCSChannel errChan = new DOOCSChannel(this.plot, (String)tAdr.get(i));
                            System.out.println("Expanded Adr: " + (String)tAdr.get(i));
                            this.channels.add(errChan);
                            errChan.init(this.marks, this.lineStyle, this.strokeSize);
                        }
                    } else {
                        this.errorFlag = true;
                        DOOCSChannel errChan = new DOOCSChannel(this.plot, this.doocsAddress);
                        errChan.chanErrorMsg = "Wrog Adr format: " + this.lAdr.show_adr();
                        this.channels.add(errChan);
                        errChan.init(this.marks, this.lineStyle, this.strokeSize);
                    }
                } else if (this.channels.size() < 1) {
                    DOOCSChannel aNewChannel = new DOOCSChannel(this.plot, this.doocsAddress);
                    this.channels.add(aNewChannel);
                    aNewChannel.init(this.marks, this.lineStyle, this.strokeSize);
                } else {
                    this.channels.get((int)0).doocsAdr = this.doocsAddress;
                    this.channels.get(0).init(this.marks, this.lineStyle, this.strokeSize);
                }
            } else {
                if (this.channels.size() == 0) {
                    this.channels.add(new DOOCSChannel(this.plot, this.doocsAddress));
                }
                this.channels.get((int)0).doocsAdr = this.doocsAddress;
                this.channels.get(0).init(this.marks, this.lineStyle, this.strokeSize);
            }
        } else {
            this.errorFlag = true;
        }
    }

    void initOld() {
        this.errorFlag = false;
        if (EqAdr.isValidAdr((String)this.doocsAddress)) {
            DOOCSPlot.PlotType cfr_ignored_0 = this.plot.plotType;
            if (this.plot.plotType != DOOCSPlot.PlotType.PLOTLOCATION) {
                EqData ed = new EqData();
                this.lAdr.adr(this.doocsAddress);
                if (this.lAdr.location().indexOf("*") >= 0) {
                    this.channels.clear();
                    String oldLoc = this.lAdr.location().replace("*", ".*");
                    String oldProp = this.lAdr.property();
                    this.lAdr.set_location("*");
                    if (this.plot.sysMask != 0) {
                        ed.set(this.plot.sysMask);
                    }
                    this.eq.get(this.lAdr, ed, this.lData);
                    if (this.lData.error() != 0) {
                        this.lData = this.eq.names(this.lAdr);
                    }
                    if (this.lData.error() == 0 && this.lData.length() > 0) {
                        for (int i = 0; i < this.lData.length(); ++i) {
                            String tmp = this.lData.get_string_arg(i);
                            if (tmp.indexOf("._") >= 0 || !Pattern.matches(oldLoc, tmp)) continue;
                            this.lAdr.set_location(this.lData.get_string_arg(i));
                            this.channels.add(new DOOCSChannel(this.plot, this.lAdr.show_adr()));
                        }
                    } else {
                        this.errorFlag = true;
                        DOOCSChannel errChan = new DOOCSChannel(this.plot, this.doocsAddress);
                        errChan.chanErrorMsg = "Bad Adr: " + this.lAdr.show_adr();
                        System.out.println(errChan.chanErrorMsg);
                        this.channels.add(errChan);
                    }
                } else if (this.lAdr.location().indexOf("[") >= 0 && this.lAdr.location().indexOf("]") >= 0 && this.lAdr.location().indexOf(";") >= 0) {
                    this.channels.clear();
                    this.errorFlag = true;
                    DOOCSChannel errChan = new DOOCSChannel(this.plot, this.doocsAddress);
                    errChan.chanErrorMsg = "Not yet implemented: " + this.lAdr.show_adr();
                    System.out.println(errChan.chanErrorMsg);
                    this.channels.add(errChan);
                } else if (this.channels.size() < 1) {
                    this.channels.add(new DOOCSChannel(this.plot, this.doocsAddress));
                } else {
                    this.channels.get((int)0).doocsAdr = this.doocsAddress;
                }
            } else {
                this.channels.get((int)0).doocsAdr = this.doocsAddress;
            }
            for (DOOCSChannel li : this.channels) {
                li.init();
            }
        } else {
            this.errorFlag = true;
        }
    }

    void setOrigAddress(String adr) {
        this.doocsOrigAddress = adr;
    }

    static DOOCSChannelList clone(DOOCSPlot plotSrc, DOOCSPlot p, DOOCSChannelList chL, DOOCSPlot.PlotType plotT) {
        DOOCSChannelList cl = new DOOCSChannelList(plotSrc, chL.doocsAddress, false);
        for (DOOCSChannel li : chL.channels) {
            DOOCSChannel c = DOOCSChannel.clone(plotSrc, p, li, plotT);
            cl.channels.add(c);
        }
        return cl;
    }

    public void mergeBaseAdr(String baseAddress) {
        String adr = this.doocsOrigAddress;
        if (EqAdr.isValidAdr((String)this.doocsOrigAddress) && EqAdr.isValidAdr((String)baseAddress)) {
            EqAdr ea = new EqAdr(baseAddress);
            ea.merge(adr);
            adr = ea.show_adr();
            if (EqAdr.isValidAdr((String)adr) && this.doocsAddress.compareTo(adr) != 0) {
                this.init(adr);
            }
            this.doocsAddress = adr;
        }
    }

    public void findClosestDataPoint(DOOCSFindDataPoint dp, DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        for (DOOCSChannel li : this.channels) {
            li.findClosestDataPoint(dp, xaxis, yaxis);
        }
    }

    public int isOnDataTip(int x, int y) {
        for (DOOCSChannel li : this.channels) {
            int rtn = li.isOnDataTip(x, y);
            if (rtn < 0) continue;
            return rtn;
        }
        return -1;
    }

    public String getDataTipText(int idx) {
        for (DOOCSChannel li : this.channels) {
            String rtn = li.getDataTipText(idx);
            if (rtn == null) continue;
            return rtn;
        }
        return null;
    }

    public Point getDataTipPosition(int idx) {
        for (DOOCSChannel li : this.channels) {
            Point rtn = li.getDataTipPosition(idx);
            if (rtn == null) continue;
            return rtn;
        }
        return null;
    }

    public void setLegend(List<DOOCSChannel> listChan) {
        for (DOOCSChannel li : this.channels) {
            li.setLegend(listChan);
        }
    }

    void setDataParameter(int index, String parameter, Object obj) {
        for (DOOCSChannel li : this.channels) {
            li.setDataParameter(index, parameter, obj);
        }
    }

    void setDataTable(PlotDataTable table) {
        for (DOOCSChannel li : this.channels) {
            li.setDataTable(table);
        }
    }

    public void setDOOCSParameter(String parameter, String value) {
        if (parameter == null || value == null) {
            return;
        }
        if (parameter.startsWith("lineStyle")) {
            this.lineStyle = value;
        } else if (parameter.startsWith("lineMark")) {
            this.marks = value;
        } else if (parameter.startsWith("lineWidth")) {
            this.strokeSize = IntegerParser.parseInt(value);
        }
    }

    public void autoScaleX(DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        for (DOOCSChannel li : this.channels) {
            li.autoScaleX(xaxis, yaxis);
        }
    }

    public void autoScaleY(DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        for (DOOCSChannel li : this.channels) {
            li.autoScaleY(xaxis, yaxis);
        }
    }

    void cancel() {
        for (DOOCSChannel li : this.channels) {
            li.cancel();
        }
    }

    void startMonitoring() {
        for (DOOCSChannel li : this.channels) {
            li.startMonitoring();
        }
    }

    boolean update() {
        boolean flag = false;
        for (DOOCSChannel li : this.channels) {
            flag |= li.update();
        }
        return flag;
    }

    public void createMathFct(DOOCSPlotMath fct, DOOCSPlotSelection sel) {
        for (DOOCSChannel li : this.channels) {
            li.createMathFct(fct, sel);
        }
    }

    public void paintMathFct(Graphics g, DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        for (DOOCSChannel li : this.channels) {
            li.paintMathFct(g, xaxis, yaxis);
        }
    }

    void paintComponent(Graphics g, DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        for (DOOCSChannel li : this.channels) {
            li.paintComponent(g, xaxis, yaxis);
        }
    }

    void paintLegendLabels(Graphics g, int x0, int y0, int width, int height) {
        if (this.channels.get(0) != null) {
            this.channels.get(0).paintLegend(g, x0, y0, width, height);
        }
    }

    int paintEGULabels(Graphics g, int x0, int y0, int width, int height) {
        if (this.channels.size() > 0) {
            return this.channels.get(0).paintEGU(g, x0, y0, width, height);
        }
        return 0;
    }
}

