/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.ShowException;
import editor.undo.SetProperty;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqCallback;
import ttf.doocs.clnt.EqData;

public class DOOCSTextField
extends JTextField
implements DOOCSComponent,
ActionListener,
EqCallback {
    private MouseAdapter listener;
    private FocusAdapter listener2;
    private String errorMessage = null;
    private long timeStamp = 0L;
    private String doocsAddress = null;
    private String fullDoocsAddress = null;
    private String doocsToolTipText = null;
    private boolean doocsBorder = true;
    private float doocsUpdateTime = 0.0f;
    private boolean doocsScale = true;
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private Rectangle m_initialBounds;
    private final Border border;
    private Color bgColor;
    private Color colRed;
    private Color colYellow;
    private final int typingDelay = 10000;
    private static final int isData = 1;
    private static final int isEGU = 2;
    private EqCall eq = new EqCall();
    private EqData ed = new EqData();
    private EqData readData;
    private EqAdr adrData = null;
    private String readValue = null;
    private int dataType;
    private boolean pauseUpdate;

    public DOOCSTextField() {
        this.setPreferredSize(new Dimension(100, 20));
        this.setSize(new Dimension(100, 20));
        this.setEnabled(this.doocsRunMode);
        this.addActionListener(this);
        this.border = this.getBorder();
        this.bgColor = this.getBackground();
        this.colRed = new Color(1.0f, 0.5f, 0.5f);
        this.colYellow = new Color(0.99f, 0.99f, 0.5f);
        this.readData = new EqData();
        this.pauseUpdate = false;
        this.dataType = 0;
        this.listener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DOOCSTextField.this.pauseUpdate = true;
                DOOCSTextField.this.timeStamp = System.currentTimeMillis();
            }
        };
        this.listener2 = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!DOOCSTextField.this.getDoocsBorder()) {
                    DOOCSTextField.this.setDefaultBorder();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!DOOCSTextField.this.getDoocsBorder()) {
                    DOOCSTextField.this.setEmptyBorder();
                }
            }
        };
        this.addFocusListener(this.listener2);
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent arg0) {
                DOOCSTextField.this.timeStamp = System.currentTimeMillis();
                DOOCSTextField.this.pauseUpdate = true;
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }
        });
    }

    private void setDefaultBorder() {
        this.setBorder(this.border);
        this.setBackground(this.bgColor);
    }

    private void setEmptyBorder() {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setBackground(DOOCSParameter.getParentLayeredPane(this).getBackground());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.doocsRunMode && this.fullDoocsAddress != null && this.fullDoocsAddress.length() > 5) {
            EqData data = new EqData();
            if (this.readData.error() == 0) {
                String doocsValue = this.getText();
                if (this.readData.array_length() > 1) {
                    String value = this.readData.get_string_arg(0);
                } else {
                    String value = this.readData.get_string_arg();
                }
                if (this.dataType == 0) {
                    this.dataType = this.readData.type();
                }
                this.ed.allocate_array(this.dataType, 1, 0);
                this.ed.set_from_string(doocsValue);
                this.eq.set(this.adrData, this.ed, data);
                if (data.error() != 0) {
                    this.setBackground(this.colRed);
                    new ShowException(null, this.getName(), data.get_string_arg());
                } else {
                    this.setBackground(this.colYellow);
                    this.timeStamp = System.currentTimeMillis() - 10000L + 1000L;
                }
            } else {
                this.errorMessage = this.readValue = this.readData.get_string();
                this.setBackground(this.colRed);
                this.setText(this.readValue);
            }
        }
    }

    private void startMonitors() {
        if ((double)this.doocsUpdateTime == 0.0) {
            this.eq.get_monitor(this.adrData, this.ed, this.readData, 1, this.doocsUpdateTime, (EqCallback)this, (Object)1);
        } else {
            this.eq.get_monitor(this.adrData, this.ed, this.readData, 2, this.doocsUpdateTime, (EqCallback)this, (Object)1);
        }
        if (this.readData.error() != 0) {
            String setValue;
            this.errorMessage = setValue = this.readData.get_string();
            this.setBackground(this.colRed);
            this.setText(setValue);
        }
    }

    @Override
    public void setDnDText(String str) {
    }

    @Override
    public String getDnDText() {
        return null;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void setDoocsAddress(String address) {
        this.doocsAddress = address;
    }

    public String getDoocsAddress() {
        return this.doocsAddress;
    }

    @Override
    public void setFullDoocsAddress(String address) {
        if (address == null) {
            return;
        }
        if (this.fullDoocsAddress == null || !address.startsWith(this.fullDoocsAddress)) {
            this.fullDoocsAddress = address;
            this.setText("...");
            if (this.adrData != null) {
                this.eq.clear_monitor(this.adrData);
            }
            this.adrData = new EqAdr(this.fullDoocsAddress);
            if (!EqAdr.isValidAdr((String)this.fullDoocsAddress)) {
                this.adrData = null;
            } else if (this.doocsRunMode) {
                this.startMonitors();
            }
        }
    }

    @Override
    public String getFullDoocsAddress() {
        return this.fullDoocsAddress;
    }

    @Override
    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    @Override
    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    public void setDoocsUpdateTime(float time) {
        if ((double)time != 0.0 && (double)time < 0.1) {
            time = 0.1f;
        }
        this.doocsUpdateTime = time;
    }

    public float getDoocsUpdateTime() {
        return this.doocsUpdateTime;
    }

    @Override
    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    @Override
    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    @Override
    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    @Override
    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    public void setDoocsBorder(boolean b) {
        this.doocsBorder = b;
    }

    public boolean getDoocsBorder() {
        return this.doocsBorder;
    }

    @Override
    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        this.setEnabled(bRun);
        if (bRun) {
            if (!this.getDoocsBorder()) {
                this.setEmptyBorder();
            }
            this.addMouseListener(this.listener);
            this.startMonitors();
        } else {
            this.removeMouseListener(this.listener);
            if (this.adrData != null) {
                this.eq.clear_monitor(this.adrData);
            }
        }
    }

    @Override
    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    @Override
    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    @Override
    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("updateTime", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("border", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bgColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSTextField ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSTextField>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("updateTime")) {
            this.setDoocsUpdateTime(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("textFont")) {
            this.setFont(DOOCSParameter.convertToFont(value));
            this.checkBoundsForNewFont();
        } else if (parameter.equalsIgnoreCase("textColor")) {
            this.setForeground(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("bgColor")) {
            this.setBackground(DOOCSParameter.convertToColor(value));
            this.bgColor = this.getBackground();
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("border")) {
            this.setDoocsBorder(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSTextField.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("updateTime")) {
            return Float.valueOf(this.getDoocsUpdateTime());
        }
        if (parameter.equalsIgnoreCase("textFont")) {
            return DOOCSParameter.getDoocsFont(this.getFont());
        }
        if (parameter.equalsIgnoreCase("textColor")) {
            return DOOCSParameter.getDoocsColor(this.getForeground());
        }
        if (parameter.equalsIgnoreCase("bgColor")) {
            return DOOCSParameter.getDoocsColor(this.getBackground());
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("border")) {
            return this.getDoocsBorder();
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        System.out.println("DOOCSTextField.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    @Override
    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
    }

    private void checkBoundsForNewFont() {
        Font f = this.getFont();
        int fontHeight = (int)f.getStringBounds("ABCT", this.getFontMetrics(f).getFontRenderContext()).getHeight();
        if (this.getBounds().getHeight() < (double)fontHeight) {
            Rectangle rbounds = this.getBounds();
            rbounds.setSize(rbounds.width, fontHeight);
            this.setBounds(rbounds);
        }
    }

    @Override
    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        return change;
    }

    public void dataCallback(EqData dataOut, Object userData) {
        switch ((Integer)userData) {
            case 1: {
                if (dataOut.error() == 0) {
                    this.errorMessage = null;
                    this.readValue = this.fullDoocsAddress.endsWith(".EGU") ? (dataOut.array_length() > 1 ? dataOut.get_string(0) : dataOut.get_string()) : (dataOut.array_length() > 1 ? dataOut.get_string_arg(0) : dataOut.get_string_arg());
                    this.dataType = dataOut.type();
                    this.setBackground(this.bgColor);
                    break;
                }
                this.readValue = dataOut.get_string();
                if (this.errorMessage != null) break;
                this.errorMessage = this.readValue;
                this.setBackground(this.colRed);
                System.out.println(DOOCSParameter.getFullName(this) + ": " + this.fullDoocsAddress + ": " + this.errorMessage);
                break;
            }
        }
        if (!this.pauseUpdate && this.readValue != null && !this.readValue.equalsIgnoreCase(this.getText())) {
            String setValue = this.readValue;
            this.setText(setValue);
        }
    }
}

