/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicButtonUI;

public class DOOCSButtonUI
extends BasicButtonUI {
    private Color defaultBackground = null;
    private Color defaultSelectBackground = null;
    private static Rectangle paintIconR = new Rectangle();
    private static Rectangle paintTextR = new Rectangle();
    private static Rectangle paintViewR = new Rectangle();
    private static Insets paintViewInsets = new Insets(0, 0, 0, 0);
    protected int angle;

    DOOCSButtonUI(int angle) {
        this.angle = angle;
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.defaultSelectBackground = defaults.getColor("Button.select");
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension dim = super.getPreferredSize(c);
        return new Dimension(dim.height, dim.width);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Icon icon;
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        String text = b.getText();
        Icon icon2 = icon = b.isEnabled() ? b.getIcon() : b.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        if (model.isArmed() && model.isPressed()) {
            if (this.defaultBackground == null) {
                this.defaultBackground = b.getBackground();
            }
            b.setBackground(this.defaultSelectBackground);
        } else if (this.defaultBackground != null) {
            b.setBackground(this.defaultBackground);
        }
        FontMetrics fm = g.getFontMetrics();
        paintViewInsets = c.getInsets(paintViewInsets);
        DOOCSButtonUI.paintViewR.x = DOOCSButtonUI.paintViewInsets.left;
        DOOCSButtonUI.paintViewR.y = DOOCSButtonUI.paintViewInsets.top;
        DOOCSButtonUI.paintViewR.height = c.getWidth() - (DOOCSButtonUI.paintViewInsets.left + DOOCSButtonUI.paintViewInsets.right);
        DOOCSButtonUI.paintViewR.width = c.getHeight() - (DOOCSButtonUI.paintViewInsets.top + DOOCSButtonUI.paintViewInsets.bottom);
        DOOCSButtonUI.paintIconR.height = 0;
        DOOCSButtonUI.paintIconR.width = 0;
        DOOCSButtonUI.paintIconR.y = 0;
        DOOCSButtonUI.paintIconR.x = 0;
        DOOCSButtonUI.paintTextR.height = 0;
        DOOCSButtonUI.paintTextR.width = 0;
        DOOCSButtonUI.paintTextR.y = 0;
        DOOCSButtonUI.paintTextR.x = 0;
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform tr = g2.getTransform();
        if (this.angle == 90) {
            g2.rotate(1.5707963267948966);
            g2.translate(0, -c.getWidth());
        }
        if (this.angle == 270) {
            g2.rotate(-1.5707963267948966);
            g2.translate(-c.getHeight(), 0);
        }
        if (this.angle == 90 || this.angle == 270) {
            DOOCSButtonUI.paintViewR.y = c.getWidth() / 2 - (int)fm.getStringBounds(text, g).getHeight() / 2;
            if (icon != null) {
                DOOCSButtonUI.paintIconR.x = c.getHeight() / 2 - ((int)fm.getStringBounds(text, g).getWidth() + b.getIconTextGap() + icon.getIconWidth()) / 2;
                DOOCSButtonUI.paintViewR.x = DOOCSButtonUI.paintIconR.x + b.getIconTextGap() + icon.getIconWidth();
                DOOCSButtonUI.paintIconR.y = c.getWidth() / 2 - icon.getIconHeight() / 2;
            } else {
                DOOCSButtonUI.paintViewR.x = c.getHeight() / 2 - (int)fm.getStringBounds(text, g).getWidth() / 2;
            }
        }
        if (icon != null) {
            icon.paintIcon(c, g, DOOCSButtonUI.paintIconR.x, DOOCSButtonUI.paintIconR.y);
        }
        if (text != null) {
            int textX = DOOCSButtonUI.paintTextR.x;
            int textY = DOOCSButtonUI.paintTextR.y + fm.getAscent();
            this.paintText(g, c, new Rectangle(DOOCSButtonUI.paintViewR.x, DOOCSButtonUI.paintViewR.y, textX, textY), text);
        }
        g2.setTransform(tr);
    }
}

