/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca.jni;

import gov.aps.jca.CAException;
import gov.aps.jca.Channel;
import gov.aps.jca.Context;
import gov.aps.jca.Monitor;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRFactory;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.dbr.Severity;
import gov.aps.jca.event.AccessRightsListener;
import gov.aps.jca.event.ConnectionListener;
import gov.aps.jca.event.EventDispatcher;
import gov.aps.jca.event.GetListener;
import gov.aps.jca.event.MonitorListener;
import gov.aps.jca.event.PutListener;
import gov.aps.jca.jni.JNIAccessRightsCallback;
import gov.aps.jca.jni.JNIConnectionCallback;
import gov.aps.jca.jni.JNIContext;
import gov.aps.jca.jni.JNIException;
import java.util.ArrayList;

public class JNIChannel
extends Channel {
    protected JNIContext _jnicontext;
    protected long _channelID = 0L;
    protected String _name;
    protected short _priority;
    protected ArrayList _cnxListenerList = new ArrayList();
    protected JNIConnectionCallback _cnxCallback = null;
    protected ArrayList _accessListenerList = new ArrayList();
    protected JNIAccessRightsCallback _accessEventCallback = null;

    protected JNIChannel(JNIContext context, String name, ConnectionListener l, short priority) {
        this._jnicontext = context;
        this._name = name;
        this._priority = priority;
        if (l != null) {
            this._cnxListenerList.add(l);
            this._cnxCallback = new JNIConnectionCallback(this, this.getEventDispatcher(), this._cnxListenerList);
        }
    }

    public EventDispatcher getEventDispatcher() {
        return this._jnicontext.getEventDispatcher();
    }

    void setChannelID(long channelID) {
        this._channelID = channelID;
    }

    final long getChannelID() {
        return this._channelID;
    }

    public final boolean isValid() {
        return this._channelID != 0L;
    }

    protected final void assertState(boolean cond, String msg) throws IllegalStateException {
        if (!cond) {
            throw new IllegalStateException(msg);
        }
    }

    public void destroy() throws CAException, IllegalStateException {
        this.assertState(this.isValid(), "Channel already destroyed");
        try {
            this._jnicontext.ch_channelDestroy(this);
        }
        catch (JNIException ex) {
            throw new CAException("Failed to destroy channel", ex);
        }
        finally {
            this._jnicontext.unregisterChannel(this);
            this._jnicontext = null;
            this._name = null;
            this._channelID = 0L;
            this._cnxListenerList.clear();
            this._accessListenerList.clear();
        }
    }

    public Context getContext() throws IllegalStateException {
        this.assertState(this.isValid(), "Invalid channel");
        return this._jnicontext;
    }

    final short getPriority() {
        return this._priority;
    }

    JNIConnectionCallback getConnectionCallback() {
        return this._cnxCallback;
    }

    public ConnectionListener[] getConnectionListeners() {
        return this._cnxListenerList.toArray(new ConnectionListener[0]);
    }

    public void addConnectionListener(ConnectionListener l) throws CAException, IllegalStateException {
        this.assertState(this.isValid(), "Invalid channel");
        if (l != null) {
            this._cnxListenerList.add(l);
        }
        if (this._cnxListenerList.size() == 1) {
            this._cnxCallback = new JNIConnectionCallback(this, this.getEventDispatcher(), this._cnxListenerList);
            try {
                this._jnicontext.ch_setConnectionCallback(this, this._cnxCallback);
            }
            catch (JNIException jniex) {
                throw new CAException("Failed to add ConnectionListener", jniex);
            }
        }
    }

    public void removeConnectionListener(ConnectionListener l) throws CAException, IllegalStateException {
        this.assertState(this.isValid(), "Invalid channel");
        if (l != null) {
            this._cnxListenerList.remove(l);
        }
        if (this._cnxListenerList.size() == 0) {
            this._cnxCallback = null;
            try {
                this._jnicontext.ch_setConnectionCallback(this, this._cnxCallback);
            }
            catch (JNIException jniex) {
                throw new CAException("Failed to remove ConnectionListener", jniex);
            }
        }
    }

    JNIAccessRightsCallback getAccessRightsCallback() {
        return this._accessEventCallback;
    }

    public AccessRightsListener[] getAccessRightsListeners() throws IllegalStateException {
        this.assertState(this.isValid(), "Invalid channel");
        return this._accessListenerList.toArray(new AccessRightsListener[0]);
    }

    public void addAccessRightsListener(AccessRightsListener l) throws CAException, IllegalStateException {
        this.assertState(this.isValid(), "Invalid channel");
        if (l != null) {
            this._accessListenerList.add(l);
        }
        if (this._accessListenerList.size() == 1) {
            this._accessEventCallback = new JNIAccessRightsCallback(this, this.getEventDispatcher(), this._accessListenerList);
            try {
                this._jnicontext.ch_setAccessRightsCallback(this, this._accessEventCallback);
            }
            catch (JNIException jniex) {
                throw new CAException("Failed to add AccessRightsListener", jniex);
            }
        }
    }

    public void removeAccessRightsListener(AccessRightsListener l) throws CAException, IllegalStateException {
        this.assertState(this.isValid(), "Invalid channel");
        if (l != null) {
            this._accessListenerList.remove(l);
        }
        if (this._accessListenerList.size() == 0) {
            this._accessEventCallback = null;
            try {
                this._jnicontext.ch_setAccessRightsCallback(this, this._accessEventCallback);
            }
            catch (JNIException jniex) {
                throw new CAException("Failed to add AccessRightsCallback", jniex);
            }
        }
    }

    public String getName() throws IllegalStateException {
        return this._name;
    }

    public DBRType getFieldType() throws IllegalStateException {
        this.assertState(this.isValid(), "Invalid channel");
        return DBRType.forValue(this._jnicontext.ch_getFieldType(this));
    }

    public int getElementCount() throws IllegalStateException {
        this.assertState(this.isValid(), "Invalid channel");
        return this._jnicontext.ch_getElementCount(this);
    }

    public Channel.ConnectionState getConnectionState() throws IllegalStateException {
        this.assertState(this.isValid(), "Invalid channel");
        return Channel.ConnectionState.forValue(this._jnicontext.ch_getState(this));
    }

    public String getHostName() throws IllegalStateException {
        this.assertState(this.isValid(), "Invalid channel");
        return this._jnicontext.ch_getHostName(this);
    }

    public boolean getReadAccess() throws IllegalStateException {
        this.assertState(this.isValid(), "Invalid channel");
        return this._jnicontext.ch_getReadAccess(this);
    }

    public boolean getWriteAccess() throws IllegalStateException {
        this.assertState(this.isValid(), "Invalid channel");
        return this._jnicontext.ch_getWriteAccess(this);
    }

    public void put(byte[] value) throws CAException, IllegalStateException {
        this.put(DBRType.BYTE, value.length, value);
    }

    public void put(byte[] value, PutListener l) throws CAException, IllegalStateException {
        this.put(DBRType.BYTE, value.length, value, l);
    }

    public void put(short[] value) throws CAException, IllegalStateException {
        this.put(DBRType.SHORT, value.length, value);
    }

    public void put(short[] value, PutListener l) throws CAException, IllegalStateException {
        this.put(DBRType.SHORT, value.length, value, l);
    }

    public void put(int[] value) throws CAException, IllegalStateException {
        this.put(DBRType.INT, value.length, value);
    }

    public void put(int[] value, PutListener l) throws CAException, IllegalStateException {
        this.put(DBRType.INT, value.length, value, l);
    }

    public void put(float[] value) throws CAException, IllegalStateException {
        this.put(DBRType.FLOAT, value.length, value);
    }

    public void put(float[] value, PutListener l) throws CAException, IllegalStateException {
        this.put(DBRType.FLOAT, value.length, value, l);
    }

    public void put(double[] value) throws CAException, IllegalStateException {
        this.put(DBRType.DOUBLE, value.length, value);
    }

    public void put(double[] value, PutListener l) throws CAException, IllegalStateException {
        this.put(DBRType.DOUBLE, value.length, value, l);
    }

    public void put(String[] value) throws CAException, IllegalStateException {
        this.put(DBRType.STRING, value.length, value);
    }

    public void put(String[] value, PutListener l) throws CAException, IllegalStateException {
        this.put(DBRType.STRING, value.length, value, l);
    }

    public void putACKS(Severity severity, PutListener l) throws CAException, IllegalStateException {
        this.put(DBRType.PUT_ACKS, 1, new short[]{(short)severity.getValue()}, l);
    }

    public void putACKS(Severity severity) throws CAException, IllegalStateException {
        this.put(DBRType.PUT_ACKS, 1, new short[]{(short)severity.getValue()});
    }

    public void putACKT(boolean value, PutListener l) throws CAException, IllegalStateException {
        this.put(DBRType.PUT_ACKT, 1, new short[]{value ? (short)1 : 0}, l);
    }

    public void putACKT(boolean value) throws CAException, IllegalStateException {
        this.put(DBRType.PUT_ACKT, 1, new short[]{value ? (short)1 : 0});
    }

    protected void put(DBRType type, int count, Object value) throws CAException, IllegalStateException {
        this.assertState(this.isValid(), "Invalid channel");
        try {
            this._jnicontext.ch_arrayPut(type, count, this, value);
        }
        catch (JNIException jniex) {
            throw new CAException("Put failed", jniex);
        }
    }

    protected void put(DBRType type, int count, Object value, PutListener l) throws CAException, IllegalStateException {
        this.assertState(this.isValid(), "Invalid channel");
        try {
            this._jnicontext.ch_arrayPut(type, count, this, value, l);
        }
        catch (JNIException jniex) {
            throw new CAException("Put failed", jniex);
        }
    }

    public DBR get(DBRType type, int count) throws CAException {
        this.assertState(this.isValid(), "Invalid channel");
        DBR dbr = DBRFactory.create(type, count);
        if (dbr == null) {
            throw new CAException("Get failed: failed to create DBR.");
        }
        try {
            this._jnicontext.ch_arrayGet(dbr, this);
        }
        catch (JNIException jniex) {
            throw new CAException("Get failed", jniex);
        }
        return dbr;
    }

    public void get(DBRType type, int count, GetListener l) throws CAException {
        this.assertState(this.isValid(), "Invalid channel");
        try {
            this._jnicontext.ch_arrayGet(type, count, this, l);
        }
        catch (JNIException jniex) {
            throw new CAException("Get failed", jniex);
        }
    }

    public Monitor addMonitor(DBRType type, int count, int mask, MonitorListener l) throws CAException {
        this.assertState(this.isValid(), "Invalid channel");
        try {
            return this._jnicontext.ch_addMonitor(type, count, this, l, mask);
        }
        catch (JNIException jniex) {
            throw new CAException("Add monitor failed", jniex);
        }
    }
}

