/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca.jni;

import gov.aps.jca.CAException;
import gov.aps.jca.Channel;
import gov.aps.jca.Context;
import gov.aps.jca.Monitor;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.event.MonitorListener;
import gov.aps.jca.jni.JNIChannel;
import gov.aps.jca.jni.JNIContext;
import gov.aps.jca.jni.JNIException;
import gov.aps.jca.jni.JNIMonitorCallback;
import java.util.ArrayList;

public class JNIMonitor
extends Monitor {
    protected JNIContext _jnicontext;
    protected DBRType _type;
    protected int _count;
    protected JNIChannel _channel;
    protected ArrayList _monitorListenerList = new ArrayList();
    protected int _mask;
    protected long _monitorID;
    protected JNIMonitorCallback _callback;

    public JNIMonitor(JNIContext context, DBRType type, int count, JNIChannel ch, MonitorListener l, int mask) {
        this._jnicontext = context;
        this._type = type;
        this._count = count;
        this._channel = ch;
        if (l != null) {
            this._monitorListenerList.add(l);
        }
        this._mask = mask;
        this._callback = new JNIMonitorCallback(ch, context.getEventDispatcher(), this._monitorListenerList);
    }

    JNIMonitorCallback getMonitorCallback() {
        return this._callback;
    }

    public Context getContext() {
        return this._jnicontext;
    }

    public Channel getChannel() {
        this.assertValidity();
        return this._channel;
    }

    public JNIChannel getJNIChannel() {
        this.assertValidity();
        return this._channel;
    }

    public DBRType getType() {
        this.assertValidity();
        return this._type;
    }

    public int getCount() {
        this.assertValidity();
        return this._count;
    }

    public int getMask() {
        this.assertValidity();
        return this._mask;
    }

    public MonitorListener getMonitorListener() {
        this.assertValidity();
        return (MonitorListener)this._monitorListenerList.get(0);
    }

    public void addMonitorListener(MonitorListener l) {
        if (l == null) {
            return;
        }
        this._monitorListenerList.add(l);
    }

    public void removeMonitorListener(MonitorListener l) {
        if (l == null) {
            return;
        }
        this._monitorListenerList.remove(l);
    }

    public MonitorListener[] getMonitorListeners() {
        return this._monitorListenerList.toArray(new MonitorListener[0]);
    }

    public long getMonitorID() {
        return this._monitorID;
    }

    protected void setMonitorID(long mID) {
        if (this._monitorID != 0L) {
            throw new IllegalStateException("MonitorID has already been set");
        }
        this._monitorID = mID;
    }

    public void clear() throws CAException {
        this.assertValidity();
        try {
            this._jnicontext.ch_clearMonitor(this);
        }
        catch (JNIException jnie) {
            throw new CAException("Unable to clear monitor", jnie);
        }
    }

    protected void assertValidity() {
        if (this._monitorID == 0L) {
            throw new IllegalStateException("Invalid monitor");
        }
    }
}

