/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca.dbr;

import gov.aps.jca.CAStatus;
import gov.aps.jca.CAStatusException;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRFactory;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.dbr.DBR_Byte;
import gov.aps.jca.dbr.DBR_Double;
import gov.aps.jca.dbr.DBR_Enum;
import gov.aps.jca.dbr.DBR_Int;
import gov.aps.jca.dbr.DBR_Short;
import gov.aps.jca.dbr.DBR_String;
import gov.aps.jca.dbr.FLOAT;
import gov.aps.jca.dbr.PRECISION;
import java.util.Locale;

public class DBR_Float
extends DBR
implements FLOAT {
    public static final DBRType TYPE = new DBRType("DBR_FLOAT", 2, DBR_Float.class);

    public DBR_Float() {
        this(1);
    }

    public DBR_Float(int count) {
        this(new float[count]);
    }

    public DBR_Float(float[] value) {
        super(value);
    }

    public DBRType getType() {
        return TYPE;
    }

    public float[] getFloatValue() {
        return (float[])this.getValue();
    }

    public DBR convert(DBRType convertType) throws CAStatusException {
        if (convertType.isFLOAT() && convertType.getValue() <= this.getType().getValue()) {
            return this;
        }
        float[] fromValue = this.getFloatValue();
        DBR dbr = DBRFactory.create(convertType, this._count);
        if (convertType.isSTRING()) {
            String[] toValue = ((DBR_String)dbr).getStringValue();
            int decimals = -1;
            if (this.isPRECSION()) {
                decimals = ((PRECISION)((Object)this)).getPrecision();
            }
            if (decimals >= 0) {
                String formatFString = "%." + decimals + "f";
                for (int i = 0; i < this._count; ++i) {
                    Object[] params = new Object[]{new Float(fromValue[i])};
                    toValue[i] = String.format(Locale.US, formatFString, params);
                    if (toValue[i].length() <= 16) continue;
                    String formatEString = "%." + decimals + "e";
                    toValue[i] = String.format(Locale.US, formatEString, params);
                }
            } else {
                for (int i = 0; i < this._count; ++i) {
                    toValue[i] = String.valueOf(fromValue[i]);
                }
            }
        } else if (convertType.isSHORT()) {
            short[] toValue = ((DBR_Short)dbr).getShortValue();
            for (int i = 0; i < this._count; ++i) {
                toValue[i] = (short)fromValue[i];
            }
        } else if (convertType.isFLOAT()) {
            float[] toValue = ((DBR_Float)dbr).getFloatValue();
            for (int i = 0; i < this._count; ++i) {
                toValue[i] = fromValue[i];
            }
        } else if (convertType.isENUM()) {
            short[] toValue = ((DBR_Enum)dbr).getEnumValue();
            for (int i = 0; i < this._count; ++i) {
                toValue[i] = (short)fromValue[i];
            }
        } else if (convertType.isBYTE()) {
            byte[] toValue = ((DBR_Byte)dbr).getByteValue();
            for (int i = 0; i < this._count; ++i) {
                toValue[i] = (byte)fromValue[i];
            }
        } else if (convertType.isINT()) {
            int[] toValue = ((DBR_Int)dbr).getIntValue();
            for (int i = 0; i < this._count; ++i) {
                toValue[i] = (int)fromValue[i];
            }
        } else if (convertType.isDOUBLE()) {
            double[] toValue = ((DBR_Double)dbr).getDoubleValue();
            for (int i = 0; i < this._count; ++i) {
                toValue[i] = fromValue[i];
            }
        } else {
            throw new CAStatusException(CAStatus.NOCONVERT, "converstion not supported");
        }
        return dbr;
    }
}

