/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNCommitPathHandler;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNCommitMediator;
import org.tmatesoft.svn.core.internal.wc.SVNCommitUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCommitter;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.SVNWCManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.DefaultSVNCommitHandler;
import org.tmatesoft.svn.core.wc.DefaultSVNCommitParameters;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNCommitParameters;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNExternalsHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCommitItem;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNCopyClient
extends SVNBasicClient {
    private ISVNCommitHandler myCommitHandler;
    private ISVNCommitParameters myCommitParameters;
    private ISVNExternalsHandler myExternalsHandler;

    public SVNCopyClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    public SVNCopyClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    public void setCommitHandler(ISVNCommitHandler handler) {
        this.myCommitHandler = handler;
    }

    public ISVNCommitHandler getCommitHandler() {
        if (this.myCommitHandler == null) {
            this.myCommitHandler = new DefaultSVNCommitHandler();
        }
        return this.myCommitHandler;
    }

    public void setCommitParameters(ISVNCommitParameters parameters) {
        this.myCommitParameters = parameters;
    }

    public ISVNCommitParameters getCommitParameters() {
        if (this.myCommitParameters == null) {
            this.myCommitParameters = new DefaultSVNCommitParameters();
        }
        return this.myCommitParameters;
    }

    public void setExternalsHandler(ISVNExternalsHandler externalsHandler) {
        this.myExternalsHandler = externalsHandler;
    }

    public ISVNExternalsHandler getExternalsHandler() {
        if (this.myExternalsHandler == null) {
            this.myExternalsHandler = ISVNExternalsHandler.DEFAULT;
        }
        return this.myExternalsHandler;
    }

    public void doCopy(SVNCopySource[] sources, File dst, boolean isMove, boolean makeParents, boolean failWhenDstExists) throws SVNException {
        if (sources.length > 1 && failWhenDstExists) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_MULTIPLE_SOURCES_DISALLOWED);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        if ((sources = this.expandCopySources(sources)).length == 0) {
            return;
        }
        try {
            this.setupCopy(sources, new SVNPath(dst.getAbsolutePath()), isMove, makeParents, null, null);
        }
        catch (SVNException e) {
            SVNErrorCode err = e.getErrorMessage().getErrorCode();
            if (!(failWhenDstExists || sources.length != 1 || err != SVNErrorCode.ENTRY_EXISTS && err != SVNErrorCode.FS_ALREADY_EXISTS)) {
                SVNCopySource source = sources[0];
                String baseName = source.getName();
                if (source.isURL()) {
                    baseName = SVNEncodingUtil.uriDecode(baseName);
                }
                this.setupCopy(sources, new SVNPath(new File(dst, baseName).getAbsolutePath()), isMove, makeParents, null, null);
                return;
            }
            throw e;
        }
    }

    public SVNCommitInfo doCopy(SVNCopySource[] sources, SVNURL dst, boolean isMove, boolean makeParents, boolean failWhenDstExists, String commitMessage, SVNProperties revisionProperties) throws SVNException {
        if (sources.length > 1 && failWhenDstExists) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_MULTIPLE_SOURCES_DISALLOWED);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        if ((sources = this.expandCopySources(sources)).length == 0) {
            return SVNCommitInfo.NULL;
        }
        try {
            return this.setupCopy(sources, new SVNPath(dst.toString()), isMove, makeParents, commitMessage, revisionProperties);
        }
        catch (SVNException e) {
            SVNErrorCode err = e.getErrorMessage().getErrorCode();
            if (!(failWhenDstExists || sources.length != 1 || err != SVNErrorCode.ENTRY_EXISTS && err != SVNErrorCode.FS_ALREADY_EXISTS)) {
                SVNCopySource source = sources[0];
                String baseName = source.getName();
                if (!source.isURL()) {
                    baseName = SVNEncodingUtil.uriEncode(baseName);
                }
                return this.setupCopy(sources, new SVNPath(dst.appendPath(baseName, true).toString()), isMove, makeParents, commitMessage, revisionProperties);
            }
            throw e;
        }
    }

    public void doCopy(File nestedWC) throws SVNException {
        this.copyDisjointWCToWC(nestedWC);
    }

    private SVNCopySource[] expandCopySources(SVNCopySource[] sources) throws SVNException {
        ArrayList<SVNCopySource> expanded = new ArrayList<SVNCopySource>(sources.length);
        for (int i = 0; i < sources.length; ++i) {
            SVNCopySource source = sources[i];
            if (source.isCopyContents() && source.isURL()) {
                SVNRevision startRevision;
                SVNRevision pegRevision = source.getPegRevision();
                if (!pegRevision.isValid()) {
                    pegRevision = SVNRevision.HEAD;
                }
                if (!(startRevision = source.getRevision()).isValid()) {
                    startRevision = pegRevision;
                }
                SVNBasicClient.SVNRepositoryLocation[] locations = this.getLocations(source.getURL(), null, null, pegRevision, startRevision, SVNRevision.UNDEFINED);
                SVNRepository repository = this.createRepository(locations[0].getURL(), null, null, true);
                long revision = locations[0].getRevisionNumber();
                ArrayList entries = new ArrayList();
                repository.getDir("", revision, null, 0, entries);
                Iterator ents = entries.iterator();
                while (ents.hasNext()) {
                    SVNDirEntry entry = (SVNDirEntry)ents.next();
                    expanded.add(new SVNCopySource(SVNRevision.UNDEFINED, source.getRevision(), entry.getURL()));
                }
                continue;
            }
            expanded.add(source);
        }
        return expanded.toArray(new SVNCopySource[expanded.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUUIDFromPath(SVNWCAccess wcAccess, File path) throws SVNException {
        SVNEntry entry = wcAccess.getVersionedEntry(path, true);
        String uuid = null;
        if (entry.getUUID() != null) {
            uuid = entry.getUUID();
        } else if (entry.getURL() != null) {
            SVNRepository repos = this.createRepository(entry.getSVNURL(), null, null, false);
            try {
                uuid = repos.getRepositoryUUID(true);
            }
            finally {
                repos.closeSession();
            }
        } else {
            if (wcAccess.isWCRoot(path)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", path);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            uuid = this.getUUIDFromPath(wcAccess, path.getParentFile());
        }
        return uuid;
    }

    private static void postCopyCleanup(SVNAdminArea dir) throws SVNException {
        SVNPropertiesManager.deleteWCProperties(dir, null, false);
        SVNFileUtil.setHidden(dir.getAdminDirectory(), true);
        SVNHashMap attributes = new SVNHashMap();
        boolean save = false;
        Iterator entries = dir.entries(true);
        while (entries.hasNext()) {
            SVNEntry entry = (SVNEntry)entries.next();
            boolean deleted = entry.isDeleted();
            SVNNodeKind kind = entry.getKind();
            boolean force = false;
            if (entry.isDeleted()) {
                force = true;
                attributes.put("svn:entry:schedule", "delete");
                attributes.put("svn:entry:deleted", null);
                if (entry.isDirectory()) {
                    attributes.put("svn:entry:kind", "file");
                }
            }
            if (entry.getLockToken() != null) {
                force = true;
                attributes.put("svn:entry:lock-token", null);
                attributes.put("svn:entry:lock-owner", null);
                attributes.put("svn:entry:lock-creation-date", null);
            }
            if (force) {
                dir.modifyEntry(entry.getName(), attributes, false, force);
                save = true;
            }
            if (!deleted && kind == SVNNodeKind.DIR && !dir.getThisDirName().equals(entry.getName())) {
                SVNAdminArea childDir = dir.getWCAccess().retrieve(dir.getFile(entry.getName()));
                SVNCopyClient.postCopyCleanup(childDir);
            }
            attributes.clear();
        }
        if (save) {
            dir.saveEntries(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNCommitInfo setupCopy(SVNCopySource[] sources, SVNPath dst, boolean isMove, boolean makeParents, String message, SVNProperties revprops) throws SVNException {
        SVNErrorMessage err;
        Object dstPath;
        Object srcPath;
        CopyPair pair;
        ArrayList<CopyPair> pairs = new ArrayList<CopyPair>(sources.length);
        for (int i = 0; i < sources.length; ++i) {
            SVNCopySource source = sources[i];
            if (!source.isURL() || source.getPegRevision() != SVNRevision.BASE && source.getPegRevision() != SVNRevision.COMMITTED && source.getPegRevision() != SVNRevision.PREVIOUS) continue;
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Revision type requires a working copy path, not URL");
            SVNErrorManager.error(err2, SVNLogType.WC);
        }
        boolean srcIsURL = sources[0].isURL();
        boolean dstIsURL = dst.isURL();
        if (sources.length > 1) {
            for (int i = 0; i < sources.length; ++i) {
                SVNCopySource source = sources[i];
                CopyPair pair2 = new CopyPair();
                pair2.mySource = source.isURL() ? source.getURL().toString() : source.getFile().getAbsolutePath().replace(File.separatorChar, '/');
                pair2.setSourceRevisions(source.getPegRevision(), source.getRevision());
                if (SVNPathUtil.isURL(pair2.mySource) != srcIsURL) {
                    SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot mix repository and working copy sources");
                    SVNErrorManager.error(err3, SVNLogType.WC);
                }
                String baseName = source.getName();
                if (srcIsURL && !dstIsURL) {
                    baseName = SVNEncodingUtil.uriDecode(baseName);
                }
                pair2.myDst = dstIsURL ? dst.getURL().appendPath(baseName, true).toString() : new File(dst.getFile(), baseName).getAbsolutePath().replace(File.separatorChar, '/');
                pairs.add(pair2);
            }
        } else {
            SVNCopySource source = sources[0];
            pair = new CopyPair();
            pair.mySource = source.isURL() ? source.getURL().toString() : source.getFile().getAbsolutePath().replace(File.separatorChar, '/');
            pair.setSourceRevisions(source.getPegRevision(), source.getRevision());
            pair.myDst = dstIsURL ? dst.getURL().toString() : dst.getFile().getAbsolutePath().replace(File.separatorChar, '/');
            pairs.add(pair);
        }
        if (!srcIsURL && !dstIsURL) {
            Iterator ps = pairs.iterator();
            while (ps.hasNext()) {
                pair = (CopyPair)ps.next();
                srcPath = pair.mySource;
                dstPath = pair.myDst;
                if (!SVNPathUtil.isAncestor((String)srcPath, (String)dstPath)) continue;
                err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot copy path ''{0}'' into its own child ''{1}", new Object[]{srcPath, dstPath});
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        if (isMove) {
            if (srcIsURL == dstIsURL) {
                Iterator ps = pairs.iterator();
                while (ps.hasNext()) {
                    pair = (CopyPair)ps.next();
                    srcPath = new File(pair.mySource);
                    dstPath = new File(pair.myDst);
                    if (!((File)srcPath).equals(dstPath)) continue;
                    err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot move path ''{0}'' into itself", srcPath);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            } else {
                SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Moves between the working copy and the repository are not supported");
                SVNErrorManager.error(err4, SVNLogType.WC);
            }
        } else if (!srcIsURL) {
            CopyPair pair3;
            boolean needReposRevision = false;
            boolean needReposPegRevision = false;
            Iterator ps = pairs.iterator();
            while (ps.hasNext()) {
                pair3 = (CopyPair)ps.next();
                if (pair3.mySourceRevision != SVNRevision.UNDEFINED && pair3.mySourceRevision != SVNRevision.WORKING) {
                    needReposRevision = true;
                }
                if (pair3.mySourcePegRevision != SVNRevision.UNDEFINED && pair3.mySourcePegRevision != SVNRevision.WORKING) {
                    needReposPegRevision = true;
                }
                if (!needReposRevision && !needReposPegRevision) continue;
                break;
            }
            if (needReposRevision || needReposPegRevision) {
                ps = pairs.iterator();
                while (ps.hasNext()) {
                    pair3 = (CopyPair)ps.next();
                    SVNWCAccess wcAccess = this.createWCAccess();
                    try {
                        SVNURL url;
                        wcAccess.probeOpen(new File(pair3.mySource), false, 0);
                        SVNEntry entry = wcAccess.getEntry(new File(pair3.mySource), false);
                        SVNURL sVNURL = url = entry.isCopied() ? entry.getCopyFromSVNURL() : entry.getSVNURL();
                        if (url == null) {
                            SVNErrorMessage err5 = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' does not have a URL associated with it", new File(pair3.mySource));
                            SVNErrorManager.error(err5, SVNLogType.WC);
                        }
                        pair3.mySource = url.toString();
                        if (!needReposPegRevision || pair3.mySourcePegRevision == SVNRevision.BASE) {
                            SVNRevision sVNRevision = pair3.mySourcePegRevision = entry.isCopied() ? SVNRevision.create(entry.getCopyFromRevision()) : SVNRevision.create(entry.getRevision());
                        }
                        if (pair3.mySourceRevision != SVNRevision.BASE) continue;
                        pair3.mySourceRevision = entry.isCopied() ? SVNRevision.create(entry.getCopyFromRevision()) : SVNRevision.create(entry.getRevision());
                    }
                    finally {
                        wcAccess.close();
                    }
                }
                srcIsURL = true;
            }
        }
        if (!srcIsURL && !dstIsURL) {
            this.copyWCToWC(pairs, isMove, makeParents);
            return SVNCommitInfo.NULL;
        }
        if (!srcIsURL && dstIsURL) {
            return this.copyWCToRepos(pairs, makeParents, message, revprops);
        }
        if (srcIsURL && !dstIsURL) {
            this.copyReposToWC(pairs, makeParents);
            return SVNCommitInfo.NULL;
        }
        return this.copyReposToRepos(pairs, makeParents, isMove, message, revprops);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private SVNCommitInfo copyWCToRepos(List copyPairs, boolean makeParents, String message, SVNProperties revprops) throws SVNException {
        SVNCommitInfo info;
        block70: {
            Collection tmpFiles;
            ISVNEditor commitEditor;
            SVNWCAccess wcAccess;
            block67: {
                Iterator files222;
                SVNCommitItem[] commitables;
                ArrayList<Object> commitItems;
                ArrayList<String> newDirs;
                SVNRepository repos;
                block63: {
                    Object pair;
                    block64: {
                        block60: {
                            block61: {
                                SVNCommitItem item;
                                SVNURL url;
                                String topSrc = ((CopyPair)copyPairs.get((int)0)).mySource;
                                for (int i = 1; i < copyPairs.size(); ++i) {
                                    CopyPair pair2 = (CopyPair)copyPairs.get(i);
                                    topSrc = SVNPathUtil.getCommonPathAncestor(topSrc, pair2.mySource);
                                }
                                wcAccess = this.createWCAccess();
                                info = null;
                                commitEditor = null;
                                tmpFiles = null;
                                SVNAdminArea adminArea = wcAccess.probeOpen(new File(topSrc), false, -1);
                                wcAccess.setAnchor(adminArea.getRoot());
                                String topDstURL = ((CopyPair)copyPairs.get((int)0)).myDst;
                                topDstURL = SVNPathUtil.removeTail(topDstURL);
                                for (int i = 1; i < copyPairs.size(); ++i) {
                                    CopyPair pair3 = (CopyPair)copyPairs.get(i);
                                    topDstURL = SVNPathUtil.getCommonPathAncestor(topDstURL, pair3.myDst);
                                }
                                repos = this.createRepository(SVNURL.parseURIEncoded(topDstURL), adminArea.getRoot(), wcAccess, true);
                                newDirs = new ArrayList<String>();
                                if (makeParents) {
                                    String rootURL = topDstURL;
                                    SVNNodeKind kind = repos.checkPath("", -1L);
                                    while (kind == SVNNodeKind.NONE) {
                                        newDirs.add(rootURL);
                                        rootURL = SVNPathUtil.removeTail(rootURL);
                                        repos.setLocation(SVNURL.parseURIEncoded(rootURL), false);
                                        kind = repos.checkPath("", -1L);
                                    }
                                    topDstURL = rootURL;
                                }
                                for (int i = 0; i < copyPairs.size(); ++i) {
                                    CopyPair pair4 = (CopyPair)copyPairs.get(i);
                                    SVNEntry entry = wcAccess.getEntry(new File(pair4.mySource), false);
                                    pair4.mySourceRevisionNumber = entry.getRevision();
                                    String dstRelativePath = SVNPathUtil.getPathAsChild(topDstURL, pair4.myDst);
                                    SVNNodeKind kind = repos.checkPath(dstRelativePath = SVNEncodingUtil.uriDecode(dstRelativePath), -1L);
                                    if (kind == SVNNodeKind.NONE) continue;
                                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_ALREADY_EXISTS, "Path ''{0}'' already exists", SVNURL.parseURIEncoded(pair4.myDst));
                                    SVNErrorManager.error(err, SVNLogType.WC);
                                }
                                commitItems = new ArrayList<SVNCommitItem>(copyPairs.size());
                                if (makeParents) {
                                    for (int i = 0; i < newDirs.size(); ++i) {
                                        String newDirURL = (String)newDirs.get(i);
                                        url = SVNURL.parseURIEncoded(newDirURL);
                                        item = new SVNCommitItem(null, url, null, SVNNodeKind.NONE, null, null, true, false, false, false, false, false);
                                        commitItems.add(item);
                                    }
                                }
                                for (int i = 0; i < copyPairs.size(); ++i) {
                                    pair = (CopyPair)copyPairs.get(i);
                                    url = SVNURL.parseURIEncoded(((CopyPair)pair).myDst);
                                    item = new SVNCommitItem(null, url, null, SVNNodeKind.NONE, null, null, true, false, false, false, false, false);
                                    commitItems.add(item);
                                }
                                commitables = commitItems.toArray(new SVNCommitItem[commitItems.size()]);
                                message = this.getCommitHandler().getCommitMessage(message, commitables);
                                if (message != null) break block60;
                                pair = SVNCommitInfo.NULL;
                                Object var42_31 = null;
                                if (tmpFiles == null) break block61;
                                Iterator files222 = tmpFiles.iterator();
                                while (files222.hasNext()) {
                                    File file = (File)files222.next();
                                    SVNFileUtil.deleteFile(file);
                                }
                            }
                            if (commitEditor != null && info == null) {
                                try {
                                    commitEditor.abortEdit();
                                }
                                catch (SVNException e2) {
                                    SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, e2);
                                }
                            }
                            if (wcAccess != null) {
                                wcAccess.close();
                            }
                            return pair;
                        }
                        revprops = this.getCommitHandler().getRevisionProperties(message, commitables, revprops == null ? new SVNProperties() : revprops);
                        if (revprops != null) break block63;
                        pair = SVNCommitInfo.NULL;
                        Object var42_32 = null;
                        if (tmpFiles == null) break block64;
                        Iterator files222 = tmpFiles.iterator();
                        while (files222.hasNext()) {
                            File file = (File)files222.next();
                            SVNFileUtil.deleteFile(file);
                        }
                    }
                    if (commitEditor != null && info == null) {
                        try {
                            commitEditor.abortEdit();
                        }
                        catch (SVNException e2) {
                            SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, e2);
                        }
                    }
                    if (wcAccess != null) {
                        wcAccess.close();
                    }
                    return pair;
                }
                try {
                    int i;
                    TreeMap<File, SVNCommitItem> allCommitables = new TreeMap<File, SVNCommitItem>();
                    repos.setLocation(repos.getRepositoryRoot(true), false);
                    SVNHashMap pathsToExternalsProps = new SVNHashMap();
                    for (i = 0; i < copyPairs.size(); ++i) {
                        CopyPair source = (CopyPair)copyPairs.get(i);
                        File srcFile = new File(source.mySource);
                        SVNEntry entry = wcAccess.getVersionedEntry(srcFile, false);
                        SVNAdminArea dirArea = null;
                        dirArea = entry.isDirectory() ? wcAccess.retrieve(srcFile) : wcAccess.retrieve(srcFile.getParentFile());
                        pathsToExternalsProps.clear();
                        SVNCommitUtil.harvestCommitables(allCommitables, dirArea, srcFile, null, entry, source.myDst, entry.getURL(), true, false, false, null, SVNDepth.INFINITY, false, null, this.getCommitParameters(), pathsToExternalsProps);
                        SVNCommitItem item = (SVNCommitItem)allCommitables.get(srcFile);
                        SVNURL srcURL = entry.getSVNURL();
                        Map mergeInfo = this.calculateTargetMergeInfo(srcFile, wcAccess, srcURL, source.mySourceRevisionNumber, repos, false);
                        Map wcMergeInfo = SVNPropertiesManager.parseMergeInfo(srcFile, entry, false);
                        if (wcMergeInfo != null && mergeInfo != null) {
                            mergeInfo = SVNMergeInfoUtil.mergeMergeInfos(mergeInfo, wcMergeInfo);
                        } else if (mergeInfo == null) {
                            mergeInfo = wcMergeInfo;
                        }
                        if (mergeInfo != null) {
                            String mergeInfoString = SVNMergeInfoUtil.formatMergeInfoToString(mergeInfo);
                            item.setProperty("svn:mergeinfo", SVNPropertyValue.create(mergeInfoString));
                        }
                        if (pathsToExternalsProps.isEmpty()) continue;
                        LinkedList<String> newExternals = new LinkedList<String>();
                        Iterator pathsIter = pathsToExternalsProps.keySet().iterator();
                        while (pathsIter.hasNext()) {
                            File localPath = (File)pathsIter.next();
                            String externalsPropString = (String)pathsToExternalsProps.get(localPath);
                            SVNExternal[] externals = SVNExternal.parseExternals(localPath.getAbsolutePath(), externalsPropString);
                            boolean introduceVirtualExternalChange = false;
                            newExternals.clear();
                            for (int k = 0; k < externals.length; ++k) {
                                File externalWC = new File(localPath, externals[k].getPath());
                                SVNEntry externalEntry = null;
                                try {
                                    wcAccess.open(externalWC, false, 0);
                                    externalEntry = wcAccess.getVersionedEntry(externalWC, false);
                                }
                                catch (SVNException svne) {
                                    if (svne instanceof SVNCancelException) {
                                        throw svne;
                                    }
                                }
                                finally {
                                    wcAccess.closeAdminArea(externalWC);
                                }
                                SVNRevision externalsWCRevision = SVNRevision.UNDEFINED;
                                if (externalEntry != null) {
                                    externalsWCRevision = SVNRevision.create(externalEntry.getRevision());
                                }
                                SVNEntry ownerEntry = wcAccess.getEntry(localPath, false);
                                SVNURL ownerURL = null;
                                if (ownerEntry != null) {
                                    ownerURL = ownerEntry.getSVNURL();
                                }
                                if (ownerURL == null) continue;
                                SVNRevision[] revs = this.getExternalsHandler().handleExternal(externalWC, externals[k].resolveURL(repos.getRepositoryRoot(true), ownerURL), externals[k].getRevision(), externals[k].getPegRevision(), externals[k].getRawValue(), externalsWCRevision);
                                if (revs != null && revs[0] == externals[k].getRevision()) {
                                    newExternals.add(externals[k].getRawValue());
                                    continue;
                                }
                                if (revs == null) continue;
                                SVNExternal newExternal = new SVNExternal(externals[k].getPath(), externals[k].getUnresolvedUrl(), revs[1], revs[0], true, externals[k].isPegRevisionExplicit(), externals[k].isNewFormat());
                                newExternals.add(newExternal.toString());
                                if (introduceVirtualExternalChange) continue;
                                introduceVirtualExternalChange = true;
                            }
                            if (!introduceVirtualExternalChange) continue;
                            String newExternalsProp = "";
                            Iterator externalsIter = newExternals.iterator();
                            while (externalsIter.hasNext()) {
                                String external = (String)externalsIter.next();
                                newExternalsProp = newExternalsProp + external + '\n';
                            }
                            SVNCommitItem itemWithExternalsChanges = (SVNCommitItem)allCommitables.get(localPath);
                            if (itemWithExternalsChanges != null) {
                                itemWithExternalsChanges.setProperty("svn:externals", SVNPropertyValue.create(newExternalsProp));
                                continue;
                            }
                            SVNAdminArea childArea = wcAccess.retrieve(localPath);
                            String relativePath = childArea.getRelativePath(dirArea);
                            String itemURL = SVNPathUtil.append(source.myDst, SVNEncodingUtil.uriEncode(relativePath));
                            itemWithExternalsChanges = new SVNCommitItem(localPath, SVNURL.parseURIEncoded(itemURL), null, SVNNodeKind.DIR, null, null, false, false, true, false, false, false);
                            itemWithExternalsChanges.setProperty("svn:externals", SVNPropertyValue.create(newExternalsProp));
                            allCommitables.put(localPath, itemWithExternalsChanges);
                        }
                    }
                    commitItems = new ArrayList(allCommitables.values());
                    if (makeParents) {
                        for (i = 0; i < newDirs.size(); ++i) {
                            String newDirURL = (String)newDirs.get(i);
                            SVNURL url = SVNURL.parseURIEncoded(newDirURL);
                            SVNCommitItem item = new SVNCommitItem(null, url, null, SVNNodeKind.NONE, null, null, true, false, false, false, false, false);
                            commitItems.add(item);
                        }
                    }
                    commitables = commitItems.toArray(new SVNCommitItem[commitItems.size()]);
                    for (i = 0; i < commitables.length; ++i) {
                        commitables[i].setWCAccess(wcAccess);
                    }
                    allCommitables.clear();
                    SVNURL url = SVNCommitUtil.translateCommitables(commitables, allCommitables);
                    repos = this.createRepository(url, null, null, true);
                    SVNCommitMediator mediator = new SVNCommitMediator(allCommitables);
                    tmpFiles = mediator.getTmpFiles();
                    message = SVNCommitClient.validateCommitMessage(message);
                    SVNURL rootURL = repos.getRepositoryRoot(true);
                    commitEditor = repos.getCommitEditor(message, null, true, revprops, mediator);
                    info = SVNCommitter.commit(tmpFiles, allCommitables, rootURL.getPath(), commitEditor);
                    commitEditor = null;
                    Object var42_33 = null;
                    if (tmpFiles == null) break block67;
                    files222 = tmpFiles.iterator();
                }
                catch (Throwable throwable) {
                    Object var42_35 = null;
                    if (tmpFiles != null) {
                        Iterator files222 = tmpFiles.iterator();
                        while (files222.hasNext()) {
                            File file = (File)files222.next();
                            SVNFileUtil.deleteFile(file);
                        }
                    }
                    if (commitEditor != null && info == null) {
                        try {
                            commitEditor.abortEdit();
                        }
                        catch (SVNException e2) {
                            SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, e2);
                        }
                    }
                    if (wcAccess != null) {
                        wcAccess.close();
                    }
                    throw throwable;
                }
                while (files222.hasNext()) {
                    File file = (File)files222.next();
                    SVNFileUtil.deleteFile(file);
                }
            }
            if (commitEditor != null && info == null) {
                try {
                    commitEditor.abortEdit();
                }
                catch (SVNException e2) {
                    SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, e2);
                }
            }
            if (wcAccess != null) {
                wcAccess.close();
            }
            break block70;
            {
                catch (SVNCancelException cancel) {
                    throw cancel;
                }
                catch (SVNException e) {
                    SVNErrorMessage err = e.getErrorMessage().wrap("Commit failed (details follow):");
                    SVNErrorManager.error(err, SVNLogType.WC);
                    Object var42_34 = null;
                    if (tmpFiles != null) {
                        Iterator files222 = tmpFiles.iterator();
                        while (files222.hasNext()) {
                            File file = (File)files222.next();
                            SVNFileUtil.deleteFile(file);
                        }
                    }
                    if (commitEditor != null && info == null) {
                        try {
                            commitEditor.abortEdit();
                        }
                        catch (SVNException e2) {
                            SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, e2);
                        }
                    }
                    if (wcAccess != null) {
                        wcAccess.close();
                    }
                }
            }
        }
        if (info != null && info.getNewRevision() >= 0L) {
            this.dispatchEvent(SVNEventFactory.createSVNEvent(null, SVNNodeKind.NONE, null, info.getNewRevision(), SVNEventAction.COMMIT_COMPLETED, null, null, null), -1.0);
        }
        return info != null ? info : SVNCommitInfo.NULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private SVNCommitInfo copyReposToRepos(List copyPairs, boolean makeParents, boolean isMove, String message, SVNProperties revprops) throws SVNException {
        block36: {
            pathInfos = new ArrayList<CopyPathInfo>();
            pathsMap = new SVNHashMap();
            for (i = 0; i < copyPairs.size(); ++i) {
                info = new CopyPathInfo();
                pathInfos.add(info);
            }
            topURL = ((CopyPair)copyPairs.get((int)0)).mySource;
            topDstURL = ((CopyPair)copyPairs.get((int)0)).myDst;
            for (i = 1; i < copyPairs.size(); ++i) {
                pair = (CopyPair)copyPairs.get(i);
                topURL = SVNPathUtil.getCommonPathAncestor(topURL, pair.mySource);
            }
            topURL = copyPairs.size() == 1 ? SVNPathUtil.getCommonPathAncestor(topURL, topDstURL) : SVNPathUtil.getCommonPathAncestor(topURL, SVNPathUtil.removeTail(topDstURL));
            try {
                SVNURL.parseURIEncoded(topURL);
            }
            catch (SVNException e) {
                topURL = null;
            }
            if (topURL == null) {
                url1 = SVNURL.parseURIEncoded(((CopyPair)copyPairs.get((int)0)).mySource);
                url2 = SVNURL.parseURIEncoded(((CopyPair)copyPairs.get((int)0)).myDst);
                err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Source and dest appear not to be in the same repository (src: ''{0}''; dst: ''{1}'')", new Object[]{url1, url2});
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            for (i = 0; i < copyPairs.size(); ++i) {
                pair = (CopyPair)copyPairs.get(i);
                info = (CopyPathInfo)pathInfos.get(i);
                if (!pair.mySource.equals(pair.myDst)) continue;
                info.isResurrection = true;
                if (!topURL.equals(pair.mySource)) continue;
                topURL = SVNPathUtil.removeTail(topURL);
            }
            topRepos = this.createRepository(SVNURL.parseURIEncoded(topURL), null, null, true);
            newDirs = new ArrayList<String>();
            if (makeParents) {
                pair = (CopyPair)copyPairs.get(0);
                relativeDir = SVNPathUtil.getPathAsChild(topURL, SVNPathUtil.removeTail(pair.myDst));
                if (relativeDir != null) {
                    relativeDir = SVNEncodingUtil.uriDecode(relativeDir);
                    kind = topRepos.checkPath(relativeDir, -1L);
                    while (kind == SVNNodeKind.NONE) {
                        newDirs.add(relativeDir);
                        relativeDir = SVNPathUtil.removeTail(relativeDir);
                        kind = topRepos.checkPath(relativeDir, -1L);
                    }
                }
            }
            rootURL = topRepos.getRepositoryRoot(true).toString();
            for (i = 0; i < copyPairs.size(); ++i) {
                pair = (CopyPair)copyPairs.get(i);
                info = (CopyPathInfo)pathInfos.get(i);
                if (pair.myDst.equals(rootURL) || SVNPathUtil.getPathAsChild(pair.myDst, pair.mySource) == null) continue;
                info.isResurrection = true;
                topURL = SVNPathUtil.removeTail(topURL);
            }
            topRepos.setLocation(SVNURL.parseURIEncoded(topURL), false);
            latestRevision = topRepos.getLatestRevision();
            for (i = 0; i < copyPairs.size(); ++i) {
                pair = (CopyPair)copyPairs.get(i);
                info = (CopyPathInfo)pathInfos.get(i);
                info.mySourceRevisionNumber = pair.mySourceRevisionNumber = this.getRevisionNumber(pair.mySourceRevision, topRepos, null);
                locations = this.getLocations(SVNURL.parseURIEncoded(pair.mySource), null, topRepos, pair.mySourcePegRevision, pair.mySourceRevision, SVNRevision.UNDEFINED);
                pair.mySource = locations[0].getURL().toString();
                srcRelative = SVNPathUtil.getPathAsChild(topURL, pair.mySource);
                srcRelative = srcRelative != null ? SVNEncodingUtil.uriDecode(srcRelative) : "";
                dstRelative = SVNPathUtil.getPathAsChild(topURL, pair.myDst);
                dstRelative = dstRelative != null ? SVNEncodingUtil.uriDecode(dstRelative) : "";
                if ("".equals(srcRelative) && isMove) {
                    err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot move URL ''{0}'' into itself", SVNURL.parseURIEncoded(pair.mySource));
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                info.mySourceKind = topRepos.checkPath(srcRelative, pair.mySourceRevisionNumber);
                if (info.mySourceKind == SVNNodeKind.NONE) {
                    err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Path ''{0}'' does not exist in revision {1}", new Object[]{SVNURL.parseURIEncoded(pair.mySource), new Long(pair.mySourceRevisionNumber)});
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                if ((dstKind = topRepos.checkPath(dstRelative, latestRevision)) != SVNNodeKind.NONE) {
                    err = SVNErrorMessage.create(SVNErrorCode.FS_ALREADY_EXISTS, "Path ''{0}'' already exists", dstRelative);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                info.mySource = pair.mySource;
                info.mySourcePath = srcRelative;
                info.myDstPath = dstRelative;
            }
            paths = new ArrayList<String>(copyPairs.size() * 2);
            commitItems = new ArrayList<SVNCommitItem>(copyPairs.size() * 2);
            if (makeParents) {
                newDirsIter = newDirs.iterator();
                while (newDirsIter.hasNext()) {
                    dirPath = (String)newDirsIter.next();
                    itemURL = SVNURL.parseURIEncoded(SVNPathUtil.append(topURL, dirPath));
                    item = new SVNCommitItem(null, itemURL, null, SVNNodeKind.NONE, null, null, true, false, false, false, false, false);
                    commitItems.add(item);
                }
            }
            infos = pathInfos.iterator();
            while (infos.hasNext()) {
                info = (CopyPathInfo)infos.next();
                itemURL = SVNURL.parseURIEncoded(SVNPathUtil.append(topURL, info.myDstPath));
                item = new SVNCommitItem(null, itemURL, null, SVNNodeKind.NONE, null, null, true, false, false, false, false, false);
                commitItems.add(item);
                pathsMap.put(info.myDstPath, info);
                if (!isMove || info.isResurrection) continue;
                itemURL = SVNURL.parseURIEncoded(SVNPathUtil.append(topURL, info.mySourcePath));
                item = new SVNCommitItem(null, itemURL, null, SVNNodeKind.NONE, null, null, false, true, false, false, false, false);
                commitItems.add(item);
                pathsMap.put(info.mySourcePath, info);
            }
            if (makeParents) {
                newDirsIter = newDirs.iterator();
                while (newDirsIter.hasNext()) {
                    dirPath = (String)newDirsIter.next();
                    info = new CopyPathInfo();
                    info.myDstPath = dirPath;
                    info.isDirAdded = true;
                    paths.add(info.myDstPath);
                    pathsMap.put(dirPath, info);
                }
            }
            infos = pathInfos.iterator();
            while (infos.hasNext()) {
                info = (CopyPathInfo)infos.next();
                mergeInfo = this.calculateTargetMergeInfo(null, null, SVNURL.parseURIEncoded(info.mySource), info.mySourceRevisionNumber, topRepos, false);
                if (mergeInfo != null) {
                    info.myMergeInfoProp = SVNMergeInfoUtil.formatMergeInfoToString(mergeInfo);
                }
                paths.add(info.myDstPath);
                if (!isMove || info.isResurrection) continue;
                paths.add(info.mySourcePath);
            }
            commitables = commitItems.toArray(new SVNCommitItem[commitItems.size()]);
            message = this.getCommitHandler().getCommitMessage(message, commitables);
            if (message == null) {
                return SVNCommitInfo.NULL;
            }
            message = SVNCommitClient.validateCommitMessage(message);
            revprops = this.getCommitHandler().getRevisionProperties(message, commitables, revprops == null ? new SVNProperties() : revprops);
            if (revprops == null) {
                return SVNCommitInfo.NULL;
            }
            commitEditor = topRepos.getCommitEditor(message, null, true, revprops, null);
            committer = new CopyCommitPathHandler(pathsMap, isMove);
            result = null;
            try {
                SVNCommitUtil.driveCommitEditor(committer, paths, commitEditor, latestRevision);
                result = commitEditor.closeEdit();
                var24_34 = null;
                ** if (commitEditor == null || result != null) goto lbl-1000
            }
            catch (Throwable var23_40) {
                var24_36 = null;
                if (commitEditor != null && result == null) {
                    try {
                        commitEditor.abortEdit();
                    }
                    catch (SVNException e) {
                        SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, e);
                    }
                }
                throw var23_40;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    commitEditor.abortEdit();
                }
                catch (SVNException e) {
                    SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, e);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block36;
                catch (SVNCancelException cancel) {
                    throw cancel;
                }
                catch (SVNException e) {
                    err = e.getErrorMessage().wrap("Commit failed (details follow):");
                    SVNErrorManager.error(err, SVNLogType.DEFAULT);
                    var24_35 = null;
                    if (commitEditor != null && result == null) {
                        try {
                            commitEditor.abortEdit();
                        }
                        catch (SVNException e) {
                            SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, e);
                        }
                    }
                }
            }
        }
        if (result != null && result.getNewRevision() >= 0L) {
            this.dispatchEvent(SVNEventFactory.createSVNEvent(null, SVNNodeKind.NONE, null, result.getNewRevision(), SVNEventAction.COMMIT_COMPLETED, null, null, null), -1.0);
        }
        return result != null ? result : SVNCommitInfo.NULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyReposToWC(List copyPairs, boolean makeParents) throws SVNException {
        Iterator pairs = copyPairs.iterator();
        while (pairs.hasNext()) {
            CopyPair pair = (CopyPair)pairs.next();
            SVNBasicClient.SVNRepositoryLocation[] locations = this.getLocations(SVNURL.parseURIEncoded(pair.mySource), null, null, pair.mySourcePegRevision, pair.mySourceRevision, SVNRevision.UNDEFINED);
            String actualURL = locations[0].getURL().toString();
            String originalSource = pair.mySource;
            pair.mySource = actualURL;
            pair.myOriginalSource = originalSource;
        }
        String topDst = ((CopyPair)copyPairs.get((int)0)).myDst;
        if (copyPairs.size() > 1) {
            topDst = SVNPathUtil.removeTail(topDst);
        }
        String topSrc = ((CopyPair)copyPairs.get((int)0)).mySource;
        for (int i = 1; i < copyPairs.size(); ++i) {
            CopyPair pair = (CopyPair)copyPairs.get(i);
            topSrc = SVNPathUtil.getCommonPathAncestor(topSrc, pair.mySource);
        }
        if (copyPairs.size() == 1) {
            topSrc = SVNPathUtil.removeTail(topSrc);
        }
        SVNRepository topSrcRepos = this.createRepository(SVNURL.parseURIEncoded(topSrc), null, null, false);
        try {
            SVNErrorMessage err;
            Iterator pairs2 = copyPairs.iterator();
            while (pairs2.hasNext()) {
                CopyPair pair = (CopyPair)pairs2.next();
                pair.mySourceRevisionNumber = this.getRevisionNumber(pair.mySourceRevision, topSrcRepos, null);
            }
            String reposPath = topSrcRepos.getLocation().toString();
            Iterator pairs3 = copyPairs.iterator();
            while (pairs3.hasNext()) {
                CopyPair pair = (CopyPair)pairs3.next();
                String relativePath = SVNPathUtil.getPathAsChild(reposPath, pair.mySource);
                SVNNodeKind kind = topSrcRepos.checkPath(relativePath = SVNEncodingUtil.uriDecode(relativePath), pair.mySourceRevisionNumber);
                if (kind == SVNNodeKind.NONE) {
                    err = null;
                    err = pair.mySourceRevisionNumber >= 0L ? SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Path ''{0}'' not found in revision {1}", new Object[]{SVNURL.parseURIEncoded(pair.mySource), new Long(pair.mySourceRevisionNumber)}) : SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Path ''{0}'' not found in head revision", SVNURL.parseURIEncoded(pair.mySource));
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                pair.mySourceKind = kind;
                SVNFileType dstType = SVNFileType.getType(new File(pair.myDst));
                if (dstType != SVNFileType.NONE) {
                    SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Path ''{0}'' already exists", new File(pair.myDst));
                    SVNErrorManager.error(err2, SVNLogType.WC);
                }
                String dstParent = SVNPathUtil.removeTail(pair.myDst);
                SVNFileType dstParentFileType = SVNFileType.getType(new File(dstParent));
                if (makeParents && dstParentFileType == SVNFileType.NONE) {
                    this.addLocalParents(new File(dstParent), this.getEventDispatcher());
                    continue;
                }
                if (dstParentFileType == SVNFileType.DIRECTORY) continue;
                SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "Path ''{0}'' is not a directory", dstParent);
                SVNErrorManager.error(err3, SVNLogType.WC);
            }
            SVNWCAccess dstAccess = this.createWCAccess();
            try {
                String dstUUID;
                String srcUUID;
                block24: {
                    block23: {
                        dstAccess.probeOpen(new File(topDst), true, 0);
                        Iterator pairs4 = copyPairs.iterator();
                        while (pairs4.hasNext()) {
                            CopyPair pair = (CopyPair)pairs4.next();
                            SVNEntry dstEntry = dstAccess.getEntry(new File(pair.myDst), false);
                            if (dstEntry == null || dstEntry.isDirectory() || dstEntry.isScheduledForDeletion()) continue;
                            err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Entry for ''{0}'' exists (though the working file is missing)", new File(pair.myDst));
                            SVNErrorManager.error(err, SVNLogType.WC);
                        }
                        srcUUID = null;
                        dstUUID = null;
                        try {
                            srcUUID = topSrcRepos.getRepositoryUUID(true);
                        }
                        catch (SVNException e) {
                            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NO_REPOS_UUID) break block23;
                            throw e;
                        }
                    }
                    String dstParent = topDst;
                    if (copyPairs.size() == 1) {
                        dstParent = SVNPathUtil.removeTail(topDst);
                    }
                    try {
                        dstUUID = this.getUUIDFromPath(dstAccess, new File(dstParent));
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NO_REPOS_UUID) break block24;
                        throw e;
                    }
                }
                boolean sameRepos = false;
                if (srcUUID != null) {
                    sameRepos = srcUUID.equals(dstUUID);
                }
                Iterator pairs5 = copyPairs.iterator();
                while (pairs5.hasNext()) {
                    CopyPair pair = (CopyPair)pairs5.next();
                    this.copyReposToWC(pair, sameRepos, topSrcRepos, dstAccess);
                }
            }
            finally {
                dstAccess.close();
            }
        }
        finally {
            topSrcRepos.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyReposToWC(CopyPair pair, boolean sameRepositories, SVNRepository topSrcRepos, SVNWCAccess dstAccess) throws SVNException {
        long srcRevNum = pair.mySourceRevisionNumber;
        if (pair.mySourceKind == SVNNodeKind.DIR) {
            String srcURL = pair.myOriginalSource;
            SVNURL url = SVNURL.parseURIEncoded(srcURL);
            SVNUpdateClient updateClient = new SVNUpdateClient(this.getRepositoryPool(), this.getOptions());
            updateClient.setEventHandler(this.getEventDispatcher());
            File dstFile = new File(pair.myDst);
            SVNRevision srcRevision = pair.mySourceRevision;
            SVNRevision srcPegRevision = pair.mySourcePegRevision;
            updateClient.doCheckout(url, dstFile, srcPegRevision, srcRevision, SVNDepth.INFINITY, false);
            if (sameRepositories) {
                url = SVNURL.parseURIEncoded(pair.mySource);
                SVNAdminArea dstArea = dstAccess.open(dstFile, true, -1);
                SVNEntry dstRootEntry = dstArea.getEntry(dstArea.getThisDirName(), false);
                if (srcRevision == SVNRevision.HEAD) {
                    srcRevNum = dstRootEntry.getRevision();
                }
                SVNAdminArea dir = dstAccess.getAdminArea(dstFile.getParentFile());
                SVNWCManager.add(dstFile, dir, url, srcRevNum);
                Map srcMergeInfo = this.calculateTargetMergeInfo(null, null, url, srcRevNum, topSrcRepos, false);
                this.extendWCMergeInfo(dstFile, dstRootEntry, srcMergeInfo, dstAccess);
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Source URL ''{0}'' is from foreign repository; leaving it as a disjoint WC", url);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        } else if (pair.mySourceKind == SVNNodeKind.FILE) {
            String srcURL = pair.mySource;
            SVNURL url = SVNURL.parseURIEncoded(srcURL);
            File dst = new File(pair.myDst);
            SVNAdminArea dir = dstAccess.getAdminArea(dst.getParentFile());
            File tmpFile = SVNAdminUtil.createTmpFile(dir);
            String path = this.getPathRelativeToRoot(null, url, null, null, topSrcRepos);
            SVNProperties props = new SVNProperties();
            OutputStream os = null;
            long revision = -1L;
            try {
                os = SVNFileUtil.openFileForWriting(tmpFile);
                revision = topSrcRepos.getFile(path, srcRevNum, props, new SVNCancellableOutputStream(os, this));
            }
            finally {
                SVNFileUtil.closeFile(os);
            }
            if (srcRevNum < 0L) {
                srcRevNum = revision;
            }
            SVNWCManager.addRepositoryFile(dir, dst.getName(), null, tmpFile, props, null, sameRepositories ? pair.mySource : null, sameRepositories ? srcRevNum : -1L);
            SVNEntry entry = dstAccess.getEntry(dst, false);
            Map mergeInfo = this.calculateTargetMergeInfo(null, null, url, srcRevNum, topSrcRepos, false);
            this.extendWCMergeInfo(dst, entry, mergeInfo, dstAccess);
            SVNEvent event = SVNEventFactory.createSVNEvent(dst, SVNNodeKind.FILE, null, -1L, SVNEventAction.ADD, null, null, null);
            dstAccess.handleEvent(event);
            this.sleepForTimeStamp();
        }
    }

    private void copyWCToWC(List copyPairs, boolean isMove, boolean makeParents) throws SVNException {
        Iterator pairs = copyPairs.iterator();
        while (pairs.hasNext()) {
            SVNFileType dstFileType;
            CopyPair pair = (CopyPair)pairs.next();
            SVNFileType srcFileType = SVNFileType.getType(new File(pair.mySource));
            if (srcFileType == SVNFileType.NONE) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Path ''{0}'' does not exist", new File(pair.mySource));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if ((dstFileType = SVNFileType.getType(new File(pair.myDst))) != SVNFileType.NONE) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Path ''{0}'' already exists", new File(pair.myDst));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            File dstParent = new File(SVNPathUtil.removeTail(pair.myDst));
            pair.myBaseName = SVNPathUtil.tail(pair.myDst);
            SVNFileType dstParentFileType = SVNFileType.getType(dstParent);
            if (makeParents && dstParentFileType == SVNFileType.NONE) {
                this.addLocalParents(dstParent, this.getEventDispatcher());
                continue;
            }
            if (dstParentFileType == SVNFileType.DIRECTORY) continue;
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "Path ''{0}'' is not a directory", dstParent);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (isMove) {
            this.moveWCToWC(copyPairs);
        } else {
            this.copyWCToWC(copyPairs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyDisjointWCToWC(File nestedWC) throws SVNException {
        File nestedWCParent;
        SVNFileType nestedWCType = SVNFileType.getType(nestedWC);
        if (nestedWCType != SVNFileType.DIRECTORY) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "This kind of copy can be run on a root of a disjoint wc directory only");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if ((nestedWCParent = (nestedWC = new File(nestedWC.getAbsolutePath().replace(File.separatorChar, '/'))).getParentFile()) == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "{0} seems to be not a disjoint wc since it has no parent", nestedWC);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNWCAccess parentWCAccess = this.createWCAccess();
        SVNWCAccess nestedWCAccess = this.createWCAccess();
        try {
            SVNErrorMessage err;
            SVNURL parentReposRoot;
            String parentPath;
            SVNURL nestedWCReposRoot;
            String nestedWCPath;
            SVNErrorMessage err2;
            SVNAdminArea parentArea = parentWCAccess.open(nestedWCParent, true, 0);
            SVNEntry srcEntryInParent = parentWCAccess.getEntry(nestedWC, false);
            if (srcEntryInParent != null) {
                SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Entry ''{0}'' already exists in parent directory", nestedWC.getName());
                SVNErrorManager.error(err3, SVNLogType.WC);
            }
            SVNAdminArea nestedArea = nestedWCAccess.open(nestedWC, false, -1);
            SVNEntry nestedWCThisEntry = nestedWCAccess.getVersionedEntry(nestedWC, false);
            SVNEntry parentThisEntry = parentWCAccess.getVersionedEntry(nestedWCParent, false);
            if (nestedWCThisEntry.getRepositoryRoot() != null && parentThisEntry.getRepositoryRoot() != null && !nestedWCThisEntry.getRepositoryRoot().equals(parentThisEntry.getRepositoryRoot())) {
                err2 = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy to ''{0}'', as it is not from repository ''{1}''; it is from ''{2}''", new Object[]{nestedWCParent, nestedWCThisEntry.getRepositoryRootURL(), parentThisEntry.getRepositoryRootURL()});
                SVNErrorManager.error(err2, SVNLogType.WC);
            }
            if (parentThisEntry.isScheduledForDeletion()) {
                err2 = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy to ''{0}'', as it is scheduled for deletion", nestedWCParent);
                SVNErrorManager.error(err2, SVNLogType.WC);
            }
            if (nestedWCThisEntry.isScheduledForDeletion()) {
                err2 = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy ''{0}'', as it is scheduled for deletion", nestedWC);
                SVNErrorManager.error(err2, SVNLogType.WC);
            }
            if (SVNPathUtil.isAncestor(nestedWCPath = this.getPathRelativeToRoot(nestedWC, null, nestedWCReposRoot = this.getReposRoot(nestedWC, null, SVNRevision.WORKING, nestedArea, nestedWCAccess), nestedWCAccess, null), parentPath = this.getPathRelativeToRoot(nestedWCParent, null, parentReposRoot = this.getReposRoot(nestedWCParent, null, SVNRevision.WORKING, parentArea, parentWCAccess), parentWCAccess, null))) {
                err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot copy path ''{0}'' into its own child ''{1}", new Object[]{nestedWCPath, parentPath});
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (nestedWCThisEntry.isScheduledForAddition() && !nestedWCThisEntry.isCopied() || nestedWCThisEntry.getURL() == null) {
                err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Cannot copy or move ''{0}'': it is not in repository yet; try committing first", nestedWC);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            boolean[] extend = new boolean[]{false};
            Map mergeInfo = this.fetchMergeInfoForPropagation(nestedWC, extend, nestedWCAccess);
            this.copyDisjointDir(nestedWC, parentWCAccess, nestedWCParent);
            parentWCAccess.probeTry(nestedWC, true, -1);
            this.propagateMegeInfo(nestedWC, mergeInfo, extend, parentWCAccess);
        }
        finally {
            parentWCAccess.close();
            nestedWCAccess.close();
            this.sleepForTimeStamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyDisjointDir(File nestedWC, SVNWCAccess parentAccess, File nestedWCParent) throws SVNException {
        SVNWCClient wcClient = new SVNWCClient((ISVNAuthenticationManager)null, null);
        wcClient.setEventHandler(this.getEventDispatcher());
        wcClient.doCleanup(nestedWC);
        SVNWCAccess nestedWCAccess = this.createWCAccess();
        SVNAdminArea dir = null;
        String copyFromURL = null;
        long copyFromRevision = -1L;
        try {
            dir = nestedWCAccess.open(nestedWC, true, -1);
            SVNEntry nestedWCThisEntry = nestedWCAccess.getVersionedEntry(nestedWC, false);
            SVNCopyClient.postCopyCleanup(dir);
            if (nestedWCThisEntry.isCopied()) {
                if (nestedWCThisEntry.getCopyFromURL() != null) {
                    copyFromURL = nestedWCThisEntry.getCopyFromURL();
                    copyFromRevision = nestedWCThisEntry.getCopyFromRevision();
                }
                SVNHashMap attributes = new SVNHashMap();
                attributes.put("svn:entry:url", copyFromURL);
                dir.modifyEntry(dir.getThisDirName(), attributes, true, false);
            } else {
                copyFromURL = nestedWCThisEntry.getURL();
                copyFromRevision = nestedWCThisEntry.getRevision();
            }
        }
        finally {
            nestedWCAccess.close();
        }
        SVNWCManager.add(nestedWC, parentAccess.getAdminArea(nestedWCParent), SVNURL.parseURIEncoded(copyFromURL), copyFromRevision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyWCToWC(List pairs) throws SVNException {
        String dstParentPath = null;
        Iterator ps = pairs.iterator();
        while (ps.hasNext()) {
            CopyPair pair = (CopyPair)ps.next();
            String dstPath = pair.myDst;
            if (dstParentPath == null) {
                dstParentPath = SVNPathUtil.removeTail(pair.myDst);
            }
            dstParentPath = SVNPathUtil.getCommonPathAncestor(dstParentPath, dstPath);
        }
        SVNWCAccess dstAccess = this.createWCAccess();
        try {
            dstAccess.open(new File(dstParentPath), true, 0);
            Iterator ps2 = pairs.iterator();
            while (ps2.hasNext()) {
                Object var11_11;
                CopyPair pair = (CopyPair)ps2.next();
                this.checkCancelled();
                SVNWCAccess srcAccess = null;
                String srcParent = SVNPathUtil.removeTail(pair.mySource);
                SVNFileType srcType = SVNFileType.getType(new File(pair.mySource));
                try {
                    if (srcParent.equals(dstParentPath)) {
                        if (srcType == SVNFileType.DIRECTORY) {
                            srcAccess = this.createWCAccess();
                            srcAccess.open(new File(pair.mySource), false, -1);
                        } else {
                            srcAccess = dstAccess;
                        }
                    } else {
                        try {
                            srcAccess = this.createWCAccess();
                            srcAccess.open(new File(srcParent), false, srcType == SVNFileType.DIRECTORY ? -1 : 0);
                        }
                        catch (SVNException e) {
                            if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_NOT_DIRECTORY) throw e;
                            srcAccess = null;
                        }
                    }
                    File sourceFile = new File(pair.mySource);
                    this.copyFiles(sourceFile, new File(dstParentPath), dstAccess, pair.myBaseName);
                    if (srcAccess != null) {
                        this.propagateMegeInfo(sourceFile, new File(pair.myDst), srcAccess, dstAccess);
                    }
                    var11_11 = null;
                    if (srcAccess == null || srcAccess == dstAccess) continue;
                }
                catch (Throwable throwable) {
                    var11_11 = null;
                    if (srcAccess == null || srcAccess == dstAccess) throw throwable;
                    srcAccess.close();
                    throw throwable;
                    return;
                }
                srcAccess.close();
                {
                }
            }
        }
        finally {
            dstAccess.close();
            this.sleepForTimeStamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveWCToWC(List pairs) throws SVNException {
        Iterator ps = pairs.iterator();
        while (ps.hasNext()) {
            SVNWCAccess srcAccess;
            block8: {
                Object var13_12;
                CopyPair pair = (CopyPair)ps.next();
                this.checkCancelled();
                File srcParent = new File(SVNPathUtil.removeTail(pair.mySource));
                File dstParent = new File(SVNPathUtil.removeTail(pair.myDst));
                File sourceFile = new File(pair.mySource);
                SVNFileType srcType = SVNFileType.getType(sourceFile);
                srcAccess = this.createWCAccess();
                SVNWCAccess dstAccess = null;
                try {
                    srcAccess.open(srcParent, true, srcType == SVNFileType.DIRECTORY ? -1 : 0);
                    if (srcParent.equals(dstParent)) {
                        dstAccess = srcAccess;
                    } else {
                        String srcParentPath = srcParent.getAbsolutePath().replace(File.separatorChar, '/');
                        srcParentPath = SVNPathUtil.validateFilePath(srcParentPath);
                        String dstParentPath = dstParent.getAbsolutePath().replace(File.separatorChar, '/');
                        dstParentPath = SVNPathUtil.validateFilePath(dstParentPath);
                        if (srcType == SVNFileType.DIRECTORY && SVNPathUtil.isAncestor(srcParentPath, dstParentPath)) {
                            dstAccess = srcAccess;
                        } else {
                            dstAccess = this.createWCAccess();
                            dstAccess.open(dstParent, true, 0);
                        }
                    }
                    this.copyFiles(sourceFile, dstParent, dstAccess, pair.myBaseName);
                    this.propagateMegeInfo(sourceFile, new File(pair.myDst), srcAccess, dstAccess);
                    SVNWCManager.delete(srcAccess, srcAccess.getAdminArea(srcParent), sourceFile, true, true);
                    var13_12 = null;
                    if (dstAccess == null || dstAccess == srcAccess) break block8;
                }
                catch (Throwable throwable) {
                    var13_12 = null;
                    if (dstAccess != null && dstAccess != srcAccess) {
                        dstAccess.close();
                    }
                    srcAccess.close();
                    throw throwable;
                }
                dstAccess.close();
            }
            srcAccess.close();
            {
            }
        }
        this.sleepForTimeStamp();
    }

    private void propagateMegeInfo(File src, File dst, SVNWCAccess srcAccess, SVNWCAccess dstAccess) throws SVNException {
        boolean[] extend = new boolean[]{false};
        Map mergeInfo = this.fetchMergeInfoForPropagation(src, extend, srcAccess);
        this.propagateMegeInfo(dst, mergeInfo, extend, dstAccess);
    }

    Map fetchMergeInfoForPropagation(File src, boolean[] extend, SVNWCAccess srcAccess) throws SVNException {
        SVNEntry entry = srcAccess.getVersionedEntry(src, false);
        if (entry.getSchedule() == null || entry.isScheduledForAddition() && entry.isCopied()) {
            TreeMap mergeInfo = this.calculateTargetMergeInfo(src, srcAccess, entry.getSVNURL(), entry.getRevision(), null, true);
            if (mergeInfo == null) {
                mergeInfo = new TreeMap();
            }
            extend[0] = true;
            return mergeInfo;
        }
        TreeMap mergeInfo = SVNPropertiesManager.parseMergeInfo(src, entry, false);
        if (mergeInfo == null) {
            mergeInfo = new TreeMap();
        }
        extend[0] = false;
        return mergeInfo;
    }

    private void propagateMegeInfo(File dst, Map mergeInfo, boolean[] extend, SVNWCAccess dstAccess) throws SVNException {
        if (extend[0]) {
            SVNEntry dstEntry = dstAccess.getEntry(dst, false);
            this.extendWCMergeInfo(dst, dstEntry, mergeInfo, dstAccess);
            return;
        }
        SVNPropertiesManager.recordWCMergeInfo(dst, mergeInfo, dstAccess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFiles(File src, File dstParent, SVNWCAccess dstAccess, String dstName) throws SVNException {
        SVNWCAccess srcAccess = this.createWCAccess();
        try {
            SVNFileType srcType;
            SVNErrorMessage err;
            srcAccess.probeOpen(src, false, -1);
            SVNEntry dstEntry = dstAccess.getVersionedEntry(dstParent, false);
            SVNEntry srcEntry = srcAccess.getVersionedEntry(src, false);
            if (srcEntry.getRepositoryRoot() != null && dstEntry.getRepositoryRoot() != null && !srcEntry.getRepositoryRoot().equals(dstEntry.getRepositoryRoot())) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy to ''{0}'', as it is not from repository ''{1}''; it is from ''{2}''", new Object[]{dstParent, srcEntry.getRepositoryRootURL(), dstEntry.getRepositoryRootURL()});
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (dstEntry.isScheduledForDeletion()) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy to ''{0}'', as it is scheduled for deletion", dstParent);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if ((srcType = SVNFileType.getType(src)) == SVNFileType.FILE || srcType == SVNFileType.SYMLINK) {
                if (srcEntry.isScheduledForAddition() && !srcEntry.isCopied()) {
                    this.copyAddedFileAdm(src, dstAccess, dstParent, dstName, true);
                } else {
                    this.copyFileAdm(src, srcAccess, dstParent, dstAccess, dstName);
                }
            } else if (srcType == SVNFileType.DIRECTORY) {
                if (srcEntry.isScheduledForAddition() && !srcEntry.isCopied()) {
                    this.copyAddedDirAdm(src, srcAccess, dstParent, dstAccess, dstName, true);
                } else {
                    this.copyDirAdm(src, srcAccess, dstAccess, dstParent, dstName);
                }
            }
        }
        finally {
            srcAccess.close();
        }
    }

    private void copyFileAdm(File src, SVNWCAccess srcAccess, File dstParent, SVNWCAccess dstAccess, String dstName) throws SVNException {
        SVNEntry srcEntry;
        SVNEntry dstEntry;
        File dst = new File(dstParent, dstName);
        SVNFileType dstType = SVNFileType.getType(dst);
        if (dstType != SVNFileType.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "''{0}'' already exists and is in the way", dst);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if ((dstEntry = dstAccess.getEntry(dst, false)) != null && !dstEntry.isScheduledForDeletion()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "There is already a versioned item ''{0}''", dst);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if ((srcEntry = srcAccess.getVersionedEntry(src, false)).isScheduledForAddition() && !srcEntry.isCopied() || srcEntry.getURL() == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Cannot copy or move ''{0}'': it is not in repository yet; try committing first", src);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        String copyFromURL = null;
        long copyFromRevision = -1L;
        SVNAdminArea srcDir = srcAccess.getAdminArea(src.getParentFile());
        if (srcEntry.isCopied()) {
            SVNLocationEntry location = this.determineCopyFromInfo(src, srcAccess, srcEntry, dstEntry);
            copyFromURL = location.getPath();
            copyFromRevision = location.getRevision();
        } else {
            copyFromURL = srcEntry.getURL();
            copyFromRevision = srcEntry.getRevision();
        }
        File srcBaseFile = new File(src.getParentFile(), SVNAdminUtil.getTextBasePath(src.getName(), false));
        File dstBaseFile = new File(dstParent, SVNAdminUtil.getTextBasePath(dstName, true));
        SVNFileUtil.copyFile(srcBaseFile, dstBaseFile, false);
        SVNVersionedProperties srcBaseProps = srcDir.getBaseProperties(src.getName());
        SVNVersionedProperties srcWorkingProps = srcDir.getProperties(src.getName());
        SVNAdminArea dstDir = dstAccess.getAdminArea(dstParent);
        File tmpWCFile = SVNAdminUtil.createTmpFile(dstDir);
        if (srcWorkingProps.getPropertyValue("svn:special") != null) {
            SVNFileUtil.copyFile(src, tmpWCFile, false);
        } else {
            SVNFileUtil.copyFile(src, tmpWCFile, false);
        }
        SVNWCManager.addRepositoryFile(dstDir, dstName, tmpWCFile, null, srcBaseProps.asMap(), srcWorkingProps.asMap(), copyFromURL, copyFromRevision);
        SVNEvent event = SVNEventFactory.createSVNEvent(dst, SVNNodeKind.FILE, null, -1L, SVNEventAction.ADD, null, null, null);
        dstAccess.handleEvent(event);
    }

    private void copyAddedFileAdm(File src, SVNWCAccess dstAccess, File dstParent, String dstName, boolean isAdded) throws SVNException {
        File dst = new File(dstParent, dstName);
        SVNFileUtil.copyFile(src, dst, false);
        if (isAdded) {
            SVNWCManager.add(dst, dstAccess.getAdminArea(dstParent), null, -1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyDirAdm(File src, SVNWCAccess srcAccess, SVNWCAccess dstAccess, File dstParent, String dstName) throws SVNException {
        File dst = new File(dstParent, dstName);
        SVNEntry srcEntry = srcAccess.getVersionedEntry(src, false);
        if (srcEntry.isScheduledForAddition() && !srcEntry.isCopied() || srcEntry.getURL() == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Cannot copy or move ''{0}'': it is not in repository yet; try committing first", src);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNFileUtil.copyDirectory(src, dst, true, this.getEventDispatcher());
        SVNWCClient wcClient = new SVNWCClient((ISVNAuthenticationManager)null, null);
        wcClient.setEventHandler(this.getEventDispatcher());
        wcClient.doCleanup(dst);
        SVNWCAccess tgtAccess = this.createWCAccess();
        SVNAdminArea dir = null;
        String copyFromURL = null;
        long copyFromRevision = -1L;
        try {
            dir = tgtAccess.open(dst, true, -1);
            SVNCopyClient.postCopyCleanup(dir);
            if (srcEntry.isCopied()) {
                SVNEntry dstEntry = dstAccess.getEntry(dst, false);
                SVNLocationEntry info = this.determineCopyFromInfo(src, srcAccess, srcEntry, dstEntry);
                copyFromURL = info.getPath();
                copyFromRevision = info.getRevision();
                SVNHashMap attributes = new SVNHashMap();
                attributes.put("svn:entry:url", copyFromURL);
                dir.modifyEntry(dir.getThisDirName(), attributes, true, false);
            } else {
                copyFromURL = srcEntry.getURL();
                copyFromRevision = srcEntry.getRevision();
            }
        }
        finally {
            tgtAccess.close();
        }
        SVNWCManager.add(dst, dstAccess.getAdminArea(dstParent), SVNURL.parseURIEncoded(copyFromURL), copyFromRevision);
    }

    private void copyAddedDirAdm(File src, SVNWCAccess srcAccess, File dstParent, SVNWCAccess dstParentAccess, String dstName, boolean isAdded) throws SVNException {
        File dst = new File(dstParent, dstName);
        if (!isAdded) {
            SVNFileUtil.copyDirectory(src, dst, true, this.getEventDispatcher());
        } else {
            this.checkCancelled();
            dst.mkdirs();
            SVNWCManager.add(dst, dstParentAccess.getAdminArea(dstParent), null, -1L);
            SVNAdminArea srcChildArea = srcAccess.retrieve(src);
            File[] entries = SVNFileListUtil.listFiles(src);
            for (int i = 0; entries != null && i < entries.length; ++i) {
                this.checkCancelled();
                File fsEntry = entries[i];
                String name = fsEntry.getName();
                if (SVNFileUtil.getAdminDirectoryName().equals(name)) continue;
                SVNEntry entry = srcChildArea.getEntry(name, true);
                if (fsEntry.isDirectory()) {
                    this.copyAddedDirAdm(fsEntry, srcAccess, dst, dstParentAccess, name, entry != null);
                    continue;
                }
                if (!fsEntry.isFile()) continue;
                this.copyAddedFileAdm(fsEntry, dstParentAccess, dst, name, entry != null);
            }
        }
    }

    private SVNLocationEntry determineCopyFromInfo(File src, SVNWCAccess srcAccess, SVNEntry srcEntry, SVNEntry dstEntry) throws SVNException {
        String url = null;
        long rev = -1L;
        if (srcEntry.getCopyFromURL() != null) {
            url = srcEntry.getCopyFromURL();
            rev = srcEntry.getCopyFromRevision();
        } else {
            SVNLocationEntry info = this.getCopyFromInfoFromParent(src, srcAccess);
            url = info.getPath();
            rev = info.getRevision();
        }
        if (dstEntry != null && rev == dstEntry.getRevision() && url.equals(dstEntry.getCopyFromURL())) {
            url = null;
            rev = -1L;
        }
        return new SVNLocationEntry(rev, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNLocationEntry getCopyFromInfoFromParent(File file, SVNWCAccess access) throws SVNException {
        File parent = file.getParentFile();
        String rest = file.getName();
        String url = null;
        long rev = -1L;
        while (parent != null && url == null) {
            try {
                SVNEntry entry = access.getVersionedEntry(parent, false);
                url = entry.getCopyFromURL();
                rev = entry.getCopyFromRevision();
            }
            catch (SVNException e) {
                SVNWCAccess wcAccess = SVNWCAccess.newInstance(null);
                try {
                    wcAccess.probeOpen(parent, false, -1);
                    SVNEntry entry = wcAccess.getVersionedEntry(parent, false);
                    url = entry.getCopyFromURL();
                    rev = entry.getCopyFromRevision();
                }
                finally {
                    wcAccess.close();
                }
            }
            if (url != null) {
                url = SVNPathUtil.append(url, SVNEncodingUtil.uriEncode(rest));
                continue;
            }
            rest = SVNPathUtil.append(parent.getName(), rest);
            parent = parent.getParentFile();
        }
        return new SVNLocationEntry(rev, url);
    }

    private void addLocalParents(File path, ISVNEventHandler handler) throws SVNException {
        boolean created = path.mkdirs();
        SVNWCClient wcClient = new SVNWCClient((ISVNAuthenticationManager)null, null);
        try {
            wcClient.setEventHandler(handler);
            wcClient.doAdd(path, false, false, true, SVNDepth.EMPTY, true, true);
        }
        catch (SVNException e) {
            if (created) {
                SVNFileUtil.deleteAll(path, true);
            }
            throw e;
        }
    }

    private void extendWCMergeInfo(File path, SVNEntry entry, Map mergeInfo, SVNWCAccess access) throws SVNException {
        Map wcMergeInfo = SVNPropertiesManager.parseMergeInfo(path, entry, false);
        if (wcMergeInfo != null && mergeInfo != null) {
            wcMergeInfo = SVNMergeInfoUtil.mergeMergeInfos(wcMergeInfo, mergeInfo);
        } else if (wcMergeInfo == null) {
            wcMergeInfo = mergeInfo;
        }
        SVNPropertiesManager.recordWCMergeInfo(path, wcMergeInfo, access);
    }

    private Map calculateTargetMergeInfo(File srcFile, SVNWCAccess access, SVNURL srcURL, long srcRevision, SVNRepository repository, boolean noReposAccess) throws SVNException {
        boolean isLocallyAdded = false;
        SVNEntry entry = null;
        SVNURL url = null;
        if (access != null) {
            entry = access.getVersionedEntry(srcFile, false);
            if (entry.isScheduledForAddition() && !entry.isCopied()) {
                isLocallyAdded = true;
            } else if (entry.getCopyFromURL() != null) {
                url = entry.getCopyFromSVNURL();
                srcRevision = entry.getCopyFromRevision();
            } else if (entry.getURL() != null) {
                url = entry.getSVNURL();
                srcRevision = entry.getRevision();
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "Entry for ''{0}'' has no URL", srcFile);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        } else {
            url = srcURL;
        }
        Map targetMergeInfo = null;
        if (!isLocallyAdded) {
            String mergeInfoPath = null;
            if (!noReposAccess) {
                mergeInfoPath = this.getPathRelativeToRoot(null, url, entry != null ? entry.getRepositoryRootURL() : null, access, repository);
                targetMergeInfo = this.getReposMergeInfo(repository, mergeInfoPath, srcRevision, SVNMergeInfoInheritance.INHERITED, true);
            } else {
                targetMergeInfo = this.getWCMergeInfo(srcFile, entry, null, SVNMergeInfoInheritance.INHERITED, false, new boolean[1]);
            }
        }
        return targetMergeInfo;
    }

    private static class CopyPair {
        public String mySource;
        public String myOriginalSource;
        public SVNNodeKind mySourceKind;
        public SVNRevision mySourceRevision;
        public SVNRevision mySourcePegRevision;
        public long mySourceRevisionNumber;
        public String myBaseName;
        public String myDst;

        private CopyPair() {
        }

        public void setSourceRevisions(SVNRevision pegRevision, SVNRevision revision) {
            if (pegRevision == SVNRevision.UNDEFINED) {
                pegRevision = SVNPathUtil.isURL(this.mySource) ? SVNRevision.HEAD : SVNRevision.WORKING;
            }
            if (revision == SVNRevision.UNDEFINED) {
                revision = pegRevision;
            }
            this.mySourceRevision = revision;
            this.mySourcePegRevision = pegRevision;
        }
    }

    private static class CopyPathInfo {
        public boolean isDirAdded;
        public boolean isResurrection;
        public SVNNodeKind mySourceKind;
        public String mySource;
        public String mySourcePath;
        public String myDstPath;
        public String myMergeInfoProp;
        public long mySourceRevisionNumber;

        private CopyPathInfo() {
        }
    }

    private static class CopyCommitPathHandler
    implements ISVNCommitPathHandler {
        private Map myPathInfos;
        private boolean myIsMove;

        public CopyCommitPathHandler(Map pathInfos, boolean isMove) {
            this.myPathInfos = pathInfos;
            this.myIsMove = isMove;
        }

        public boolean handleCommitPath(String commitPath, ISVNEditor commitEditor) throws SVNException {
            CopyPathInfo pathInfo = (CopyPathInfo)this.myPathInfos.get(commitPath);
            boolean doAdd = false;
            boolean doDelete = false;
            if (pathInfo.isDirAdded) {
                commitEditor.addDir(commitPath, null, -1L);
                return true;
            }
            if (pathInfo.isResurrection) {
                if (!this.myIsMove) {
                    doAdd = true;
                }
            } else if (this.myIsMove) {
                if (commitPath.equals(pathInfo.mySourcePath)) {
                    doDelete = true;
                } else {
                    doAdd = true;
                }
            } else {
                doAdd = true;
            }
            if (doDelete) {
                commitEditor.deleteEntry(commitPath, -1L);
            }
            boolean closeDir = false;
            if (doAdd) {
                SVNPathUtil.checkPathIsValid(commitPath);
                if (pathInfo.mySourceKind == SVNNodeKind.DIR) {
                    commitEditor.addDir(commitPath, pathInfo.mySourcePath, pathInfo.mySourceRevisionNumber);
                    if (pathInfo.myMergeInfoProp != null) {
                        commitEditor.changeDirProperty("svn:mergeinfo", SVNPropertyValue.create(pathInfo.myMergeInfoProp));
                    }
                    closeDir = true;
                } else {
                    commitEditor.addFile(commitPath, pathInfo.mySourcePath, pathInfo.mySourceRevisionNumber);
                    if (pathInfo.myMergeInfoProp != null) {
                        commitEditor.changeFileProperty(commitPath, "svn:mergeinfo", SVNPropertyValue.create(pathInfo.myMergeInfoProp));
                    }
                    commitEditor.closeFile(commitPath, null);
                }
            }
            return closeDir;
        }
    }
}

