/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.types;

import de.desy.tine.endianUtils.Swap;
import de.desy.tine.types.TCompoundDataObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class TDS
implements TCompoundDataObject {
    public int tval;
    public float dval;
    public int sval;
    public static final int sizeInBytes = 12;
    public static final short dFormat = 18;
    ByteArrayOutputStream dBuffer = new ByteArrayOutputStream(12);
    public byte[] hByteArray;

    public double getDoubleValue() {
        return this.dval;
    }

    public int getIntegerValue() {
        return this.sval;
    }

    public String toString() {
        return "[" + this.tval + ", " + this.dval + ", " + this.sval + "]";
    }

    public void setValues(int newTValue, float newDValue, int newSValue) {
        this.tval = newTValue;
        this.dval = newDValue;
        this.sval = newSValue;
    }

    public int getSizeInBytes() {
        return 12;
    }

    public short getFormat() {
        return 18;
    }

    public void setByteArray(byte[] byteArray) {
        this.hByteArray = byteArray;
    }

    public byte[] getByteArray() {
        return this.hByteArray;
    }

    public TDS() {
        this.tval = 0;
        this.dval = 0.0f;
        this.sval = 0;
    }

    public TDS(float d) {
        this.tval = 0;
        this.dval = d;
        this.sval = 0;
    }

    public TDS(int t) {
        this.tval = t;
        this.dval = 0.0f;
        this.sval = 0;
    }

    public TDS(float d, int t) {
        this.dval = d;
        this.tval = t;
        this.sval = 0;
    }

    public TDS(float d, int t, int s) {
        this.dval = d;
        this.tval = t;
        this.sval = s;
    }

    public TDS(TDS instance) {
        this.dval = instance.dval;
        this.tval = instance.tval;
        this.sval = instance.sval;
    }

    public boolean equals(TDS instance) {
        if (instance.dval != this.dval) {
            return false;
        }
        if (instance.tval != this.tval) {
            return false;
        }
        return instance.sval == this.sval;
    }

    public byte[] toByteArray() {
        try {
            this.dBuffer.reset();
            DataOutputStream ds = new DataOutputStream(this.dBuffer);
            ds.writeInt(Swap.Long(this.tval));
            byte[] b = Swap.Float(this.dval);
            ds.write(b, 0, 4);
            ds.writeInt(Swap.Long(this.sval));
            ds.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.hByteArray = this.dBuffer.toByteArray();
        return this.hByteArray;
    }

    public void toStruct() {
        try {
            ByteArrayInputStream dis = new ByteArrayInputStream(this.hByteArray);
            DataInputStream ds = new DataInputStream(dis);
            this.tval = Swap.Long(ds.readInt());
            byte[] b = new byte[4];
            ds.read(b, 0, 4);
            this.dval = Swap.Float(b);
            this.sval = Swap.Long(ds.readInt());
            ds.close();
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.dval);
        result = 31 * result + this.sval;
        result = 31 * result + this.tval;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TDS other = (TDS)obj;
        return this.equals(other);
    }
}

