/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.types;

import de.desy.tine.endianUtils.Swap;
import de.desy.tine.types.TCompoundDataObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public final class SPECTRUM
implements TCompoundDataObject {
    public static final int MAXIMUM_LENGTH = 1024;
    public String comment;
    public int tm;
    public float s_start;
    public float s_inc;
    public int status;
    public float[] d_spect_array = new float[1024];
    public static int sizeInBytes = 4192;
    public static int hdrSizeInBytes = 96;
    public int length = 1024;
    public static final short dFormat = 28;
    ByteArrayOutputStream dBuffer = new ByteArrayOutputStream(sizeInBytes);
    public byte[] hByteArray;

    public double getDoubleValue() {
        return this.d_spect_array[0];
    }

    public int getIntegerValue() {
        return this.status;
    }

    public int getSizeInBytes() {
        return sizeInBytes;
    }

    public short getFormat() {
        return 28;
    }

    public void setByteArray(byte[] byteArray) {
        this.hByteArray = byteArray;
    }

    public byte[] getByteArray() {
        return this.hByteArray;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.length * 4 + hdrSizeInBytes);
        sb.append("[" + this.comment + ", " + this.tm + ", " + this.s_start + ", " + this.s_inc + ", " + this.status + "]");
        for (int i = 0; i < this.length; ++i) {
            sb.append(" " + this.d_spect_array[i]);
        }
        return sb.toString();
    }

    public void setValues(int newTM, float newStart, float newInc, int newStatus) {
        this.tm = newTM;
        this.s_start = newStart;
        this.s_inc = newInc;
        this.status = newStatus;
    }

    public SPECTRUM() {
        this.s_start = 0.0f;
        this.s_inc = 0.0f;
        this.status = 0;
        this.tm = 0;
        this.comment = "";
        this.hByteArray = new byte[sizeInBytes];
    }

    public SPECTRUM(int spectrumLength) {
        this.s_start = 0.0f;
        this.s_inc = 0.0f;
        this.status = 0;
        this.tm = 0;
        this.comment = "";
        if (spectrumLength > 1024) {
            spectrumLength = 1024;
        }
        this.length = spectrumLength;
        this.hByteArray = new byte[sizeInBytes];
    }

    public SPECTRUM(SPECTRUM instance) {
        this.s_start = instance.s_start;
        this.s_inc = instance.s_inc;
        this.status = instance.status;
        this.tm = instance.tm;
        this.comment = new String(instance.comment);
        this.length = instance.length;
        this.hByteArray = new byte[sizeInBytes];
        System.arraycopy(instance.d_spect_array, 0, this.d_spect_array, 0, this.length);
    }

    public boolean equals(SPECTRUM instance) {
        if (instance.s_start != this.s_start) {
            return false;
        }
        if (instance.s_inc != this.s_inc) {
            return false;
        }
        if (instance.status != this.status) {
            return false;
        }
        if (instance.length != this.length) {
            return false;
        }
        if (instance.comment == null || this.comment == null) {
            return false;
        }
        if (instance.comment.compareTo(this.comment) != 0) {
            return false;
        }
        return Arrays.equals(instance.d_spect_array, this.d_spect_array);
    }

    public byte[] toByteArray() {
        try {
            this.dBuffer.reset();
            DataOutputStream ds = new DataOutputStream(this.dBuffer);
            byte[] b = new byte[80];
            ds.write(this.comment.getBytes());
            ds.write(b, 0, 80 - this.comment.length());
            ds.writeInt(Swap.Long(this.tm));
            b = Swap.Float(this.s_start);
            ds.write(b, 0, 4);
            b = Swap.Float(this.s_inc);
            ds.write(b, 0, 4);
            ds.writeInt(Swap.Long(this.status));
            for (int i = 0; i < this.d_spect_array.length; ++i) {
                b = Swap.Float(this.d_spect_array[i]);
                ds.write(b, 0, 4);
            }
            ds.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.hByteArray = this.dBuffer.toByteArray();
        return this.hByteArray;
    }

    public void toStruct() {
        try {
            ByteArrayInputStream dis = new ByteArrayInputStream(this.hByteArray);
            DataInputStream ds = new DataInputStream(dis);
            byte[] b = new byte[4192];
            ds.read(b, 0, 80);
            this.comment = new String(b).trim();
            this.tm = Swap.Long(ds.readInt());
            ds.read(b, 0, 4);
            this.s_start = Swap.Float(b);
            ds.read(b, 0, 4);
            this.s_inc = Swap.Float(b);
            this.status = Swap.Long(ds.readInt());
            for (int i = 0; i < this.d_spect_array.length && i < this.length && ds.read(b, 0, 4) >= 0; ++i) {
                this.d_spect_array[i] = Swap.Float(b);
            }
            ds.close();
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.comment == null ? 0 : this.comment.hashCode());
        result = 31 * result + Arrays.hashCode(this.d_spect_array);
        result = 31 * result + this.length;
        result = 31 * result + Float.floatToIntBits(this.s_inc);
        result = 31 * result + Float.floatToIntBits(this.s_start);
        result = 31 * result + this.status;
        result = 31 * result + this.tm;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SPECTRUM other = (SPECTRUM)obj;
        return this.equals(other);
    }

    public String getComment() {
        return this.comment;
    }

    public int getLength() {
        return this.length;
    }

    public float getIncrement() {
        return this.s_inc;
    }

    public float getStart() {
        return this.s_start;
    }

    public int getTime() {
        return this.tm;
    }

    public int getStatus() {
        return this.status;
    }
}

