/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.types;

import de.desy.tine.endianUtils.Swap;
import de.desy.tine.server.logger.MsgLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class NAMEINT {
    public String name;
    public int ival;
    private int nameSizeInBytes = 16;
    private short dFormat = (short)21;
    ByteArrayOutputStream dBuffer = new ByteArrayOutputStream(this.nameSizeInBytes + 4);
    public byte[] hByteArray;

    public int getSizeInBytes() {
        return this.nameSizeInBytes + 4;
    }

    public short getFormat() {
        return this.dFormat;
    }

    public byte[] getByteArray() {
        return this.hByteArray;
    }

    public void setByteArray(byte[] byteArray) {
        this.hByteArray = byteArray;
    }

    public void setValues(String newName, int newIValue) {
        this.name = newName;
        this.ival = newIValue;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getName() {
        return this.name;
    }

    public NAMEINT() {
        this.name = new String(new StringBuffer(this.nameSizeInBytes));
        this.ival = 0;
    }

    public NAMEINT(String Name2) {
        this.name = Name2;
        this.ival = 0;
    }

    public NAMEINT(String Name2, int i) {
        this.name = Name2;
        this.ival = i;
    }

    public NAMEINT(int namelength) {
        switch (namelength) {
            case 8: {
                this.dFormat = (short)20;
                break;
            }
            case 16: {
                this.dFormat = (short)21;
                break;
            }
            case 32: {
                this.dFormat = (short)22;
                break;
            }
            case 48: {
                this.dFormat = (short)23;
                break;
            }
            case 64: {
                this.dFormat = (short)37;
                break;
            }
            default: {
                return;
            }
        }
        this.nameSizeInBytes = namelength;
        this.name = new String(new StringBuffer(this.nameSizeInBytes));
        this.ival = 0;
    }

    public NAMEINT(NAMEINT instance) {
        this.name = instance.name;
        this.ival = instance.ival;
        this.nameSizeInBytes = instance.nameSizeInBytes;
        this.name = this.name == null ? new String(new StringBuffer(this.nameSizeInBytes)) : new String(this.name);
        this.dBuffer = new ByteArrayOutputStream(this.nameSizeInBytes + 4);
    }

    public String toString() {
        return "[" + this.name + ", " + this.ival + "]";
    }

    public boolean equals(NAMEINT instance) {
        if (instance.nameSizeInBytes != this.nameSizeInBytes) {
            return false;
        }
        if (instance.name == null || this.name == null) {
            return false;
        }
        return instance.name.compareTo(this.name) == 0;
    }

    public int getNameSizeInBytes() {
        return this.nameSizeInBytes;
    }

    public byte[] toByteArray() {
        try {
            this.dBuffer.reset();
            DataOutputStream ds = new DataOutputStream(this.dBuffer);
            byte[] bname = this.name.getBytes();
            byte[] b = new byte[this.nameSizeInBytes];
            for (int i = 0; i < this.nameSizeInBytes && i < bname.length; ++i) {
                b[i] = bname[i];
            }
            ds.write(b, 0, b.length);
            ds.writeInt(Swap.Long(this.ival));
            ds.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MsgLog.log("NAMEINT", "could not prepare byte stream", 66, e, 0);
            return null;
        }
        this.hByteArray = this.dBuffer.toByteArray();
        return this.hByteArray;
    }

    public void toStruct() {
        try {
            ByteArrayInputStream dis = new ByteArrayInputStream(this.hByteArray);
            DataInputStream ds = new DataInputStream(dis);
            byte[] b = new byte[this.nameSizeInBytes + 4];
            ds.read(b, 0, this.nameSizeInBytes);
            int len = 0;
            int i = 0;
            while (i < this.nameSizeInBytes && b[i] != 0) {
                ++i;
                ++len;
            }
            this.name = new String(b, 0, len);
            this.ival = Swap.Long(ds.readInt());
            ds.close();
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MsgLog.log("NAMEINT", "could not prepare byte stream", 66, e, 0);
        }
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.ival;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.nameSizeInBytes;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NAMEINT other = (NAMEINT)obj;
        return this.equals(other);
    }

    public double getDoubleValue() {
        return this.ival;
    }

    public int getIntegerValue() {
        return this.ival;
    }
}

