/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.types;

import de.desy.tine.endianUtils.Swap;
import de.desy.tine.types.TCompoundDataObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class INTINT
implements TCompoundDataObject {
    public int i1val;
    public int i2val;
    public static final int sizeInBytes = 8;
    public static final short dFormat = 15;
    ByteArrayOutputStream dBuffer = new ByteArrayOutputStream(8);
    public byte[] hByteArray;

    public double getDoubleValue() {
        return this.i1val;
    }

    public int getIntegerValue() {
        return this.i2val;
    }

    public void setValues(int newI1Value, int newI2Value) {
        this.i1val = newI1Value;
        this.i2val = newI2Value;
    }

    public int getSizeInBytes() {
        return 8;
    }

    public short getFormat() {
        return 15;
    }

    public void setByteArray(byte[] byteArray) {
        this.hByteArray = byteArray;
    }

    public byte[] getByteArray() {
        return this.hByteArray;
    }

    public INTINT() {
        this.i1val = 0;
        this.i2val = 0;
    }

    public INTINT(int l) {
        this.i1val = l;
        this.i2val = 0;
    }

    public INTINT(int l, int i) {
        this.i1val = l;
        this.i2val = i;
    }

    public INTINT(INTINT instance) {
        this.i1val = instance.i1val;
        this.i2val = instance.i2val;
    }

    public String toString() {
        return "[" + this.i1val + ", " + this.i2val + "]";
    }

    public boolean equals(INTINT instance) {
        if (instance.i1val != this.i1val) {
            return false;
        }
        return instance.i2val == this.i2val;
    }

    public byte[] toByteArray() {
        try {
            this.dBuffer.reset();
            DataOutputStream ds = new DataOutputStream(this.dBuffer);
            ds.writeInt(Swap.Long(this.i1val));
            ds.writeInt(Swap.Long(this.i2val));
            ds.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.hByteArray = this.dBuffer.toByteArray();
        return this.hByteArray;
    }

    public void toStruct() {
        try {
            ByteArrayInputStream dis = new ByteArrayInputStream(this.hByteArray);
            DataInputStream ds = new DataInputStream(dis);
            this.i1val = Swap.Long(ds.readInt());
            this.i2val = Swap.Long(ds.readInt());
            ds.close();
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.i1val;
        result = 31 * result + this.i2val;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        INTINT other = (INTINT)obj;
        return this.equals(other);
    }
}

