/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.types;

import de.desy.tine.endianUtils.Swap;
import de.desy.tine.types.TCompoundDataObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class INTFLTINT
implements TCompoundDataObject {
    public int i1val;
    public float fval;
    public int i2val;
    public static final int sizeInBytes = 12;
    public static final short dFormat = 18;
    ByteArrayOutputStream dBuffer = new ByteArrayOutputStream(12);
    public byte[] hByteArray;

    public double getDoubleValue() {
        return this.fval;
    }

    public int getIntegerValue() {
        return this.i1val;
    }

    public void setValues(int newI1Value, float newFValue, int newI2Value) {
        this.i1val = newI1Value;
        this.fval = newFValue;
        this.i2val = newI2Value;
    }

    public int getSizeInBytes() {
        return 12;
    }

    public short getFormat() {
        return 18;
    }

    public void setByteArray(byte[] byteArray) {
        this.hByteArray = byteArray;
    }

    public byte[] getByteArray() {
        return this.hByteArray;
    }

    public INTFLTINT() {
        this.i1val = 0;
        this.fval = 0.0f;
        this.i2val = 0;
    }

    public INTFLTINT(float f) {
        this.i1val = 0;
        this.fval = f;
        this.i2val = 0;
    }

    public INTFLTINT(int i) {
        this.i1val = i;
        this.fval = 0.0f;
        this.i2val = 0;
    }

    public INTFLTINT(int i, float f) {
        this.fval = f;
        this.i1val = i;
        this.i2val = 0;
    }

    public INTFLTINT(int i1, float f, int i2) {
        this.fval = f;
        this.i1val = i1;
        this.i2val = i2;
    }

    public INTFLTINT(INTFLTINT instance) {
        this.fval = instance.fval;
        this.i1val = instance.i1val;
        this.i2val = instance.i2val;
    }

    public String toString() {
        return "[" + this.i1val + ", " + this.fval + ", " + this.i2val + "]";
    }

    public boolean equals(INTFLTINT instance) {
        if (instance.i1val != this.i1val) {
            return false;
        }
        if (instance.fval != this.fval) {
            return false;
        }
        return instance.i2val == this.i2val;
    }

    public byte[] toByteArray() {
        try {
            this.dBuffer.reset();
            DataOutputStream ds = new DataOutputStream(this.dBuffer);
            ds.writeInt(Swap.Long(this.i1val));
            byte[] b = Swap.Float(this.fval);
            ds.write(b, 0, 4);
            ds.writeInt(Swap.Long(this.i2val));
            ds.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.hByteArray = this.dBuffer.toByteArray();
        return this.hByteArray;
    }

    public void toStruct() {
        try {
            ByteArrayInputStream dis = new ByteArrayInputStream(this.hByteArray);
            DataInputStream ds = new DataInputStream(dis);
            this.i1val = Swap.Long(ds.readInt());
            byte[] b = new byte[4];
            ds.read(b, 0, 4);
            this.fval = Swap.Float(b);
            this.i2val = Swap.Long(ds.readInt());
            ds.close();
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.fval);
        result = 31 * result + this.i1val;
        result = 31 * result + this.i2val;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        INTFLTINT other = (INTFLTINT)obj;
        return this.equals(other);
    }
}

