/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.types;

import de.desy.tine.dataUtils.TDataTime;
import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.definitions.TFormat;
import de.desy.tine.endianUtils.Swap;
import de.desy.tine.server.logger.DbgLog;
import de.desy.tine.structUtils.TTaggedStructure;
import de.desy.tine.types.TCompoundDataObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class HISTORY
implements TCompoundDataObject {
    private double timestamp;
    private int sysstamp;
    private int usrstamp;
    private short fmt = (short)255;
    private String tag = null;
    private Object hDataObject = null;
    private Object hStructObject = null;
    private int sizeInBytes;
    private byte[] hdrbytes = new byte[16];
    private byte[] hByteArray = null;
    ByteArrayOutputStream dBuffer;

    public TDataType getDataObject() {
        TDataType td = null;
        if (this.hDataObject != null) {
            td = new TDataType(1, this.fmt);
            td.setDataTimeStamp(this.timestamp);
            td.sysDataStamp = this.sysstamp;
            td.usrDataStamp = this.usrstamp;
            td.putData(this.hDataObject);
        } else if (this.hStructObject != null) {
            td = new TDataType((TTaggedStructure[])this.hStructObject);
            td.setDataTimeStamp(this.timestamp);
            td.sysDataStamp = this.sysstamp;
            td.usrDataStamp = this.usrstamp;
        }
        return td;
    }

    public HISTORY() {
        this.timestamp = 0.0;
        this.sysstamp = 0;
        this.usrstamp = 0;
        this.fmt = (short)255;
        this.tag = "";
        this.hDataObject = null;
        this.hStructObject = null;
        this.sizeInBytes = TFormat.getHistoryHeaderSize();
    }

    public HISTORY(TDataType d) {
        if (d == null) {
            return;
        }
        this.timestamp = (double)(d.dTimestamp / 1000L) + (double)(d.dTimestamp % 1000L) / 1000.0;
        this.sysstamp = d.sysDataStamp;
        this.usrstamp = d.usrDataStamp;
        this.fmt = d.dFormat;
        this.tag = this.fmt == 7 ? d.getTag() : TFormat.toString(this.fmt);
        this.hDataObject = d.getDataObject();
        this.hStructObject = d.getStructObject();
        this.sizeInBytes = TFormat.formatSizeOf(this.fmt) + TFormat.getHistoryHeaderSize();
    }

    public HISTORY(double time, short svalue, int sstmp, int ustmp) {
        this.timestamp = time;
        this.sysstamp = sstmp;
        this.usrstamp = ustmp;
        this.fmt = 1;
        this.tag = TFormat.toString(this.fmt);
        this.hDataObject = new short[1];
        ((short[])this.hDataObject)[0] = svalue;
        this.sizeInBytes = TFormat.formatSizeOf(this.fmt) + TFormat.getHistoryHeaderSize();
    }

    public HISTORY(double time, int ivalue, int sstmp, int ustmp) {
        this.timestamp = time;
        this.sysstamp = sstmp;
        this.usrstamp = ustmp;
        this.fmt = (short)3;
        this.tag = TFormat.toString(this.fmt);
        this.hDataObject = new int[1];
        ((int[])this.hDataObject)[0] = ivalue;
        this.sizeInBytes = TFormat.formatSizeOf(this.fmt) + TFormat.getHistoryHeaderSize();
    }

    public HISTORY(double time, float fvalue, int sstmp, int ustmp) {
        this.timestamp = time;
        this.sysstamp = sstmp;
        this.usrstamp = ustmp;
        this.fmt = (short)5;
        this.tag = TFormat.toString(this.fmt);
        this.hDataObject = new float[1];
        ((float[])this.hDataObject)[0] = fvalue;
        this.sizeInBytes = TFormat.formatSizeOf(this.fmt) + TFormat.getHistoryHeaderSize();
    }

    public HISTORY(double time, double dvalue, int sstmp, int ustmp) {
        this.timestamp = time;
        this.sysstamp = sstmp;
        this.usrstamp = ustmp;
        this.fmt = 0;
        this.tag = TFormat.toString(this.fmt);
        this.hDataObject = new double[1];
        ((double[])this.hDataObject)[0] = dvalue;
        this.sizeInBytes = TFormat.formatSizeOf(this.fmt) + TFormat.getHistoryHeaderSize();
    }

    public HISTORY(double time, TCompoundDataObject value, int sstmp, int ustmp) {
        this.timestamp = time;
        this.sysstamp = sstmp;
        this.usrstamp = ustmp;
        this.fmt = value.getFormat();
        this.tag = TFormat.toString(this.fmt);
        this.hDataObject = new TCompoundDataObject[1];
        ((TCompoundDataObject[])this.hDataObject)[0] = value;
        this.sizeInBytes = TFormat.formatSizeOf(this.fmt) + TFormat.getHistoryHeaderSize();
    }

    public HISTORY(double time, TTaggedStructure value, int sstmp, int ustmp) {
        this.timestamp = time;
        this.sysstamp = sstmp;
        this.usrstamp = ustmp;
        this.fmt = (short)7;
        this.tag = value.getName();
        this.hStructObject = new TTaggedStructure[1];
        ((TTaggedStructure[])this.hStructObject)[0] = value;
        this.sizeInBytes = TFormat.formatSizeOf(this.fmt) + TFormat.getHistoryHeaderSize();
    }

    private byte[] getObjectBytes() {
        if (this.hDataObject != null) {
            switch (this.fmt) {
                case 1: {
                    return Swap.ShortToBytes(((short[])this.hDataObject)[0]);
                }
                case 3: {
                    return Swap.LongToBytes(((int[])this.hDataObject)[0]);
                }
                case 5: {
                    return Swap.Float(((float[])this.hDataObject)[0]);
                }
                case 0: {
                    return Swap.Double(((double[])this.hDataObject)[0]);
                }
            }
            return ((TCompoundDataObject[])this.hDataObject)[0].toByteArray();
        }
        if (this.hStructObject != null) {
            return ((TTaggedStructure[])this.hStructObject)[0].toByteArray();
        }
        return null;
    }

    private void putObjectBytes(DataInputStream dis) {
        try {
            if (this.hDataObject != null) {
                switch (this.fmt) {
                    case 1: {
                        ((short[])this.hDataObject)[0] = Swap.Short(dis.readShort());
                        break;
                    }
                    case 3: {
                        ((int[])this.hDataObject)[0] = Swap.Long(dis.readInt());
                        break;
                    }
                    case 5: {
                        dis.read(this.hdrbytes, 0, 4);
                        ((float[])this.hDataObject)[0] = Swap.Float(this.hdrbytes);
                        break;
                    }
                    case 0: {
                        dis.read(this.hdrbytes, 0, 8);
                        ((double[])this.hDataObject)[0] = Swap.Double(this.hdrbytes);
                        break;
                    }
                    default: {
                        byte[] ba = new byte[this.sizeInBytes - TFormat.getHistoryHeaderSize()];
                        ((TCompoundDataObject[])this.hDataObject)[0].setByteArray(ba);
                        ((TCompoundDataObject[])this.hDataObject)[0].toStruct();
                    }
                }
                return;
            }
            if (this.hStructObject != null) {
                byte[] ba = new byte[this.sizeInBytes - TFormat.getHistoryHeaderSize()];
                ((TTaggedStructure[])this.hStructObject)[0].toStruct(ba);
            }
        }
        catch (Exception e) {
            DbgLog.log("putObjectBytes", "exception " + e.getMessage());
        }
    }

    public byte[] getByteArray() {
        return this.hByteArray;
    }

    public short getFormat() {
        return 56;
    }

    public short getCarriedFormat() {
        return this.fmt;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public void setByteArray(byte[] byteArray) {
        this.hByteArray = byteArray;
    }

    public byte[] toByteArray() {
        try {
            this.dBuffer = new ByteArrayOutputStream(this.sizeInBytes);
            DataOutputStream ds = new DataOutputStream(this.dBuffer);
            ds.write(Swap.Double(this.timestamp));
            ds.writeInt(Swap.Long(this.sysstamp));
            ds.writeInt(Swap.Long(this.usrstamp));
            ds.write(this.getObjectBytes());
            ds.close();
            return this.dBuffer.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void toStruct() {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.hByteArray);
            DataInputStream dis = new DataInputStream(bais);
            dis.read(this.hdrbytes);
            this.timestamp = Swap.Double(this.hdrbytes);
            this.sysstamp = Swap.Long(dis.readInt());
            this.usrstamp = Swap.Long(dis.readInt());
            this.putObjectBytes(dis);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getTag() {
        return this.tag;
    }

    public String toString() {
        String s = "    value: " + this.getDataObject().toString() + "\n";
        s = s + "timestamp: " + TDataTime.toString(this.timestamp) + "\n";
        s = s + " sysstamp: " + this.sysstamp + "\n";
        s = s + " usrstamp: " + this.usrstamp + "\n";
        return s;
    }

    public double getDoubleValue() {
        return 0.0;
    }

    public int getIntegerValue() {
        return 0;
    }
}

