/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.types;

import de.desy.tine.endianUtils.Swap;
import de.desy.tine.types.TCompoundDataObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class DBLINT
implements TCompoundDataObject {
    public double dval;
    public int ival;
    public static int sizeInBytes = 12;
    public static short dFormat = (short)16;
    ByteArrayOutputStream dBuffer = new ByteArrayOutputStream(sizeInBytes);
    public byte[] hByteArray;

    public double getDoubleValue() {
        return this.dval;
    }

    public int getIntegerValue() {
        return this.ival;
    }

    public void setValues(double newDValue, int newIValue) {
        this.dval = newDValue;
        this.ival = newIValue;
    }

    public void setByteArray(byte[] byteArray) {
        this.hByteArray = byteArray;
    }

    public int getSizeInBytes() {
        return sizeInBytes;
    }

    public short getFormat() {
        return dFormat;
    }

    public byte[] getByteArray() {
        return this.hByteArray;
    }

    public DBLINT() {
        this.dval = 0.0;
        this.ival = 0;
    }

    public DBLINT(float f) {
        this.dval = f;
        this.ival = 0;
    }

    public DBLINT(double d) {
        this.dval = d;
        this.ival = 0;
    }

    public DBLINT(int i) {
        this.ival = i;
    }

    public DBLINT(float f, int i) {
        this.dval = f;
        this.ival = i;
    }

    public DBLINT(double d, int i) {
        this.dval = d;
        this.ival = i;
    }

    public DBLINT(DBLINT instance) {
        this.dval = instance.dval;
        this.ival = instance.ival;
    }

    public String toString() {
        return "[" + this.dval + ", " + this.ival + "]";
    }

    public boolean equals(DBLINT instance) {
        if (instance.dval != this.dval) {
            return false;
        }
        return instance.ival == this.ival;
    }

    public byte[] toByteArray() {
        try {
            this.dBuffer.reset();
            DataOutputStream ds = new DataOutputStream(this.dBuffer);
            byte[] b = Swap.Double(this.dval);
            ds.write(b, 0, 8);
            ds.writeInt(Swap.Long(this.ival));
            ds.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.hByteArray = this.dBuffer.toByteArray();
        return this.hByteArray;
    }

    public void toStruct() {
        try {
            ByteArrayInputStream dis = new ByteArrayInputStream(this.hByteArray);
            DataInputStream ds = new DataInputStream(dis);
            byte[] b = new byte[8];
            ds.read(b, 0, 8);
            this.dval = Swap.Double(b);
            this.ival = Swap.Long(ds.readInt());
            ds.close();
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.dval);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.ival;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DBLINT other = (DBLINT)obj;
        if (Double.doubleToLongBits(this.dval) != Double.doubleToLongBits(other.dval)) {
            return false;
        }
        return this.ival == other.ival;
    }
}

