/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.traceUtils;

import de.desy.tine.client.TLink;
import de.desy.tine.client.TLinkCallback;
import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.queryUtils.TQuery;
import de.desy.tine.server.logger.DbgLog;
import de.desy.tine.traceUtils.TTraceHandler;
import de.desy.tine.traceUtils.TTraceHeader;
import java.io.IOException;
import javax.naming.NamingException;

public class TTrace
implements TLinkCallback {
    private String[] tracePrps = null;
    private boolean hasXAxis = false;
    private boolean hasReference = false;
    private boolean hasSequence = false;
    private boolean hasAverage = false;
    private boolean isScheduled = false;
    private String ctx;
    private String srv;
    private String prp;
    private String dev = "#0";
    private int length;
    private TTraceHeader[] hdr = new TTraceHeader[1];
    private float[] xaxis = null;
    private float[] ref = null;
    private float[] trace = null;
    private TTraceHandler hndlr = null;
    private TLink lnk = null;
    private int traceStatus = 0;
    private String traceStatusString = null;
    private long timestamp = 0L;
    private long lastSyncTimestamp = 0L;
    private long refTimestamp = 0L;

    public int getTraceStatus() {
        return this.traceStatus;
    }

    public String getTraceStatusString() {
        return this.traceStatusString == null ? "not active" : this.traceStatusString;
    }

    public void setReferenceTrace(float[] reference) {
        this.ref = reference;
        this.refTimestamp = System.currentTimeMillis();
    }

    public void setReferenceTrace(float[] reference, long referenceTimestamp) {
        this.ref = reference;
        this.refTimestamp = referenceTimestamp;
    }

    public long getReferenceTimestamp() {
        return this.refTimestamp;
    }

    public void setReferenceTimestamp(long referenceTimestamp) {
        this.refTimestamp = referenceTimestamp;
    }

    private synchronized float[] getPropertyData(String property, String message) throws IOException {
        float[] y = new float[this.length];
        TDataType yt = new TDataType(y);
        String devName = "/" + this.ctx + "/" + this.srv + "/" + this.dev;
        TLink tl = new TLink(devName, property, yt, null, 1);
        int cc = tl.execute(500, true);
        this.lastSyncTimestamp = tl.getLastTimeStamp();
        tl.close();
        this.traceStatus = cc;
        this.traceStatusString = tl.getLastError();
        if (cc == 45 || cc == 98) {
            throw new IOException("timeout retrieving " + message);
        }
        if (property.compareToIgnoreCase(this.prp) == 0) {
            this.timestamp = yt.getDataTimeStamp();
        }
        return y;
    }

    public float[][] getTraceSequence() throws IOException {
        int cc;
        if (!this.hasSequence) {
            return null;
        }
        int[] n = new int[1];
        TDataType nt = new TDataType(n);
        String devName = "/" + this.ctx + "/" + this.srv + "/" + this.dev;
        TLink tl = new TLink(devName, this.prp + ".NSEQ", nt, null, 1);
        this.traceStatus = cc = tl.execute(500, true);
        this.traceStatusString = tl.getLastError();
        tl.close();
        if (cc == 45 || cc == 98) {
            throw new IOException("timeout retrieving sequence information");
        }
        int nseq = n[0];
        float[] y = new float[nseq * this.length];
        TDataType yt = new TDataType(y);
        tl = new TLink(devName, this.prp + ".SEQ", yt, null, 1);
        this.traceStatus = cc = tl.execute(500, true);
        this.traceStatusString = tl.getLastError();
        tl.close();
        this.timestamp = yt.getDataTimeStamp();
        if (cc == 45 || cc == 98) {
            throw new IOException("timeout retrieving sequence");
        }
        float[][] tseq = new float[nseq][];
        for (int i = 0; i < nseq; ++i) {
            tseq[i] = new float[this.length];
            System.arraycopy(y, i * this.length, tseq[i], 0, this.length);
        }
        return tseq;
    }

    public float[] getReference() throws IOException {
        if (!this.hasReference) {
            return this.ref;
        }
        float[] r = this.getPropertyData(this.prp + ".REF", "trace reference");
        this.refTimestamp = this.lastSyncTimestamp;
        return r;
    }

    public float[] getAverage() throws IOException {
        if (!this.hasAverage) {
            return null;
        }
        return this.getPropertyData(this.prp + ".AVE", "trace average");
    }

    public float[] getTrace() throws IOException {
        if (this.trace != null && this.lnk != null) {
            return this.trace;
        }
        return this.getPropertyData(this.prp, "trace");
    }

    public long getTraceTimestamp() {
        if (this.trace != null && this.lnk != null) {
            return this.lnk.getLastTimeStamp();
        }
        return this.timestamp;
    }

    public void callback(TLink link) {
        if (link.linkStatus != 0) {
            DbgLog.log("TTrace callback", "link error : " + link.getLastError());
        }
        this.traceStatus = link.getLinkStatus();
        this.traceStatusString = link.getLastError();
        if (this.hndlr != null) {
            this.hndlr.update(this);
        }
    }

    public void stopMonitor() {
        if (this.lnk != null) {
            this.lnk.close();
        }
        this.lnk = null;
    }

    public int monitorTrace(TTraceHandler myTraceHandler, boolean scheduled, int pollingRate) {
        if (this.trace == null) {
            this.trace = new float[this.length];
        }
        TDataType tracet = new TDataType(this.trace);
        String devName = "/" + this.ctx + "/" + this.srv + "/" + this.dev;
        String property = this.prp;
        if (scheduled && this.isScheduled) {
            property = property + ".SCH";
        }
        this.lnk = new TLink(devName, property, tracet, null, 1);
        int lid = this.lnk.attach((short)3, (TLinkCallback)this, pollingRate);
        if (lid < 0) {
            this.lnk = null;
            return -lid;
        }
        this.hndlr = myTraceHandler;
        return 0;
    }

    public int getPreTriggerPosition() {
        return this.hdr[0].getPreTrigger();
    }

    public float[] getXAxis() {
        if (this.xaxis != null) {
            return this.xaxis;
        }
        float[] x = new float[this.length];
        if (!this.hasXAxis) {
            float off = this.hdr[0].getXOffset();
            float inc = this.hdr[0].getXScaleFactor();
            for (int i = 0; i < this.length; ++i) {
                x[i] = off + (float)i * inc;
            }
        } else {
            try {
                x = this.getPropertyData(this.prp + ".XAXIS", "trace x axis");
            }
            catch (IOException e) {
                return null;
            }
        }
        this.xaxis = x;
        return this.xaxis;
    }

    public String getXAxisUnits() {
        return this.hdr[0].getXUnits();
    }

    public String getYAxisUnits() {
        return this.hdr[0].getYUnits();
    }

    public float getTracePlotMaximum() {
        return this.hdr[0].getYPlotMaxmimum();
    }

    public float getTracePlotMinimum() {
        return this.hdr[0].getYPlotMinimum();
    }

    private boolean isTaggedWith(String property, String tag, int index) {
        int i;
        return property.endsWith(tag) && (i = property.indexOf(tag)) == index;
    }

    public String[] getProperties(String devName, String devProperty) {
        if (this.tracePrps == null) {
            String prps = devProperty + ".*";
            try {
                this.tracePrps = TQuery.getPropertiesWithPattern(this.ctx, this.srv, this.dev, prps, 500);
            }
            catch (IOException e) {
                return null;
            }
            int pidx = devProperty.length();
            for (int i = 0; i < this.tracePrps.length; ++i) {
                if (this.isTaggedWith(this.tracePrps[i], ".XAXIS", pidx)) {
                    this.hasXAxis = true;
                }
                if (this.isTaggedWith(this.tracePrps[i], ".SEQ", pidx)) {
                    this.hasSequence = true;
                }
                if (this.isTaggedWith(this.tracePrps[i], ".REF", pidx)) {
                    this.hasReference = true;
                }
                if (this.isTaggedWith(this.tracePrps[i], ".AVE", pidx)) {
                    this.hasAverage = true;
                }
                if (!this.isTaggedWith(this.tracePrps[i], ".SCH", pidx)) continue;
                this.isScheduled = true;
            }
        }
        return this.tracePrps;
    }

    private void getInfoHeader() throws IOException {
        int cc;
        this.hdr[0] = new TTraceHeader();
        TDataType hdrt = new TDataType(this.hdr);
        String devName = "/" + this.ctx + "/" + this.srv + "/" + this.dev;
        TLink tl = new TLink(devName, this.prp + ".INFO", hdrt, null, 1);
        this.traceStatus = cc = tl.execute(500, true);
        this.traceStatusString = tl.getLastError();
        tl.close();
        if (cc == 45 || cc == 98) {
            throw new IOException("could not acquire trace header information");
        }
        this.length = this.hdr[0].getTraceLength();
    }

    public TTrace(String context, String server, String device, String property) throws NamingException, IOException {
        if (context == null) {
            throw new NamingException("context not given");
        }
        if (server == null) {
            throw new NamingException("server name not given");
        }
        if (property == null || property.length() == 0) {
            property = "Trace";
        }
        if (device == null) {
            device = "#0";
        }
        this.ctx = context;
        this.srv = server;
        this.prp = property;
        this.dev = device;
        this.getInfoHeader();
        this.getProperties(device, property);
    }

    public TTrace(String context, String server, String device) throws NamingException, IOException {
        this(context, server, device, null);
    }

    public TTrace(String context, String server) throws NamingException, IOException {
        this(context, server, null, null);
    }
}

