/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.startup;

import de.desy.tine.server.logger.DbgLog;
import de.desy.tine.startup.TInitializer;
import de.desy.tine.startup.TInitializerFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Properties;
import java.util.logging.FileHandler;

public class DefaultTInitializerFactory
extends TInitializerFactory {
    private static final String ENS = "131.169.120.41";
    private static final int SRV_PORT = 9003;
    private static final int TCP_PORT = 8503;
    private static final String GCAST = "238.1.1.0";
    private static final int GCAST_PORT = 8004;
    private static final String MCAST = "238.1.1.1";
    private static final int MCAST_PORT = 9503;
    private static final String NETCAST = "238.1.1.2";
    private static final int NETCAST_PORT = 9002;
    private static final int UDP_CLN_PORT = 8050;
    private static int srvRcvBufferSize = 65536;
    private static int clnRcvBufferSize = 65536;
    private static int sckTimeToLive = 16;
    private static int srvPacketMtu = 1472;
    private static DefaultTInitializer instance = null;

    public synchronized TInitializer getInitializer() {
        if (instance == null) {
            instance = new DefaultTInitializer();
        }
        return instance;
    }

    private class DefaultTInitializer
    implements TInitializer {
        private String tineHome = null;
        private String fecHome = null;
        private String historyHome = null;
        private String logHome = null;
        private String addrFileLocation = null;
        private String eqpFileLocation = null;
        private String cshostsFileLocation = null;
        private String fecidFileLocation = null;
        private String exportsFileLocation = null;
        private String usersFileLocation = null;
        private String aliasFileLocation = null;
        private String netsFileLocation = null;
        private String alarmwFileLocation = null;
        private String historyFileLocation = null;
        private String logFileLocation = null;
        private String casHostFileLocation = null;
        private Properties tineProperties = new Properties();
        private boolean hasInitialzed = false;

        public DefaultTInitializer() {
            this.initialize();
        }

        private synchronized void initialize() {
            if (this.hasInitialzed) {
                return;
            }
            try {
                String prpsFileName;
                String cp = System.getProperty("java.class.path");
                String cpSeparator = System.getProperty("path.separator");
                String[] cplibs = cp.split(cpSeparator);
                String jarHome = null;
                int stopindex = -1;
                boolean found = false;
                for (int i = 0; i < cplibs.length; ++i) {
                    stopindex = cplibs[i].indexOf("tine.jar");
                    if (stopindex <= 0) continue;
                    jarHome = cplibs[i].substring(0, stopindex - 1);
                    break;
                }
                if (stopindex == -1) {
                    jarHome = ".";
                }
                if (!new File(prpsFileName = jarHome + "/tine.properties").exists()) {
                    prpsFileName = System.getProperty("user.dir") + "/tine.properties";
                } else {
                    DbgLog.log("initializer", "found tine.properties on the class path");
                    found = true;
                }
                if (!found) {
                    if (!new File(prpsFileName).exists()) {
                        prpsFileName = System.getProperty("java.ext.dirs") + "/tine.properties";
                    } else {
                        DbgLog.log("initializer", "found tine.properties in java.ext.dirs directory");
                        found = true;
                    }
                }
                if (!found) {
                    if (!new File(prpsFileName).exists()) {
                        prpsFileName = System.getProperty("java.home") + "/tine.properties";
                    } else {
                        DbgLog.log("initializer", "found tine.properties in java.home directory");
                        found = true;
                    }
                }
                this.tineProperties.load(new FileInputStream(prpsFileName));
            }
            catch (IOException e) {
                DbgLog.log("initializer", "tine.properties file not found!");
                DbgLog.log("initializer", "use local environment to find repositories!");
            }
            this.addrFileLocation = this.getTineHome() + "/fecaddr.csv";
            this.eqpFileLocation = this.getTineHome() + "/eqpdbase.csv";
            this.cshostsFileLocation = this.getTineHome() + "/cshosts.csv";
            this.fecidFileLocation = this.getFecHome() + "/fecid.csv";
            this.exportsFileLocation = this.getFecHome() + "/exports.csv";
            this.usersFileLocation = this.getFecHome() + "/users.csv";
            this.aliasFileLocation = this.getFecHome() + "/alias.csv";
            this.netsFileLocation = this.getFecHome() + "/ipnets.csv";
            this.alarmwFileLocation = this.getFecHome() + "/almwatch.csv";
            this.historyFileLocation = this.getFecHome() + "/history.csv";
            this.logFileLocation = this.getLogHome() + "/fec.log";
            this.casHostFileLocation = this.getFecHome() + "/cashosts.csv";
            int bs = Integer.parseInt(System.getProperty("srv.RECV_BUFFER_SIZE", "0"));
            if (bs > 4096) {
                srvRcvBufferSize = bs;
            }
            if ((bs = Integer.parseInt(System.getProperty("cln.RECV_BUFFER_SIZE", "0"))) > 4096) {
                clnRcvBufferSize = bs;
            }
            if ((bs = Integer.parseInt(System.getProperty("srv.TIME_TO_LIVE", "0"))) > 1) {
                sckTimeToLive = bs;
            }
            if ((bs = Integer.parseInt(System.getProperty("srv.PACKET_MTU", "0"))) > 512 && bs < 32000) {
                srvPacketMtu = bs;
            }
            this.hasInitialzed = true;
        }

        public synchronized String getTineHome() {
            if (this.tineHome == null) {
                String home = System.getProperty("tine.home");
                if (home != null) {
                    DbgLog.log("initializer", "tine home set from JVM argument");
                } else {
                    home = this.tineProperties.getProperty("tine.home");
                    if (home != null) {
                        DbgLog.log("initializer", "tine home set from tine properties");
                    } else {
                        DbgLog.log("initializer", "trying to determine tine home from local environment");
                        home = System.getenv("TINE_HOME");
                        if (home != null) {
                            DbgLog.log("initializer", "tine home set from TINE_HOME environment");
                        } else {
                            home = System.getenv("CONTROLDB");
                            if (home != null) {
                                DbgLog.log("initializer", "tine home set from legacy environment");
                            } else {
                                DbgLog.log("initializer", "unable to determine tine home from local environment");
                            }
                        }
                    }
                }
                if (home != null && (home.endsWith("/") || home.endsWith("\\"))) {
                    home = home.substring(0, home.length() - 1);
                }
                if (home == null) {
                    home = ".";
                    File f = new File(home);
                    DbgLog.log("initializer", "using working directory : " + f.getAbsolutePath() + " as tine home");
                }
                this.tineHome = new String(home);
            }
            return this.tineHome;
        }

        public synchronized String getFecHome() {
            if (this.fecHome == null) {
                String home = System.getProperty("fec.home");
                if (home == null) {
                    home = this.tineProperties.getProperty("fec.home");
                }
                if (home == null) {
                    home = System.getenv("FEC_HOME");
                }
                if (home == null) {
                    home = System.getenv("FECDB");
                }
                if (home != null && (home.endsWith("/") || home.endsWith("\\"))) {
                    home = home.substring(0, home.length() - 1);
                }
                this.fecHome = home != null ? new String(home) : this.getTineHome();
            }
            return this.fecHome;
        }

        public synchronized String getHistoryHome() {
            if (this.historyHome == null) {
                String home = System.getProperty("history.home");
                if (home == null) {
                    home = this.tineProperties.getProperty("history.home");
                }
                if (home == null) {
                    home = System.getenv("HISTORY_HOME");
                }
                if (home == null) {
                    home = System.getenv("HISTORYDB");
                }
                if (home != null) {
                    if (home.endsWith("/") || home.endsWith("\\")) {
                        home = home.substring(0, home.length() - 1);
                    }
                } else {
                    home = this.getFecHome() + "/../HISTORY";
                }
                this.historyHome = home;
            }
            return this.historyHome;
        }

        public synchronized String getLogHome() {
            if (this.logHome == null) {
                String home = System.getProperty("log.home");
                if (home == null) {
                    home = this.tineProperties.getProperty("log.home");
                }
                if (home == null) {
                    home = System.getenv("FEC_LOG");
                }
                if (home == null) {
                    home = System.getenv("FECLOG");
                }
                if (home == null) {
                    home = System.getenv("LOG_HOME");
                }
                if (home != null && (home.endsWith("/") || home.endsWith("\\"))) {
                    home = home.substring(0, home.length() - 1);
                }
                this.logHome = home != null ? new String(home) : this.getFecHome();
            }
            return this.logHome;
        }

        private synchronized BufferedReader getCfgResource(String fileLocation) {
            if (fileLocation == null) {
                return null;
            }
            try {
                return new BufferedReader(new InputStreamReader(new FileInputStream(fileLocation)));
            }
            catch (Exception e) {
                if (fileLocation == this.cshostsFileLocation) {
                    DbgLog.log("initializer", "Could not open configuration file : " + e);
                }
                return null;
            }
        }

        public synchronized BufferedWriter getFecLogWriter() {
            try {
                return new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.logFileLocation, true)));
            }
            catch (Exception e) {
                DbgLog.log("initializer", "Could not open fec log file " + this.logFileLocation + " for writing : " + e);
                return null;
            }
        }

        public synchronized FileHandler getFecLogResource() {
            try {
                return new FileHandler(this.logFileLocation, 50000, 3, true);
            }
            catch (Exception e) {
                DbgLog.log("initializer", "Could not open fec log file " + this.logFileLocation + " for reading : " + e);
                return null;
            }
        }

        public BufferedReader getFecIdResource() {
            return this.getCfgResource(this.fecidFileLocation);
        }

        public BufferedReader getExportsResource(String eqmName) {
            BufferedReader br;
            if (eqmName != null) {
                this.exportsFileLocation = this.getFecHome() + "/" + eqmName + "/exports.csv";
            }
            if ((br = this.getCfgResource(this.exportsFileLocation)) == null) {
                this.exportsFileLocation = this.getFecHome() + "/exports.csv";
                br = this.getCfgResource(this.exportsFileLocation);
            }
            return br;
        }

        public BufferedReader getUsersResource() {
            return this.getCfgResource(this.usersFileLocation);
        }

        public BufferedReader getNetsResource() {
            return this.getCfgResource(this.netsFileLocation);
        }

        public BufferedReader getAliasResource(String eqmName) {
            BufferedReader br;
            if (eqmName != null) {
                this.aliasFileLocation = this.getFecHome() + "/" + eqmName + "/alias.csv";
            }
            if ((br = this.getCfgResource(this.aliasFileLocation)) == null) {
                this.aliasFileLocation = this.getFecHome() + "/alias.csv";
                br = this.getCfgResource(this.aliasFileLocation);
            }
            return br;
        }

        public BufferedReader getHistoryResource(String eqmName) {
            BufferedReader br;
            if (eqmName != null) {
                this.historyFileLocation = this.getFecHome() + "/" + eqmName + "/history.csv";
            }
            if ((br = this.getCfgResource(this.historyFileLocation)) == null) {
                this.historyFileLocation = this.getFecHome() + "/history.csv";
                br = this.getCfgResource(this.historyFileLocation);
            }
            return br;
        }

        public BufferedReader getAlmWatchResource(String eqmName) {
            BufferedReader br;
            if (eqmName != null) {
                this.alarmwFileLocation = this.getFecHome() + "/" + eqmName + "/almwatch.csv";
            }
            if ((br = this.getCfgResource(this.alarmwFileLocation)) == null) {
                this.alarmwFileLocation = this.getFecHome() + "/almwatch.csv";
                br = this.getCfgResource(this.alarmwFileLocation);
            }
            return br;
        }

        public BufferedReader getCasHostResource() {
            return this.getCfgResource(this.casHostFileLocation);
        }

        public BufferedReader getAddressResource() {
            return this.getCfgResource(this.addrFileLocation);
        }

        public String getENSAddress() {
            return DefaultTInitializerFactory.ENS;
        }

        public BufferedReader getEquipmentResource() {
            return this.getCfgResource(this.eqpFileLocation);
        }

        public BufferedReader getHostsResource() {
            return this.getCfgResource(this.cshostsFileLocation);
        }

        public String getGCastAddress() {
            return DefaultTInitializerFactory.GCAST;
        }

        public int getGCastPort() {
            return 8004;
        }

        public String getNetCastAddress() {
            return DefaultTInitializerFactory.NETCAST;
        }

        public int getNetCastPort() {
            return 9002;
        }

        public String getMCastAddress() {
            return DefaultTInitializerFactory.MCAST;
        }

        public int getMCastPort() {
            return 9503;
        }

        public int getSrvPort() {
            return 9003;
        }

        public int getTCPPort() {
            return 8503;
        }

        public int getClnPort() {
            return 8050;
        }

        public BufferedReader getAlmDefinitionResource(String eqmName) {
            if (eqmName == null) {
                return null;
            }
            String fileLocation = this.getFecHome() + "/" + eqmName + "/" + "alarms.csv";
            BufferedReader br = this.getCfgResource(fileLocation);
            if (br == null) {
                fileLocation = this.getFecHome() + "/" + eqmName + "-alarms.csv";
                br = this.getCfgResource(fileLocation);
                br = this.getCfgResource(fileLocation);
                if (br == null) {
                    fileLocation = this.getFecHome() + "/" + "alarms.csv";
                    br = this.getCfgResource(fileLocation);
                }
            }
            return br;
        }

        public BufferedReader getDevicesResource(String eqmName) {
            if (eqmName == null) {
                return null;
            }
            String fileLocation = this.getFecHome() + "/" + eqmName + "/" + "devices.csv";
            BufferedReader br = this.getCfgResource(fileLocation);
            if (br == null) {
                fileLocation = this.getFecHome() + "/" + eqmName + "-devices.csv";
                br = this.getCfgResource(fileLocation);
                br = this.getCfgResource(fileLocation);
                if (br == null) {
                    fileLocation = this.getFecHome() + "/" + "devices.csv";
                    br = this.getCfgResource(fileLocation);
                }
            }
            return br;
        }

        public int getClnRcvBufferSize() {
            return clnRcvBufferSize;
        }

        public void setClnRcvBufferSize(int bufferSize) {
            if (bufferSize < 16000) {
                bufferSize = 16000;
            }
            clnRcvBufferSize = bufferSize;
        }

        public int getSckTimeToLive() {
            return sckTimeToLive;
        }

        public void setSckTimeToLive(int ttl) {
            if (ttl < 1) {
                ttl = 1;
            }
            sckTimeToLive = ttl;
        }

        public int getSrvPacketMtu() {
            return srvPacketMtu;
        }

        public void setSrvPacketMtu(int mtu) {
            if (mtu < 512) {
                mtu = 512;
            }
            if (mtu > 64000) {
                mtu = 64000;
            }
            srvPacketMtu = mtu;
        }

        public int getSrvRcvBufferSize() {
            return srvRcvBufferSize;
        }

        public void setSrvRcvBufferSize(int bufferSize) {
            if (bufferSize < 16000) {
                bufferSize = 16000;
            }
            srvRcvBufferSize = bufferSize;
        }
    }
}

