/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server.properties;

import java.util.LinkedList;

public final class TMetaProperties {
    private LinkedList<TMetaProperty> mp = new LinkedList();
    public static final int EGU_ID = 1;
    public static final int HST_ID = 2;
    public static final int NAM_ID = 3;
    public static final int DSC_ID = 4;
    public static final int BIT_ID = 5;
    public static final int MSK_ID = 6;
    public static final int GAT_ID = 7;

    public TMetaProperties() {
        this.mp.add(new TMetaProperty(".AR", 2));
        this.mp.add(new TMetaProperty(".ARC", 2));
        this.mp.add(new TMetaProperty(".ARCH", 2));
        this.mp.add(new TMetaProperty(".EGU", 1));
        this.mp.add(new TMetaProperty(".HST", 2));
        this.mp.add(new TMetaProperty(".HIST", 2));
        this.mp.add(new TMetaProperty(".HST@", 2));
        this.mp.add(new TMetaProperty(".HIST@", 2));
        this.mp.add(new TMetaProperty(".NAM", 3));
        this.mp.add(new TMetaProperty(".DSC", 4));
        this.mp.add(new TMetaProperty(".DESC", 4));
        this.mp.add(new TMetaProperty(".BIT.", 5));
        this.mp.add(new TMetaProperty(".MASK.", 6));
        this.mp.add(new TMetaProperty(".GATE.", 7));
    }

    public int getGate(String property) {
        int gate = 0;
        int idx = property.indexOf(".BIT.");
        if (idx > 0) {
            int bit = Integer.parseInt(property.substring(idx + 5));
            gate = 1 << bit;
        } else {
            idx = property.indexOf(".MASK.");
            if (idx > 0 || (idx = property.indexOf(".GATE.")) > 0) {
                String istr = property.substring(idx + 6);
                gate = istr.startsWith("0x") || istr.startsWith("0X") ? Integer.parseInt(istr, 16) : Integer.parseInt(istr);
            }
        }
        return gate;
    }

    public String getTargetProperty(String property) {
        int idx = 0;
        for (int i = 0; i < this.mp.size(); ++i) {
            String ext = this.mp.get(i).getTag();
            idx = property.indexOf(ext);
            if (idx <= 0) continue;
            return property.substring(0, idx);
        }
        return property;
    }

    public int getIndex(String property) {
        for (int i = 0; i < this.mp.size(); ++i) {
            String ext = this.mp.get(i).getTag();
            if (property.indexOf(ext) <= 0) continue;
            return this.mp.get(i).getId();
        }
        return -1;
    }

    public boolean isMetaProperty(String property) {
        return this.getIndex(property) >= 0;
    }

    public static boolean isHistorySnapshot(String property) {
        return property.endsWith(".HIST@") || property.endsWith(".HST@");
    }

    public static boolean isCentralArchive(String property) {
        return property.endsWith(".ARCH") || property.endsWith(".ARC") || property.endsWith(".AR");
    }

    public final class TMetaProperty {
        private String tag;
        private int id;

        public String getTag() {
            return this.tag;
        }

        public int getId() {
            return this.id;
        }

        public TMetaProperty(String extension, int index) {
            this.tag = new String(extension);
            this.id = index;
        }
    }
}

