/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server.logger;

import de.desy.tine.server.equipment.TEquipmentModuleFactory;
import de.desy.tine.server.logger.DbgLog;
import de.desy.tine.server.logger.TFecLogFormatter;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class TFecLog {
    private static TEquipmentModuleFactory eqmFactory = TEquipmentModuleFactory.getInstance();
    private static FileHandler feclogHandler = null;
    private static int logDepth = 1000;
    private static int debugLevel = 0;

    public static int getDebugLevel() {
        return debugLevel;
    }

    public static void setDebugLevel(int debuglevel) {
        debugLevel = debuglevel;
    }

    public static int getLogDepth() {
        return logDepth;
    }

    public static void setLogDepth(int depthInLines) {
        if (depthInLines > 0) {
            logDepth = depthInLines;
        }
    }

    public static int log(String text) {
        return TFecLog.log(eqmFactory.getFecName(), text);
    }

    public static int log(String tag, String text) {
        if (feclogHandler == null) {
            feclogHandler = eqmFactory.getInitializer().getFecLogResource();
            if (feclogHandler == null) {
                DbgLog.log("TFecLog", "cannot write to log file : no resource !");
                return -1;
            }
            feclogHandler.setFormatter(new TFecLogFormatter());
        }
        String txt = "[" + tag + "] : " + text;
        try {
            LogRecord lr = new LogRecord(Level.INFO, txt);
            feclogHandler.publish(lr);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            DbgLog.log("TFecLog", "cannot write to log file : " + e.toString());
        }
        DbgLog.log("TFecLog", txt);
        return 0;
    }

    public static String[] getFiles() {
        return TFecLog.getFiles(eqmFactory.getInitializer().getLogHome());
    }

    public static String[] getFiles(String filePath) {
        File path = new File(filePath);
        File[] rawList = path.listFiles();
        String[] files = new String[rawList.length];
        for (int i = 0; i < rawList.length; ++i) {
            files[i] = rawList[i].getName();
        }
        return files;
    }

    public static String getLines(int maxNumberOfLines) {
        return TFecLog.getLines("fec.log.0", maxNumberOfLines);
    }

    public static boolean fileExists(String fileName) {
        String fn = null;
        if (fileName == null || fileName.length() == 0) {
            return false;
        }
        fn = fileName.indexOf(47) == -1 && fileName.indexOf(92) == -1 ? eqmFactory.getInitializer().getLogHome() + "/" + fileName : fileName;
        return new File(fn).exists();
    }

    public static String getLines(String fileName, int maxNumberOfLines) {
        String fn = null;
        StringBuffer sb = null;
        String text = null;
        int nl = 0;
        try {
            fn = fileName.indexOf(47) == -1 && fileName.indexOf(92) == -1 ? eqmFactory.getInitializer().getLogHome() + "/" + fileName : fileName;
            RandomAccessFile raf = new RandomAccessFile(fn, "r");
            int flen = (int)raf.length();
            int fpos = flen - maxNumberOfLines * 80;
            if (fpos < 0) {
                fpos = 0;
            }
            raf.seek(fpos);
            sb = new StringBuffer(flen - fpos);
            while ((text = raf.readLine()) != null) {
                sb.append(text);
                sb.append("\n");
                ++nl;
            }
        }
        catch (Exception e) {
            DbgLog.log("TFecLog", e.toString());
        }
        if (sb == null) {
            sb = new StringBuffer("file unavailable");
        }
        text = sb.toString();
        if (debugLevel > 0) {
            DbgLog.log("TFecLog", text);
        }
        return text;
    }
}

