/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server.logger;

import de.desy.tine.dataUtils.TDataTime;
import de.desy.tine.structUtils.TTaggedStructure;

public class ClogFilter
extends TTaggedStructure {
    private char[] ctx = new char[32];
    private String ctxString;
    private char[] tag = new char[32];
    private String tagString;
    private char[] logger = new char[32];
    private String loggerString;
    private char[] txt = new char[256];
    private String txtString;
    private int[] pri = new int[1];
    private int[] sts = new int[1];
    private int[] timeStart = new int[1];
    private int[] timeStop = new int[1];

    public String getContext() {
        if (this.ctxString == null) {
            this.ctxString = new String(this.ctx);
        }
        return this.ctxString;
    }

    public String getTag() {
        if (this.tagString == null) {
            this.tagString = new String(this.tag);
        }
        return this.tagString;
    }

    public String getLogger() {
        if (this.loggerString == null) {
            this.loggerString = new String(this.logger);
        }
        return this.loggerString;
    }

    public String getText() {
        if (this.txtString == null) {
            this.txtString = new String(this.txt);
        }
        return this.txtString;
    }

    public int getPriority() {
        return this.pri[0];
    }

    public int getStatus() {
        return this.sts[0];
    }

    public long getTimeStart() {
        return TDataTime.getLongDataTimeStamp(this.timeStart[0]);
    }

    public long getTimeStop() {
        return TDataTime.getLongDataTimeStamp(this.timeStop[0]);
    }

    public void setTimeStart(long startTime) {
        this.timeStart[0] = (int)(startTime / 1000L);
    }

    public void setTimeStop(long stopTime) {
        this.timeStart[0] = (int)(stopTime / 1000L);
    }

    private void initStructure() {
        this.addField(this.ctx, "context");
        this.addField(this.tag, "tag");
        this.addField(this.logger, "logger");
        this.addField(this.txt, "text");
        this.addField(this.pri, "priority");
        this.addField(this.sts, "status");
        this.addField(this.timeStart, "timeSent");
        this.addField(this.timeStop, "timeLogged");
        this.initDone();
    }

    ClogFilter() {
        super("CLOGF");
        this.initStructure();
    }

    private void pushChars(String s, char[] c) {
        int len;
        if (s == null) {
            s = "";
        }
        if ((len = s.length()) > c.length) {
            len = c.length;
        }
        s.getChars(0, len, c, 0);
    }

    public ClogFilter(String text, String context, String tag, String caller, int priority, int status, long start, long stop) {
        super("CLOGF");
        this.pushChars(context, this.ctx);
        this.pushChars(tag, this.tag);
        this.pushChars(caller, this.logger);
        this.pushChars(text, this.txt);
        this.pri[0] = priority;
        this.sts[0] = status;
        this.timeStart[0] = (int)(start / 1000L);
        this.timeStop[0] = (int)(stop / 1000L);
        this.initStructure();
    }

    public ClogFilter(long start, long stop) {
        super("CLOGF");
        this.timeStart[0] = (int)(start / 1000L);
        this.timeStop[0] = (int)(stop / 1000L);
        this.initStructure();
    }
}

