/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server.logger;

import de.desy.tine.client.TLinkFactory;
import de.desy.tine.dataUtils.TDataTime;
import de.desy.tine.server.equipment.TEquipmentModuleFactory;
import de.desy.tine.server.logger.ClsLog;
import de.desy.tine.structUtils.TTaggedStructure;

public class Clog
extends TTaggedStructure {
    private char[] ctx = new char[32];
    private String ctxString;
    private char[] tag = new char[32];
    private String tagString;
    private char[] logger = new char[32];
    private String loggerString;
    private char[] txt = new char[256];
    private String txtString;
    private int[] pri = new int[1];
    private int[] sts = new int[1];
    private double[] timeSent = new double[1];
    private double[] timeLogged = new double[1];

    public void reset() {
        this.ctxString = null;
        this.tagString = null;
        this.loggerString = null;
        this.txtString = null;
    }

    public String getContext() {
        if (this.ctxString == null) {
            this.ctxString = new String(this.ctx).trim();
        }
        return this.ctxString;
    }

    public String getTag() {
        if (this.tagString == null) {
            this.tagString = new String(this.tag).trim();
        }
        return this.tagString;
    }

    public String getLogger() {
        if (this.loggerString == null) {
            this.loggerString = new String(this.logger).trim();
        }
        return this.loggerString;
    }

    public String getText() {
        if (this.txtString == null) {
            this.txtString = new String(this.txt).trim();
        }
        return this.txtString;
    }

    public int getPriority() {
        return this.pri[0];
    }

    public int getStatus() {
        return this.sts[0];
    }

    public long getTimeSent() {
        return TDataTime.getLongDataTimeStamp(this.timeSent[0]);
    }

    public long getTimeLogged() {
        return TDataTime.getLongDataTimeStamp(this.timeLogged[0]);
    }

    private void initStructure() {
        this.addField(this.ctx, "context");
        this.addField(this.tag, "tag");
        this.addField(this.logger, "logger");
        this.addField(this.txt, "text");
        this.addField(this.pri, "priority");
        this.addField(this.sts, "status");
        this.addField(this.timeSent, "timeSent");
        this.addField(this.timeLogged, "timeLogged");
        this.initDone();
    }

    Clog() {
        super("CLOG");
        this.initStructure();
    }

    private void pushChars(String s, char[] c) {
        int len;
        if (s == null) {
            s = "";
        }
        if ((len = s.length()) > c.length) {
            len = c.length;
        }
        s.getChars(0, len, c, 0);
    }

    Clog(String text, String context, String tag, String caller, int priority, int status) {
        super("CLOG");
        this.pushChars(context, this.ctx);
        this.pushChars(tag, this.tag);
        this.pushChars(caller, this.logger);
        this.pushChars(text, this.txt);
        this.pri[0] = priority;
        this.sts[0] = status;
        this.timeSent[0] = TDataTime.getDataTimeStamp();
        this.initStructure();
    }

    Clog(String text) {
        super("CLOG");
        this.pushChars(TEquipmentModuleFactory.getInstance().getFecContext(), this.ctx);
        this.pushChars(TEquipmentModuleFactory.getInstance().getFecSubsystem(), this.tag);
        this.pushChars(TLinkFactory.getInstance().getUserName(), this.logger);
        this.pushChars(text, this.txt);
        this.pri[0] = ClsLog.ClogPriority.CLOG_PRIORITY_USEFUL.ordinal();
        this.sts[0] = ClsLog.ClogStatus.CLOG_STATUS_INFO.ordinal();
        this.timeSent[0] = TDataTime.getDataTimeStamp();
        this.initStructure();
    }

    Clog(Clog reference) {
        this(reference.getText(), reference.getContext(), reference.getTag(), reference.getLogger(), reference.getPriority(), reference.getStatus());
        this.timeLogged[0] = reference.timeLogged[0];
        this.timeSent[0] = reference.timeSent[0];
    }
}

