/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server.devices;

import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.definitions.TStrings;
import de.desy.tine.server.alarms.TAlarm;
import de.desy.tine.server.equipment.TEquipmentModule;
import de.desy.tine.server.logger.DbgLog;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TDevice {
    public int devNumber;
    public String devName;
    private String devDescription;
    private LinkedList<TAlarm> devAlarmList = new LinkedList();
    private int devAlarmMrt = 0;
    private int devAlarmMrct = 0;
    private short devAlarmHsv = 0;
    private int nDevAlarmsAtMrt;
    private int nDevAlarmsAtMrct;
    private int nDevAlarmsAtHsv;
    private TEquipmentModule eqm = null;
    private String redirection = null;
    private LinkedList<String> devPrpList = null;

    public LinkedList<String> getPropertyList() {
        return this.devPrpList;
    }

    private LinkedList<String> mapStringArrayToList(String[] prpArray) {
        if (prpArray == null) {
            return null;
        }
        LinkedList<String> ll = new LinkedList<String>();
        for (String p : prpArray) {
            ll.add(p);
        }
        return ll;
    }

    public void setPropertyList(String[] prpList) {
        this.devPrpList = this.mapStringArrayToList(prpList);
    }

    public void setPropertyList(List<String> prpList) {
        if (prpList instanceof LinkedList) {
            this.devPrpList = (LinkedList)prpList;
        } else if (prpList instanceof ArrayList) {
            String[] prps = ((ArrayList)prpList).toArray(new String[0]);
            this.devPrpList = this.mapStringArrayToList(prps);
        }
    }

    public int getHighestAlarmSeverity() {
        return this.devAlarmHsv;
    }

    public int getNumberOfAlarmsAtMostRecentTimestamp() {
        return this.nDevAlarmsAtMrct;
    }

    public int getNumberOfAlarmsAtHighestSeverity() {
        return this.nDevAlarmsAtHsv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TAlarm[] getAlarmList() {
        LinkedList<TAlarm> linkedList = this.devAlarmList;
        synchronized (linkedList) {
            return this.devAlarmList.toArray(new TAlarm[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TAlarm getAlarmFromList(int code, byte[] data, short flags) {
        TAlarm alm = null;
        LinkedList<TAlarm> linkedList = this.devAlarmList;
        synchronized (linkedList) {
            Iterator li = this.devAlarmList.iterator();
            if (code == 0) {
                DbgLog.log("getAlarmFromList", "searching for alarm code == 0?");
            }
            while (li.hasNext()) {
                int dlen;
                alm = (TAlarm)li.next();
                if (alm.isTerminated()) {
                    if (alm.isTransient()) continue;
                    int dt = alm.getTimeStamp() + TAlarm.getTerminationWindow() - (int)(System.currentTimeMillis() / 1000L);
                    int oscw = TAlarm.getAlmOscillationWindow();
                    if (dt <= 0 || dt >= 128 - oscw) continue;
                    TAlarm.setAlmOscillationWindow(oscw += dt);
                    DbgLog.log("getAlarmFromList", "increase alarm oscillation windows to " + oscw + " clear counts");
                    continue;
                }
                if (alm.getCode() != code) continue;
                byte dsc = alm.getDescriptor();
                byte[] adata = alm.getData();
                int n = dlen = alm.getAlmDef() == null ? 0 : alm.getAlmDef().getAlarmDataArraySize();
                if (dlen > 0 && data != null && adata != null) {
                    for (int n2 = 0; n2 < dlen && n2 < adata.length && n2 < data.length; ++n2) {
                        if (data[n2] == adata[n2]) continue;
                        dsc = (byte)(dsc & 0xFFFFFFFE);
                        dsc = (byte)(dsc | 8);
                        DbgLog.log("getAlarmFromList", alm.getTag() + " : alarm data changed");
                    }
                }
                if (alm.getClearCount() > 1) {
                    dsc = (byte)(dsc & 0xFFFFFFFE);
                    dsc = (byte)(dsc | 4);
                    DbgLog.log("getAlarmFromList", alm.getTag() + " : mark alarm as oscillating");
                }
                alm.resetClearCount();
                alm.setDescriptor(dsc);
                return alm;
            }
            if (((flags = (short)(flags | 1)) & 0x10) != 0) {
                flags = (short)(flags | 0x40);
            }
            alm = new TAlarm(code, (byte)flags, data, this);
            if (this.eqm.casReadRequired) {
                alm.blockRemoval();
            }
            this.devAlarmList.add(alm);
        }
        DbgLog.log("getAlarmFromList", this.devName + " : " + alm.getTag() + "(" + code + ") : add alarm to list");
        return alm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAlarms() {
        LinkedList<TAlarm> linkedList = this.devAlarmList;
        synchronized (linkedList) {
            return this.devAlarmList.size();
        }
    }

    public int getMostRecentTimestamp() {
        return this.devAlarmMrct;
    }

    private void refreshMrt(int ts) {
        if (ts > this.devAlarmMrt) {
            this.devAlarmMrt = ts;
            this.nDevAlarmsAtMrt = 1;
        } else if (ts == this.devAlarmMrt) {
            ++this.nDevAlarmsAtMrt;
        }
    }

    private void refreshHsv(short sv) {
        if (sv > this.devAlarmHsv) {
            this.devAlarmHsv = sv;
            this.nDevAlarmsAtHsv = 1;
        } else if (sv == this.devAlarmHsv) {
            ++this.nDevAlarmsAtHsv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAlarms() {
        int thisTimeStamp = (int)(System.currentTimeMillis() / 1000L);
        TAlarm alm = null;
        LinkedList<TAlarm> linkedList = this.devAlarmList;
        synchronized (linkedList) {
            Iterator li = this.devAlarmList.iterator();
            this.nDevAlarmsAtHsv = 0;
            this.devAlarmHsv = 0;
            this.nDevAlarmsAtMrt = 0;
            this.devAlarmMrt = 0;
            this.nDevAlarmsAtMrct = 0;
            this.devAlarmMrct = 0;
            while (li.hasNext()) {
                byte dsc;
                alm = (TAlarm)li.next();
                if (alm.isTerminated() && thisTimeStamp > alm.getTimeStamp() + TAlarm.getTerminationWindow()) {
                    if (alm.getSeverity() > 0 && alm.isRemovalBlocked()) {
                        DbgLog.log("processAlarms", alm.getTag() + " : missing CAS read -> removal blocked");
                    } else {
                        DbgLog.log("processAlarms", alm.getTag() + " : remove alarm");
                        this.devAlarmList.remove(alm);
                        continue;
                    }
                }
                if (!alm.isTerminated() && alm.getClearCount() > TAlarm.getAlmOscillationWindow() - 3 && thisTimeStamp > alm.getTimeStamp()) {
                    dsc = alm.getDescriptor();
                    dsc = (byte)(dsc & 0xFFFFFFFE);
                    dsc = (byte)(dsc | 0x40);
                    alm.setDescriptor(dsc);
                    alm.setTimeStamp(thisTimeStamp);
                    alm.setTerminated(true);
                    DbgLog.log("processAlarms", alm.getTag() + " : mark alarm as terminated");
                }
                if (thisTimeStamp > alm.getTimeStamp() + TAlarm.getAlmHeartbeatWindow()) {
                    dsc = alm.getDescriptor();
                    dsc = (byte)(dsc & 0xFFFFFFFE);
                    dsc = (byte)(dsc | 2);
                    alm.setDescriptor(dsc);
                    alm.setTimeStamp(thisTimeStamp);
                }
                this.refreshMrt(alm.getTimeStamp());
                this.refreshHsv((short)alm.getSeverity());
            }
        }
        if (thisTimeStamp > this.devAlarmMrt && this.devAlarmMrt > this.devAlarmMrct) {
            this.nDevAlarmsAtMrct = this.nDevAlarmsAtMrt;
            this.devAlarmMrct = this.devAlarmMrt;
        }
    }

    public TAlarm setAlarm(int code) {
        return this.setAlarm(code, null, (short)1);
    }

    public TAlarm setAlarm(int code, byte[] data) {
        return this.setAlarm(code, data, (short)1);
    }

    public TAlarm setAlarm(int code, TDataType data) {
        return this.setAlarm(code, data.getDataBuffer(), (short)1);
    }

    public TAlarm setAlarm(int code, float data) {
        float[] fdata = new float[]{data};
        TDataType td = new TDataType(fdata);
        return this.setAlarm(code, td.getDataBuffer(), (short)1);
    }

    public TAlarm setAlarm(int code, int data) {
        int[] idata = new int[]{data};
        TDataType td = new TDataType(idata);
        return this.setAlarm(code, td.getDataBuffer(), (short)1);
    }

    public TAlarm setAlarm(int code, short[] data) {
        TDataType td = new TDataType(data);
        return this.setAlarm(code, td.getDataBuffer(), (short)1);
    }

    public TAlarm setAlarm(int code, byte[] data, short flags) {
        TAlarm alm = this.getAlarmFromList(code, data, flags);
        if (alm.isTerminated()) {
            DbgLog.log("setAlarm", alm.getTag() + " : set alarm as terminated");
        }
        return alm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAlarms() {
        LinkedList<TAlarm> linkedList = this.devAlarmList;
        synchronized (linkedList) {
            Iterator li = this.devAlarmList.iterator();
            while (li.hasNext()) {
                ((TAlarm)li.next()).clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAlarm(int code) {
        TAlarm alm2 = null;
        LinkedList<TAlarm> linkedList = this.devAlarmList;
        synchronized (linkedList) {
            for (TAlarm alm2 : this.devAlarmList) {
                if ((alm2.getDescriptor() & 0x40) != 0 || alm2.getCode() != code) continue;
                alm2.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAlarm(int code) {
        LinkedList<TAlarm> linkedList = this.devAlarmList;
        synchronized (linkedList) {
            Iterator li = this.devAlarmList.iterator();
            TAlarm alm = null;
            while (li.hasNext()) {
                alm = (TAlarm)li.next();
                if ((alm.getDescriptor() & 0x40) != 0 || alm.getCode() != code) continue;
                alm.setDescriptor((byte)64);
                alm.clear();
            }
        }
    }

    public TDevice(String name, int number) {
        TStrings.validateDeviceName(name);
        this.devName = name;
        this.devNumber = number;
    }

    public TDevice(int number) {
        this.devName = "#" + number;
        this.devNumber = number;
    }

    public TDevice(String name, int number, TEquipmentModule equipmentModule) {
        TStrings.validateDeviceName(name);
        this.devName = name;
        this.devNumber = number;
        this.eqm = equipmentModule;
    }

    public TEquipmentModule getEqm() {
        return this.eqm;
    }

    public String getName() {
        return this.devName;
    }

    public void setName(String name) {
        TStrings.validateDeviceName(name);
        this.devName = name;
    }

    public void setEqm(TEquipmentModule eqm) {
        this.eqm = eqm;
    }

    public String getRedirection() {
        return this.redirection;
    }

    public void setRedirection(String redirection) {
        this.redirection = redirection;
    }

    public String getDescription() {
        return this.devDescription;
    }

    public void setDescription(String description) {
        this.devDescription = description;
    }
}

