/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server.connections;

import de.desy.tine.definitions.TTransport;
import de.desy.tine.server.connections.TContractTable;
import de.desy.tine.stringUtils.StringToBytes;
import de.desy.tine.structUtils.TStructBase;
import de.desy.tine.structUtils.TStructDescription;
import de.desy.tine.structUtils.TStructRegistry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.LinkedList;

public class TClient
extends TStructBase {
    public String userName;
    byte[] IPXaddress = new byte[12];
    byte[] node = new byte[6];
    short IPfamily = (short)2;
    short IPport;
    public InetAddress IPaddress;
    byte[] IPsine_zero = new byte[8];
    public short ncontracts;
    private ArrayList<TContractTable> conLst = new ArrayList();
    private LinkedList<TContractTable> conLstAdd = new LinkedList();
    public short tineProtocol;
    public short inetProtocol;
    public int port;
    public OutputStream output;
    public Socket sck;
    private static TStructDescription myStructDsc;
    private static final int ARRAY_SIZE_HINT = 20;
    public static final int nice_query_size = 50;

    public String toString() {
        String s = new String(this.userName) + " @ " + this.IPaddress.getHostAddress() + ":" + this.IPport;
        s = s.concat(" " + TTransport.toString(this.inetProtocol));
        s = s.concat(" (" + this.ncontracts + ")");
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContract(TContractTable con) {
        LinkedList<TContractTable> linkedList = this.conLstAdd;
        synchronized (linkedList) {
            this.conLstAdd.add(con);
        }
    }

    public void rmvContract(TContractTable con) {
        this.conLst.remove(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAddedContracts() {
        LinkedList<TContractTable> linkedList = this.conLstAdd;
        synchronized (linkedList) {
            this.conLstAdd.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendAddedContracts() {
        TContractTable tct2 = null;
        LinkedList<TContractTable> linkedList = this.conLstAdd;
        synchronized (linkedList) {
            for (TContractTable tct2 : this.conLstAdd) {
                this.conLst.add(tct2);
            }
            this.conLstAdd.clear();
        }
    }

    public boolean hasAddedContracts() {
        return this.conLstAdd.size() > 0;
    }

    public TContractTable[] getContractList() {
        TContractTable[] cta = null;
        try {
            cta = this.conLst.toArray(new TContractTable[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cta;
    }

    public static TStructDescription getStructDescription() {
        return myStructDsc;
    }

    private static void initClientStruct() {
        if (TStructRegistry.contains("CLNQS")) {
            return;
        }
        myStructDsc = new TStructDescription("CLNQS");
        myStructDsc.beginDefinition();
        myStructDsc.addField("username", (short)4, 16);
        myStructDsc.addField("ipxAddr", (short)2, 12);
        myStructDsc.addField("ipxNode", (short)2, 6);
        myStructDsc.addField("ipFamily", (short)1, 1);
        myStructDsc.addField("ipPort", (short)1, 1);
        myStructDsc.addField("ipAddr", (short)2, 4);
        myStructDsc.addField("ipZero", (short)2, 8);
        myStructDsc.addField("numContracts", (short)1, 1);
        myStructDsc.addField("transport", (short)1, 1);
        myStructDsc.setArraySize(20);
        myStructDsc.endDefinition();
        TStructRegistry.add(myStructDsc);
    }

    public void writeData(DataOutput dout) throws IOException {
        dout.write(StringToBytes.stringToFixedBytes(this.userName, 16));
        dout.write(this.IPXaddress);
        dout.write(this.node);
        dout.writeShort(this.IPfamily);
        dout.writeShort(this.port);
        dout.write(this.IPaddress.getAddress(), 0, 4);
        dout.write(this.IPsine_zero);
        dout.writeShort(this.ncontracts);
        dout.writeShort(this.tineProtocol);
    }

    public void readData(DataInput din) throws IOException {
    }

    static {
        TClient.initClientStruct();
    }
}

