/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.queryUtils;

import de.desy.tine.endianUtils.Swap;
import de.desy.tine.server.logger.MsgLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PropertyQuery {
    public String name;
    public String prpDesc;
    public short prpSize;
    public byte prpFormat;
    public byte prpAccess;
    public static int sizeInBytes = 68;
    ByteArrayOutputStream dBuffer = new ByteArrayOutputStream(sizeInBytes);
    byte[] hByteArray;

    public PropertyQuery() {
        this.name = new String(new StringBuffer(32));
        this.prpDesc = new String(new StringBuffer(32));
    }

    public byte[] toByteArray() {
        try {
            int i;
            this.dBuffer.reset();
            DataOutputStream ds = new DataOutputStream(this.dBuffer);
            byte[] bname = this.name.getBytes();
            byte[] b = new byte[sizeInBytes];
            for (i = 0; i < 32 && i < bname.length; ++i) {
                b[i] = bname[i];
            }
            ds.write(b, 0, 32);
            bname = this.prpDesc.getBytes();
            for (i = 0; i < 32 && i < bname.length; ++i) {
                b[i] = bname[i];
            }
            ds.write(b, 0, 32);
            ds.writeShort(Swap.Short(this.prpSize));
            ds.writeByte(this.prpFormat);
            ds.writeByte(this.prpAccess);
            ds.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MsgLog.log("PropertyQuery", "could not prepare byte stream", 66, e, 0);
            return null;
        }
        this.hByteArray = this.dBuffer.toByteArray();
        return this.hByteArray;
    }

    public void toStruct() {
        try {
            ByteArrayInputStream dis = new ByteArrayInputStream(this.hByteArray);
            DataInputStream ds = new DataInputStream(dis);
            byte[] b = new byte[32];
            ds.read(b, 0, 32);
            int len = 0;
            int i = 0;
            while (i < 32 && b[i] != 0) {
                ++i;
                ++len;
            }
            this.name = new String(b, 0, len);
            ds.read(b, 0, 32);
            len = 0;
            i = 0;
            while (i < 32 && b[i] != 0) {
                ++i;
                ++len;
            }
            this.prpDesc = new String(b, 0, len);
            this.prpSize = Swap.Short(ds.readShort());
            this.prpFormat = ds.readByte();
            this.prpAccess = ds.readByte();
            ds.close();
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MsgLog.log("PropertyQuery", "could not prepare byte stream", 66, e, 0);
        }
    }
}

