/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.histUtils;

import de.desy.tine.client.TLink;
import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.definitions.TErrorList;
import de.desy.tine.histUtils.HstCfg;
import de.desy.tine.histUtils.HstSrc;
import de.desy.tine.histUtils.McaCfg;
import de.desy.tine.histUtils.PrfCfg;
import de.desy.tine.histUtils.THistorySource;
import de.desy.tine.queryUtils.TQuery;
import de.desy.tine.server.logger.DbgLog;
import de.desy.tine.types.DBLDBL;
import de.desy.tine.types.FLTINT;
import de.desy.tine.types.NAME;
import de.desy.tine.types.NAME16I;
import de.desy.tine.types.NAME32;
import de.desy.tine.types.NAME32I;
import de.desy.tine.types.NAME64;
import de.desy.tine.types.NAME64I;
import de.desy.tine.types.TCompoundDataObject;
import java.util.Vector;

public final class THistory {
    private static final int MAX_HSTCFG_SIZE = 100;
    private static HstCfg[] cfgs = new HstCfg[100];
    private static McaCfg[] mcacfgs = new McaCfg[100];
    private static PrfCfg[] prfcfgs = new PrfCfg[100];
    private static boolean isInitialized = false;

    private static void initCfgs() {
        if (isInitialized) {
            return;
        }
        for (int i = 0; i < 100; ++i) {
            THistory.cfgs[i] = new HstCfg();
            THistory.mcacfgs[i] = new McaCfg();
            THistory.prfcfgs[i] = new PrfCfg();
        }
        isInitialized = true;
    }

    private static boolean isCentralArchiveServer(String server) {
        return server.endsWith("HISTORY");
    }

    private static boolean isCentralArchiver(String server) {
        return server.endsWith("ARCHIVER");
    }

    private static String getQueryPropertyRoot(String property) {
        int slen = property.length();
        if (property.endsWith(".HIST") || property.endsWith(".ARCH")) {
            return property.substring(0, slen - 5);
        }
        if (property.endsWith(".HST") || property.endsWith(".ARC")) {
            return property.substring(0, slen - 4);
        }
        if (property.endsWith(".AR")) {
            return property.substring(0, slen - 3);
        }
        return property;
    }

    private static boolean isArchiveQueryProperty(String property) {
        if (property.endsWith(".HIST")) {
            return true;
        }
        if (property.endsWith(".HST")) {
            return true;
        }
        if (property.endsWith(".ARCH")) {
            return true;
        }
        if (property.endsWith(".ARC")) {
            return true;
        }
        return property.endsWith(".AR");
    }

    private static synchronized int getArchivedNumPointsInInterval(String context, String server, String property, String device, double start, double stop, int timeout) {
        int cc = 0;
        int[] startstop = new int[2];
        int[] npts = new int[1];
        if (server == null && context == null) {
            return 20;
        }
        if (context == null) {
            context = "DEFAULT";
        }
        if (server == null) {
            server = "HISTORY";
        }
        startstop[0] = (int)start;
        startstop[1] = (int)stop;
        TDataType din = new TDataType(startstop);
        TDataType dout = new TDataType(npts);
        String dname = new String("/" + context + "/" + server + "/" + device);
        String pname = new String(property);
        if (!THistory.isCentralArchiveServer(server) && !THistory.isArchiveQueryProperty(property)) {
            pname = pname + ".HIST";
        }
        TLink tl = new TLink(dname, pname, dout, din, 1);
        cc = tl.execute(timeout, true);
        tl.close();
        return cc > 0 ? -cc : npts[0];
    }

    private static synchronized int getDataArray(String context, String server, String property, String device, int index, double start, double stop, TCompoundDataObject[] data, THistorySource src, int timeout) {
        int idx;
        int cc = 0;
        HstSrc[] srvs = new HstSrc[2];
        String s1 = server;
        String p1 = property;
        if (s1 == null) {
            s1 = "HISTORY";
        }
        if ((idx = property.indexOf(".HIST")) >= 0 || (idx = property.indexOf(".HST")) >= 0 || (idx = property.indexOf(".AR")) >= 0) {
            p1 = property.substring(0, idx - 1);
        }
        String s2 = s1;
        if (!THistory.isCentralArchiveServer(s1)) {
            p1 = property + ".ARCH";
        } else {
            s2 = "ARCHIVER";
        }
        int npts1 = THistory.getArchivedNumPointsInInterval(context, s1, p1, device, start, stop, timeout);
        if (npts1 < 0) {
            npts1 = 0;
        }
        srvs[0] = new HstSrc("Central Archive", s1, npts1);
        String p2 = property + ".HIST";
        int npts2 = THistory.getArchivedNumPointsInInterval(context, s2, p2, device, start, stop, timeout);
        if (npts2 < 0) {
            npts2 = 0;
        }
        srvs[1] = new HstSrc("Local History", s2, npts2);
        boolean done = false;
        int nret = 0;
        if (npts1 > 500 || npts1 > npts2) {
            nret = THistory.getArchivedDataArray(context, s1, p1, device, index, start, stop, data, timeout);
            if (nret > 0) {
                srvs[0].setAsDefault(true);
                srvs[0].setNumberReturned(nret);
                done = true;
            } else {
                cc = -nret;
            }
        }
        if (!done && npts2 > 0) {
            nret = THistory.getArchivedDataArray(context, s2, p2, device, index, start, stop, data, timeout);
            if (nret > 0) {
                srvs[1].setNumberReturned(nret);
            } else {
                cc = -nret;
            }
            srvs[1].setAsDefault(true);
        }
        if (src != null) {
            src.CentralArchive = srvs[0];
            src.LocalHistory = srvs[1];
            src.setNumberOfPointsReturned(nret);
        }
        return cc;
    }

    private static synchronized int getArchivedDataArray(String context, String server, String property, String device, int index, double start, double stop, TCompoundDataObject[] data, int timeout) {
        int cc = 0;
        int[] startstop = new int[3];
        if (server == null && context == null) {
            return 20;
        }
        if (data == null) {
            return 20;
        }
        if (context == null) {
            context = "DEFAULT";
        }
        if (server == null) {
            server = "HISTORY";
        }
        if (timeout < 100) {
            timeout = 100;
        }
        startstop[0] = (int)start;
        startstop[1] = (int)stop;
        startstop[2] = index;
        TDataType din = new TDataType(startstop);
        TDataType dout = new TDataType(data);
        String dname = new String("/" + context + "/" + server + "/" + device);
        String pname = new String(property);
        if (!THistory.isCentralArchiveServer(server) && !THistory.isArchiveQueryProperty(property)) {
            pname = pname + ".HIST";
        }
        TLink tl = new TLink(dname, pname, dout, din, 1);
        cc = tl.execute(timeout, true);
        tl.close();
        if (cc != 0 && THistory.isCentralArchiver(server)) {
            pname = THistory.isArchiveQueryProperty(property) ? THistory.getQueryPropertyRoot(property) + ".ARCH" : new String(property) + ".ARCH";
            tl = new TLink(dname, pname, dout, din, 1);
            cc = tl.execute(timeout, true);
            tl.close();
        }
        return cc == 0 ? dout.getCompletionLength() : -cc;
    }

    private static int getArchivedDataArray(String context, String server, String property, String device, int index, double start, double stop, TCompoundDataObject[] data) {
        return THistory.getArchivedDataArray(context, server, property, device, index, start, stop, data, 2000);
    }

    private static synchronized int getArchivedDataSnapshot(String context, String server, String property, String device, double[] targetTime, float[] data) {
        int cc = 0;
        int[] startstop = new int[2];
        if (server == null && context == null) {
            return 20;
        }
        if (targetTime == null || data == null) {
            return 20;
        }
        if (context == null) {
            context = "DEFAULT";
        }
        if (server == null) {
            server = "HISTORY";
        }
        startstop[0] = (int)targetTime[0];
        startstop[1] = (int)targetTime[0];
        TDataType din = new TDataType(startstop);
        TDataType dout = new TDataType(data);
        String dname = new String("/" + context + "/" + server + "/" + device);
        String[] pname = new String[2];
        pname[0] = new String(property);
        int ntries = 1;
        if (!server.endsWith("HISTORY") && !THistory.isArchiveQueryProperty(property)) {
            pname[0] = property + ".HIST";
            pname[1] = property + ".ARCH";
            ntries = 2;
        }
        for (int i = 0; i < ntries; ++i) {
            TLink tl = new TLink(dname, pname[i], dout, din, 1);
            cc = tl.execute(2000, true);
            targetTime[0] = tl.getLastDataTimeStamp();
            tl.close();
            if (cc == 0 && dout.getCompletionLength() > 0) break;
        }
        return cc;
    }

    public static int getArchivedData(String context, String server, String property, String device, double start, double stop, FLTINT[] data) {
        return THistory.getArchivedDataArray(context, server, property, device, 0, start, stop, data);
    }

    public static int getArchivedData(String context, String server, String property, String device, int index, double start, double stop, FLTINT[] data) {
        return THistory.getArchivedDataArray(context, server, property, device, index, start, stop, data);
    }

    public static int getArchivedData(String context, String server, String property, String device, int index, double start, double stop, FLTINT[] data, int timeout) {
        return THistory.getArchivedDataArray(context, server, property, device, index, start, stop, data, timeout);
    }

    public static int getArchivedData(String context, String server, String property, String device, double start, double stop, DBLDBL[] data) {
        return THistory.getArchivedDataArray(context, server, property, device, 0, start, stop, data);
    }

    public static int getArchivedData(String context, String server, String property, String device, double start, double stop, DBLDBL[] data, THistorySource src, int timeout) {
        return THistory.getDataArray(context, server, property, device, 0, start, stop, data, src, timeout);
    }

    public static int getArchivedData(String context, String server, String property, String device, double start, double stop, FLTINT[] data, THistorySource src, int timeout) {
        return THistory.getDataArray(context, server, property, device, 0, start, stop, data, src, timeout);
    }

    public static int getArchivedData(String context, String server, String property, String device, double start, double stop, NAME16I[] data, THistorySource src, int timeout) {
        return THistory.getDataArray(context, server, property, device, 0, start, stop, data, src, timeout);
    }

    public static int getArchivedData(String context, String server, String property, String device, double start, double stop, NAME32I[] data, THistorySource src, int timeout) {
        return THistory.getDataArray(context, server, property, device, 0, start, stop, data, src, timeout);
    }

    public static int getArchivedData(String context, String server, String property, String device, double start, double stop, NAME64I[] data, THistorySource src, int timeout) {
        return THistory.getDataArray(context, server, property, device, 0, start, stop, data, src, timeout);
    }

    public static int getArchivedData(String context, String server, String property, String device, int index, double start, double stop, DBLDBL[] data) {
        return THistory.getArchivedDataArray(context, server, property, device, index, start, stop, data);
    }

    public static int getArchivedData(String context, String server, String property, String device, int index, double start, double stop, DBLDBL[] data, int timeout) {
        return THistory.getArchivedDataArray(context, server, property, device, index, start, stop, data, timeout);
    }

    public static int getArchivedData(String context, String server, String property, String device, double start, double stop, NAME16I[] data) {
        return THistory.getArchivedDataArray(context, server, property, device, 0, start, stop, data);
    }

    public static int getArchivedData(String context, String server, String property, String device, double start, double stop, NAME16I[] data, int timeout) {
        return THistory.getArchivedDataArray(context, server, property, device, 0, start, stop, data, timeout);
    }

    public static int getArchivedData(String context, String server, String property, String device, double start, double stop, NAME32I[] data) {
        return THistory.getArchivedDataArray(context, server, property, device, 0, start, stop, data);
    }

    public static int getArchivedData(String context, String server, String property, String device, double start, double stop, NAME32I[] data, int timeout) {
        return THistory.getArchivedDataArray(context, server, property, device, 0, start, stop, data, timeout);
    }

    public static int getArchivedData(String context, String server, String property, String device, double start, double stop, NAME64I[] data) {
        return THistory.getArchivedDataArray(context, server, property, device, 0, start, stop, data);
    }

    public static int getArchivedData(String context, String server, String property, String device, double start, double stop, NAME64I[] data, int timeout) {
        return THistory.getArchivedDataArray(context, server, property, device, 0, start, stop, data, timeout);
    }

    public static int getNumPointsInInterval(String context, String server, String property, String device, double start, double stop) {
        return THistory.getArchivedNumPointsInInterval(context, server, property, device, start, stop, 1000);
    }

    public static int getNumPointsInInterval(String context, String server, String property, String device, double start, double stop, int timeout) {
        return THistory.getArchivedNumPointsInInterval(context, server, property, device, start, stop, timeout);
    }

    public static int getArchivedSnapshot(String context, String server, String property, String device, double[] targetTime, float[] data) {
        return THistory.getArchivedDataSnapshot(context, server, property, device, targetTime, data);
    }

    public static String[] getArchivedProperties(String context) {
        return THistory.getArchivedProperties(context, null, null);
    }

    public static String[] getArchivedProperties(String context, String server) {
        return THistory.getArchivedProperties(context, server, null);
    }

    public static String[] getArchivedProperties(String context, String server, String subsystem) {
        if (server == null && context == null) {
            return null;
        }
        if (context == null) {
            context = "DEFAULT";
        }
        if (server == null) {
            server = "HISTORY";
        }
        boolean isCentral = THistory.isCentralArchiveServer(server);
        TDataType dtsubs = subsystem != null && subsystem.length() > 0 && !subsystem.startsWith("ALL") && !subsystem.startsWith("All") ? new TDataType(subsystem) : new TDataType();
        TCompoundDataObject[] nlist = null;
        int[] nprps = new int[1];
        TDataType dtnprps = new TDataType(nprps);
        String tagsString = isCentral ? "TAGS" : "HISTORIES";
        String ntagsString = "N" + tagsString;
        String dname = "/" + context + "/" + server;
        TLink tl = new TLink(dname, ntagsString, dtnprps, dtsubs, 1);
        int cc = tl.execute(800, true);
        tl.close();
        if (cc != 0) {
            return null;
        }
        if (nprps[0] > 0) {
            nlist = new NAME32[nprps[0]];
            TDataType dtprps = new TDataType(nlist);
            tl = new TLink(dname, tagsString, dtprps, dtsubs, 1);
            cc = tl.execute(800, true);
            tl.close();
            if (cc != 0) {
                return null;
            }
        }
        if (nlist == null) {
            return null;
        }
        Vector<String> v = new Vector<String>(nlist.length);
        int n = 0;
        for (int i = 0; i < nlist.length; ++i) {
            String nam = ((NAME)((Object)nlist[i])).getName();
            if (nam.endsWith(".NAM")) continue;
            v.add(nam);
            ++n;
        }
        return v.toArray(new String[n]);
    }

    public static String[] getArchivedDevices(String context, String server, String property) {
        return TQuery.getDeviceNames(context, server, property);
    }

    public static String[] getArchivedSubsystems(String context) {
        return THistory.getArchivedSubsystems(context, null);
    }

    public static String[] getArchivedSubsystems(String context, String server) {
        if (server == null && context == null) {
            return null;
        }
        if (context == null) {
            context = "DEFAULT";
        }
        if (server == null) {
            server = "HISTORY";
        }
        if (!THistory.isCentralArchiveServer(server)) {
            return null;
        }
        TCompoundDataObject[] nlist = null;
        int[] nsubs = new int[1];
        TDataType dtnsubs = new TDataType(nsubs);
        String tagsString = "SUBSYSTEMS";
        String ntagsString = "N" + tagsString;
        String dname = "/" + context + "/" + server;
        TLink tl = new TLink(dname, ntagsString, dtnsubs, null, 1);
        int cc = tl.execute(800, true);
        tl.close();
        if (cc != 0) {
            return null;
        }
        if (nsubs[0] > 0) {
            nlist = new NAME32[nsubs[0]];
            TDataType dtsubs = new TDataType(nlist);
            tl = new TLink(dname, tagsString, dtsubs, null, 1);
            cc = tl.execute(800, true);
            tl.close();
            if (cc != 0) {
                return null;
            }
        }
        Vector<String> v = new Vector<String>(nlist.length);
        int n = 0;
        for (int i = 0; i < nlist.length; ++i) {
            String nam = ((NAME)((Object)nlist[i])).getName();
            if (nam.length() == 0) continue;
            v.add(nam);
            ++n;
        }
        return v.toArray(new String[n]);
    }

    public static String[] getOperationHistoryContexts() {
        return TQuery.getContexts("STATE");
    }

    public static String[] getArchiveServerContexts() {
        return TQuery.getContexts("HISTORY");
    }

    public static String[] getOperationHistoryConfigurationNames(String context) {
        if (context == null) {
            return null;
        }
        return TQuery.getDeviceNames(context, "STATE", "CONFIGURATION");
    }

    public static String[] getViewerMcaConfigurationNames(String context) {
        if (context == null) {
            return null;
        }
        return TQuery.getDeviceNames(context, "HISTORY", "CONFIGURATION.MCA");
    }

    public static String[] getViewerConfigurationNames(String context) {
        if (context == null) {
            return null;
        }
        return TQuery.getDeviceNames(context, "HISTORY", "CONFIGURATION");
    }

    public static String[] getViewerTraceConfigurationNames(String context) {
        if (context == null) {
            return null;
        }
        String[] nms = TQuery.getDeviceNames(context, "HISTORY", "CONFIGURATION.TRACE");
        if (nms == null || nms.length < 2) {
            return nms;
        }
        String[] nmsr = new String[nms.length - 2];
        boolean hasProperties = false;
        boolean hasTraces = false;
        int k = 0;
        for (int i = 0; i < nms.length; ++i) {
            if (nms[i].compareToIgnoreCase("properties") == 0) {
                hasProperties = true;
                continue;
            }
            if (nms[i].compareToIgnoreCase("traces") == 0) {
                hasTraces = true;
                continue;
            }
            if (k >= nms.length - 2) continue;
            nmsr[k++] = nms[i];
        }
        return hasProperties && hasTraces ? nmsr : nms;
    }

    public static String[] getViewerConfigurationNames(String context, String group) {
        String[] nms;
        if (context == null) {
            return null;
        }
        String prp = "CONFIGURATION";
        if (group != null) {
            prp = prp + "." + group;
        }
        if ((nms = TQuery.getDeviceNames(context, "HISTORY", prp)) == null || nms.length < 2) {
            return nms;
        }
        String[] nmsr = new String[nms.length - 1];
        boolean hasProperties = false;
        int k = 0;
        for (int i = 0; i < nms.length; ++i) {
            if (nms[i].compareToIgnoreCase("properties") == 0) {
                hasProperties = true;
                continue;
            }
            if (k >= nms.length - 1) continue;
            nmsr[k++] = nms[i];
        }
        return hasProperties ? nmsr : nms;
    }

    public static String[] getViewerConfigurationGroups(String context) {
        if (context == null) {
            return null;
        }
        TCompoundDataObject[] prps = new NAME64[100];
        TDataType dtprps = new TDataType(prps);
        String dname = "/" + context + "/HISTORY";
        String dprop = "CONFIGURATION.*";
        TLink tl = new TLink(dname, dprop, dtprps, null, 1);
        int cc = tl.execute(800, true);
        tl.close();
        if (cc != 0) {
            return null;
        }
        int len = dtprps.getCompletionLength();
        Vector<String> v = new Vector<String>(len);
        int n = 0;
        for (int i = 0; i < len; ++i) {
            String nam = ((NAME)((Object)prps[i])).getName();
            if (nam.compareToIgnoreCase("CONFIGURATION") == 0 || nam.length() == 0 || nam.endsWith(".NAM") || nam.endsWith(".MCA")) continue;
            v.add(nam.substring(14));
            ++n;
        }
        return n > 0 ? v.toArray(new String[n]) : null;
    }

    public static HstCfg[] getSelectableProptiesConfiguration(String context, String group) {
        if (context == null || group == null) {
            return null;
        }
        return THistory.getViewerConfiguration(context, "properties", group);
    }

    public static HstCfg[] getSelectableTracesConfiguration(String context) {
        if (context == null) {
            return null;
        }
        return THistory.getViewerConfiguration(context, "traces", "TRACE");
    }

    public static HstCfg[] getViewerConfiguration(String context, String name) {
        return THistory.getViewerConfiguration(context, name, null);
    }

    public static synchronized HstCfg[] getViewerConfiguration(String context, String name, String group) {
        if (context == null || name == null) {
            return null;
        }
        if (!isInitialized) {
            THistory.initCfgs();
        }
        TDataType dtcfg = new TDataType(cfgs);
        String dname = "/" + context + "/HISTORY/" + name;
        String dprop = "CONFIGURATION";
        if (group != null && group.length() > 0) {
            dprop = dprop + "." + group;
        }
        TLink tl = new TLink(dname, dprop, dtcfg, null, 1);
        int cc = tl.execute(800, true);
        tl.close();
        if (cc != 0) {
            DbgLog.log("getViewerConfiguration", TErrorList.getErrorString(cc));
            return null;
        }
        int num = dtcfg.getCompletionLength();
        if (num == 0) {
            return null;
        }
        boolean hasPropertiesList = false;
        for (int i = 0; i < num; ++i) {
            if (cfgs[i].getDescription().compareToIgnoreCase("properties") != 0) continue;
            hasPropertiesList = true;
            break;
        }
        int ncfg = hasPropertiesList ? num - 1 : num;
        HstCfg[] cfg = new HstCfg[ncfg];
        int n = 0;
        for (int i = 0; i < num; ++i) {
            if (cfgs[i].getDescription().compareToIgnoreCase("properties") == 0) continue;
            cfg[n++] = new HstCfg(cfgs[i]);
        }
        return cfg;
    }

    public static synchronized McaCfg[] getMcaViewerConfiguration(String context, String name) {
        if (context == null || name == null) {
            return null;
        }
        if (!isInitialized) {
            THistory.initCfgs();
        }
        TDataType dtcfg = new TDataType(mcacfgs);
        String dname = "/" + context + "/HISTORY/" + name;
        String dprop = "CONFIGURATION.MCA";
        TLink tl = new TLink(dname, dprop, dtcfg, null, 1);
        int cc = tl.execute(800, true);
        tl.close();
        if (cc != 0) {
            DbgLog.log("getMcaViewerConfiguration", TErrorList.getErrorString(cc));
            return null;
        }
        int num = dtcfg.getCompletionLength();
        if (num == 0) {
            return null;
        }
        McaCfg[] cfg = new McaCfg[num];
        for (int i = 0; i < num; ++i) {
            cfg[i] = new McaCfg(mcacfgs[i]);
        }
        return cfg;
    }

    public static synchronized McaCfg[] getOperationHistoryConfiguration(String context, String name) {
        if (context == null || name == null) {
            return null;
        }
        if (!isInitialized) {
            THistory.initCfgs();
        }
        TDataType dtcfg = new TDataType(mcacfgs);
        String dname = "/" + context + "/STATE/" + name;
        String dprop = "CONFIGURATION";
        TLink tl = new TLink(dname, dprop, dtcfg, null, 1);
        int cc = tl.execute(800, true);
        tl.close();
        if (cc != 0) {
            DbgLog.log("getOperationHistoryConfiguration", TErrorList.getErrorString(cc));
            return null;
        }
        int num = dtcfg.getCompletionLength();
        if (num == 0) {
            return null;
        }
        McaCfg[] cfg = new McaCfg[num];
        for (int i = 0; i < num; ++i) {
            cfg[i] = new McaCfg(mcacfgs[i]);
        }
        return cfg;
    }

    public static synchronized PrfCfg[] getOperationHistoryProfile(String context, String name) {
        if (context == null || name == null) {
            return null;
        }
        if (!isInitialized) {
            THistory.initCfgs();
        }
        TDataType dtcfg = new TDataType(prfcfgs);
        String dname = "/" + context + "/STATE/" + name;
        String dprop = "PROFILE";
        TLink tl = new TLink(dname, dprop, dtcfg, null, 1);
        int cc = tl.execute(800, true);
        tl.close();
        if (cc != 0) {
            DbgLog.log("getOperationHistoryProfile", TErrorList.getErrorString(cc));
            return null;
        }
        int num = dtcfg.getCompletionLength();
        if (num == 0) {
            return null;
        }
        PrfCfg[] cfg = new PrfCfg[num];
        for (int i = 0; i < num; ++i) {
            cfg[i] = new PrfCfg(prfcfgs[i]);
        }
        return cfg;
    }
}

