/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.headers;

import de.desy.tine.client.TLink;
import de.desy.tine.client.TLinkFactory;
import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.definitions.TFormat;
import de.desy.tine.endianUtils.Swap;
import de.desy.tine.server.logger.DbgLog;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.LinkedList;

public class TGlobalsHdr {
    short msgSizeInBytes;
    short mtu;
    int debugLevel = 0;
    byte[] globalsNameAsByteArray = new byte[64];
    short dArrayLength;
    short dFormat;
    short status;
    short reserved;
    int dStamp;
    int sysStamp;
    int dTimestamp;
    int dTimestampMSec;
    static final int maxPayloadSizeInBytes = 1472;
    static final int glbhdrSizeInBytes = 88;
    static final int glbhdrSizeInBytesLegacy = 24;
    static ByteArrayInputStream dBuffer;
    byte[] usernameAsByteArray = new byte[16];
    private short protocol;
    private short numInPacket;
    static final short hdrSizeInBytes = 22;
    private short totalSizeInBytes;
    TLinkFactory tf;
    private LinkedList<TLink> lnks = new LinkedList();
    private byte[] dBytes = new byte[1472];

    public TGlobalsHdr(TLinkFactory tfactory) {
        this.tf = tfactory;
    }

    public TLink[] toStruct(InetAddress gaddr, byte[] data, int length) {
        boolean isLegacy = false;
        int bytesread = 0;
        int ghdrsize = 88;
        int nlen = 64;
        try {
            this.lnks.clear();
            dBuffer = new ByteArrayInputStream(data);
            DataInputStream ds = new DataInputStream(dBuffer);
            this.totalSizeInBytes = Swap.Short(ds.readShort());
            if (this.totalSizeInBytes < 46) {
                String msg = "recv: " + this.totalSizeInBytes + " bytes : hdr " + 22 + 24;
                DbgLog.log("TGlobalsHdr", msg);
                return null;
            }
            ds.read(this.usernameAsByteArray, 0, 16);
            this.protocol = Swap.Short(ds.readShort());
            this.numInPacket = Swap.Short(ds.readShort());
            bytesread = 22;
            switch (this.protocol) {
                case 3: {
                    isLegacy = true;
                    ghdrsize = 24;
                    nlen = 16;
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    return null;
                }
            }
            for (int i = 0; i < this.numInPacket && bytesread < this.totalSizeInBytes; ++i) {
                ds.read(this.globalsNameAsByteArray, 0, nlen);
                this.dArrayLength = Swap.Short(ds.readShort());
                this.dFormat = (short)(Swap.Short(ds.readShort()) % 256);
                if (isLegacy) {
                    this.dTimestamp = Swap.Long(ds.readInt());
                    this.status = 0;
                    this.dTimestampMSec = 0;
                    this.sysStamp = 0;
                    this.dStamp = 0;
                } else {
                    this.status = Swap.Short(ds.readShort());
                    this.reserved = Swap.Short(ds.readShort());
                    this.dStamp = Swap.Long(ds.readInt());
                    this.sysStamp = Swap.Long(ds.readInt());
                    this.dTimestamp = Swap.Long(ds.readInt());
                    this.dTimestampMSec = Swap.Long(ds.readInt());
                }
                bytesread += ghdrsize;
                TLink glb = this.tf.findTLink(gaddr, new String(this.globalsNameAsByteArray));
                int dataSizeInBytes = this.dArrayLength * TFormat.formatSizeOf(this.dFormat);
                byte[] d = this.dBytes;
                ds.read(d, 0, dataSizeInBytes);
                bytesread += dataSizeInBytes;
                if (glb == null || glb.dOutput == null) continue;
                if (glb.dOutput.getFormat() == 254) {
                    glb.dOutput.dFormat = this.dFormat;
                    glb.dOutput.dArrayLength = this.dArrayLength;
                    glb.dOutput.numblks = 1;
                }
                glb.linkStatus = this.status;
                glb.dOutput.sysDataStamp = this.sysStamp;
                glb.dOutput.usrDataStamp = this.dStamp;
                glb.dOutput.timestamp = this.dTimestamp;
                glb.dOutput.timestampMSEC = this.dTimestampMSec;
                glb.dOutput.dTimestamp = (long)this.dTimestamp * 1000L + (long)this.dTimestampMSec;
                if (this.dFormat == glb.dOutput.getFormat()) {
                    glb.dOutput.update(d, 1, 0);
                    this.tf.fillinIncomingData(glb);
                } else {
                    TDataType dt = new TDataType(this.dArrayLength, this.dFormat);
                    dt.update(d, 1, 0);
                    Object srcData = dt.getDataObject();
                    dt.getData(srcData);
                    glb.dOutput.putData(srcData);
                    glb.dOutput.dCompletionLength = this.dArrayLength;
                }
                this.lnks.add(glb);
            }
            ds.close();
            dBuffer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return this.lnks.toArray(new TLink[0]);
    }
}

