/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.headers;

import de.desy.tine.addrUtils.TSrvEntry;
import de.desy.tine.client.TLink;
import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.definitions.TAccess;
import de.desy.tine.definitions.TFormat;
import de.desy.tine.endianUtils.Swap;
import de.desy.tine.types.SPECTRUM;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class TContractP5 {
    public String eqmProperty;
    public String eqmDeviceName;
    public String eqmName;
    public int dataSizeIn;
    public int dataSizeOut;
    public byte hEqmName;
    public byte dataAccess;
    public byte dataFormatIn;
    public byte dataFormatOut;
    public String dataTagIn;
    public String dataTagOut;
    public static final int hdrSizeInBytes = 84;
    int totalSizeInBytes;
    public ByteArrayOutputStream dBuffer;

    public boolean equals(TContractP5 contract) {
        if (contract.eqmProperty.compareTo(this.eqmProperty) != 0) {
            return false;
        }
        if (contract.eqmDeviceName.compareTo(this.eqmDeviceName) != 0) {
            return false;
        }
        if (contract.eqmName.compareTo(this.eqmName) != 0) {
            return false;
        }
        if (contract.dataSizeIn != this.dataSizeIn) {
            return false;
        }
        if (contract.dataSizeOut != this.dataSizeOut) {
            return false;
        }
        if (TAccess.toBase(contract.dataAccess) != TAccess.toBase(this.dataAccess)) {
            return false;
        }
        if (contract.dataFormatIn != this.dataFormatIn) {
            return false;
        }
        if (contract.dataFormatOut != this.dataFormatOut) {
            return false;
        }
        if (contract.dataTagIn.compareTo(this.dataTagIn) != 0) {
            return false;
        }
        return contract.dataTagOut.compareTo(this.dataTagOut) == 0;
    }

    public TContractP5(String property, String device, String eqm, TDataType dout, TDataType din, short access) {
        this.eqmProperty = property;
        this.eqmDeviceName = device;
        this.eqmName = eqm;
        if (din != null) {
            this.dataSizeIn = din.dArrayLength;
            this.dataFormatIn = (byte)din.dFormat;
            this.dataTagIn = din.getTag();
        } else {
            this.dataSizeIn = 0;
            this.dataFormatIn = (byte)-1;
            this.dataTagIn = "";
        }
        if (dout != null) {
            this.dataSizeOut = dout.dArrayLength;
            this.dataFormatOut = (byte)dout.dFormat;
            this.dataTagOut = dout.getTag();
        } else {
            this.dataSizeOut = 0;
            this.dataFormatOut = (byte)-1;
            this.dataTagOut = "";
        }
        this.dataAccess = (byte)access;
    }

    public TContractP5(TLink eqm) {
        TSrvEntry mod = new TSrvEntry(eqm.expName, eqm.cntName);
        if (mod.fecAddr == null) {
            return;
        }
        if (eqm.srvAddr != null) {
            eqm.srvAddr.fecAddr = mod.fecAddr;
            eqm.srvAddr.eqmName = mod.eqmName;
            this.eqmName = mod.eqmName;
            this.eqmProperty = eqm.devProperty;
            this.eqmDeviceName = eqm.devName;
            this.dataSizeOut = eqm.dOutput.getArrayLength();
            this.dataSizeIn = eqm.dInput.getArrayLength();
            this.dataFormatOut = (byte)eqm.dOutput.getFormat();
            this.dataFormatIn = (byte)eqm.dInput.getFormat();
            this.dataAccess = (byte)eqm.devAccess;
            this.dataTagOut = eqm.dOutput.getTag();
            this.dataTagIn = eqm.dInput.getTag();
        }
        try {
            int i;
            this.dBuffer = new ByteArrayOutputStream(84);
            DataOutputStream ds = new DataOutputStream(this.dBuffer);
            byte[] bstr = new byte[32];
            byte[] tmp = eqm.devProperty.getBytes();
            byte[] tmp2 = eqm.devName.getBytes();
            if (tmp2.length > 16 && tmp.length < 16) {
                for (i = 0; i < 16; ++i) {
                    bstr[i] = i < tmp.length ? tmp[i] : (byte)0;
                }
                bstr[16] = 0;
                for (i = 0; i < 15; ++i) {
                    bstr[i + 17] = i < tmp2.length - 15 ? tmp2[i + 15] : (byte)0;
                }
                byte[] amp = "&".getBytes();
                tmp2[15] = amp[0];
            } else {
                for (i = 0; i < 32; ++i) {
                    bstr[i] = i < tmp.length ? tmp[i] : (byte)0;
                }
            }
            ds.write(bstr, 0, 32);
            for (i = 0; i < 16; ++i) {
                bstr[i] = i < tmp2.length ? tmp2[i] : (byte)0;
            }
            ds.write(bstr, 0, 16);
            tmp = mod.eqmName.getBytes();
            for (i = 0; i < 8; ++i) {
                bstr[i] = i < tmp.length ? tmp[i] : (byte)0;
            }
            ds.write(bstr, 0, 8);
            int inlen = eqm.dInput.getArrayLength();
            int outlen = eqm.dOutput.getArrayLength();
            if (eqm.dOutput.getFormat() == 7) {
                outlen = eqm.dOutput.getSizeInBytes();
            }
            if (eqm.dInput.getFormat() == 7) {
                inlen = eqm.dInput.getSizeInBytes();
            }
            ds.writeInt(Swap.Long(inlen));
            ds.writeInt(Swap.Long(outlen));
            ds.writeByte(0);
            ds.writeByte(eqm.devAccess);
            ds.writeByte((byte)eqm.dInput.getFormat());
            ds.writeByte((byte)eqm.dOutput.getFormat());
            tmp = eqm.dInput.getTag().getBytes();
            for (i = 0; i < 8; ++i) {
                bstr[i] = i < tmp.length ? tmp[i] : (byte)0;
            }
            ds.write(bstr, 0, 8);
            tmp = eqm.dOutput.getTag().getBytes();
            for (i = 0; i < 8; ++i) {
                bstr[i] = i < tmp.length ? tmp[i] : (byte)0;
            }
            ds.write(bstr, 0, 8);
            this.totalSizeInBytes = 84 + eqm.dInput.getSizeInBytes();
            ds.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void prepareInComing(DataInputStream ds) {
        byte[] d = new byte[32];
        try {
            ds.read(d, 0, 32);
            this.eqmProperty = new String(d, 0, 32).trim();
            ds.read(d, 0, 16);
            this.eqmDeviceName = new String(d, 0, 16).trim();
            ds.read(d, 0, 8);
            this.eqmName = new String(d, 0, 8).trim();
            this.dataSizeIn = Swap.Long(ds.readInt());
            this.dataSizeOut = Swap.Long(ds.readInt());
            this.hEqmName = ds.readByte();
            this.dataAccess = ds.readByte();
            this.dataFormatIn = ds.readByte();
            this.dataFormatOut = ds.readByte();
            ds.read(d, 0, 8);
            this.dataTagIn = new String(d, 0, 8).trim();
            ds.read(d, 0, 8);
            this.dataTagOut = new String(d, 0, 8).trim();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TContractP5(byte[] data, int off, int len) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(data, off, len);
            DataInputStream ds = new DataInputStream(is);
            this.prepareInComing(ds);
            ds.close();
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TContractP5(DataInputStream ds) {
        this.prepareInComing(ds);
    }

    public TContractP5(ByteArrayInputStream inBuffer) {
        DataInputStream ds = new DataInputStream(inBuffer);
        this.prepareInComing(ds);
        try {
            ds.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getOutputDataSize() {
        int fmtsiz = 0;
        fmtsiz = TFormat.formatSizeOf(this.dataFormatOut);
        if (fmtsiz > 0) {
            int datasize = fmtsiz * this.dataSizeOut;
            if (this.dataFormatOut == 28) {
                datasize += SPECTRUM.hdrSizeInBytes;
            }
            return datasize;
        }
        return 0;
    }

    public String toString() {
        String msg = new String("target : <" + this.eqmName + ">/" + this.eqmDeviceName + "[" + this.eqmProperty + "]");
        msg = msg.concat("" + TAccess.toString(this.dataAccess) + " access");
        msg = msg.concat("\ninput  : " + this.dataSizeIn + " " + TFormat.toString(this.dataFormatIn) + " value(s)");
        if (this.dataTagIn.length() > 0) {
            msg = msg.concat(" tag = " + this.dataTagIn);
        }
        msg = msg.concat("\noutput : " + this.dataSizeOut + " " + TFormat.toString(this.dataFormatOut) + " value(s)");
        if (this.dataTagOut.length() > 0) {
            msg = msg.concat(" tag = " + this.dataTagOut);
        }
        return msg;
    }

    public byte[] toByteArray() {
        return this.dBuffer != null ? this.dBuffer.toByteArray() : null;
    }
}

