/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.headers;

import de.desy.tine.addrUtils.TSrvEntry;
import de.desy.tine.client.TLink;
import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.definitions.TAccess;
import de.desy.tine.definitions.TFormat;
import de.desy.tine.endianUtils.Swap;
import de.desy.tine.headers.TContractP5;
import de.desy.tine.types.SPECTRUM;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public final class TContract {
    public String eqmProperty;
    public String eqmDeviceName;
    public String eqmName;
    public int dataSizeIn;
    public int dataSizeOut;
    public byte hEqmName;
    public byte dataAccess;
    public byte dataFormatIn;
    public byte dataFormatOut;
    public String dataTagIn;
    public String dataTagOut;
    public byte[] extStringSpace;
    public int extStringSize = 0;
    public static final int hdrSizeInBytes = 180;
    int totalSizeInBytes;
    public ByteArrayOutputStream dBuffer;
    private boolean isLegacy = false;

    public boolean equals(TContract contract) {
        if (contract.eqmProperty.compareToIgnoreCase(this.eqmProperty) != 0) {
            return false;
        }
        if (contract.eqmDeviceName.compareToIgnoreCase(this.eqmDeviceName) != 0) {
            return false;
        }
        if (contract.eqmName.compareTo(this.eqmName) != 0) {
            return false;
        }
        if (contract.dataSizeIn != this.dataSizeIn) {
            return false;
        }
        if (contract.dataSizeOut != this.dataSizeOut) {
            return false;
        }
        if (TAccess.toBase(contract.dataAccess) != TAccess.toBase(this.dataAccess)) {
            return false;
        }
        if (contract.dataFormatIn != this.dataFormatIn) {
            return false;
        }
        if (contract.dataFormatOut != this.dataFormatOut) {
            return false;
        }
        if (contract.dataTagIn.compareTo(this.dataTagIn) != 0) {
            return false;
        }
        if (contract.dataTagOut.compareTo(this.dataTagOut) != 0) {
            return false;
        }
        if (contract.extStringSize != this.extStringSize) {
            return false;
        }
        return contract.extStringSize <= 0 || Arrays.equals(contract.extStringSpace, this.extStringSpace);
    }

    public TContract(TContractP5 legacyContract) {
        this.eqmProperty = legacyContract.eqmProperty;
        this.eqmDeviceName = legacyContract.eqmDeviceName;
        this.eqmName = legacyContract.eqmName;
        this.dataSizeIn = legacyContract.dataSizeIn;
        this.dataSizeOut = legacyContract.dataSizeOut;
        this.hEqmName = legacyContract.hEqmName;
        this.dataAccess = legacyContract.dataAccess;
        this.dataFormatIn = legacyContract.dataFormatIn;
        this.dataFormatOut = legacyContract.dataFormatOut;
        this.dataTagIn = legacyContract.dataTagIn;
        this.dataTagOut = legacyContract.dataTagOut;
        this.extStringSize = 0;
        this.extStringSpace = null;
        this.dBuffer = legacyContract.dBuffer;
    }

    public TContract(String property, String device, String eqm, TDataType dout, TDataType din, short access) {
        this.eqmProperty = property;
        this.eqmDeviceName = device;
        this.eqmName = eqm;
        if (din != null) {
            this.dataSizeIn = din.dArrayLength;
            this.dataFormatIn = (byte)din.dFormat;
            this.dataTagIn = din.getTag();
        } else {
            this.dataSizeIn = 0;
            this.dataFormatIn = (byte)-1;
            this.dataTagIn = "";
        }
        if (dout != null) {
            this.dataSizeOut = dout.dArrayLength;
            this.dataFormatOut = (byte)dout.dFormat;
            this.dataTagOut = dout.getTag();
        } else {
            this.dataSizeOut = 0;
            this.dataFormatOut = (byte)-1;
            this.dataTagOut = "";
        }
        this.dataAccess = (byte)access;
    }

    public TContract(TLink lnk) {
        int padding = 0;
        TSrvEntry srv = new TSrvEntry(lnk.expName, lnk.cntName);
        if (srv.fecAddr == null) {
            return;
        }
        this.isLegacy = srv.isLegacy;
        if (lnk.srvAddr != null) {
            lnk.srvAddr.fecAddr = srv.fecAddr;
            lnk.srvAddr.eqmName = srv.eqmName;
            this.eqmName = srv.eqmName;
            this.eqmProperty = lnk.devProperty;
            this.eqmDeviceName = lnk.devName;
            this.dataSizeOut = lnk.dOutput.getArrayLength();
            this.dataSizeIn = lnk.dInput.getArrayLength();
            this.dataFormatOut = (byte)lnk.dOutput.getFormat();
            this.dataFormatIn = (byte)lnk.dInput.getFormat();
            this.dataAccess = (byte)lnk.devAccess;
            this.dataTagOut = lnk.dOutput.getTag();
            this.dataTagIn = lnk.dInput.getTag();
        }
        try {
            if (!this.isLegacy) {
                int i;
                int dslen;
                int n = dslen = lnk.devName == null ? 0 : lnk.devName.length();
                if (dslen > 64) {
                    this.extStringSize = dslen - 64 + 1;
                    padding = this.extStringSize % 2;
                }
                this.dBuffer = new ByteArrayOutputStream(180);
                DataOutputStream ds = new DataOutputStream(this.dBuffer);
                byte[] bstr = new byte[64];
                byte[] tmp = lnk.devProperty.getBytes();
                for (i = 0; i < 64; ++i) {
                    bstr[i] = i < tmp.length ? tmp[i] : (byte)0;
                }
                ds.write(bstr, 0, 64);
                tmp = lnk.devName.getBytes();
                if (tmp.length > 64) {
                    for (i = 0; i < 63; ++i) {
                        bstr[i] = tmp[i];
                    }
                    byte[] amp = "&".getBytes();
                    bstr[63] = amp[0];
                    this.extStringSpace = new byte[this.extStringSize + padding];
                    int charsRemaining = tmp.length - 64 + 1;
                    if (charsRemaining > 1024) {
                        charsRemaining = 1024;
                    }
                    for (i = 0; i < charsRemaining; ++i) {
                        this.extStringSpace[i] = tmp[63 + i];
                    }
                    if (padding > 0) {
                        this.extStringSpace[this.extStringSize] = 0;
                    }
                } else {
                    for (i = 0; i < 64; ++i) {
                        bstr[i] = i < tmp.length ? tmp[i] : (byte)0;
                    }
                }
                ds.write(bstr, 0, 64);
                tmp = srv.eqmName.getBytes();
                for (i = 0; i < 8; ++i) {
                    bstr[i] = i < tmp.length ? tmp[i] : (byte)0;
                }
                ds.write(bstr, 0, 8);
                int inlen = lnk.dInput.getArrayLength();
                int outlen = lnk.dOutput.getArrayLength();
                if (lnk.dOutput.getFormat() == 7) {
                    outlen = lnk.dOutput.getSizeInBytes();
                }
                if (lnk.dInput.getFormat() == 7) {
                    inlen = lnk.dInput.getSizeInBytes();
                }
                ds.writeInt(Swap.Long(inlen));
                ds.writeInt(Swap.Long(outlen));
                ds.writeByte(0);
                ds.writeByte(lnk.devAccess);
                ds.writeByte((byte)lnk.dInput.getFormat());
                ds.writeByte((byte)lnk.dOutput.getFormat());
                tmp = lnk.dInput.getTag().getBytes();
                for (i = 0; i < 16; ++i) {
                    bstr[i] = i < tmp.length ? tmp[i] : (byte)0;
                }
                ds.write(bstr, 0, 16);
                tmp = lnk.dOutput.getTag().getBytes();
                for (i = 0; i < 16; ++i) {
                    bstr[i] = i < tmp.length ? tmp[i] : (byte)0;
                }
                ds.write(bstr, 0, 16);
                if (this.extStringSize > 0) {
                    ds.write(this.extStringSpace);
                }
                this.totalSizeInBytes = 180 + this.extStringSize + padding + lnk.dInput.getSizeInBytes();
                ds.close();
            } else {
                this.setLegacy(lnk);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setLegacy(TLink lnk) {
        if (lnk == null) {
            return;
        }
        try {
            int i;
            this.isLegacy = true;
            this.dBuffer = new ByteArrayOutputStream(84);
            DataOutputStream ds = new DataOutputStream(this.dBuffer);
            byte[] bstr = new byte[32];
            byte[] tmp = lnk.devProperty.getBytes();
            byte[] tm2 = lnk.devName.getBytes();
            if (tm2.length > 16 && tmp.length < 16) {
                for (i = 0; i < 16; ++i) {
                    bstr[i] = i < tmp.length ? tmp[i] : (byte)0;
                }
                bstr[16] = 0;
                for (i = 0; i < 15; ++i) {
                    bstr[i + 16 + 1] = i < tm2.length - 16 + 1 ? tm2[i + 16 - 1] : (byte)0;
                }
                byte[] amp = "&".getBytes();
                tm2[15] = amp[0];
            } else {
                for (i = 0; i < 32; ++i) {
                    bstr[i] = i < tmp.length ? tmp[i] : (byte)0;
                }
            }
            ds.write(bstr, 0, 32);
            for (i = 0; i < 16; ++i) {
                bstr[i] = i < tm2.length ? tm2[i] : (byte)0;
            }
            ds.write(bstr, 0, 16);
            tmp = lnk.srvAddr.eqmName.getBytes();
            for (i = 0; i < 8; ++i) {
                bstr[i] = i < tmp.length ? tmp[i] : (byte)0;
            }
            ds.write(bstr, 0, 8);
            int inlen = lnk.dInput.getArrayLength();
            int outlen = lnk.dOutput.getArrayLength();
            if (lnk.dOutput.getFormat() == 7) {
                outlen = lnk.dOutput.getSizeInBytes();
            }
            if (lnk.dInput.getFormat() == 7) {
                inlen = lnk.dInput.getSizeInBytes();
            }
            ds.writeInt(Swap.Long(inlen));
            ds.writeInt(Swap.Long(outlen));
            ds.writeByte(0);
            ds.writeByte(lnk.devAccess);
            ds.writeByte((byte)lnk.dInput.getFormat());
            ds.writeByte((byte)lnk.dOutput.getFormat());
            tmp = lnk.dInput.getTag().getBytes();
            for (i = 0; i < 8; ++i) {
                bstr[i] = i < tmp.length ? tmp[i] : (byte)0;
            }
            ds.write(bstr, 0, 8);
            tmp = lnk.dOutput.getTag().getBytes();
            for (i = 0; i < 8; ++i) {
                bstr[i] = i < tmp.length ? tmp[i] : (byte)0;
            }
            ds.write(bstr, 0, 8);
            this.totalSizeInBytes = 84 + lnk.dInput.getSizeInBytes();
            ds.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void prepareInComing(DataInputStream ds) {
        byte[] d = new byte[1024];
        try {
            ds.read(d, 0, 64);
            this.eqmProperty = new String(d, 0, 64).trim();
            ds.read(d, 0, 64);
            this.eqmDeviceName = new String(d, 0, 64).trim();
            ds.read(d, 0, 8);
            this.eqmName = new String(d, 0, 8).trim();
            this.dataSizeIn = Swap.Long(ds.readInt());
            this.dataSizeOut = Swap.Long(ds.readInt());
            this.hEqmName = ds.readByte();
            this.dataAccess = ds.readByte();
            this.dataFormatIn = ds.readByte();
            this.dataFormatOut = ds.readByte();
            ds.read(d, 0, 16);
            this.dataTagIn = new String(d, 0, 16).trim();
            ds.read(d, 0, 16);
            this.dataTagOut = new String(d, 0, 16).trim();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TContract(byte[] data, int off, int len) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(data, off, len);
            DataInputStream ds = new DataInputStream(is);
            this.prepareInComing(ds);
            ds.close();
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setExtendedStringSpace(byte[] extBytes, int extOffset, int extLength) {
        try {
            this.extStringSize = extLength;
            this.extStringSpace = new byte[extLength];
            System.arraycopy(extBytes, extOffset, this.extStringSpace, 0, extLength);
        }
        catch (Exception e) {
            this.extStringSize = 0;
            this.extStringSpace = null;
        }
    }

    public String getExtendedDeviceName() {
        String dev = this.eqmDeviceName;
        if (this.extStringSize > 0) {
            dev = dev.substring(0, 63) + new String(this.extStringSpace);
        }
        return dev;
    }

    public TContract(DataInputStream ds) {
        this.prepareInComing(ds);
    }

    public TContract(ByteArrayInputStream inBuffer) {
        DataInputStream ds = new DataInputStream(inBuffer);
        this.prepareInComing(ds);
        try {
            ds.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getOutputDataSize() {
        int fmtsiz = 0;
        fmtsiz = TFormat.formatSizeOf(this.dataFormatOut);
        if (fmtsiz > 0) {
            int datasize = fmtsiz * this.dataSizeOut;
            if (this.dataFormatOut == 28) {
                datasize += SPECTRUM.hdrSizeInBytes;
            }
            return datasize;
        }
        return 0;
    }

    public String toString() {
        String msg = new String("target : <" + this.eqmName + ">/" + this.eqmDeviceName + "[" + this.eqmProperty + "]");
        msg = msg.concat("" + TAccess.toString(this.dataAccess) + " access");
        msg = msg.concat("\ninput  : " + this.dataSizeIn + " " + TFormat.toString(this.dataFormatIn) + " value(s)");
        if (this.dataTagIn.length() > 0) {
            msg = msg.concat(" tag = " + this.dataTagIn);
        }
        msg = msg.concat("\noutput : " + this.dataSizeOut + " " + TFormat.toString(this.dataFormatOut) + " value(s)");
        if (this.dataTagOut.length() > 0) {
            msg = msg.concat(" tag = " + this.dataTagOut);
        }
        return msg;
    }

    public byte[] toByteArray() {
        return this.dBuffer != null ? this.dBuffer.toByteArray() : null;
    }
}

