/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.alarmUtils;

import de.desy.tine.structUtils.TTaggedStructure;

public class CasSrvInfo
extends TTaggedStructure {
    private char[] ctx = new char[32];
    private String contextString = null;
    private char[] srv = new char[32];
    private String serverString = null;
    private char[] sub = new char[16];
    private String subString = null;
    private char[] ext = new char[16];
    private String extString = null;
    private int[] sevLvl = new int[1];
    private int[] arcLvl = new int[1];
    private int[] retLvl = new int[1];
    private int[] almLvl = new int[1];
    private int[] almSys = new int[1];

    public void clear() {
        this.contextString = null;
        this.serverString = null;
        this.subString = null;
        this.extString = null;
        this.sevLvl[0] = 0;
        this.arcLvl[0] = 0;
        this.almLvl[0] = 0;
        this.almSys[0] = 0;
    }

    private void initStructure() {
        this.addField(this.ctx, "devContext");
        this.addField(this.srv, "devServer");
        this.addField(this.sub, "subSystem");
        this.addField(this.ext, "arcExt");
        this.addField(this.sevLvl, "SeverityLevel");
        this.addField(this.arcLvl, "ArchiveLevel");
        this.addField(this.retLvl, "Retention");
        this.addField(this.almLvl, "AlarmLevel");
        this.addField(this.almSys, "AlarmSystem");
        this.initDone();
    }

    CasSrvInfo() {
        super("CQS");
        this.initStructure();
    }

    CasSrvInfo(CasSrvInfo reference) {
        super("CQS");
        this.initStructure();
        System.arraycopy(reference.ctx, 0, this.ctx, 0, this.ctx.length);
        System.arraycopy(reference.srv, 0, this.srv, 0, this.srv.length);
        System.arraycopy(reference.sub, 0, this.sub, 0, this.sub.length);
        System.arraycopy(reference.ext, 0, this.ext, 0, this.ext.length);
        this.sevLvl[0] = reference.sevLvl[0];
        this.arcLvl[0] = reference.arcLvl[0];
        this.retLvl[0] = reference.retLvl[0];
        this.almLvl[0] = reference.almLvl[0];
        this.almSys[0] = reference.almSys[0];
    }

    public String getContext() {
        if (this.contextString == null) {
            this.contextString = new String(this.ctx).trim();
        }
        return this.contextString;
    }

    public String getServer() {
        if (this.serverString == null) {
            this.serverString = new String(this.srv).trim();
        }
        return this.serverString;
    }

    public String getSubsystem() {
        if (this.subString == null) {
            this.subString = new String(this.sub).trim();
        }
        return this.subString;
    }

    public String getArchiveExtension() {
        if (this.extString == null) {
            this.extString = new String(this.ext).trim();
        }
        return this.extString;
    }

    public int getSeverityLevel() {
        return this.sevLvl[0];
    }

    public int getArchiveLevel() {
        return this.arcLvl[0];
    }

    public int getRetention() {
        return this.retLvl[0];
    }

    public int getAlarmLevel() {
        return this.almLvl[0];
    }

    public int getAlarmSystem() {
        return this.almSys[0];
    }
}

