/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.addrUtils;

import de.desy.tine.endianUtils.Swap;
import de.desy.tine.server.logger.MsgLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class FECAddr {
    public static final String LOOPBACKADDR = "127.0.0.1";
    protected String fecName = new String(new StringBuffer(16));
    protected byte[] ipxNetwork = new byte[4];
    protected byte[] ipxNode = new byte[6];
    protected byte[] ipxImmediateAddress = new byte[6];
    protected String ipAddr = new String(new StringBuffer(16));
    protected byte[] ipHAddr = new byte[4];
    protected int portOffset;
    protected int inetProtocol;
    protected int tineProtocol;
    public static int sizeInBytes = 64;
    ByteArrayOutputStream dBuffer = new ByteArrayOutputStream(sizeInBytes);
    byte[] hByteArray;

    public int getPortOffset() {
        return this.portOffset;
    }

    public byte[] toByteArray() {
        try {
            int i;
            this.dBuffer.reset();
            DataOutputStream ds = new DataOutputStream(this.dBuffer);
            byte[] bstr = new byte[64];
            byte[] tmp = this.fecName.getBytes();
            for (i = 0; i < 16; ++i) {
                bstr[i] = i < tmp.length ? tmp[i] : (byte)0;
            }
            ds.write(bstr, 0, 16);
            ds.write(this.ipxNetwork, 0, 4);
            ds.write(this.ipxNode, 0, 6);
            ds.write(this.ipxImmediateAddress, 0, 6);
            tmp = this.ipAddr.getBytes();
            for (i = 0; i < 16; ++i) {
                bstr[i] = i < tmp.length ? tmp[i] : (byte)0;
            }
            ds.write(bstr, 0, 16);
            ds.write(this.ipHAddr, 0, 4);
            ds.writeInt(Swap.Long(this.portOffset));
            ds.writeInt(Swap.Long(this.inetProtocol));
            ds.writeInt(Swap.Long(this.tineProtocol));
            ds.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MsgLog.log("FECAddr", "could not prepare byte stream", 66, e, 0);
            return null;
        }
        this.hByteArray = this.dBuffer.toByteArray();
        return this.hByteArray;
    }

    public void toStruct() {
        try {
            ByteArrayInputStream dis = new ByteArrayInputStream(this.hByteArray);
            DataInputStream ds = new DataInputStream(dis);
            byte[] bstr = new byte[64];
            ds.read(bstr, 0, 16);
            this.fecName = new String(bstr);
            ds.read(this.ipxNetwork, 0, 4);
            ds.read(this.ipxNode, 0, 6);
            ds.read(this.ipxImmediateAddress, 0, 6);
            ds.read(bstr, 0, 16);
            this.ipAddr = new String(bstr);
            ds.read(this.ipHAddr, 0, 4);
            this.portOffset = Swap.Long(ds.readInt());
            this.inetProtocol = Swap.Long(ds.readInt());
            this.tineProtocol = Swap.Long(ds.readInt());
            ds.close();
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MsgLog.log("FECAddr", "could not prepare byte stream", 66, e, 0);
        }
    }

    public String toString() {
        String msg = new String("FEC name : " + this.fecName);
        msg = msg.concat("\nFEC ip   : " + this.ipAddr);
        msg = msg.concat("\nFEC port : " + this.portOffset);
        msg = msg.concat("\nFEC tine protocol : " + this.tineProtocol);
        return msg;
    }

    public String getFecName() {
        return this.fecName;
    }

    public void setFecName(String fecName) {
        this.fecName = fecName;
    }

    public int getInetProtocol() {
        return this.inetProtocol;
    }

    public void setInetProtocol(int inetProtocol) {
        this.inetProtocol = inetProtocol;
    }

    public String getIpAddr() {
        return this.ipAddr;
    }

    public void setIpAddr(String ipAddr) {
        this.ipAddr = ipAddr;
    }

    public int getTineProtocol() {
        return this.tineProtocol;
    }

    public void setTineProtocol(int tineProtocol) {
        this.tineProtocol = tineProtocol;
    }

    public void setPortOffset(int portOffset) {
        this.portOffset = portOffset;
    }
}

