/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca.jni;

import gov.aps.jca.CAException;
import gov.aps.jca.CAStatus;
import gov.aps.jca.Channel;
import gov.aps.jca.JCALibrary;
import gov.aps.jca.TimeoutException;
import gov.aps.jca.Version;
import gov.aps.jca.configuration.Configurable;
import gov.aps.jca.configuration.Configuration;
import gov.aps.jca.configuration.ConfigurationException;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.event.ConnectionListener;
import gov.aps.jca.event.EventDispatcher;
import gov.aps.jca.event.GetListener;
import gov.aps.jca.event.MonitorListener;
import gov.aps.jca.event.PutListener;
import gov.aps.jca.jni.JNI;
import gov.aps.jca.jni.JNIAccessRightsCallback;
import gov.aps.jca.jni.JNIChannel;
import gov.aps.jca.jni.JNIConnectionCallback;
import gov.aps.jca.jni.JNIContext;
import gov.aps.jca.jni.JNIContextExceptionCallback;
import gov.aps.jca.jni.JNIContextMessageCallback;
import gov.aps.jca.jni.JNIException;
import gov.aps.jca.jni.JNIGetCallback;
import gov.aps.jca.jni.JNIMonitor;
import gov.aps.jca.jni.JNIMonitorCallback;
import gov.aps.jca.jni.JNIPutCallback;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ThreadSafeContext
extends JNIContext
implements Runnable,
Configurable {
    protected int _priority = 5;
    protected Thread _thread;
    public static final Version VERSION = new Version("JNI/ThreadSafeContext Channel Access", "Java w/ JNI using native C++ code", JCALibrary.getInstance().getVersion(), JCALibrary.getInstance().getRevision(), JCALibrary.getInstance().getModification(), 0);
    private final LinkedBlockingQueue REQUEST_QUEUE = new LinkedBlockingQueue();
    private boolean _keepRunning = true;
    LinkedList _GetQueue = new LinkedList();
    static /* synthetic */ Class class$gov$aps$jca$jni$ThreadSafeContext$Get;

    public Version getVersion() {
        return VERSION;
    }

    public ThreadSafeContext() {
        String cn = ThreadSafeContext.class.getName();
        JCALibrary jca = JCALibrary.getInstance();
        String logger = jca.getProperty(cn + ".logger", null);
        this.setLogger(logger == null ? this.getLogger() : Logger.getLogger(logger));
        this.setPreemptiveCallback(jca.getPropertyAsBoolean(cn + ".preemptive_callback", this.getPreemptiveCallback()));
        this.setAddrList(jca.getProperty(cn + ".addr_list", this.getAddrList()));
        this.setAutoAddrList(jca.getPropertyAsBoolean(cn + ".auto_addr_list", this.getAutoAddrList()));
        this.setConnectionTimeout(jca.getPropertyAsFloat(cn + ".connection_timeout", this.getConnectionTimeout()));
        this.setBeaconPeriod(jca.getPropertyAsFloat(cn + ".beacon_period", this.getBeaconPeriod()));
        this.setRepeaterPort(jca.getPropertyAsInt(cn + ".repeater_port", this.getRepeaterPort()));
        this.setServerPort(jca.getPropertyAsInt(cn + ".server_port", this.getServerPort()));
        this.setMaxArrayBytes(jca.getPropertyAsInt(cn + ".max_array_bytes", this.getMaxArrayBytes()));
        this.setPriority(jca.getPropertyAsInt(cn + ".priority", this.getPriority()));
        try {
            EventDispatcher ed = (EventDispatcher)Class.forName(jca.getProperty(cn + ".event_dispatcher", "")).newInstance();
            this.setEventDispatcher(ed);
        }
        catch (ClassNotFoundException ex1) {
        }
        catch (IllegalAccessException ex1) {
        }
        catch (InstantiationException ex1) {
            // empty catch block
        }
    }

    public void configure(Configuration conf) throws ConfigurationException {
        boolean preemptive_callback = this.getPreemptiveCallback();
        try {
            preemptive_callback = conf.getChild("preemptive_callback", false).getValueAsBoolean();
        }
        catch (Exception ex) {
            preemptive_callback = conf.getAttributeAsBoolean("preemptive_callback", preemptive_callback);
        }
        this.setPreemptiveCallback(preemptive_callback);
        String addr_list = this.getAddrList();
        try {
            addr_list = conf.getChild("addr_list", false).getValue();
        }
        catch (Exception ex) {
            addr_list = conf.getAttribute("addr_list", addr_list);
        }
        this.setAddrList(addr_list);
        boolean auto_addr_list = this.getAutoAddrList();
        try {
            auto_addr_list = conf.getChild("auto_addr_list", false).getValueAsBoolean();
        }
        catch (Exception ex) {
            auto_addr_list = conf.getAttributeAsBoolean("auto_addr_list", auto_addr_list);
        }
        this.setAutoAddrList(auto_addr_list);
        float connection_timeout = this.getConnectionTimeout();
        try {
            connection_timeout = conf.getChild("connection_timeout", false).getValueAsFloat();
        }
        catch (Exception ex) {
            connection_timeout = conf.getAttributeAsFloat("connection_timeout", connection_timeout);
        }
        this.setConnectionTimeout(connection_timeout);
        float beacon_period = this.getBeaconPeriod();
        try {
            beacon_period = conf.getChild("beacon_period", false).getValueAsFloat();
        }
        catch (Exception ex) {
            beacon_period = conf.getAttributeAsFloat("beacon_period", beacon_period);
        }
        this.setBeaconPeriod(beacon_period);
        int repeater_port = this.getRepeaterPort();
        try {
            repeater_port = conf.getChild("repeater_port", false).getValueAsInteger();
        }
        catch (Exception ex) {
            repeater_port = conf.getAttributeAsInteger("repeater_port", repeater_port);
        }
        this.setRepeaterPort(repeater_port);
        int server_port = this.getServerPort();
        try {
            server_port = conf.getChild("server_port", false).getValueAsInteger();
        }
        catch (Exception ex) {
            server_port = conf.getAttributeAsInteger("server_port", server_port);
        }
        this.setServerPort(server_port);
        int max_array_bytes = this.getMaxArrayBytes();
        try {
            max_array_bytes = conf.getChild("max_array_bytes", false).getValueAsInteger();
        }
        catch (Exception ex) {
            max_array_bytes = conf.getAttributeAsInteger("max_array_bytes", max_array_bytes);
        }
        this.setMaxArrayBytes(max_array_bytes);
        int priority = this.getPriority();
        try {
            priority = conf.getChild("priority", false).getValueAsInteger();
        }
        catch (Exception ex) {
            priority = conf.getAttributeAsInteger("priority", priority);
        }
        this.setPriority(priority);
        try {
            Configuration evConf = conf.getChild("event_dispatcher", false);
            if (evConf == null) {
                return;
            }
            String evClass = evConf.getAttribute("class");
            EventDispatcher event_dispatcher = (EventDispatcher)Class.forName(evClass).newInstance();
            if (event_dispatcher instanceof Configurable) {
                ((Configurable)((Object)event_dispatcher)).configure(evConf);
            }
            this.setEventDispatcher(event_dispatcher);
        }
        catch (ConfigurationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConfigurationException("Unable to configure context", ex);
        }
    }

    public String paramString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append("[");
        sb.append("PREEMPTIVE_CALLBACK=");
        sb.append(this.getPreemptiveCallback());
        sb.append(",ADDR_LIST=");
        sb.append(this.getAddrList());
        sb.append(",AUTO_ADDR_LIST=");
        sb.append(this.getAutoAddrList());
        sb.append(",CONNECTION_TIMEOUT=");
        sb.append(this.getConnectionTimeout());
        sb.append(",BEACON_PERIOD=");
        sb.append(this.getBeaconPeriod());
        sb.append(",REPEATER_PORT=");
        sb.append(this.getRepeaterPort());
        sb.append(",SERVER_PORT=");
        sb.append(this.getServerPort());
        sb.append(",MAX_ARRAY_BYTES=");
        sb.append(this.getMaxArrayBytes());
        sb.append(",PRIORITY=");
        sb.append(this.getPriority());
        sb.append("]");
        return sb.toString();
    }

    public void printInfo(PrintStream out) {
        super.printInfo(out);
        out.println("PRIORITY : " + this.getPriority());
    }

    protected void setPriority(int priority) throws IllegalStateException {
        this.assertState(!this.isInitialized(), "Context already initialized");
        this._priority = priority;
    }

    public int getPriority() {
        return this._priority;
    }

    protected long contextInitialize() throws CAException, IllegalStateException {
        this.assertState(!this.isInitialized(), "Context already initialized");
        this._thread = new Thread(this);
        this._thread.setDaemon(true);
        this._thread.setPriority(this.getPriority());
        this._thread.start();
        try {
            return (Long)this.processRequest(new ContextCreateRequest());
        }
        catch (JNIException ex) {
            throw new CAException("Failed to initialize context", ex);
        }
    }

    public void destroy() throws CAException, IllegalStateException {
        if (this.getCtxtID() == 0L) {
            return;
        }
        super.destroy();
        try {
            this.processRequest(new ContextDestroyRequest());
        }
        catch (JNIException ex) {
            throw new CAException("Failed to destroy context", ex);
        }
        finally {
            this._thread = null;
            this._keepRunning = false;
            this.REQUEST_QUEUE.clear();
            this.setCtxtID(0L);
        }
    }

    void setMessageCallback(JNIContextMessageCallback callback) throws CAException, IllegalStateException {
        this._initialize();
        this.assertState(this.isValid(), "Invalid context");
        try {
            this.processRequest(new MessageCallbackRequest(callback));
        }
        catch (JNIException ex) {
            throw new CAException("Failed to set context message handler", ex);
        }
    }

    void setExceptionCallback(JNIContextExceptionCallback callback) throws CAException, IllegalStateException {
        this._initialize();
        this.assertState(this.isValid(), "Invalid context");
        try {
            this.processRequest(new ExceptionCallbackRequest(callback));
        }
        catch (JNIException ex) {
            throw new CAException("Failed to se context exception's handler", ex);
        }
    }

    public void pendIO(double timeout) throws TimeoutException, CAException, IllegalStateException {
        if (this.getLogger() != null) {
            this.getLogger().log(Level.FINE, "pendIO(" + timeout + ")");
        }
        this._initialize();
        this.assertState(this.isValid(), "Invalid context");
        try {
            this.processRequest(new PendIORequest(timeout));
        }
        catch (JNIException ex) {
            if (ex.getStatus() == CAStatus.TIMEOUT) {
                throw new TimeoutException("pendIO timed out", ex);
            }
            throw new CAException("pendIO failed", ex);
        }
    }

    public boolean testIO() throws CAException, IllegalStateException {
        if (this.getLogger() != null) {
            this.getLogger().log(Level.FINE, "testIO()");
        }
        this._initialize();
        this.assertState(this.isValid(), "Invalid context");
        try {
            return (Boolean)this.processRequest(new TestIORequest());
        }
        catch (JNIException ex) {
            throw new CAException("testIO failed", ex);
        }
    }

    public void pendEvent(double time) throws CAException, IllegalStateException {
        if (this.getLogger() != null) {
            this.getLogger().log(Level.FINE, "pendEvent(" + time + ")");
        }
        this._initialize();
        this.assertState(this.isValid(), "Invalid context");
        try {
            this.processRequest(new PendEventRequest(time));
        }
        catch (JNIException ex) {
            throw new CAException("pendEvent failed", ex);
        }
    }

    public void poll() throws CAException, IllegalStateException {
        if (this.getLogger() != null) {
            this.getLogger().log(Level.FINE, "poll()");
        }
        this._initialize();
        this.assertState(this.isValid(), "Invalid context");
        try {
            this.processRequest(new PollRequest());
        }
        catch (JNIException ex) {
            throw new CAException("poll failed", ex);
        }
    }

    public void flushIO() throws CAException, IllegalStateException {
        if (this.getLogger() != null) {
            this.getLogger().log(Level.FINE, "flushIO()");
        }
        this._initialize();
        this.assertState(this.isValid(), "Invalid context");
        try {
            this.processRequest(new FlushIORequest());
        }
        catch (JNIException ex) {
            throw new CAException("flushIO failed", ex);
        }
    }

    public void attachCurrentThread() throws IllegalStateException {
        if (this.getLogger() != null) {
            this.getLogger().log(Level.FINE, "attachCurrentThread()", Thread.currentThread().getName());
        }
        this._initialize();
        this.assertState(this.isValid(), "Invalid context");
    }

    public Channel createChannel(String name, ConnectionListener l, short priority) throws CAException, IllegalStateException {
        if (this.getLogger() != null) {
            this.getLogger().log(Level.FINE, "createChannel(" + name + "," + l + "," + priority + ")");
        }
        this._initialize();
        if (name == null || (name = name.trim()).equals("")) {
            throw new IllegalArgumentException("Channel's name is null or empty");
        }
        if (priority < 0 || priority > 99) {
            throw new IllegalArgumentException("Priority out of bounds");
        }
        this.assertState(this.isValid(), "Invalid context");
        try {
            JNIChannel ch = (JNIChannel)this.processRequest(new ChannelCreateRequest(name, l, priority));
            this.registerChannel(ch);
            return ch;
        }
        catch (JNIException ex) {
            throw new CAException("createChannel failed", ex);
        }
    }

    void ch_channelDestroy(JNIChannel ch) throws JNIException {
        this.assertState(this.isValid(), "Invalid context");
        this.processRequest(new ChannelDestroyRequest(ch));
    }

    void ch_setConnectionCallback(JNIChannel ch, JNIConnectionCallback callback) throws JNIException {
        this.assertState(this.isValid(), "Invalid context");
        this.processRequest(new ConnectionCallbackRequest(ch, callback));
    }

    void ch_setAccessRightsCallback(JNIChannel ch, JNIAccessRightsCallback callback) throws JNIException {
        this.assertState(this.isValid(), "Invalid context");
        this.processRequest(new AccessRightsRequest(ch, callback));
    }

    int ch_getFieldType(JNIChannel ch) {
        this.assertState(this.isValid(), "Invalid context");
        return (Integer)this.processRequestSafe(new GetFieldTypeRequest(ch));
    }

    int ch_getElementCount(JNIChannel ch) {
        this.assertState(this.isValid(), "Invalid context");
        return (Integer)this.processRequestSafe(new GetElementCountRequest(ch));
    }

    int ch_getState(JNIChannel ch) {
        this.assertState(this.isValid(), "Invalid context");
        return (Integer)this.processRequestSafe(new GetStateRequest(ch));
    }

    String ch_getHostName(JNIChannel ch) {
        this.assertState(this.isValid(), "Invalid context");
        return (String)this.processRequestSafe(new GetHostNameRequest(ch));
    }

    boolean ch_getReadAccess(JNIChannel ch) {
        this.assertState(this.isValid(), "Invalid context");
        return (Boolean)this.processRequestSafe(new GetReadAccessRequest(ch));
    }

    boolean ch_getWriteAccess(JNIChannel ch) {
        this.assertState(this.isValid(), "Invalid context");
        return (Boolean)this.processRequestSafe(new GetWriteAccessRequest(ch));
    }

    void ch_arrayPut(DBRType type, int count, JNIChannel ch, Object value) throws JNIException {
        this.assertState(this.isValid(), "Invalid context");
        this.processRequest(new ArrayPutRequest(type, count, ch, value));
    }

    void ch_arrayPut(DBRType type, int count, JNIChannel ch, Object value, PutListener l) throws JNIException {
        this.assertState(this.isValid(), "Invalid context");
        this.processRequest(new ArrayPutCallbackRequest(type, count, ch, value, l));
    }

    void ch_arrayGet(DBR dbr, JNIChannel ch) throws JNIException {
        this.assertState(this.isValid(), "Invalid context");
        this.processRequest(new ArrayGetRequest(dbr, ch));
    }

    void ch_arrayGet(DBRType type, int count, JNIChannel ch, GetListener l) throws JNIException {
        this.assertState(this.isValid(), "Invalid context");
        this.processRequest(new ArrayGetCallbackRequest(type, count, ch, l));
    }

    JNIMonitor ch_addMonitor(DBRType type, int count, JNIChannel ch, MonitorListener l, int mask) throws JNIException {
        this.assertState(this.isValid(), "Invalid context");
        return (JNIMonitor)this.processRequest(new AddMonitorRequest(type, count, ch, l, mask));
    }

    void ch_clearMonitor(JNIMonitor monitor) throws JNIException {
        this.assertState(this.isValid(), "Invalid context");
        this.processRequest(new ClearMonitorRequest(monitor));
    }

    private void queueRequest(Request request) {
        try {
            if (request != null) {
                this.REQUEST_QUEUE.put(request);
            }
        }
        catch (InterruptedException exception) {
            exception.printStackTrace();
        }
    }

    private Request nextRequest() {
        try {
            return (Request)this.REQUEST_QUEUE.take();
        }
        catch (InterruptedException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this._keepRunning) {
            Request request = this.nextRequest();
            if (request == null) continue;
            Request request2 = request;
            synchronized (request2) {
                try {
                    request.process();
                }
                catch (JNIException cae) {
                    request.setException(cae);
                }
                request.notifyAll();
            }
            Thread.yield();
        }
    }

    protected Object processRequestSafe(Request r) {
        try {
            return this.processRequest(r);
        }
        catch (JNIException jNIException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object processRequest(Request r) throws JNIException {
        Request request = r;
        synchronized (request) {
            this.queueRequest(r);
            try {
                r.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            r.fireException();
            return r.result();
        }
    }

    void clearGetQueue() {
        Iterator it = this._GetQueue.iterator();
        while (it.hasNext()) {
            try {
                ((Get)it.next()).update();
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
        this._GetQueue.clear();
    }

    JNIContext getJNIContext() {
        return this;
    }

    class ClearMonitorRequest
    extends Request {
        protected JNIMonitor _m;

        public ClearMonitorRequest(JNIMonitor m) {
            this._m = m;
        }

        public void process() throws JNIException {
            JNI.ch_clearMonitor(this._m.getMonitorID());
        }
    }

    class AddMonitorRequest
    extends Request {
        protected DBRType _type;
        protected int _count;
        protected JNIChannel _ch;
        protected MonitorListener _l;
        protected int _mask;
        protected JNIMonitor _res;

        public AddMonitorRequest(DBRType type, int count, JNIChannel ch, MonitorListener l, int mask) {
            this._type = type;
            this._count = count;
            this._ch = ch;
            this._l = l;
            this._mask = mask;
            this._res = new JNIMonitor(ThreadSafeContext.this.getJNIContext(), type, count, ch, l, mask);
        }

        public void process() throws JNIException {
            JNIMonitorCallback callback = this._res.getMonitorCallback();
            this._res.setMonitorID(JNI.ch_addMonitor(this._type.getValue(), this._count, this._ch.getChannelID(), callback, this._mask));
        }

        public Object result() {
            return this._res;
        }
    }

    class ArrayGetCallbackRequest
    extends Request {
        protected DBRType _type;
        protected int _count;
        protected JNIChannel _ch;
        protected GetListener _l;

        public ArrayGetCallbackRequest(DBRType type, int count, JNIChannel ch, GetListener l) {
            this._type = type;
            this._count = count;
            this._ch = ch;
            this._l = l;
        }

        public void process() throws JNIException {
            JNIGetCallback callback = new JNIGetCallback(this._ch, ThreadSafeContext.this._eventDispatcher, this._l);
            JNI.ch_arrayGetCallback(this._type.getValue(), this._count, this._ch.getChannelID(), callback);
        }
    }

    class ArrayGetRequest
    extends Request {
        protected DBR _dbr;
        protected JNIChannel _ch;

        public ArrayGetRequest(DBR dbr, JNIChannel ch) {
            this._dbr = dbr;
            this._ch = ch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() throws JNIException {
            Object object = JNI.lock();
            synchronized (object) {
                int type = this._dbr.getType().getValue();
                int count = this._dbr.getCount();
                long dbrid = JNI.dbr_create(type, count);
                ThreadSafeContext.this._GetQueue.addLast(new Get(this._dbr, dbrid));
                JNI.ch_arrayGet(type, count, this._ch.getChannelID(), dbrid);
            }
        }
    }

    class ArrayPutCallbackRequest
    extends Request {
        protected DBRType _type;
        protected int _count;
        protected JNIChannel _ch;
        protected Object _value;
        protected PutListener _l;

        public ArrayPutCallbackRequest(DBRType type, int count, JNIChannel ch, Object value, PutListener l) {
            this._type = type;
            this._count = count;
            this._ch = ch;
            this._value = value;
            this._l = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() throws JNIException {
            Object object = JNI.lock();
            synchronized (object) {
                JNIPutCallback callback = new JNIPutCallback(this._ch, ThreadSafeContext.this._eventDispatcher, this._l);
                long dbrid = JNI.dbr_create(this._type.getValue(), this._count);
                JNI.dbr_setValue(dbrid, this._type.getValue(), this._count, this._value);
                try {
                    JNI.ch_arrayPutCallback(this._type.getValue(), this._count, this._ch.getChannelID(), dbrid, callback);
                }
                finally {
                    JNI.dbr_destroy(dbrid);
                }
            }
        }
    }

    class ArrayPutRequest
    extends Request {
        protected DBRType _type;
        protected int _count;
        protected JNIChannel _ch;
        protected Object _value;

        public ArrayPutRequest(DBRType type, int count, JNIChannel ch, Object value) {
            this._type = type;
            this._count = count;
            this._ch = ch;
            this._value = value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() throws JNIException {
            long dbrid = JNI.dbr_create(this._type.getValue(), this._count);
            JNI.dbr_setValue(dbrid, this._type.getValue(), this._count, this._value);
            try {
                JNI.ch_arrayPut(this._type.getValue(), this._count, this._ch.getChannelID(), dbrid);
            }
            finally {
                JNI.dbr_destroy(dbrid);
            }
        }
    }

    class GetWriteAccessRequest
    extends Request {
        protected boolean _res;
        protected JNIChannel _ch;

        public GetWriteAccessRequest(JNIChannel ch) {
            this._ch = ch;
        }

        public void process() throws JNIException {
            this._res = JNI.ch_getWriteAccess(this._ch.getChannelID());
        }

        public Object result() {
            return new Boolean(this._res);
        }
    }

    class GetReadAccessRequest
    extends Request {
        protected boolean _res;
        protected JNIChannel _ch;

        public GetReadAccessRequest(JNIChannel ch) {
            this._ch = ch;
        }

        public void process() throws JNIException {
            this._res = JNI.ch_getReadAccess(this._ch.getChannelID());
        }

        public Object result() {
            return new Boolean(this._res);
        }
    }

    class GetHostNameRequest
    extends Request {
        protected String _res;
        protected JNIChannel _ch;

        public GetHostNameRequest(JNIChannel ch) {
            this._ch = ch;
        }

        public void process() throws JNIException {
            this._res = JNI.ch_getHostName(this._ch.getChannelID());
        }

        public Object result() {
            return this._res;
        }
    }

    class GetStateRequest
    extends Request {
        protected int _res;
        protected JNIChannel _ch;

        public GetStateRequest(JNIChannel ch) {
            this._ch = ch;
        }

        public void process() throws JNIException {
            this._res = JNI.ch_getState(this._ch.getChannelID());
        }

        public Object result() {
            return new Integer(this._res);
        }
    }

    class GetElementCountRequest
    extends Request {
        protected int _res;
        protected JNIChannel _ch;

        public GetElementCountRequest(JNIChannel ch) {
            this._ch = ch;
        }

        public void process() throws JNIException {
            this._res = JNI.ch_getElementCount(this._ch.getChannelID());
        }

        public Object result() {
            return new Integer(this._res);
        }
    }

    class GetFieldTypeRequest
    extends Request {
        protected int _res;
        protected JNIChannel _ch;

        public GetFieldTypeRequest(JNIChannel ch) {
            this._ch = ch;
        }

        public void process() throws JNIException {
            this._res = JNI.ch_getFieldType(this._ch.getChannelID());
        }

        public Object result() {
            return new Integer(this._res);
        }
    }

    class AccessRightsRequest
    extends Request {
        protected JNIChannel _ch;
        protected JNIAccessRightsCallback _callback;

        public AccessRightsRequest(JNIChannel ch, JNIAccessRightsCallback cb) {
            this._ch = ch;
            this._callback = cb;
        }

        public void process() throws JNIException {
            JNI.ch_setAccessRightsCallback(this._ch.getChannelID(), this._callback);
        }
    }

    class ConnectionCallbackRequest
    extends Request {
        protected JNIChannel _ch;
        protected JNIConnectionCallback _callback;

        public ConnectionCallbackRequest(JNIChannel ch, JNIConnectionCallback cb) {
            this._ch = ch;
            this._callback = cb;
        }

        public void process() throws JNIException {
            JNI.ch_setConnectionCallback(this._ch.getChannelID(), this._callback);
        }
    }

    class ChannelDestroyRequest
    extends Request {
        protected JNIChannel _ch;

        public ChannelDestroyRequest(JNIChannel ch) {
            this._ch = ch;
        }

        public void process() throws JNIException {
            JNI.ch_channelDestroy(this._ch.getChannelID());
        }
    }

    class ChannelCreateRequest
    extends Request {
        protected JNIChannel _res;

        public ChannelCreateRequest(String name, ConnectionListener l, short priority) {
            this._res = new JNIChannel(ThreadSafeContext.this.getJNIContext(), name, l, priority);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() throws JNIException {
            Object object = JNI.lock();
            synchronized (object) {
                JNI.setenv("EPICS_CA_ADDR_LIST", ThreadSafeContext.this._addr_list);
                JNI.setenv("EPICS_CA_AUTO_ADDR_LIST", ThreadSafeContext.this._auto_addr_list ? "YES" : "NO");
                JNI.setenv("EPICS_CA_CONN_TMO", "" + ThreadSafeContext.this._connection_timeout);
                JNI.setenv("EPICS_CA_BEACON_PERIOD", "" + ThreadSafeContext.this._beacon_period);
                JNI.setenv("EPICS_CA_REPEATER_PORT", "" + ThreadSafeContext.this._repeater_port);
                JNI.setenv("EPICS_CA_SERVER_PORT", "" + ThreadSafeContext.this._server_port);
                JNI.setenv("EPICS_CA_MAX_ARRAY_BYTES", "" + ThreadSafeContext.this._max_array_bytes);
                this._res.setChannelID(JNI.ch_channelCreate(this._res.getName(), this._res.getConnectionCallback(), this._res.getPriority()));
            }
        }

        public Object result() {
            return this._res;
        }
    }

    class FlushIORequest
    extends Request {
        FlushIORequest() {
        }

        public void process() throws JNIException {
            JNI.ctxt_flushIO();
        }
    }

    class PollRequest
    extends Request {
        PollRequest() {
        }

        public void process() throws JNIException {
            JNI.ctxt_poll();
        }
    }

    class PendEventRequest
    extends Request {
        protected double _timeout;

        public PendEventRequest(double timeout) {
            this._timeout = timeout;
        }

        public void process() throws JNIException {
            JNI.ctxt_pendEvent(this._timeout);
            ThreadSafeContext.this.clearGetQueue();
        }
    }

    class TestIORequest
    extends Request {
        protected boolean _res;

        TestIORequest() {
        }

        public void process() throws JNIException {
            this._res = JNI.ctxt_testIO();
        }

        public Object result() {
            return new Boolean(this._res);
        }
    }

    class PendIORequest
    extends Request {
        protected double _timeout;

        public PendIORequest(double timeout) {
            this._timeout = timeout;
        }

        public void process() throws JNIException {
            JNI.ctxt_pendIO(this._timeout);
            ThreadSafeContext.this.clearGetQueue();
        }
    }

    class ExceptionCallbackRequest
    extends Request {
        protected JNIContextExceptionCallback _callback;

        public ExceptionCallbackRequest(JNIContextExceptionCallback cb) {
            this._callback = cb;
        }

        public void process() throws JNIException {
            JNI.ctxt_setExceptionCallback(this._callback);
        }
    }

    class MessageCallbackRequest
    extends Request {
        protected JNIContextMessageCallback _callback;

        public MessageCallbackRequest(JNIContextMessageCallback cb) {
            this._callback = cb;
        }

        public void process() throws JNIException {
            JNI.ctxt_setMessageCallback(this._callback);
        }
    }

    class ContextDestroyRequest
    extends Request {
        ContextDestroyRequest() {
        }

        public void process() throws JNIException {
            JNI.ctxt_contextDestroy();
        }
    }

    class ContextCreateRequest
    extends Request {
        protected long _res;

        ContextCreateRequest() {
            this._res = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() throws JNIException {
            Object object = JNI.lock();
            synchronized (object) {
                JNI.setenv("EPICS_CA_ADDR_LIST", ThreadSafeContext.this._addr_list);
                JNI.setenv("EPICS_CA_AUTO_ADDR_LIST", ThreadSafeContext.this._auto_addr_list ? "YES" : "NO");
                JNI.setenv("EPICS_CA_CONN_TMO", "" + ThreadSafeContext.this._connection_timeout);
                JNI.setenv("EPICS_CA_BEACON_PERIOD", "" + ThreadSafeContext.this._beacon_period);
                JNI.setenv("EPICS_CA_REPEATER_PORT", "" + ThreadSafeContext.this._repeater_port);
                JNI.setenv("EPICS_CA_SERVER_PORT", "" + ThreadSafeContext.this._server_port);
                JNI.setenv("EPICS_CA_MAX_ARRAY_BYTES", "" + ThreadSafeContext.this._max_array_bytes);
                this._res = JNI.ctxt_contextCreate(ThreadSafeContext.this._preemptive_callback);
            }
        }

        public Object result() {
            return new Long(this._res);
        }
    }

    class Request {
        protected JNIException _cause;

        Request() {
        }

        public void process() throws JNIException {
        }

        public Object result() {
            return null;
        }

        public void setException(JNIException cause) {
            this._cause = cause;
        }

        public void fireException() throws JNIException {
            if (this._cause != null) {
                throw this._cause;
            }
        }
    }

    class Get {
        DBR dbr;
        long dbrid;

        public Get(DBR dbr, long dbrid) {
            this.dbr = dbr;
            this.dbrid = dbrid;
        }

        public void update() {
            JNI.dbr_update(this.dbr, this.dbrid);
            JNI.dbr_destroy(this.dbrid);
        }

        public String toString() {
            return (class$gov$aps$jca$jni$ThreadSafeContext$Get == null ? (class$gov$aps$jca$jni$ThreadSafeContext$Get = ThreadSafeContext.class$("gov.aps.jca.jni.ThreadSafeContext$Get")) : class$gov$aps$jca$jni$ThreadSafeContext$Get).getName() + "[ID: " + this.dbrid + " dbr=" + this.dbr + "]";
        }
    }
}

