/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca.jni;

import java.text.NumberFormat;
import java.text.ParseException;

public class JNITargetArch {
    public static String getTargetArch() {
        String osname = System.getProperty("os.name", "");
        float osversion = 0.0f;
        try {
            osversion = NumberFormat.getInstance().parse(System.getProperty("os.version", "")).floatValue();
        }
        catch (ParseException pe) {
            // empty catch block
        }
        String osarch = System.getProperty("os.arch", "");
        if (osarch.equals("i386") || osarch.equals("i486") || osarch.equals("i586")) {
            osarch = "x86";
        }
        if (osname.equals("SunOS")) {
            if (osversion >= 5.0f) {
                if (osarch.equals("sparc")) {
                    return "solaris-sparc";
                }
                if (osarch.equals("x86")) {
                    return "solaris-x86";
                }
            }
        } else if (osname.equals("Mac OS X")) {
            if (osarch.equals("ppc")) {
                return "darwin-ppc";
            }
            if (osarch.equals("x86")) {
                return "darwin-x86";
            }
        } else if (osname.equals("Linux")) {
            if (osarch.equals("x86")) {
                return "linux-x86";
            }
            if (osarch.equals("x86_64") || osarch.equals("amd64")) {
                return "linux-x86_64";
            }
        } else if (osname.startsWith("Win")) {
            return "win32-x86";
        }
        return "unknown";
    }
}

