/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca.jni;

import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRFactory;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.event.ContextExceptionEvent;
import gov.aps.jca.event.EventDispatcher;
import gov.aps.jca.jni.JNI;
import gov.aps.jca.jni.JNICallback;
import gov.aps.jca.jni.JNIChannel;
import gov.aps.jca.jni.JNIContext;
import java.util.List;

class JNIContextExceptionCallback
extends JNICallback {
    protected JNIContext _source;

    JNIContextExceptionCallback(JNIContext source, EventDispatcher dispatcher, List listeners) {
        super(dispatcher, listeners);
        this._source = source;
    }

    public void fire(long channelID, int type, int count, long dbrID, String status, String ctxtInfo, String file, int line) {
        JNIChannel ch = null;
        if (channelID != 0L) {
            ch = this._source.lookupChannel(channelID);
        }
        DBR dbr = null;
        if (dbrID != 0L) {
            dbr = DBRFactory.create(type, count);
            JNI.dbr_update(dbr, dbrID);
        }
        String msg = "Status: " + status + "\nInfo: " + ctxtInfo + "\nfile: " + file + " at line " + line;
        ContextExceptionEvent ev = new ContextExceptionEvent(this._source, ch, DBRType.forValue(type), count, dbr, msg);
        this.dispatch(ev);
    }
}

