/*
 * Decompiled with CFR 0.152.
 */
package ttf.doocs.clnt;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.CommunicationFailed;
import fr.esrf.TangoApi.ConnectionFailed;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.NonDbDevice;
import fr.esrf.TangoApi.NonSupportedFeature;
import fr.esrf.TangoApi.WrongData;
import fr.esrf.TangoApi.WrongNameSyntax;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;

public class HistoryData
implements TangoConst {
    private DeviceProxy device;
    public String attr_name;
    public int hist_length;
    public float[] value = new float[1000];
    public int[] status = new int[1000];
    public long[] time = new long[1000];

    public HistoryData(String devName, String attr, int ilength) throws DevFailed {
        this.device = new DeviceProxy(devName);
        this.attr_name = new String(attr);
        this.hist_length = ilength;
    }

    public int fill_history() {
        int argout = 1;
        float[] read_value = new float[1];
        try {
            DeviceDataHistory[] histo = this.device.attribute_history(this.attr_name, this.hist_length);
            for (int i = 0; i < this.hist_length; ++i) {
                if (histo[i].getNbRead() != 1) {
                    this.hist_length = 0;
                    argout = 0;
                    return argout;
                }
                switch (histo[i].getType()) {
                    case 1: {
                        Object[] tmp_value = histo[i].extractBooleanArray();
                        if (tmp_value[0]) {
                            read_value[0] = 1.0f;
                        }
                        if (tmp_value[0]) break;
                        read_value[0] = 0.0f;
                        break;
                    }
                    case 6: {
                        Object[] tmp_value = histo[i].extractUShortArray();
                        read_value[0] = (float)tmp_value[0];
                        break;
                    }
                    case 2: {
                        Object[] tmp_value = histo[i].extractShortArray();
                        read_value[0] = (float)tmp_value[0];
                        break;
                    }
                    case 7: {
                        Object[] tmp_value = histo[i].extractULongArray();
                        read_value[0] = (float)tmp_value[0];
                        break;
                    }
                    case 3: {
                        Object[] tmp_value = histo[i].extractLongArray();
                        read_value[0] = (float)tmp_value[0];
                        break;
                    }
                    case 4: {
                        Object[] tmp_value = histo[i].extractFloatArray();
                        read_value[0] = (float)tmp_value[0];
                        break;
                    }
                    case 5: {
                        Object[] tmp_value = histo[i].extractDoubleArray();
                        read_value[0] = (float)tmp_value[0];
                        break;
                    }
                    default: {
                        read_value[0] = 0.0f;
                    }
                }
                this.value[i] = read_value[0];
                this.time[i] = histo[i].getTime() / 1000L;
                AttrQuality attrQuality = histo[i].getAttrQuality();
                this.status[i] = attrQuality.value();
                if (this.status[i] <= 0) continue;
                this.status[i] = 1;
            }
        }
        catch (NonSupportedFeature e) {
            System.out.println(e.getStack());
        }
        catch (NonDbDevice e) {
            System.out.println(e.getStack());
        }
        catch (WrongData e) {
            System.out.println(e.getStack());
        }
        catch (WrongNameSyntax e) {
            System.out.println(e.getStack());
        }
        catch (ConnectionFailed e) {
            System.out.println(e.getStack());
        }
        catch (CommunicationFailed e) {
            System.out.println(e.getStack());
        }
        catch (DevFailed e) {
            Except.print_exception((Exception)((Object)e));
        }
        return argout;
    }
}

