/*
 * Decompiled with CFR 0.152.
 */
package ttf.doocs.clnt;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevVarDoubleStringArray;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.TangoConst;
import ttf.doocs.clnt.ArgParser;

public class CommandData
implements TangoConst {
    private DeviceProxy device;
    CommandInfo cmdinfo;

    public CommandData(String devName, String cmd_name) throws DevFailed {
        this.device = new DeviceProxy(devName);
        CommandInfo[] lst = this.device.command_list_query();
        boolean flag_command = false;
        for (int icmds = 0; icmds < lst.length; ++icmds) {
            if (!lst[icmds].cmd_name.equals(cmd_name)) continue;
            this.cmdinfo = lst[icmds];
            flag_command = true;
        }
        if (!flag_command) {
            throw new DevFailed();
        }
    }

    private DeviceData generalExecuteCommandFloatInt(float input) {
        try {
            DeviceData argin = new DeviceData();
            DeviceData argout = new DeviceData();
            switch (this.cmdinfo.in_type) {
                case 1: {
                    boolean value = false;
                    if (input == 0.0f) {
                        value = false;
                    }
                    if (input == 1.0f) {
                        value = true;
                    }
                    argin.insert(value);
                    break;
                }
                case 6: {
                    int value = (int)input;
                    argin.insert_us(value);
                    break;
                }
                case 2: {
                    short value = (short)input;
                    argin.insert(value);
                    break;
                }
                case 7: {
                    long value = (long)input;
                    argin.insert_ul(value);
                    break;
                }
                case 3: {
                    int value = (int)input;
                    argin.insert(value);
                    break;
                }
                case 4: {
                    float value = input;
                    argin.insert(value);
                    break;
                }
                case 5: {
                    double value = input;
                    argin.insert(value);
                    break;
                }
                case 19: {
                    int value = (int)input;
                    argin.insert(DevState.from_int((int)value));
                    break;
                }
                default: {
                    throw new NumberFormatException("Input command type not supported code=" + this.cmdinfo.in_type);
                }
            }
            argout = this.device.command_inout(this.cmdinfo.cmd_name, argin);
            return argout;
        }
        catch (DevFailed e2) {
            System.out.println("Error in executeCommand");
            return null;
        }
    }

    public float executeCommandFloat(float input) {
        DeviceData argout = this.generalExecuteCommandFloatInt(input);
        float value = 0.0f;
        switch (this.cmdinfo.out_type) {
            case 0: {
                value = 1.0f;
                break;
            }
            case 2: {
                short dummy = argout.extractShort();
                value = dummy;
                break;
            }
            case 1: {
                boolean dummy = argout.extractBoolean();
                if (dummy) {
                    value = 1.0f;
                }
                if (dummy) break;
                value = 0.0f;
                break;
            }
            case 6: {
                int dummy = argout.extractUShort();
                value = dummy;
                break;
            }
            case 3: {
                int dummy = argout.extractLong();
                value = dummy;
                break;
            }
            case 7: {
                long dummy = argout.extractULong();
                value = dummy;
                break;
            }
            case 5: {
                double dummy = argout.extractDouble();
                value = (float)dummy;
                break;
            }
            case 4: {
                float dummy;
                value = dummy = argout.extractFloat();
                break;
            }
            default: {
                throw new NumberFormatException("Output command type not supported code=" + this.cmdinfo.out_type);
            }
        }
        return value;
    }

    public float executeCommandFloat(int input) {
        return this.executeCommandFloat((float)input);
    }

    public int executeCommandInt(float input) {
        return (int)this.executeCommandFloat(input);
    }

    public int executeCommandInt(int input) {
        return (int)this.executeCommandFloat(input);
    }

    private DeviceData generalExecuteCommand(String strin) {
        try {
            DeviceData argin = new DeviceData();
            DeviceData argout = new DeviceData();
            if (this.cmdinfo.in_type == 0) {
                argout = this.device.command_inout(this.cmdinfo.cmd_name);
                return argout;
            }
            ArgParser arg = new ArgParser(strin);
            switch (this.cmdinfo.in_type) {
                case 1: {
                    argin.insert(arg.parse_boolean());
                    break;
                }
                case 6: {
                    argin.insert_us(arg.parse_ushort());
                    break;
                }
                case 2: {
                    argin.insert(arg.parse_short());
                    break;
                }
                case 7: {
                    argin.insert_ul(arg.parse_ulong());
                    break;
                }
                case 3: {
                    argin.insert(arg.parse_long());
                    break;
                }
                case 4: {
                    argin.insert(arg.parse_float());
                    break;
                }
                case 5: {
                    argin.insert(arg.parse_double());
                    break;
                }
                case 8: {
                    argin.insert(arg.parse_string());
                    break;
                }
                case 9: {
                    argin.insert(arg.parse_char_array());
                    break;
                }
                case 14: {
                    argin.insert_us(arg.parse_ushort_array());
                    break;
                }
                case 10: {
                    argin.insert(arg.parse_short_array());
                    break;
                }
                case 15: {
                    argin.insert_ul(arg.parse_ulong_array());
                    break;
                }
                case 11: {
                    argin.insert(arg.parse_long_array());
                    break;
                }
                case 12: {
                    argin.insert(arg.parse_float_array());
                    break;
                }
                case 13: {
                    argin.insert(arg.parse_double_array());
                    break;
                }
                case 16: {
                    argin.insert(arg.parse_string_array());
                    break;
                }
                case 17: {
                    argin.insert(new DevVarLongStringArray(arg.parse_long_array(), arg.parse_string_array()));
                    break;
                }
                case 18: {
                    argin.insert(new DevVarDoubleStringArray(arg.parse_double_array(), arg.parse_string_array()));
                    break;
                }
                default: {
                    throw new NumberFormatException("Input command type not supported code=" + this.cmdinfo.in_type);
                }
            }
            argout = this.device.command_inout(this.cmdinfo.cmd_name, argin);
            return argout;
        }
        catch (DevFailed e2) {
            System.out.println("Error in executeCommand");
            return null;
        }
    }

    public String executeCommand(String strin) {
        DeviceData data = this.generalExecuteCommand(strin);
        StringBuffer ret_string = new StringBuffer();
        switch (this.cmdinfo.out_type) {
            case 0: {
                ret_string.append("\n");
                break;
            }
            case 1: {
                ret_string.append(Boolean.toString(data.extractBoolean()));
                ret_string.append("\n");
                break;
            }
            case 6: {
                ret_string.append(Integer.toString(data.extractUShort()));
                ret_string.append("\n");
                break;
            }
            case 2: {
                ret_string.append(Short.toString(data.extractShort()));
                ret_string.append("\n");
                break;
            }
            case 7: {
                ret_string.append(Long.toString(data.extractULong()));
                ret_string.append("\n");
                break;
            }
            case 3: {
                ret_string.append(Integer.toString(data.extractLong()));
                ret_string.append("\n");
                break;
            }
            case 4: {
                ret_string.append(Float.toString(data.extractFloat()));
                ret_string.append("\n");
                break;
            }
            case 5: {
                ret_string.append(Double.toString(data.extractDouble()));
                ret_string.append("\n");
                break;
            }
            case 8: {
                ret_string.append(data.extractString());
                ret_string.append("\n");
                break;
            }
            case 9: {
                byte[] dummy = data.extractByteArray();
                int nb = dummy.length;
                for (int i = 0; i < nb; ++i) {
                    ret_string.append("[" + i + "]\t " + Integer.toString(dummy[i]));
                    if (dummy[i] >= 32) {
                        ret_string.append(" '" + new Character((char)dummy[i]).toString() + "'");
                    } else {
                        ret_string.append(" '.'");
                    }
                    ret_string.append("\n");
                }
                break;
            }
            case 14: {
                int[] dummy = data.extractUShortArray();
                int nb = dummy.length;
                for (int i = 0; i < nb; ++i) {
                    ret_string.append("[" + i + "]\t " + Integer.toString(dummy[i]) + "\n");
                }
                break;
            }
            case 10: {
                short[] dummy = data.extractShortArray();
                int nb = dummy.length;
                for (int i = 0; i < nb; ++i) {
                    ret_string.append("[" + i + "]\t " + Short.toString(dummy[i]) + "\n");
                }
                break;
            }
            case 15: {
                long[] dummy = data.extractULongArray();
                int nb = dummy.length;
                for (int i = 0; i < nb; ++i) {
                    ret_string.append("[" + i + "]\t " + Long.toString(dummy[i]) + "\n");
                }
                break;
            }
            case 11: {
                int[] dummy = data.extractLongArray();
                int nb = dummy.length;
                for (int i = 0; i < nb; ++i) {
                    ret_string.append("[" + i + "]\t " + Integer.toString(dummy[i]) + "\n");
                }
                break;
            }
            case 12: {
                float[] dummy = data.extractFloatArray();
                int nb = dummy.length;
                for (int i = 0; i < nb; ++i) {
                    ret_string.append("[" + i + "]\t " + Float.toString(dummy[i]) + "\n");
                }
                break;
            }
            case 13: {
                double[] dummy = data.extractDoubleArray();
                int nb = dummy.length;
                for (int i = 0; i < nb; ++i) {
                    ret_string.append("[" + i + "]\t" + Double.toString(dummy[i]) + "\n");
                }
                break;
            }
            case 16: {
                String[] dummy = data.extractStringArray();
                int nb = dummy.length;
                for (int i = 0; i < nb; ++i) {
                    ret_string.append("[" + i + "]\t " + dummy[i] + "\n");
                }
                break;
            }
            case 17: {
                int i;
                DevVarLongStringArray dummy = data.extractLongStringArray();
                int nb = dummy.lvalue.length;
                ret_string.append("lvalue:\n");
                for (i = 0; i < nb; ++i) {
                    ret_string.append("[" + i + "]\t " + Integer.toString(dummy.lvalue[i]) + "\n");
                }
                nb = dummy.svalue.length;
                ret_string.append("svalue:\n");
                for (i = 0; i < nb; ++i) {
                    ret_string.append("[" + i + "]\t " + dummy.svalue[i] + "\n");
                }
                break;
            }
            case 18: {
                int i;
                DevVarDoubleStringArray dummy = data.extractDoubleStringArray();
                int nb = dummy.dvalue.length;
                ret_string.append("dvalue:\n");
                for (i = 0; i < nb; ++i) {
                    ret_string.append("[" + i + "]\t " + Double.toString(dummy.dvalue[i]) + "\n");
                }
                nb = dummy.svalue.length;
                ret_string.append("svalue:\n");
                for (i = 0; i < nb; ++i) {
                    ret_string.append("[" + i + "]\t " + dummy.svalue[i] + "\n");
                }
                break;
            }
            case 19: {
                System.out.println("Tango_DEV_STATE " + data.extractDevState().value() + "\n");
                ret_string.append(Tango_DevStateName[data.extractDevState().value()]);
                ret_string.append("\n");
                break;
            }
            default: {
                ret_string.append("Unsupported command type code=" + this.cmdinfo.out_type);
                ret_string.append("\n");
            }
        }
        return ret_string.toString();
    }
}

