/*
 * Decompiled with CFR 0.152.
 */
package ttf.doocs.clnt;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.TangoConst;
import ttf.doocs.clnt.ArgParser;

public class AttributeData
implements TangoConst {
    DeviceProxy device;
    DeviceAttribute devattr;
    AttributeInfo attrinfo;

    public AttributeData(String devName, String attr) throws DevFailed {
        this.device = new DeviceProxy(devName);
        this.devattr = this.device.read_attribute(attr);
        AttributeInfo[] lst = this.device.get_attribute_info();
        for (int iattrs = 0; iattrs < lst.length; ++iattrs) {
            if (!lst[iattrs].name.equals(attr)) continue;
            this.attrinfo = lst[iattrs];
        }
        if (this.devattr.hasFailed()) {
            throw new DevFailed();
        }
    }

    public int get_int() {
        int int_value = (int)this.get_value();
        return int_value;
    }

    public float get_float() {
        float float_value = (float)this.get_value();
        return float_value;
    }

    public double get_value() {
        double value = 0.0;
        try {
            switch (this.devattr.getType()) {
                case 19: {
                    value = this.devattr.extractState().value();
                    break;
                }
                case 22: {
                    short dummy = this.devattr.extractUChar();
                    value = dummy;
                    break;
                }
                case 2: {
                    short dummy = this.devattr.extractShort();
                    value = dummy;
                    break;
                }
                case 1: {
                    boolean dummy = this.devattr.extractBoolean();
                    if (dummy) {
                        value = 1.0;
                    }
                    if (!dummy) {
                        value = 0.0;
                    }
                    break;
                }
                case 6: {
                    int dummy = this.devattr.extractUShort();
                    value = dummy;
                    break;
                }
                case 3: {
                    int dummy = this.devattr.extractLong();
                    value = dummy;
                    break;
                }
                case 7: {
                    long dummy = this.devattr.extractULong();
                    value = dummy;
                    break;
                }
                case 5: {
                    double dummy;
                    value = dummy = this.devattr.extractDouble();
                    break;
                }
                case 4: {
                    float dummy = this.devattr.extractFloat();
                    value = dummy;
                    break;
                }
                default: {
                    value = 0.0;
                }
            }
        }
        catch (DevFailed e) {
            System.out.println("Error in AttributeData.get_value");
            value = -1.0;
        }
        return value;
    }

    public int get_int(int index) {
        int int_value = (int)this.get_value(index);
        return int_value;
    }

    public float get_float(int index) {
        float float_value = (float)this.get_value(index);
        return float_value;
    }

    public double get_value(int index) {
        double value = 0.0;
        if (index < 0) {
            index = 0;
        }
        try {
            switch (this.devattr.getType()) {
                case 22: {
                    short[] dummy = this.devattr.extractUCharArray();
                    int nbRead = this.devattr.getNbRead();
                    if (index > nbRead - 1) {
                        index = nbRead - 1;
                    }
                    value = dummy[index];
                    break;
                }
                case 2: {
                    short[] dummy = this.devattr.extractShortArray();
                    int nbRead = this.devattr.getNbRead();
                    if (index > nbRead - 1) {
                        index = nbRead - 1;
                    }
                    value = dummy[index];
                    break;
                }
                case 1: {
                    boolean[] dummy = this.devattr.extractBooleanArray();
                    int nbRead = this.devattr.getNbRead();
                    if (index > nbRead - 1) {
                        index = nbRead - 1;
                    }
                    if (dummy[index]) {
                        value = 1.0;
                    }
                    if (!dummy[index]) {
                        value = 0.0;
                    }
                    break;
                }
                case 6: {
                    int[] dummy = this.devattr.extractUShortArray();
                    int nbRead = this.devattr.getNbRead();
                    if (index > nbRead - 1) {
                        index = nbRead - 1;
                    }
                    value = dummy[index];
                    break;
                }
                case 3: {
                    int[] dummy = this.devattr.extractLongArray();
                    int nbRead = this.devattr.getNbRead();
                    if (index > nbRead - 1) {
                        index = nbRead - 1;
                    }
                    value = dummy[index];
                    break;
                }
                case 7: {
                    long[] dummy = this.devattr.extractULongArray();
                    int nbRead = this.devattr.getNbRead();
                    if (index > nbRead - 1) {
                        index = nbRead - 1;
                    }
                    value = dummy[index];
                    break;
                }
                case 5: {
                    double[] dummy = this.devattr.extractDoubleArray();
                    int nbRead = this.devattr.getNbRead();
                    if (index > nbRead - 1) {
                        index = nbRead - 1;
                    }
                    value = dummy[index];
                    break;
                }
                case 4: {
                    float[] dummy = this.devattr.extractFloatArray();
                    int nbRead = this.devattr.getNbRead();
                    if (index > nbRead - 1) {
                        index = nbRead - 1;
                    }
                    value = dummy[index];
                    break;
                }
                default: {
                    value = 0.0;
                }
            }
        }
        catch (DevFailed e) {
            System.out.println("Error in AttributeData.get_value");
            value = -1.0;
        }
        return value;
    }

    public float[] get_float_array() {
        try {
            switch (this.devattr.getType()) {
                case 22: {
                    short[] dummy = this.devattr.extractUCharArray();
                    int nbRead = this.devattr.getNbRead();
                    float[] a = new float[nbRead];
                    for (int i = 0; i < nbRead; ++i) {
                        a[i] = dummy[i];
                    }
                    return a;
                }
                case 2: {
                    short[] dummy = this.devattr.extractShortArray();
                    int nbRead = this.devattr.getNbRead();
                    float[] a = new float[nbRead];
                    for (int i = 0; i < nbRead; ++i) {
                        a[i] = dummy[i];
                    }
                    return a;
                }
                case 1: {
                    boolean[] temp_dummy = this.devattr.extractBooleanArray();
                    int nbRead = this.devattr.getNbRead();
                    float[] dummy = new float[nbRead];
                    for (int i = 0; i < nbRead; ++i) {
                        if (temp_dummy[i]) {
                            dummy[i] = 1.0f;
                        }
                        if (temp_dummy[i]) continue;
                        dummy[i] = 0.0f;
                    }
                    float[] a = new float[nbRead];
                    for (int i = 0; i < nbRead; ++i) {
                        a[i] = dummy[i];
                    }
                    return a;
                }
                case 6: {
                    int[] dummy = this.devattr.extractUShortArray();
                    int nbRead = this.devattr.getNbRead();
                    float[] a = new float[nbRead];
                    for (int i = 0; i < nbRead; ++i) {
                        a[i] = dummy[i];
                    }
                    return a;
                }
                case 3: {
                    int[] dummy = this.devattr.extractLongArray();
                    int nbRead = this.devattr.getNbRead();
                    float[] a = new float[nbRead];
                    for (int i = 0; i < nbRead; ++i) {
                        a[i] = dummy[i];
                    }
                    return a;
                }
                case 7: {
                    long[] dummy = this.devattr.extractULongArray();
                    int nbRead = this.devattr.getNbRead();
                    float[] a = new float[nbRead];
                    for (int i = 0; i < nbRead; ++i) {
                        a[i] = dummy[i];
                    }
                    return a;
                }
                case 5: {
                    double[] dummy = this.devattr.extractDoubleArray();
                    int nbRead = this.devattr.getNbRead();
                    float[] a = new float[nbRead];
                    for (int i = 0; i < nbRead; ++i) {
                        a[i] = (float)dummy[i];
                    }
                    return a;
                }
                case 4: {
                    float[] dummy = this.devattr.extractFloatArray();
                    int nbRead = this.devattr.getNbRead();
                    float[] a = new float[nbRead];
                    for (int i = 0; i < nbRead; ++i) {
                        a[i] = dummy[i];
                    }
                    return a;
                }
            }
            return null;
        }
        catch (DevFailed e) {
            System.out.println("Error in AttributeData.get_float_array");
            return null;
        }
    }

    public int[] get_int_array() {
        try {
            switch (this.devattr.getType()) {
                case 22: {
                    short[] dummy = this.devattr.extractUCharArray();
                    int nbRead = this.devattr.getNbRead();
                    int[] a = new int[nbRead];
                    for (int i = 0; i < nbRead; ++i) {
                        a[i] = dummy[i];
                    }
                    return a;
                }
                case 2: {
                    short[] dummy = this.devattr.extractShortArray();
                    int nbRead = this.devattr.getNbRead();
                    int[] a = new int[nbRead];
                    for (int i = 0; i < nbRead; ++i) {
                        a[i] = dummy[i];
                    }
                    return a;
                }
                case 1: {
                    boolean[] temp_dummy = this.devattr.extractBooleanArray();
                    int nbRead = this.devattr.getNbRead();
                    int[] dummy = new int[nbRead];
                    for (int i = 0; i < nbRead; ++i) {
                        if (temp_dummy[i]) {
                            dummy[i] = 1;
                        }
                        if (temp_dummy[i]) continue;
                        dummy[i] = 0;
                    }
                    int[] a = new int[nbRead];
                    for (int i = 0; i < nbRead; ++i) {
                        a[i] = dummy[i];
                    }
                    return a;
                }
                case 6: {
                    int[] dummy = this.devattr.extractUShortArray();
                    int nbRead = this.devattr.getNbRead();
                    int[] a = new int[nbRead];
                    for (int i = 0; i < nbRead; ++i) {
                        a[i] = dummy[i];
                    }
                    return a;
                }
                case 3: {
                    int[] dummy = this.devattr.extractLongArray();
                    int nbRead = this.devattr.getNbRead();
                    int[] a = new int[nbRead];
                    for (int i = 0; i < nbRead; ++i) {
                        a[i] = dummy[i];
                    }
                    return a;
                }
                case 7: {
                    long[] dummy = this.devattr.extractULongArray();
                    int nbRead = this.devattr.getNbRead();
                    int[] a = new int[nbRead];
                    for (int i = 0; i < nbRead; ++i) {
                        a[i] = (int)dummy[i];
                    }
                    return a;
                }
                case 5: {
                    double[] dummy = this.devattr.extractDoubleArray();
                    int nbRead = this.devattr.getNbRead();
                    int[] a = new int[nbRead];
                    for (int i = 0; i < nbRead; ++i) {
                        a[i] = (int)dummy[i];
                    }
                    return a;
                }
                case 4: {
                    float[] dummy = this.devattr.extractFloatArray();
                    int nbRead = this.devattr.getNbRead();
                    int[] a = new int[nbRead];
                    for (int i = 0; i < nbRead; ++i) {
                        a[i] = (int)dummy[i];
                    }
                    return a;
                }
            }
            return null;
        }
        catch (DevFailed e) {
            System.out.println("Error in AttributeData.get_int_array");
            return null;
        }
    }

    public String get_string_arg() {
        StringBuffer ret_string = new StringBuffer();
        try {
            switch (this.devattr.getType()) {
                case 1: {
                    boolean[] dummy = this.devattr.extractBooleanArray();
                    int value = 1;
                    int nbRead = this.devattr.getNbRead();
                    for (int i = 0; i < nbRead - 1; ++i) {
                        if (dummy[i]) {
                            value = 1;
                        }
                        if (!dummy[i]) {
                            value = 0;
                        }
                        ret_string.append(value + ",");
                    }
                    if (dummy[nbRead - 1]) {
                        value = 1;
                    }
                    if (!dummy[nbRead - 1]) {
                        value = 0;
                    }
                    ret_string.append(value);
                    break;
                }
                case 21: {
                    return String.valueOf(this.devattr.extractCharArray());
                }
                case 5: {
                    double[] dummy = this.devattr.extractDoubleArray();
                    int nbRead = this.devattr.getNbRead();
                    for (int i = 0; i < nbRead - 1; ++i) {
                        ret_string.append(dummy[i] + ",");
                    }
                    ret_string.append(dummy[nbRead - 1]);
                    break;
                }
                case 4: {
                    float[] dummy = this.devattr.extractFloatArray();
                    int nbRead = this.devattr.getNbRead();
                    for (int i = 0; i < nbRead - 1; ++i) {
                        ret_string.append(dummy[i] + ",");
                    }
                    ret_string.append(dummy[nbRead - 1]);
                    break;
                }
                case 27: {
                    int[] dummy = this.devattr.extractLongArray();
                    int nbRead = this.devattr.getNbRead();
                    for (int i = 0; i < nbRead - 1; ++i) {
                        ret_string.append(dummy[i] + ",");
                    }
                    ret_string.append(dummy[nbRead - 1]);
                    break;
                }
                case 3: {
                    int[] dummy = this.devattr.extractLongArray();
                    int nbRead = this.devattr.getNbRead();
                    for (int i = 0; i < nbRead - 1; ++i) {
                        ret_string.append(dummy[i] + ",");
                    }
                    ret_string.append(dummy[nbRead - 1]);
                    break;
                }
                case 23: {
                    long[] dummy = this.devattr.extractLong64Array();
                    int nbRead = this.devattr.getNbRead();
                    for (int i = 0; i < nbRead - 1; ++i) {
                        ret_string.append(dummy[i] + ",");
                    }
                    ret_string.append(dummy[nbRead - 1]);
                    break;
                }
                case 2: {
                    short[] dummy = this.devattr.extractShortArray();
                    int nbRead = this.devattr.getNbRead();
                    for (int i = 0; i < nbRead - 1; ++i) {
                        ret_string.append(dummy[i] + ",");
                    }
                    ret_string.append(dummy[nbRead - 1]);
                    break;
                }
                case 19: {
                    ret_string.append(Tango_DevStateName[this.devattr.extractState().value()]);
                    break;
                }
                case 8: {
                    return this.devattr.extractString();
                }
                case 22: {
                    short[] dummy = this.devattr.extractUCharArray();
                    int nbRead = this.devattr.getNbRead();
                    for (int i = 0; i < nbRead - 1; ++i) {
                        ret_string.append(dummy[i] + ",");
                    }
                    ret_string.append(dummy[nbRead - 1]);
                    break;
                }
                case 7: {
                    long[] dummy = this.devattr.extractULongArray();
                    int nbRead = this.devattr.getNbRead();
                    for (int i = 0; i < nbRead - 1; ++i) {
                        ret_string.append(dummy[i] + ",");
                    }
                    ret_string.append(dummy[nbRead - 1]);
                    break;
                }
                case 24: {
                    long[] dummy = this.devattr.extractULong64Array();
                    int nbRead = this.devattr.getNbRead();
                    for (int i = 0; i < nbRead - 1; ++i) {
                        ret_string.append(dummy[i] + ",");
                    }
                    ret_string.append(dummy[nbRead - 1]);
                    break;
                }
                case 6: {
                    int[] dummy = this.devattr.extractUShortArray();
                    int nbRead = this.devattr.getNbRead();
                    for (int i = 0; i < nbRead - 1; ++i) {
                        ret_string.append(dummy[i] + ",");
                    }
                    ret_string.append(dummy[nbRead - 1]);
                    break;
                }
                default: {
                    return " ";
                }
            }
        }
        catch (DevFailed e) {
            System.out.println("Error in AttributeData.get_string_arg");
            return " ";
        }
        return ret_string.toString();
    }

    public int set(int f) {
        return this.set((float)f);
    }

    public int set(float f) {
        try {
            switch (this.devattr.getType()) {
                case 22: {
                    short value = (short)f;
                    DeviceAttribute argin = new DeviceAttribute(this.devattr.getName());
                    argin.insert_uc(value);
                    this.device.write_attribute(argin);
                    break;
                }
                case 2: {
                    short value = (short)f;
                    DeviceAttribute argin = new DeviceAttribute(this.devattr.getName());
                    argin.insert(value);
                    this.device.write_attribute(argin);
                    break;
                }
                case 1: {
                    boolean value = false;
                    if (f == 0.0f) {
                        value = false;
                    }
                    if (f == 1.0f) {
                        value = true;
                    }
                    if (f == 0.0f || f == 1.0f) {
                        DeviceAttribute argin = new DeviceAttribute(this.devattr.getName());
                        argin.insert(value);
                        this.device.write_attribute(argin);
                    }
                    break;
                }
                case 6: {
                    int value = (int)f;
                    DeviceAttribute argin = new DeviceAttribute(this.devattr.getName());
                    argin.insert_us(value);
                    this.device.write_attribute(argin);
                    break;
                }
                case 3: {
                    int value = (int)f;
                    DeviceAttribute argin = new DeviceAttribute(this.devattr.getName());
                    argin.insert(value);
                    this.device.write_attribute(argin);
                    break;
                }
                case 7: {
                    long value = (long)f;
                    DeviceAttribute argin = new DeviceAttribute(this.devattr.getName());
                    argin.insert_ul(value);
                    this.device.write_attribute(argin);
                    break;
                }
                case 5: {
                    double value = f;
                    DeviceAttribute argin = new DeviceAttribute(this.devattr.getName());
                    argin.insert(value);
                    this.device.write_attribute(argin);
                    break;
                }
                case 4: {
                    float value = f;
                    DeviceAttribute argin = new DeviceAttribute(this.devattr.getName());
                    argin.insert(value);
                    this.device.write_attribute(argin);
                    break;
                }
                default: {
                    return 0;
                }
            }
        }
        catch (DevFailed e) {
            System.out.println("Error in AttributeData.set(float)");
            return 0;
        }
        return 1;
    }

    public int set(String s) {
        ArgParser arg = new ArgParser(s);
        try {
            DeviceAttribute send = new DeviceAttribute(this.devattr.getName());
            switch (this.attrinfo.data_type) {
                case 22: {
                    switch (this.attrinfo.data_format.value()) {
                        case 0: {
                            send.insert_uc(arg.parse_uchar());
                            break;
                        }
                        case 1: {
                            send.insert_uc(arg.parse_uchar_array());
                            break;
                        }
                        case 2: {
                            send.insert_uc(arg.parse_uchar_image(), arg.get_image_width(), arg.get_image_height());
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.attrinfo.data_format.value()) {
                        case 0: {
                            send.insert(arg.parse_boolean());
                            break;
                        }
                        case 1: {
                            send.insert(arg.parse_boolean_array());
                            break;
                        }
                        case 2: {
                            send.insert(arg.parse_boolean_image(), arg.get_image_width(), arg.get_image_height());
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.attrinfo.data_format.value()) {
                        case 0: {
                            send.insert(arg.parse_short());
                            break;
                        }
                        case 1: {
                            send.insert(arg.parse_short_array());
                            break;
                        }
                        case 2: {
                            send.insert(arg.parse_short_image(), arg.get_image_width(), arg.get_image_height());
                        }
                    }
                    break;
                }
                case 6: {
                    switch (this.attrinfo.data_format.value()) {
                        case 0: {
                            send.insert_us(arg.parse_ushort());
                            break;
                        }
                        case 1: {
                            send.insert_us(arg.parse_ushort_array());
                            break;
                        }
                        case 2: {
                            send.insert_us(arg.parse_ushort_image(), arg.get_image_width(), arg.get_image_height());
                        }
                    }
                    break;
                }
                case 3: {
                    switch (this.attrinfo.data_format.value()) {
                        case 0: {
                            send.insert(arg.parse_long());
                            break;
                        }
                        case 1: {
                            send.insert(arg.parse_long_array());
                            break;
                        }
                        case 2: {
                            send.insert(arg.parse_long_image(), arg.get_image_width(), arg.get_image_height());
                        }
                    }
                    break;
                }
                case 7: {
                    switch (this.attrinfo.data_format.value()) {
                        case 0: {
                            send.insert_ul(arg.parse_ulong());
                            break;
                        }
                        case 1: {
                            send.insert_ul(arg.parse_ulong_array());
                            break;
                        }
                        case 2: {
                            send.insert_ul(arg.parse_ulong_image(), arg.get_image_width(), arg.get_image_height());
                        }
                    }
                    break;
                }
                case 4: {
                    switch (this.attrinfo.data_format.value()) {
                        case 0: {
                            send.insert(arg.parse_float());
                            break;
                        }
                        case 1: {
                            send.insert(arg.parse_float_array());
                            break;
                        }
                        case 2: {
                            send.insert(arg.parse_float_image(), arg.get_image_width(), arg.get_image_height());
                        }
                    }
                    break;
                }
                case 5: {
                    switch (this.attrinfo.data_format.value()) {
                        case 0: {
                            send.insert(arg.parse_double());
                            break;
                        }
                        case 1: {
                            send.insert(arg.parse_double_array());
                            break;
                        }
                        case 2: {
                            send.insert(arg.parse_double_image(), arg.get_image_width(), arg.get_image_height());
                        }
                    }
                    break;
                }
                case 8: {
                    switch (this.attrinfo.data_format.value()) {
                        case 0: {
                            send.insert(arg.parse_string());
                            break;
                        }
                        case 1: {
                            send.insert(arg.parse_string_array());
                            break;
                        }
                        case 2: {
                            send.insert(arg.parse_string_image(), arg.get_image_width(), arg.get_image_height());
                        }
                    }
                    break;
                }
                default: {
                    return 0;
                }
            }
            this.device.write_attribute(send);
        }
        catch (DevFailed e) {
            System.out.println("Error");
            return 0;
        }
        return 1;
    }

    public int set(int f, int index) {
        return this.set((float)f, index);
    }

    public int set(float f, int index) {
        float[] tmp = this.get_float_array();
        try {
            int nbRead = this.devattr.getNbRead();
            if (index > nbRead - 1) {
                index = nbRead - 1;
            }
        }
        catch (DevFailed e) {
            System.out.println("Error in AttributeData.set(float,index)");
            return 0;
        }
        try {
            switch (this.devattr.getType()) {
                case 22: {
                    short[] ret = new short[tmp.length];
                    for (int i = 0; i < tmp.length; ++i) {
                        ret[i] = (short)tmp[i];
                    }
                    ret[index] = (short)f;
                    DeviceAttribute argin = new DeviceAttribute(this.devattr.getName());
                    argin.insert_uc(ret);
                    this.device.write_attribute(argin);
                    break;
                }
                case 2: {
                    short[] ret = new short[tmp.length];
                    for (int i = 0; i < tmp.length; ++i) {
                        ret[i] = (short)tmp[i];
                    }
                    ret[index] = (short)f;
                    DeviceAttribute argin = new DeviceAttribute(this.devattr.getName());
                    argin.insert(ret);
                    this.device.write_attribute(argin);
                    break;
                }
                case 1: {
                    boolean[] ret = new boolean[tmp.length];
                    for (int i = 0; i < tmp.length; ++i) {
                        ret[i] = false;
                        if (tmp[i] == 0.0f) {
                            ret[i] = false;
                        }
                        if (tmp[i] != 1.0f) continue;
                        ret[i] = true;
                    }
                    if (f == 0.0f) {
                        ret[index] = false;
                    }
                    if (f == 1.0f) {
                        ret[index] = true;
                    }
                    DeviceAttribute argin = new DeviceAttribute(this.devattr.getName());
                    argin.insert(ret);
                    this.device.write_attribute(argin);
                    break;
                }
                case 6: {
                    int[] ret = new int[tmp.length];
                    for (int i = 0; i < tmp.length; ++i) {
                        ret[i] = (int)tmp[i];
                    }
                    ret[index] = (int)f;
                    DeviceAttribute argin = new DeviceAttribute(this.devattr.getName());
                    argin.insert_us(ret);
                    this.device.write_attribute(argin);
                    break;
                }
                case 3: {
                    int[] ret = new int[tmp.length];
                    for (int i = 0; i < tmp.length; ++i) {
                        ret[i] = (int)tmp[i];
                    }
                    ret[index] = (int)f;
                    DeviceAttribute argin = new DeviceAttribute(this.devattr.getName());
                    argin.insert(ret);
                    this.device.write_attribute(argin);
                    break;
                }
                case 7: {
                    long[] ret = new long[tmp.length];
                    for (int i = 0; i < tmp.length; ++i) {
                        ret[i] = (long)tmp[i];
                    }
                    ret[index] = (long)f;
                    DeviceAttribute argin = new DeviceAttribute(this.devattr.getName());
                    argin.insert_ul(ret);
                    this.device.write_attribute(argin);
                    break;
                }
                case 5: {
                    double[] ret = new double[tmp.length];
                    for (int i = 0; i < tmp.length; ++i) {
                        ret[i] = tmp[i];
                    }
                    ret[index] = f;
                    DeviceAttribute argin = new DeviceAttribute(this.devattr.getName());
                    argin.insert(ret);
                    this.device.write_attribute(argin);
                    break;
                }
                case 4: {
                    float[] ret = new float[tmp.length];
                    for (int i = 0; i < tmp.length; ++i) {
                        ret[i] = tmp[i];
                    }
                    ret[index] = f;
                    DeviceAttribute argin = new DeviceAttribute(this.devattr.getName());
                    argin.insert(ret);
                    this.device.write_attribute(argin);
                    break;
                }
                default: {
                    return 0;
                }
            }
        }
        catch (DevFailed e) {
            System.out.println("Error in AttributeData.set(float,index)");
            return 0;
        }
        return 1;
    }

    public int set(float[] tmp) {
        try {
            switch (this.devattr.getType()) {
                case 22: {
                    short[] ret = new short[tmp.length];
                    for (int i = 0; i < tmp.length; ++i) {
                        ret[i] = (short)tmp[i];
                    }
                    DeviceAttribute argin = new DeviceAttribute(this.devattr.getName());
                    argin.insert_uc(ret);
                    this.device.write_attribute(argin);
                    break;
                }
                case 2: {
                    short[] ret = new short[tmp.length];
                    for (int i = 0; i < tmp.length; ++i) {
                        ret[i] = (short)tmp[i];
                    }
                    DeviceAttribute argin = new DeviceAttribute(this.devattr.getName());
                    argin.insert(ret);
                    this.device.write_attribute(argin);
                    break;
                }
                case 1: {
                    boolean[] ret = new boolean[tmp.length];
                    for (int i = 0; i < tmp.length; ++i) {
                        ret[i] = false;
                        if (tmp[i] == 0.0f) {
                            ret[i] = false;
                        }
                        if (tmp[i] != 1.0f) continue;
                        ret[i] = true;
                    }
                    DeviceAttribute argin = new DeviceAttribute(this.devattr.getName());
                    argin.insert(ret);
                    this.device.write_attribute(argin);
                    break;
                }
                case 6: {
                    int[] ret = new int[tmp.length];
                    for (int i = 0; i < tmp.length; ++i) {
                        ret[i] = (int)tmp[i];
                    }
                    DeviceAttribute argin = new DeviceAttribute(this.devattr.getName());
                    argin.insert_us(ret);
                    this.device.write_attribute(argin);
                    break;
                }
                case 3: {
                    int[] ret = new int[tmp.length];
                    for (int i = 0; i < tmp.length; ++i) {
                        ret[i] = (int)tmp[i];
                    }
                    DeviceAttribute argin = new DeviceAttribute(this.devattr.getName());
                    argin.insert(ret);
                    this.device.write_attribute(argin);
                    break;
                }
                case 7: {
                    long[] ret = new long[tmp.length];
                    for (int i = 0; i < tmp.length; ++i) {
                        ret[i] = (long)tmp[i];
                    }
                    DeviceAttribute argin = new DeviceAttribute(this.devattr.getName());
                    argin.insert_ul(ret);
                    this.device.write_attribute(argin);
                    break;
                }
                case 5: {
                    double[] ret = new double[tmp.length];
                    for (int i = 0; i < tmp.length; ++i) {
                        ret[i] = tmp[i];
                    }
                    DeviceAttribute argin = new DeviceAttribute(this.devattr.getName());
                    argin.insert(ret);
                    this.device.write_attribute(argin);
                    break;
                }
                case 4: {
                    float[] ret = new float[tmp.length];
                    for (int i = 0; i < tmp.length; ++i) {
                        ret[i] = tmp[i];
                    }
                    DeviceAttribute argin = new DeviceAttribute(this.devattr.getName());
                    argin.insert(ret);
                    this.device.write_attribute(argin);
                    break;
                }
                default: {
                    return 0;
                }
            }
        }
        catch (DevFailed e) {
            System.out.println("Error");
            return 0;
        }
        return 1;
    }
}

