/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.TriangleSquareWindowsCornerIcon;
import editor.events.DOOCSButtonPressedEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StatusBar
extends JPanel
implements DOOCSButtonPressedEvent {
    private JLabel leftStatusLabel;
    private JPanel contentPanel;
    private boolean shiftPressed = false;
    private boolean controlPressed = false;
    private int numberOfSelectedComponents = 0;

    public StatusBar() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(10, 23));
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.add((Component)new JLabel(new TriangleSquareWindowsCornerIcon()), "South");
        rightPanel.setOpaque(false);
        this.add((Component)rightPanel, "East");
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BorderLayout());
        this.contentPanel.setOpaque(false);
        this.add((Component)this.contentPanel, "Center");
        this.leftStatusLabel = new JLabel();
        this.contentPanel.add((Component)this.leftStatusLabel, "West");
    }

    public void setLabelText(String text, Icon icon) {
        this.leftStatusLabel.setText(text);
        this.leftStatusLabel.setIcon(icon);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int y = 0;
        g.setColor(new Color(156, 154, 140));
        g.drawLine(0, y, this.getWidth(), y);
        g.setColor(new Color(196, 194, 183));
        g.drawLine(0, ++y, this.getWidth(), y);
        g.setColor(new Color(218, 215, 201));
        g.drawLine(0, ++y, this.getWidth(), y);
        g.setColor(new Color(233, 231, 217));
        g.drawLine(0, ++y, this.getWidth(), y);
        y = this.getHeight() - 3;
        g.setColor(new Color(233, 232, 218));
        g.drawLine(0, y, this.getWidth(), y);
        g.setColor(new Color(233, 231, 216));
        g.drawLine(0, ++y, this.getWidth(), y);
        y = this.getHeight() - 1;
        g.setColor(new Color(221, 221, 220));
        g.drawLine(0, y, this.getWidth(), y);
    }

    @Override
    public void DOOCSShiftPressed(boolean pressed) {
        this.shiftPressed = pressed;
        this.updateText();
    }

    @Override
    public void DOOCSControlPressed(boolean pressed) {
        this.controlPressed = pressed;
        this.updateText();
    }

    @Override
    public void DOOCSNumberOfSelectedComponentsChanged(int number) {
        this.numberOfSelectedComponents = number;
        this.updateText();
    }

    private void updateText() {
        String text = null;
        if (this.shiftPressed && this.controlPressed) {
            text = "Shift+Control pressed";
        }
        if (this.shiftPressed && !this.controlPressed) {
            text = "Shift pressed";
        }
        if (!this.shiftPressed && this.controlPressed) {
            text = "Control pressed";
        }
        if (this.numberOfSelectedComponents > 1) {
            text = text == null ? this.numberOfSelectedComponents + " components selected" : text + ", " + this.numberOfSelectedComponents + " components selected";
        }
        this.setLabelText(text, null);
    }
}

