/*
 * Decompiled with CFR 0.152.
 */
package editor;

import DOOCSComponents.DOOCSLayeredPane;
import DOOCSComponents.DOOCSParameter;
import java.util.Hashtable;
import java.util.Map;

public class DoocsFrameCache {
    public Hashtable<String, DOOCSLayeredPane> myCache = new Hashtable();
    private static DoocsFrameCache instance;

    private DoocsFrameCache() {
    }

    public static synchronized DoocsFrameCache getInstance() {
        if (instance == null) {
            instance = new DoocsFrameCache();
        }
        return instance;
    }

    public DOOCSLayeredPane getDOOCSLayeredPane(String title) {
        DOOCSLayeredPane pane = this.myCache.get(title);
        return pane;
    }

    public void addDOOCSLayeredPane(String title, DOOCSLayeredPane panel) {
        this.myCache.put(title, panel);
    }

    public void removeDOOCSLayeredPane(String title) {
        this.myCache.remove(title);
    }

    public void clear() {
        this.myCache.clear();
    }

    public void closeAllFrames() {
        for (Map.Entry<String, DOOCSLayeredPane> entry : this.myCache.entrySet()) {
            DOOCSLayeredPane lpane = entry.getValue();
            DOOCSParameter.getParentFrame(lpane).dispose();
        }
        this.myCache.clear();
    }
}

