/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSComponents.DOOCSParameter;
import DOOCSPlot.DOOCSPlot;
import DOOCSPlot.DOOCSPlotAxis;
import DOOCSPlot.DOOCSPlotHist;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import xmlparser.IntegerParser;

public class DOOCSPlotYAxis
extends DOOCSPlotAxis {
    public DOOCSPlotYAxis() {
    }

    public DOOCSPlotYAxis(DOOCSPlot p) {
        this.plot = p;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("yMin", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("yMax", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("yDefaultMin", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("yDefaultMax", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("yLimitMin", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("yLimitMax", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("yTextFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("yTextColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("yIsLog", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("yHasGrid", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("yAutoScale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("yShowText", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("yStrokeSize", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("yTickLength", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL)};
        return parameters;
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("yMin")) {
            return this.getMin();
        }
        if (parameter.equalsIgnoreCase("yMax")) {
            return this.getMax();
        }
        if (parameter.equalsIgnoreCase("yDefaultMin")) {
            return this.getDefaultMin();
        }
        if (parameter.equalsIgnoreCase("yDefaultMax")) {
            return this.getDefaultMax();
        }
        if (parameter.equalsIgnoreCase("yLimitMin")) {
            return this.getLimitMin();
        }
        if (parameter.equalsIgnoreCase("yLimitMax")) {
            return this.getLimitMax();
        }
        if (parameter.equalsIgnoreCase("yTextFont")) {
            return DOOCSParameter.getDoocsFont(this.getFont());
        }
        if (parameter.equalsIgnoreCase("yTextColor")) {
            return DOOCSParameter.getDoocsColor(this.getForeground());
        }
        if (parameter.equalsIgnoreCase("yIsLog")) {
            return this.getIsLog();
        }
        if (parameter.equalsIgnoreCase("yHasGrid")) {
            return this.getHasGrid();
        }
        if (parameter.equalsIgnoreCase("yAutoScale")) {
            return this.getAutoScale();
        }
        if (parameter.equalsIgnoreCase("yShowText")) {
            return this.getShowText();
        }
        if (parameter.equalsIgnoreCase("yStrokeSize")) {
            return this.getStrokeSize();
        }
        if (parameter.equalsIgnoreCase("yTickLength")) {
            return this.getTickLength();
        }
        return null;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("yMin")) {
            this.setMin(Double.parseDouble(value));
        } else if (parameter.equalsIgnoreCase("yMax")) {
            this.setMax(Double.parseDouble(value));
        } else if (parameter.equalsIgnoreCase("yDefaultMin")) {
            this.setDefaultMin(Double.parseDouble(value));
        } else if (parameter.equalsIgnoreCase("yDefaultMax")) {
            this.setDefaultMax(Double.parseDouble(value));
        } else if (parameter.equalsIgnoreCase("yLimitMin")) {
            this.setLimitMin(Double.parseDouble(value));
        } else if (parameter.equalsIgnoreCase("yLimitMax")) {
            this.setLimitMax(Double.parseDouble(value));
        } else if (parameter.equalsIgnoreCase("yTextFont")) {
            this.setFont(DOOCSParameter.convertToFont(value));
        } else if (parameter.equalsIgnoreCase("yTextColor")) {
            this.setForeground(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("yIsLog")) {
            this.setIsLog(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("yHasGrid")) {
            this.setHasGrid(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("yAutoScale")) {
            this.setAutoScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("yShowText")) {
            this.setShowText(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("yStrokeSize")) {
            this.setStrokeSize(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("yTickLength")) {
            this.setTickLength(IntegerParser.parseInt(value));
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int ixp;
        String tickText;
        int iy;
        Graphics2D g2d = (Graphics2D)g;
        double d = this.actMin / 10.0;
        float x = 0.0f;
        float y = 0.0f;
        int markTick = 0;
        g2d.setColor(this.getForeground());
        g2d.setFont(this.getFont());
        BasicStroke myStroke = new BasicStroke(this.strokeSize);
        g2d.setStroke(myStroke);
        float space = this.p1Y - this.p0Y;
        float dely = -space / (float)this.nMajorTicks;
        float dely2 = dely / (float)this.nMinorTicks;
        int ch = g2d.getFontMetrics().getHeight();
        int ixr = this.p0X - this.tickLength - 3;
        boolean isLogicFlag = false;
        if (this.plot instanceof DOOCSPlotHist && ((DOOCSPlotHist)this.plot).isLogicPlot) {
            isLogicFlag = true;
        }
        for (int i = 0; i < this.nMajorTicks; ++i) {
            y = (float)this.p1Y + dely * (float)i;
            iy = (int)((double)y + 0.5);
            if (i == this.nMajorTicks - 1) {
                space = space / 4.0f * 3.0f;
            }
            d = this.isLog ? (d *= 10.0) : this.actMin + this.delMajor * (double)i;
            if (d == 0.0 || isLogicFlag) {
                g2d.drawLine(this.p0X, iy, this.p2XY, iy);
            }
            if ((float)(ch + 2) < space) {
                int idx;
                tickText = isLogicFlag ? ((idx = (int)d) < 24 && idx >= 0 && ((DOOCSPlotHist)this.plot).bitNames != null ? ((DOOCSPlotHist)this.plot).bitNames[idx] : "") : (d == 0.0 ? "0" : this.numberToString(d, this.precision));
                ixp = tickText != null ? ixr - g2d.getFontMetrics().stringWidth(tickText) : ixr;
                if (ixp < 0) {
                    ixp = 0;
                }
                if (this.showText && this.spaceForText && tickText != null) {
                    if (isLogicFlag) {
                        g2d.drawString(tickText, ixp, iy + ch / 2 - 8);
                    } else {
                        g2d.drawString(tickText, ixp, iy + ch / 2 - 2);
                    }
                    markTick = 2;
                } else {
                    markTick = 0;
                }
                space = -dely;
            } else {
                space -= dely;
            }
            if (this.hasGrid) {
                g2d.drawLine(this.p0X - this.tickLength + markTick, iy, this.p2XY, iy);
            } else {
                g2d.drawLine(this.p0X, iy, this.p0X - this.tickLength + markTick, iy);
            }
            if (this.isLog) {
                int istep = 1;
                if (dely2 > -15.0f) {
                    istep = 2;
                }
                for (int j = 1; j < 10; j += istep) {
                    int iy2 = (int)(Math.log10(j) * (double)dely + (double)y + 0.5);
                    g2d.drawLine(this.p0X, iy2, this.p0X - this.tickLength / 2, iy2);
                }
                continue;
            }
            for (int j = 1; j < this.nMinorTicks; ++j) {
                float y2 = y + dely2 * (float)j;
                int iy2 = (int)((double)y2 + 0.5);
                g2d.drawLine(this.p0X, iy2, this.p0X - this.tickLength / 2, iy2);
            }
        }
        y = (float)this.p1Y + dely * (float)this.nMajorTicks;
        iy = (int)((double)y + 0.5);
        tickText = this.numberToString(this.actMax, this.precision);
        ixp = ixr - g2d.getFontMetrics().stringWidth(tickText);
        if (ixp < 0) {
            ixp = 0;
        }
        if (this.showText && this.spaceForText && !isLogicFlag) {
            g2d.drawString(tickText, ixp, iy + ch / 2 - 2);
            markTick = 2;
        } else {
            markTick = 0;
        }
        g2d.drawLine(this.p0X, iy, this.p0X - this.tickLength + markTick, iy);
        g2d.drawLine(this.p0X, this.p1Y, this.p0X, iy);
        g2d.drawLine(this.p2XY, this.p1Y, this.p2XY, iy);
    }
}

