/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSPlot.DOOCSPlot;
import DOOCSPlot.DOOCSPlotAxis;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Calendar;

public class DOOCSPlotXAxisHist
extends DOOCSPlotAxis {
    private static final int TAB_LENGTH = 34;
    private static final int DEL_SEC = 0;
    private static final int T_SEL = 1;
    private static final int DEL_MAJ = 2;
    private static final int DEL_MIN = 3;
    private static final int T_SEC = 0;
    private static final int T_MIN = 1;
    private static final int T_HOUR = 2;
    private static final int T_DAY = 3;
    private static final int T_MONTH = 4;
    private static final int T_YEAR = 5;

    public DOOCSPlotXAxisHist() {
    }

    public DOOCSPlotXAxisHist(DOOCSPlot p) {
        this.plot = p;
        this.isTimeScale = true;
    }

    @Override
    public void linRoundUp(double rmin, double rmax) {
        int i;
        double tmp;
        int[][] tab = new int[][]{{10, 0, 2, 1}, {20, 0, 5, 1}, {40, 0, 10, 1}, {60, 0, 10, 1}, {90, 0, 10, 1}, {120, 1, 60, 10}, {180, 1, 60, 10}, {240, 1, 60, 10}, {360, 1, 60, 10}, {480, 1, 60, 10}, {600, 1, 120, 60}, {900, 1, 120, 60}, {1200, 1, 120, 60}, {1800, 1, 300, 60}, {2600, 1, 300, 60}, {3600, 1, 600, 60}, {5400, 1, 600, 60}, {7200, 2, 1200, 600}, {14400, 2, 3600, 600}, {21600, 2, 3600, 600}, {36000, 2, 3600, 600}, {61000, 2, 7200, 600}, {86400, 2, 21600, 3600}, {172800, 3, 36000, 3600}, {345600, 3, 86400, 3600}, {604800, 3, 86400, 21600}, {1209600, 3, 86400, 21600}, {2635200, 3, 86400, 21600}, {5182000, 4, 86400, 21600}, {10364000, 4, 2592000, 86400}, {15552000, 4, 2592000, 86400}, {31536000, 5, 31536000, 2592000}, {62208000, 5, 31536000, 2592000}, {311040000, 5, 31536000, 5182000}};
        long cTime = System.currentTimeMillis() / 1000L;
        Calendar cal = Calendar.getInstance();
        if (rmin > rmax) {
            tmp = rmax;
            rmax = rmin;
            rmin = tmp;
        }
        if (rmin < 100000.0) {
            rmin = (double)cTime - rmin;
        }
        if (rmax < 100000.0) {
            rmax += (double)cTime;
        }
        if (rmin < 5.0E8) {
            rmin = 5.0E8;
        }
        if (rmax > (double)(cTime + 86400L)) {
            rmax = cTime + 86400L;
        }
        if (rmin > rmax) {
            tmp = rmin;
            rmin = rmax;
            rmax = tmp;
        }
        double del = rmax - rmin;
        if (!this.initDone) {
            this.initDone = true;
            rmax = cTime;
            rmin = rmax - del;
        }
        long t1 = (long)rmin;
        cal.setTimeInMillis(t1 * 1000L);
        int sec = cal.get(13);
        int min = cal.get(12);
        int hour = cal.get(11);
        int day = cal.get(5);
        int month = cal.get(2);
        int year = cal.get(1);
        long t2 = (long)rmax;
        cal.setTimeInMillis(t2 * 1000L);
        int sec2 = cal.get(13);
        int min2 = cal.get(12);
        int hour2 = cal.get(11);
        int day2 = cal.get(5);
        int month2 = cal.get(2);
        int year2 = cal.get(1);
        for (i = 0; i < 33 && del > (double)tab[i][0]; ++i) {
        }
        switch (tab[i][1]) {
            case 0: {
                this.actMin = rmin;
                this.actMax = rmax;
                if (!(del < (double)tab[i][2])) break;
                this.actMax = this.actMin + (double)tab[i][2];
                break;
            }
            default: {
                cal.set(year, month, day, hour, min, 0);
                this.actMin = cal.getTimeInMillis() / 1000L;
                if (sec2 > 0) {
                    cal.set(year2, month2, day2, hour2, min2 + 1, 0);
                } else {
                    cal.set(year2, month2, day2, hour2, min2, 0);
                }
                this.actMax = cal.getTimeInMillis() / 1000L;
                break;
            }
            case 2: {
                cal.set(year, month, day, hour, 0, 0);
                this.actMin = cal.getTimeInMillis() / 1000L;
                if (sec2 > 0 || min2 > 0) {
                    cal.set(year2, month2, day2, hour2 + 1, 0, 0);
                } else {
                    cal.set(year2, month2, day2, hour2, 0, 0);
                }
                this.actMax = cal.getTimeInMillis() / 1000L;
                break;
            }
            case 3: {
                cal.set(year, month, day, 0, 0, 0);
                this.actMin = cal.getTimeInMillis() / 1000L;
                if (min2 > 0 || hour2 > 0) {
                    cal.set(year2, month2, day2 + 1, 0, 0, 0);
                } else {
                    cal.set(year2, month2, day2, 0, 0, 0);
                }
                this.actMax = cal.getTimeInMillis() / 1000L;
                break;
            }
            case 4: {
                cal.set(year, month, 1, 0, 0, 0);
                this.actMin = cal.getTimeInMillis() / 1000L;
                if (hour2 > 0 || day2 > 1) {
                    cal.set(year2, month2 + 1, 1, 0, 0, 0);
                } else {
                    cal.set(year2, month2, 1, 0, 0, 0);
                }
                this.actMax = cal.getTimeInMillis() / 1000L;
                break;
            }
            case 5: {
                cal.set(year, 0, 1, 0, 0, 0);
                this.actMin = cal.getTimeInMillis() / 1000L;
                int d1 = cal.get(5);
                int d2 = cal.get(2);
                if (month2 > 1 || day2 > 1) {
                    cal.set(year2 + 1, 0, 1, 0, 0, 0);
                } else {
                    cal.set(year2, 0, 1, 0, 0, 0);
                }
                this.actMax = cal.getTimeInMillis() / 1000L;
            }
        }
        this.nMajorTicks = (int)((this.actMax - this.actMin) / (double)tab[i][2] + 0.9);
        if (this.nMajorTicks < 1) {
            this.nMajorTicks = 1;
        }
        this.actMax = this.actMin + (double)(this.nMajorTicks * tab[i][2]);
        this.nMinorTicks = tab[i][2] / tab[i][3];
        this.delMajor = tab[i][2];
        this.delMinor = tab[i][3];
        this.setScale(this.actMin, this.actMax);
    }

    @Override
    public void setScale(double rmin, double rmax) {
        this.actMin = rmin;
        this.actMax = rmax;
        if (this.isLog) {
            double lmin = rmin <= 0.0 ? -20.0 : Math.log10(rmin);
            double lmax = rmax <= 0.0 ? -20.0 : Math.log10(rmax);
            this.transformScale = (double)this.pixelLength / (lmax - lmin);
        } else {
            this.transformScale = (double)this.pixelLength / (this.actMax - this.actMin);
        }
    }

    @Override
    public void rescaleDrag(double min, double max) {
        if (this.isLog) {
            double delta = Math.log10(this.actMax) - Math.log10(this.actMin);
            double lmin = Math.log10(this.actMin);
            double lmax = Math.log10(this.actMax);
            double ldmin = this.defaultMin > 0.0 ? Math.log10(this.defaultMin) : lmin;
            double ldmax = this.defaultMax > 0.0 ? Math.log10(this.defaultMax) : lmax;
            double llmin = this.limitMin > 0.0 ? Math.log10(this.limitMin) : lmin;
            double llmax = this.limitMax > 0.0 ? Math.log10(this.limitMax) : lmax;
            min = min * delta + lmin;
            max = max * delta + lmin;
            if (min < lmin) {
                this.actMin = min > ldmin ? this.defaultMin : (this.actMin /= 100.0);
                if (lmin < llmin) {
                    this.actMin = this.limitMin;
                }
            } else {
                this.actMin = Math.pow(10.0, min);
            }
            if (max > lmax) {
                this.actMax = max < ldmax ? this.defaultMax : (this.actMax *= 100.0);
                if (lmax > llmax) {
                    this.actMax = this.limitMax;
                }
            } else {
                this.actMax = Math.pow(10.0, max);
            }
        } else {
            double delta = this.actMax - this.actMin;
            min = min * delta + this.actMin;
            max = max * delta + this.actMin;
            this.actMin = min < this.actMin ? (this.actMin -= 3.0 * delta) : min;
            this.actMax = max > this.actMax ? (this.actMax += 3.0 * delta) : max;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int pos2;
        int pos;
        int cwMax;
        int cw;
        String[] str;
        int ix;
        Graphics2D g2d = (Graphics2D)g;
        int cw2 = 0;
        int markTick = 0;
        double d = this.actMin;
        float x = 0.0f;
        float y = 0.0f;
        g2d.setColor(this.getForeground());
        g2d.setFont(this.getFont());
        BasicStroke myStroke = new BasicStroke(this.strokeSize);
        g2d.setStroke(myStroke);
        float space = this.p1X - this.p0X;
        float delx = space / (float)this.nMajorTicks;
        float delx2 = delx / (float)this.nMinorTicks;
        space = 0.0f;
        int chAscent = g2d.getFontMetrics().getAscent();
        int ch = g2d.getFontMetrics().getHeight();
        for (int i = 0; i < this.nMajorTicks; ++i) {
            x = (float)this.p0X + delx * (float)i;
            ix = (int)((double)x + 0.5);
            d = this.isLog ? (d *= 10.0) : this.actMin + this.delMajor * (double)i;
            str = this.time_to_str(Math.round(d * 1000.0));
            cw = cw2 = g2d.getFontMetrics().stringWidth(str[0]);
            if (str[1] != null) {
                cw2 = g2d.getFontMetrics().stringWidth(str[1]);
            }
            cwMax = Math.max(cw, cw2);
            pos = ix - cw / 2;
            pos2 = ix - cw2 / 2;
            if (pos < 2) {
                pos = 2;
            }
            if ((float)pos > space && (float)pos2 > space && pos + cw <= this.plot.getWidth() && pos2 + cw2 <= this.plot.getWidth() && this.showText && this.spaceForText) {
                space = pos + cwMax + 10;
                markTick = 2;
                g2d.drawString(str[0], pos, this.p1Y + ch + this.tickLength);
                if (str[1] != null) {
                    g2d.drawString(str[1], pos2, this.p1Y + ch + chAscent + this.tickLength);
                }
            } else {
                markTick = 0;
            }
            if (this.hasGrid) {
                g2d.drawLine(ix, this.p1Y + this.tickLength + markTick, ix, this.p2XY);
            } else {
                g2d.drawLine(ix, this.p1Y, ix, this.p1Y + this.tickLength + markTick);
            }
            if (i + 1 == this.nMajorTicks) {
                space -= delx / 2.0f;
            }
            if (this.isLog) {
                int istep = 1;
                if (delx2 > -15.0f) {
                    istep = 2;
                }
                for (int j = 1; j < 10; j += istep) {
                    int ix2 = (int)(Math.log10(j) * (double)delx + (double)x + 0.5);
                    g2d.drawLine(ix2, this.p1Y, ix2, this.p1Y + this.tickLength / 2);
                }
                continue;
            }
            for (int j = 1; j < this.nMinorTicks; ++j) {
                float x2 = x + delx2 * (float)j;
                int ix2 = (int)((double)x2 + 0.5);
                g2d.drawLine(ix2, this.p1Y, ix2, this.p1Y + this.tickLength / 2);
            }
        }
        x = (float)this.p0X + delx * (float)this.nMajorTicks;
        d = this.isLog ? (d *= 10.0) : this.actMin + this.delMajor * (double)this.nMajorTicks;
        ix = (int)((double)x + 0.5);
        if (this.showText && this.spaceForText) {
            str = this.time_to_str(Math.round(d * 1000.0));
            cw = cw2 = g2d.getFontMetrics().stringWidth(str[0]);
            if (str[1] != null) {
                cw2 = g2d.getFontMetrics().stringWidth(str[1]);
            }
            pos = ix - cw / 2;
            pos2 = ix - cw2 / 2;
            cwMax = Math.max(cw, cw2);
            if ((float)pos > space && (float)pos2 > space && pos + cw <= this.plot.getWidth() && pos2 + cw2 <= this.plot.getWidth()) {
                g2d.drawString(str[0], pos, this.p1Y + ch + this.tickLength);
                markTick = 2;
                if (str[1] != null) {
                    g2d.drawString(str[1], pos2, this.p1Y + ch + chAscent + this.tickLength);
                }
            } else {
                markTick = 0;
            }
            if (this.eguText != null && this.eguText.length() > 0) {
                int l = g2d.getFontMetrics().stringWidth(this.eguText);
                pos = this.plot.getWidth() - 10 - l;
                g2d.drawString(this.eguText, pos, this.p1Y + ch + chAscent + this.tickLength);
            }
        }
        g2d.drawLine(ix, this.p1Y, ix, this.p1Y + this.tickLength + markTick);
        g2d.drawLine(this.p0X, this.p1Y, ix, this.p1Y);
        g2d.drawLine(this.p0X, this.p2XY, ix, this.p2XY);
    }
}

