/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSLayeredPane;
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.DOOCSValueShowHist;
import DOOCSComponents.PrintUtilities;
import DOOCSComponents.StringTransferHandler;
import DOOCSPlot.DOOCSAdrList;
import DOOCSPlot.DOOCSChannel;
import DOOCSPlot.DOOCSChannelList;
import DOOCSPlot.DOOCSDataContainer;
import DOOCSPlot.DOOCSFindDataPoint;
import DOOCSPlot.DOOCSPlotAxis;
import DOOCSPlot.DOOCSPlotCanvas;
import DOOCSPlot.DOOCSPlotContextMenu;
import DOOCSPlot.DOOCSPlotLegend;
import DOOCSPlot.DOOCSPlotRefDFT;
import DOOCSPlot.DOOCSPlotRefHistgram;
import DOOCSPlot.DOOCSPlotSelection;
import DOOCSPlot.DOOCSPlotWindow;
import DOOCSPlot.DOOCSPlotXAxis;
import DOOCSPlot.DOOCSPlotXAxisHist;
import DOOCSPlot.DOOCSPlotXAxisLocation;
import DOOCSPlot.DOOCSPlotYAxis;
import DOOCSPlot.PlotToolTip;
import DOOCSPlot.utils.EventNumberDialog;
import editor.undo.SetProperty;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import layoutmanager.ScaleConstraints;
import layoutmanager.ScaleLayout;
import runtime.jddd_run;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqData;
import xmlparser.IntegerParser;

public abstract class DOOCSPlot
extends JComponent
implements Runnable,
DOOCSComponent,
MouseInputListener {
    private int debugCounter = 0;
    public int debug = 0;
    Thread th;
    public boolean stop = false;
    private boolean doocsBorder = false;
    protected boolean doocsFill = true;
    protected boolean doocsScale = true;
    protected String doocsLayer = "NONE";
    public Rectangle m_initialBounds;
    protected MouseInputListener m_DOOCSMouse;
    protected boolean doocsRunMode = false;
    private boolean initDone = false;
    protected Dimension prefSize;
    protected float doocsUpdateTime = 1.0f;
    protected boolean showTitle = true;
    protected boolean spaceForTitle = true;
    protected Color titleColor = Color.BLACK;
    private String titleText;
    private Font titleFont;
    private int yPosTitle;
    private int legendPosY;
    private final int topLegendPosY = 2;
    protected boolean showDataTip = false;
    protected PlotToolTip toolTip;
    protected boolean showToolTip = false;
    public int dataTipIndex = -1;
    public int colorIndex = 0;
    DOOCSPlot destinationPlot;
    boolean destinationPlotUpdate = false;
    public DOOCSAdrList doocsAdrList;
    public String doocsRefAdr;
    public DOOCSChannelList doocsRefChannels = null;
    public boolean recalcFlag = false;
    public int sysMask = 0;
    public DOOCSPlotCanvas fastCanvas = null;
    private boolean overwriteMode = false;
    public DOOCSPlotLegend doocsPlotLegend;
    public DOOCSPlotSelection doocsPlotSelection;
    public DOOCSPlotAxis doocsPlotAxisX;
    public DOOCSPlotAxis doocsPlotAxisY;
    public JPopupMenu popupAxis;
    public JPopupMenu popupSelection;
    public JPopupMenu popupChannel;
    public JMenuItem popupChannelMIAdr;
    public JMenuItem popupChannelMIDescr;
    public JMenuItem popupChannelEvt;
    public JMenuItem popupChannelDaq;
    private ActionListener mathActListner;
    private JDialog evtPanel = null;
    public DOOCSChannel selectedChannel;
    public int dataAreaX0;
    public int dataAreaY0;
    public int dataAreaX1;
    public int dataAreaY1;
    double scaleX;
    double scaleY;
    protected Cursor cursorScale;
    protected Cursor cursorMove;
    protected Cursor cursorMoveHor;
    protected Cursor cursorMoveVert;
    protected Cursor cursorCross;
    protected long cursorTime;
    public EqCall eq = null;
    private int selectionPixels = 5;
    private String doubleClickPanel;
    private boolean overridePanel = false;
    public MouseStatus mouseStatusLast = MouseStatus.OUTSIDE;
    protected int mouseX;
    protected int mouseXlast;
    protected int dragX;
    protected int mouseY;
    protected int mouseYlast;
    protected int dragY;
    protected boolean isDragging = false;
    protected boolean isMoving = false;
    public int mouseClosestDataX;
    public int mouseClosestDataY;
    public double mouseClosestRealX;
    public double mouseClosestRealY;
    public DOOCSChannel mouseClosestDataChannel;
    protected int mouseCrossXlast;
    protected int mouseCrossYlast;
    public PlotType plotType = PlotType.PLOTUNDEF;
    public int defaultWidth = 350;
    public int defaultHeight = 200;
    public long drawTimeMs = 0L;
    public boolean boundsNeedsUpdate = false;
    public boolean doAll = false;
    private String daqAddress;

    public DOOCSPlot(PlotType pt) {
        this.plotType = pt;
        this.colorIndex = 0;
        this.setFont(Font.getFont("Dialog,1,14"));
        this.titleFont = new Font("Helvetica", 1, 14);
        this.titleText = "";
        this.doubleClickPanel = new String("");
        this.doocsRefAdr = new String();
        this.setPreferredSize(new Dimension(this.defaultWidth, this.defaultHeight));
        this.setSize(new Dimension(this.defaultWidth, this.defaultHeight));
        this.setLayout(new ScaleLayout(new Dimension(this.defaultWidth, this.defaultHeight)));
        this.cursorScale = new Cursor(0);
        this.cursorMove = new Cursor(12);
        this.cursorCross = new Cursor(1);
        this.cursorMoveHor = new Cursor(10);
        this.cursorMoveVert = new Cursor(8);
        this.setOpaque(true);
        this.setTransferHandler(new StringTransferHandler());
        this.m_DOOCSMouse = null;
        if (this.plotType == PlotType.PLOTLOCATION) {
            this.doocsPlotAxisX = new DOOCSPlotXAxisLocation(this);
            this.doocsPlotAxisX.eguText = "";
        } else if (this.plotType == PlotType.PLOTHIST) {
            this.doocsPlotAxisX = new DOOCSPlotXAxisHist(this);
            this.doocsPlotAxisX.eguText = "";
        } else if (this.plotType == PlotType.PLOTXY) {
            this.doocsPlotAxisX = new DOOCSPlotXAxis(this);
            this.doocsPlotAxisX.eguText = "";
        } else {
            this.doocsPlotAxisX = new DOOCSPlotXAxis(this);
            this.doocsPlotAxisX.eguText = "time";
        }
        this.doocsPlotAxisX.font = this.getFont();
        this.doocsPlotAxisY = new DOOCSPlotYAxis(this);
        this.doocsPlotAxisY.font = this.getFont();
        this.doocsPlotAxisX.roundUp(this.doocsPlotAxisX.actMin, this.doocsPlotAxisX.actMax);
        this.doocsPlotAxisX.initDone = false;
        this.doocsPlotAxisY.roundUp(this.doocsPlotAxisY.actMin, this.doocsPlotAxisY.actMax);
        this.doocsAdrList = new DOOCSAdrList(this, null);
        this.doocsPlotLegend = new DOOCSPlotLegend(this.doocsAdrList, this);
        this.doocsAdrList.init();
        this.doocsPlotSelection = new DOOCSPlotSelection(this.doocsAdrList, this);
        this.doocsPlotSelection.setVisible(false);
        this.doocsPlotSelection.setActive(false);
        this.createMathActionListener();
    }

    @Override
    public JToolTip createToolTip() {
        this.toolTip = new PlotToolTip(this);
        this.toolTip.setComponent(this);
        return this.toolTip;
    }

    public void stopThreads() {
        this.stop = true;
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.doocsAdrList.cancel();
    }

    public void startThreads() {
        this.stop = false;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.init();
        this.doocsAdrList.startMonitoring();
        if (this.th == null || this.th != null && !this.th.isAlive()) {
            this.th = new Thread(this);
            this.th.start();
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public void setBounds(int x0, int y0, int w, int h) {
        if (super.getBounds().width != w || super.getBounds().height != h) {
            this.boundsNeedsUpdate = true;
        }
        this.repaint();
        super.setBounds(x0, y0, w, h);
    }

    public void setBounds() {
        int yTitleSpace;
        int ixspace;
        int iyspace;
        int x0 = this.getBounds().x;
        int y0 = this.getBounds().y;
        int w = this.getBounds().width;
        int h = this.getBounds().height;
        int oldLegendPosY = this.legendPosY;
        int oldYPosTitle = this.yPosTitle;
        int oldX0 = this.dataAreaX0;
        int oldX1 = this.dataAreaX1;
        int oldY0 = this.dataAreaY0;
        int oldY1 = this.dataAreaY1;
        if (this.titleFont == null) {
            return;
        }
        if (this.doocsPlotAxisX == null) {
            return;
        }
        int xScaleFontH = (int)((double)this.doocsPlotAxisX.getFont().getSize() * 1.33);
        int yScaleFontH = (int)((double)this.doocsPlotAxisY.getFont().getSize() * 1.33);
        int titleFontH = (int)((double)this.titleFont.getSize() * 1.33);
        Graphics gr = this.getGraphics();
        if (!this.initDone) {
            this.doocsPlotAxisY.roundUp(this.doocsPlotAxisY.actMin, this.doocsPlotAxisY.actMax);
            this.doocsPlotAxisX.roundUp(this.doocsPlotAxisX.actMin, this.doocsPlotAxisX.actMax);
        }
        if (gr != null) {
            Font f = this.doocsPlotAxisX.getFont();
            FontMetrics fmX = f != null ? gr.getFontMetrics(f) : gr.getFontMetrics();
            xScaleFontH = fmX.getHeight();
            FontMetrics fm = gr.getFontMetrics(this.titleFont);
            titleFontH = fm.getHeight();
            f = this.doocsPlotAxisY.getFont();
            FontMetrics fmY = f != null ? gr.getFontMetrics(f) : gr.getFontMetrics();
            yScaleFontH = fmY.getHeight();
            iyspace = fmY.charWidth('a') * (this.doocsPlotAxisY.tickStringLength + 1);
            ixspace = fmX.charWidth('a') * (this.doocsPlotAxisX.tickStringLength / 2 + 2);
            yTitleSpace = this.showTitle ? Math.max(titleFontH, yScaleFontH) * 4 / 3 : yScaleFontH * 4 / 3;
        } else {
            iyspace = 40;
            ixspace = 25;
            yTitleSpace = titleFontH * 4 / 3;
        }
        if (yTitleSpace * 6 > h) {
            this.spaceForTitle = false;
            this.doocsPlotAxisX.spaceForText = false;
        } else {
            this.spaceForTitle = true;
            this.doocsPlotAxisX.spaceForText = true;
        }
        if (iyspace * 3 > w) {
            iyspace = this.doocsPlotAxisY.tickLength + 2;
            ixspace = iyspace / 2;
            this.doocsPlotAxisY.spaceForText = false;
        } else {
            this.doocsPlotAxisY.spaceForText = true;
        }
        if (this.doocsBorder) {
            x0 = 5;
            y0 = 5;
            w -= 5;
            h -= 5;
        } else {
            x0 = 0;
            y0 = 0;
        }
        this.dataAreaX0 = x0 + this.doocsPlotAxisY.tickLength + iyspace;
        if (this.spaceForTitle && this.showTitle) {
            this.dataAreaY0 = y0 + yTitleSpace;
            this.legendPosY = this.dataAreaY0 + 2;
        } else {
            this.dataAreaY0 = y0 + yTitleSpace / 2;
            this.legendPosY = this.dataAreaY0 + 2;
        }
        this.dataAreaX1 = x0 + w - ixspace;
        this.dataAreaY1 = this.doocsPlotAxisX.spaceForText && this.doocsPlotAxisX.showText ? y0 + h - 2 * xScaleFontH - this.doocsPlotAxisX.tickLength : y0 + h - this.doocsPlotAxisX.tickLength - 4;
        this.doocsPlotAxisX.p0X = this.dataAreaX0;
        this.doocsPlotAxisX.p0Y = this.dataAreaY1;
        this.doocsPlotAxisX.p1X = this.dataAreaX1;
        this.doocsPlotAxisX.p1Y = this.dataAreaY1;
        this.doocsPlotAxisX.p2XY = this.dataAreaY0;
        this.doocsPlotAxisX.pixelLength = this.dataAreaX1 - this.dataAreaX0;
        this.doocsPlotAxisY.p0X = this.dataAreaX0;
        this.doocsPlotAxisY.p0Y = this.dataAreaY0;
        this.doocsPlotAxisY.p1X = this.dataAreaX0;
        this.doocsPlotAxisY.p1Y = this.dataAreaY1;
        this.doocsPlotAxisY.p2XY = this.dataAreaX1;
        this.yPosTitle = this.dataAreaY0 - yTitleSpace / 3;
        this.doocsPlotAxisY.pixelLength = this.dataAreaY1 - this.dataAreaY0;
        if (oldX0 != this.dataAreaX0 || oldX1 != this.dataAreaX1 || oldY0 != this.dataAreaY0 || oldY1 != this.dataAreaY1) {
            this.doocsPlotAxisY.roundUp(this.doocsPlotAxisY.actMin, this.doocsPlotAxisY.actMax);
            this.doocsPlotAxisX.roundUp(this.doocsPlotAxisX.actMin, this.doocsPlotAxisX.actMax);
            this.boundsNeedsUpdate = true;
            this.repaint();
        }
        if (this.fastCanvas != null) {
            this.fastCanvas.setBounds(0, 0, this.dataAreaX1 - this.dataAreaX0 - 1, Math.abs(this.dataAreaY0 - this.dataAreaY1) - 1);
        }
        if (!this.initDone) {
            if (this.titleText.length() > 0) {
                this.doocsPlotLegend.setBounds(this.dataAreaX0 + 10, this.legendPosY, 10, 10);
            } else {
                this.doocsPlotLegend.setBounds(this.dataAreaX0 + 30, 2, 10, 10);
            }
            if (gr != null) {
                this.initDone = true;
            }
        }
        this.boundsNeedsUpdate = false;
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        Graphics2D g2d = (Graphics2D)this.getGraphics();
        double xsmin = 0.0;
        double xsmax = 0.0;
        double ysmin = 0.0;
        double ysmax = 0.0;
        this.isMoving = false;
        if (this.isDragging && Math.abs(this.dragX - this.mouseXlast) < 10 && Math.abs(this.dragY - this.mouseYlast) < 10) {
            this.isDragging = false;
        }
        if (!this.isDragging) {
            if (e.getButton() == 3) {
                this.mouseStatusLast = this.pickMouse(e);
                switch (this.mouseStatusLast) {
                    case ONDATA: {
                        DOOCSFindDataPoint dp = new DOOCSFindDataPoint(x, y);
                        this.doocsAdrList.findClosestDataPoint(dp, g2d);
                        x = dp.getX();
                        y = dp.getY();
                        this.selectedChannel = dp.getChannel();
                        this.createMenuChannel();
                        if (this.selectedChannel != null) {
                            this.popupChannelMIAdr.setText(this.selectedChannel.doocsAdr);
                            if (this.popupChannelDaq.isEnabled()) {
                                this.daqAddress = this.selectedChannel.doocsAdr;
                                EqAdr eaa = new EqAdr(this.daqAddress);
                                EqData di = new EqData();
                                eaa.set_property("DAQ_CHANNEL");
                                EqData daqRes = new EqData();
                                this.eq.get(eaa, di, daqRes);
                                this.daqAddress = daqRes.get_string_arg();
                                if (daqRes.error() == 0 && this.daqAddress.length() > 3) {
                                    this.popupChannelDaq.setText("Plot from DAQ: " + this.daqAddress);
                                    this.popupChannelDaq.setEnabled(true);
                                } else {
                                    this.popupChannelDaq.setText("Plot from DAQ: not available");
                                    this.popupChannelDaq.setEnabled(false);
                                }
                            }
                        } else {
                            this.popupChannelMIAdr.setText("Address undefined");
                        }
                        this.popupChannelMIDescr.setText(dp.getDescription());
                        this.popupChannel.show(e.getComponent(), e.getX(), e.getY());
                        break;
                    }
                    case ONSELECTION: {
                        this.createMenuSelection();
                        this.popupSelection.show(e.getComponent(), e.getX(), e.getY());
                        break;
                    }
                    default: {
                        this.createMenuAxis();
                        this.popupAxis.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
                return;
            }
            if (e.getButton() == 2) {
                this.boundsNeedsUpdate = true;
                this.repaint();
            } else if (e.getButton() == 1) {
                this.mouseStatusLast = this.pickMouse(e);
                switch (this.mouseStatusLast) {
                    case ONDATA: 
                    case ONSELECTION: {
                        x = e.getX();
                        y = e.getY();
                        DOOCSFindDataPoint dp = new DOOCSFindDataPoint(x, y);
                        this.doocsAdrList.findClosestDataPoint(dp, g2d);
                        this.mouseCrossXlast = dp.getX();
                        this.mouseCrossYlast = dp.getY();
                        this.cursorTime = System.nanoTime();
                        if (e.getClickCount() > 1) {
                            EqAdr tmpAdr = new EqAdr(dp.adrFullString);
                            tmpAdr.set_location(dp.adrString);
                            if (this.doubleClickPanel.length() > 0) {
                                jddd_run.startPanel(this.doubleClickPanel, tmpAdr.show_adr(), this, this.overridePanel, false, null);
                            } else if (this.doocsAdrList.nChannels > 1) {
                                DOOCSValueShowHist.showHist(tmpAdr.show_adr(), this);
                            } else {
                                JOptionPane.showMessageDialog(this, "No panel defined for: " + dp.adrString);
                            }
                        }
                        this.showToolTip = true;
                        this.showPosition(e, g2d);
                        break;
                    }
                    default: {
                        this.mouseCrossXlast = 0;
                        break;
                    }
                }
            }
        } else {
            this.isDragging = false;
            if (e.getButton() == 1) {
                int dscale;
                int i;
                if (this.dragX > this.mouseXlast) {
                    i = this.dragX;
                    this.dragX = this.mouseXlast;
                    this.mouseXlast = i;
                }
                if (this.mouseXlast > this.doocsPlotAxisX.p0X && this.dragX < this.doocsPlotAxisX.p1X) {
                    dscale = this.doocsPlotAxisX.p1X - this.doocsPlotAxisX.p0X;
                    if (this.dragX < this.mouseXlast) {
                        xsmin = (double)(this.dragX - this.doocsPlotAxisX.p0X) / (double)dscale;
                        xsmax = (double)(this.mouseXlast - this.doocsPlotAxisX.p0X) / (double)dscale;
                    } else {
                        xsmax = (double)(this.dragX - this.doocsPlotAxisX.p0X) / (double)dscale;
                        xsmin = (double)(this.mouseXlast - this.doocsPlotAxisX.p0X) / (double)dscale;
                    }
                    if (!e.isShiftDown()) {
                        this.doocsPlotAxisX.rescaleDrag(xsmin, xsmax);
                        this.doocsPlotAxisX.roundUp(this.doocsPlotAxisX.actMin, this.doocsPlotAxisX.actMax);
                        this.doocsPlotAxisX.autoScale = false;
                    }
                }
                if (this.dragY > this.mouseYlast) {
                    i = this.dragY;
                    this.dragY = this.mouseYlast;
                    this.mouseYlast = i;
                }
                if (this.mouseYlast > this.doocsPlotAxisY.p0Y && this.dragY < this.doocsPlotAxisY.p1Y) {
                    dscale = this.doocsPlotAxisY.p1Y - this.doocsPlotAxisY.p0Y;
                    if (this.dragY > this.mouseYlast) {
                        ysmin = (double)(this.doocsPlotAxisY.p1Y - this.dragY) / (double)dscale;
                        ysmax = (double)(this.doocsPlotAxisY.p1Y - this.mouseYlast) / (double)dscale;
                    } else {
                        ysmax = (double)(this.doocsPlotAxisY.p1Y - this.dragY) / (double)dscale;
                        ysmin = (double)(this.doocsPlotAxisY.p1Y - this.mouseYlast) / (double)dscale;
                    }
                    if (!e.isShiftDown()) {
                        this.doocsPlotAxisY.rescaleDrag(ysmin, ysmax);
                        this.doocsPlotAxisY.roundUp(this.doocsPlotAxisY.actMin, this.doocsPlotAxisY.actMax);
                        this.doocsPlotAxisY.autoScale = false;
                    }
                }
                if (e.isShiftDown()) {
                    this.doocsPlotSelection.setRange(this.mouseXlast, this.mouseYlast, this.dragX, this.dragY, true);
                    this.doocsPlotSelection.setActive(true);
                    this.doocsPlotSelection.setVisible(true);
                }
                this.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
                this.repaint(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        boolean i = true;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        boolean i = true;
    }

    public void showPosition(MouseEvent e, Graphics2D g2d) {
        int x = e.getX();
        int y = e.getY();
        DOOCSFindDataPoint dp = new DOOCSFindDataPoint(x, y);
        this.doocsAdrList.findClosestDataPoint(dp, g2d);
        this.mouseClosestDataX = dp.getX();
        this.mouseClosestDataY = dp.getY();
        this.mouseClosestRealX = dp.dataX;
        this.mouseClosestRealY = dp.dataY;
        this.mouseClosestDataChannel = dp.getChannel();
        if (this.mouseClosestDataX != 0 && this.mouseClosestDataY != 0) {
            if (this.showToolTip) {
                this.setToolTipText(dp.getText());
            }
        } else {
            this.mouseClosestDataX = x;
            this.mouseClosestDataY = y;
            this.mouseClosestRealX = 0.0;
            this.mouseClosestRealY = 0.0;
            this.mouseClosestDataChannel = null;
            if (this.doocsAdrList.list.isEmpty() && this.showToolTip) {
                this.setToolTipText("Undefined address!");
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Graphics2D g2d = (Graphics2D)this.getGraphics();
        this.mouseStatusLast = this.pickMouse(e);
        switch (this.mouseStatusLast) {
            case ONXAXIS: 
            case ONSELECTION_W: 
            case ONSELECTION_E: {
                this.setCursor(this.cursorMoveHor);
                break;
            }
            case ONYAXIS: 
            case ONSELECTION_N: 
            case ONSELECTION_S: {
                this.setCursor(this.cursorMoveVert);
                break;
            }
            case ONLEGEND: {
                this.setCursor(this.cursorMove);
                break;
            }
            case ONSELECTION: {
                this.setCursor(this.cursorMove);
                this.showPosition(e, g2d);
                break;
            }
            case ONDATA: {
                this.setCursor(this.cursorCross);
                if (!this.showToolTip) break;
                this.showPosition(e, g2d);
                break;
            }
            case ONTITLE: {
                this.setCursor(this.cursorCross);
                break;
            }
            case ONDATATIP: {
                this.setCursor(this.cursorCross);
                Point pt = this.doocsAdrList.getDataTipPosition(this.dataTipIndex);
                if (pt != null) {
                    this.mouseClosestDataX = pt.x;
                    this.mouseClosestDataY = pt.y;
                } else {
                    this.mouseClosestDataX = e.getX();
                    this.mouseClosestDataY = e.getY();
                }
                if (!this.showToolTip) break;
                this.setToolTipText(this.doocsAdrList.getDataTipText(this.dataTipIndex));
                break;
            }
            default: {
                this.setToolTipText(null);
                this.setCursor(this.cursorScale);
            }
        }
        this.mouseXlast = this.mouseX;
        this.mouseYlast = this.mouseY;
    }

    @Override
    public Point getToolTipLocation(MouseEvent e) {
        return new Point(this.mouseClosestDataX, this.mouseClosestDataY);
    }

    @Override
    public void setDoocsToolTipText(String ttt) {
    }

    @Override
    public String getDoocsToolTipText() {
        return null;
    }

    public void mergeBaseAdr() {
        String adr = this.doocsAdrList.getFullDoocsAddress();
        this.doocsAdrList.mergeBaseDoocsAddress(adr);
        if (this.doocsRefChannels != null) {
            this.doocsRefChannels.mergeBaseAdr(adr);
        }
    }

    @Override
    public void setFullDoocsAddress(String address) {
        this.doocsAdrList.setFullDoocsAddress(address);
    }

    @Override
    public String getFullDoocsAddress() {
        return this.doocsAdrList.getFullDoocsAddress();
    }

    public void setDoocsRefAdr(String adr) {
        if (adr != null && adr.compareTo(this.doocsRefAdr) != 0) {
            this.doocsRefAdr = adr;
            this.doocsRefChannels = new DOOCSChannelList(this, this.doocsRefAdr, true);
            this.doocsRefChannels.channels.get((int)0).isRefChannel = true;
            this.doocsRefChannels.channels.get(0).init();
        }
    }

    public String getDoocsRefAdr() {
        return this.doocsRefAdr;
    }

    public void setSysMask(int msk) {
        this.sysMask = msk;
    }

    public int getSysMask() {
        return this.sysMask;
    }

    public void setShowDataTip(boolean b) {
        this.showDataTip = b;
    }

    public boolean getShowDataTip() {
        return this.showDataTip;
    }

    public void setDoubleClickPanel(String p) {
        this.doubleClickPanel = p;
    }

    public String getDoubleClickPanel() {
        return this.doubleClickPanel;
    }

    public void setOverridePanel(boolean o) {
        this.overridePanel = o;
    }

    public boolean getOverridePanel() {
        return this.overridePanel;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        MouseStatus msts;
        MouseStatus psts = this.pickMouse(e);
        if (this.isDragging) {
            msts = MouseStatus.OUTSIDE;
        } else {
            MouseStatus mouseStatus = msts = this.mouseStatusLast != MouseStatus.OUTSIDE ? this.mouseStatusLast : psts;
        }
        if (!this.isMoving) {
            this.dragX = this.mouseXlast;
            this.dragY = this.mouseYlast;
            this.isMoving = true;
        }
        int dxMouseAbs = this.mouseX - this.dragX;
        int dyMouseAbs = this.dragY - this.mouseY;
        int dxMouse = this.mouseX - this.mouseXlast;
        int dyMouse = this.mouseYlast - this.mouseY;
        switch (msts) {
            case ONXAXIS: {
                int dscale = this.doocsPlotAxisX.p1X - this.doocsPlotAxisX.p0X;
                if (Math.abs(dxMouseAbs) <= dscale / 10) break;
                if (this.doocsPlotAxisX.isLog) {
                    if (dxMouseAbs > 0) {
                        this.doocsPlotAxisX.setScale(this.doocsPlotAxisX.actMin / 10.0, this.doocsPlotAxisX.actMax * 10.0);
                    } else {
                        this.doocsPlotAxisX.setScale(this.doocsPlotAxisX.actMin * 10.0, this.doocsPlotAxisX.actMax / 10.0);
                    }
                } else {
                    double del = dxMouseAbs > 0 ? this.doocsPlotAxisX.delMajor : -this.doocsPlotAxisX.delMajor;
                    this.doocsPlotAxisX.setScale(this.doocsPlotAxisX.actMin + del, this.doocsPlotAxisX.actMax + del);
                }
                this.doocsPlotAxisX.autoScale = false;
                this.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
                this.dragX = this.mouseX;
                break;
            }
            case ONYAXIS: {
                int dscale = this.doocsPlotAxisY.p1Y - this.doocsPlotAxisY.p0Y;
                if (Math.abs(dyMouseAbs) <= dscale / 10) break;
                if (this.doocsPlotAxisY.isLog) {
                    if (dyMouseAbs > 0) {
                        this.doocsPlotAxisY.setScale(this.doocsPlotAxisY.actMin * 10.0, this.doocsPlotAxisY.actMax * 10.0);
                    } else {
                        this.doocsPlotAxisY.setScale(this.doocsPlotAxisY.actMin / 10.0, this.doocsPlotAxisY.actMax / 10.0);
                    }
                } else {
                    double del = dyMouseAbs > 0 ? this.doocsPlotAxisY.delMajor : -this.doocsPlotAxisY.delMajor;
                    this.doocsPlotAxisY.setScale(this.doocsPlotAxisY.actMin + del, this.doocsPlotAxisY.actMax + del);
                }
                this.doocsPlotAxisY.autoScale = false;
                this.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
                this.repaint(this.getX(), this.getY(), this.getWidth(), this.getHeight());
                this.dragY = this.mouseY;
                break;
            }
            case ONLEGEND: {
                int iLy;
                int iLx = this.doocsPlotLegend.getX() + dxMouse;
                if (iLx > this.getBounds().width - 10) {
                    iLx = this.getBounds().width - 10;
                }
                if (iLx < -this.doocsPlotLegend.getWidth() + 10) {
                    iLx = -this.doocsPlotLegend.getWidth() + 10;
                }
                if ((iLy = this.doocsPlotLegend.getY() - dyMouse) > this.getBounds().height - 10) {
                    iLy = this.getBounds().height - 10;
                }
                if (iLy < -this.doocsPlotLegend.getHeight() + 10) {
                    iLy = -this.doocsPlotLegend.getHeight() + 10;
                }
                this.doocsPlotLegend.setBounds(iLx, iLy, this.doocsPlotLegend.getWidth(), this.doocsPlotLegend.getHeight());
                this.repaint(this.getBounds());
                break;
            }
            case ONSELECTION: 
            case ONSELECTION_W: 
            case ONSELECTION_E: 
            case ONSELECTION_N: 
            case ONSELECTION_S: {
                if (dxMouseAbs == 0 && dyMouseAbs == 0) {
                    return;
                }
                int iy = this.doocsPlotSelection.getYMinAbs();
                int ix = this.doocsPlotSelection.getXMinAbs();
                int ix2 = this.doocsPlotSelection.getXMaxAbs();
                int iy2 = this.doocsPlotSelection.getYMaxAbs();
                switch (msts) {
                    case ONSELECTION: {
                        this.doocsPlotSelection.setRange(ix + dxMouseAbs, iy - dyMouseAbs, ix2 + dxMouseAbs, iy2 - dyMouseAbs, false);
                        break;
                    }
                    case ONSELECTION_N: {
                        this.doocsPlotSelection.setRange(ix, iy, ix2, iy2 - dyMouseAbs, false);
                        break;
                    }
                    case ONSELECTION_S: {
                        this.doocsPlotSelection.setRange(ix, iy - dyMouseAbs, ix2, iy2, false);
                        break;
                    }
                    case ONSELECTION_W: {
                        this.doocsPlotSelection.setRange(ix + dxMouseAbs, iy, ix2, iy2, false);
                        break;
                    }
                    case ONSELECTION_E: {
                        this.doocsPlotSelection.setRange(ix, iy, ix2 + dxMouseAbs, iy2, false);
                    }
                }
                if (this.destinationPlot != null) {
                    this.destinationPlot.forceRecalc();
                }
                this.dragX = this.mouseX;
                this.dragY = this.mouseY;
                this.repaint();
                break;
            }
            default: {
                Graphics gr = this.getGraphics();
                gr.setXORMode(Color.PINK);
                if (this.isDragging) break;
                this.dragX = this.mouseXlast;
                this.dragY = this.mouseYlast;
                this.isDragging = true;
            }
        }
        this.mouseXlast = this.mouseX;
        this.mouseYlast = this.mouseY;
        this.repaint();
    }

    public void init() {
        this.doocsAdrList.init();
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("sysMask", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("updateTime", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("titleText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("titleFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("titleColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("legendFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scaleColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bgColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bgTransparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("border", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("fill", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE), new DOOCSParameter("showTitle", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("showLegend", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("fastDrawMode", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("overwriteMode", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("showDataTip", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("doubleClickPanel", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("overridePanel", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL, "<html>override an existing \"doubleClickPanel\"<br>or open a new panel</html>")};
        return parameters;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        return null;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter == null || value == null) {
            return;
        }
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("refAdr")) {
            this.setDoocsRefAdr(value);
        } else if (parameter.equalsIgnoreCase("sysMask")) {
            if (value.startsWith("0x")) {
                this.setSysMask(IntegerParser.parseInt(value.substring(2), 16));
            } else {
                this.setSysMask(IntegerParser.parseInt(value));
            }
        } else if (parameter.equalsIgnoreCase("updateTime")) {
            this.setDoocsUpdateTime(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("titleText")) {
            this.setTitle(value);
        } else if (parameter.equalsIgnoreCase("titleFont")) {
            this.titleFont = DOOCSParameter.convertToFont(value);
            this.setFont(DOOCSParameter.convertToFont(value));
        } else if (parameter.equalsIgnoreCase("legendFont")) {
            this.doocsPlotLegend.setFont(DOOCSParameter.convertToFont(value));
        } else if (parameter.equalsIgnoreCase("titleColor")) {
            this.setTitleColor(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("scaleColor")) {
            this.setForeground(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("bgColor")) {
            this.setBackground(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("bgTransparent")) {
            this.setOpaque(!Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("border")) {
            this.setDoocsBorder(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("showTitle")) {
            this.setShowTitle(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("showLegend")) {
            this.setShowLegend(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("fastDrawMode")) {
            this.setFastDrawMode(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("overwriteMode")) {
            this.setOverwriteMode(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("showDataTip")) {
            this.setShowDataTip(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("doubleClickPanel")) {
            this.setDoubleClickPanel(value);
        } else if (parameter.equalsIgnoreCase("overridePanel")) {
            this.setOverridePanel(Boolean.parseBoolean(value));
        }
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("sysMask")) {
            return this.getSysMask();
        }
        if (parameter.equalsIgnoreCase("refAdr")) {
            return this.getDoocsRefAdr();
        }
        if (parameter.equalsIgnoreCase("updateTime")) {
            return Float.valueOf(this.getDoocsUpdateTime());
        }
        if (parameter.equalsIgnoreCase("titleText")) {
            return this.getTitle();
        }
        if (parameter.equalsIgnoreCase("titleFont")) {
            return DOOCSParameter.getDoocsFont(this.getFont());
        }
        if (parameter.equalsIgnoreCase("titleColor")) {
            return DOOCSParameter.getDoocsColor(this.getTitleColor());
        }
        if (parameter.equalsIgnoreCase("legendFont")) {
            return DOOCSParameter.getDoocsFont(this.doocsPlotLegend.getFont());
        }
        if (parameter.equalsIgnoreCase("scaleColor")) {
            return DOOCSParameter.getDoocsColor(this.getForeground());
        }
        if (parameter.equalsIgnoreCase("bgColor")) {
            return DOOCSParameter.getDoocsColor(this.getBackground());
        }
        if (parameter.equalsIgnoreCase("bgTransparent")) {
            return !this.isOpaque();
        }
        if (parameter.equalsIgnoreCase("border")) {
            return this.getDoocsBorder();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("fill")) {
            return this.getDoocsFill();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        if (parameter.equalsIgnoreCase("showTitle")) {
            return this.getShowTitle();
        }
        if (parameter.equalsIgnoreCase("showLegend")) {
            return this.getShowLegend();
        }
        if (parameter.equalsIgnoreCase("fastDrawMode")) {
            return this.getFastDrawMode();
        }
        if (parameter.equalsIgnoreCase("overwriteMode")) {
            return this.getOverwriteMode();
        }
        if (parameter.equalsIgnoreCase("showDataTip")) {
            return this.getShowDataTip();
        }
        if (parameter.equalsIgnoreCase("doubleClickPanel")) {
            return this.getDoubleClickPanel();
        }
        if (parameter.equalsIgnoreCase("overridePanel")) {
            return this.getOverridePanel();
        }
        return null;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        if (parameter.startsWith("lineStyle")) {
            String[] allowedValues = new String[]{"NoLine", "Line", "LineFilled", "Bar", "BarFilled", "VarBar"};
            return allowedValues;
        }
        if (parameter.startsWith("lineMark")) {
            String[] allowedValues = new String[]{"None", "Dot", "Cross", "CrossSmall", "Square", "Cross45", "Circle", "Triangle", "Diamond"};
            return allowedValues;
        }
        String[] allowedValues = new String[]{"ill.ParameterName"};
        return allowedValues;
    }

    @Override
    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.m_DOOCSMouse = ml;
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((DOOCSComponent)((Object)this.getComponent(i))).addDOOCSMouseListener(ml);
        }
    }

    public void addDOOCSMouseMotionListener() {
    }

    @Override
    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        if (bRun) {
            this.startThreads();
        } else {
            this.stopThreads();
        }
    }

    @Override
    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    public void setTitle(String txt) {
        this.titleText = txt;
        if (txt != null) {
            if (txt.length() > 0) {
                if (this.doocsPlotLegend.getBounds().y == 2) {
                    this.doocsPlotLegend.setBounds(this.doocsPlotLegend.getBounds().x, this.legendPosY, this.doocsPlotLegend.getBounds().width, this.doocsPlotLegend.getBounds().height);
                }
            } else if (this.doocsPlotLegend.getBounds().y == this.legendPosY) {
                this.doocsPlotLegend.setBounds(this.doocsPlotLegend.getBounds().x, 2, this.doocsPlotLegend.getBounds().width, this.doocsPlotLegend.getBounds().height);
            }
        }
    }

    public String getTitle() {
        return this.titleText;
    }

    public void setTitleColor(Color col) {
        this.titleColor = col;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    @Override
    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    @Override
    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    @Override
    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    @Override
    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    @Override
    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    @Override
    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    public void setShowTitle(boolean show) {
        this.showTitle = show;
    }

    public boolean getShowTitle() {
        return this.showTitle;
    }

    public void setShowLegend(boolean show) {
        this.doocsPlotLegend.setVisible(show);
    }

    public boolean getShowLegend() {
        return this.doocsPlotLegend.isVisible();
    }

    public void setDoocsFill(boolean f) {
        this.doocsFill = f;
    }

    public boolean getDoocsFill() {
        return this.doocsFill;
    }

    public void setDoocsUpdateTime(float time) {
        this.doocsUpdateTime = time;
    }

    public float getDoocsUpdateTime() {
        return this.doocsUpdateTime;
    }

    public void setDoocsBorder(boolean border) {
        this.doocsBorder = border;
        if (border) {
            this.setBorder(BorderFactory.createBevelBorder(1));
        } else {
            this.setBorder(null);
        }
    }

    public boolean getDoocsBorder() {
        return this.doocsBorder;
    }

    @Override
    public String getDnDText() {
        return this.selectedChannel.doocsAdr;
    }

    @Override
    public void setDnDText(String str) {
        this.doocsAdrList.addFullAdr(str);
    }

    public MouseStatus pickMouse(MouseEvent e) {
        double sy2;
        double sx2;
        int x = e.getX();
        int y = e.getY();
        this.mouseX = x;
        this.mouseY = y;
        if (!e.getComponent().getClass().isInstance(this)) {
            return MouseStatus.OUTSIDE;
        }
        DOOCSPlot p = (DOOCSPlot)e.getComponent();
        double lx1 = this.doocsPlotLegend.getBounds().getX();
        double lx2 = lx1 + this.doocsPlotLegend.getBounds().getWidth();
        double ly1 = this.doocsPlotLegend.getBounds().getY();
        double ly2 = ly1 + this.doocsPlotLegend.getBounds().getHeight();
        double sx1 = this.doocsPlotSelection.getXMinAbs();
        if (sx1 < (double)p.doocsPlotAxisX.p0X) {
            sx1 = p.doocsPlotAxisX.p0X;
        }
        if ((sx2 = (double)this.doocsPlotSelection.getXMaxAbs()) > (double)p.doocsPlotAxisX.p1X) {
            sx2 = p.doocsPlotAxisX.p1X;
        }
        double sy1 = this.doocsPlotSelection.getYMinAbs();
        double sty = sy2 = (double)this.doocsPlotSelection.getYMaxAbs();
        if (sy2 < sy1) {
            sy2 = sy1;
            sy1 = sty;
        }
        if (sy1 != 0.0 && sy1 < (double)p.doocsPlotAxisY.p0Y) {
            sy1 = p.doocsPlotAxisY.p0Y;
        }
        if (sy1 != 0.0 && sy2 > (double)p.doocsPlotAxisY.p1Y) {
            sy2 = p.doocsPlotAxisY.p1Y;
        }
        if (y > p.doocsPlotAxisX.p0Y && y < p.doocsPlotAxisX.p0Y + p.doocsPlotAxisX.tickLength) {
            return MouseStatus.ONXAXIS;
        }
        if (x < p.doocsPlotAxisY.p0X && x > p.doocsPlotAxisY.p0X - p.doocsPlotAxisY.tickLength) {
            return MouseStatus.ONYAXIS;
        }
        if (this.doocsPlotLegend.isVisible() && (double)x > lx1 && (double)x < lx2 && (double)y > ly1 && (double)y < ly2) {
            return MouseStatus.ONLEGEND;
        }
        if (this.doocsPlotSelection.isVisible() && (double)x > sx1 && (double)x < sx2 && (double)y > sy1 && (double)y < sy2) {
            if ((double)y > sy2 - (double)this.selectionPixels) {
                return MouseStatus.ONSELECTION_N;
            }
            if ((double)y < sy1 + (double)this.selectionPixels) {
                return MouseStatus.ONSELECTION_S;
            }
            if ((double)x < sx1 + (double)this.selectionPixels) {
                return MouseStatus.ONSELECTION_W;
            }
            if ((double)x > sx2 - (double)this.selectionPixels) {
                return MouseStatus.ONSELECTION_E;
            }
            return MouseStatus.ONSELECTION;
        }
        if (this.getShowDataTip() && (this.dataTipIndex = this.doocsAdrList.isOnDataTip(x, y)) >= 0) {
            return MouseStatus.ONDATATIP;
        }
        if (x > p.dataAreaX0 && x < p.dataAreaX1 && y > p.dataAreaY0 && y < p.dataAreaY1) {
            return MouseStatus.ONDATA;
        }
        if (x > p.dataAreaX0 && x < p.dataAreaX1 && y < p.dataAreaY0) {
            return MouseStatus.ONTITLE;
        }
        return MouseStatus.OUTSIDE;
    }

    public void drawRectRubberband(Graphics gr, int x0, int y0, int x1, int y1) {
        int ix = x0 < x1 ? x0 : x1;
        int iy = y0 < y1 ? y0 : y1;
        gr.drawRect(ix, iy, Math.abs(x1 - x0), Math.abs(y1 - y0));
    }

    public void forceRecalc() {
        this.recalcFlag = true;
    }

    @Override
    public void run() {
        int dummy = 0;
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.doocsRefChannels != null) {
            this.doocsRefChannels.channels.get((int)0).isRefChannel = true;
        }
        while (!this.stop) {
            if (!this.doocsRunMode) continue;
            if (this.eq == null) {
                this.eq = new EqCall();
            }
            if (this.debugCounter != 0) {
                boolean i = true;
                continue;
            }
            ++this.debugCounter;
            if (!this.isDragging && (double)this.doocsUpdateTime >= 0.1) {
                if (this.doocsRefChannels != null) {
                    this.doocsRefChannels.channels.get(0).update();
                }
                dummy = 0;
                boolean flag = this.doocsAdrList.update();
                if (flag) {
                    dummy = 1;
                    flag = false;
                    if (this.doocsPlotAxisX.autoScale && (flag = this.autoScaleX())) {
                        dummy += 2;
                    }
                    if (this.doocsPlotAxisY.autoScale && (flag |= this.autoScaleY())) {
                        dummy += 4;
                    }
                    if (flag) {
                        this.boundsNeedsUpdate = true;
                        this.repaint();
                    }
                }
            }
            this.debugCounter = 0;
            try {
                if ((double)this.doocsUpdateTime < 0.1) {
                    Thread.sleep(300L + 3L * this.drawTimeMs);
                    continue;
                }
                Thread.sleep((long)(this.doocsUpdateTime * 1000.0f) + 3L * this.drawTimeMs);
            }
            catch (InterruptedException e) {
                System.out.println(e);
            }
        }
    }

    public boolean autoScaleX() {
        boolean flag;
        if (this.doocsRefChannels != null) {
            double old1 = this.doocsPlotAxisX.actMin;
            double old2 = this.doocsPlotAxisX.actMax;
            if (!this.doocsPlotAxisX.isTimeScale) {
                this.doocsPlotAxisX.actMin = 1.0E21;
                this.doocsPlotAxisX.actMax = -1.0E21;
            }
            this.doocsRefChannels.channels.get(0).autoScaleX(this.doocsPlotAxisX, this.doocsPlotAxisY);
            if (this.doocsPlotAxisX.actMin >= 1.0E21) {
                this.doocsPlotAxisX.actMin = this.doocsPlotAxisX.defaultMin;
            }
            if (this.doocsPlotAxisX.actMax <= -1.0E21) {
                this.doocsPlotAxisX.actMax = this.doocsPlotAxisX.defaultMax;
            }
            if (this.doocsPlotAxisX.actMin < this.doocsPlotAxisX.limitMin) {
                this.doocsPlotAxisX.actMin = this.doocsPlotAxisX.limitMin;
            }
            if (this.doocsPlotAxisX.actMax > this.doocsPlotAxisX.limitMax) {
                this.doocsPlotAxisX.actMax = this.doocsPlotAxisX.limitMax;
            }
            this.doocsPlotAxisX.roundUp(this.doocsPlotAxisX.actMin, this.doocsPlotAxisX.actMax);
            flag = old1 != this.doocsPlotAxisX.actMin || old2 != this.doocsPlotAxisX.actMax;
        } else {
            flag = this.doocsAdrList.autoScaleX(this.doocsPlotAxisX, this.doocsPlotAxisY);
        }
        return flag;
    }

    public boolean autoScaleY() {
        boolean flag = this.doocsAdrList.autoScaleY(this.doocsPlotAxisX, this.doocsPlotAxisY);
        return flag;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        int x = 0;
        int y = 0;
        int width = this.getSize().width;
        int height = this.getSize().height;
        Rectangle clip = g.getClipBounds();
        boolean bl = this.doAll = clip.width == width && clip.height == height;
        if (this.boundsNeedsUpdate) {
            this.setBounds();
            this.doAll = true;
        }
        AffineTransform saveTransform = g2d.getTransform();
        if (this.isOpaque()) {
            g2d.setColor(this.getBackground());
            g2d.fillRect(x, y, width, height);
        }
        g2d.setColor(this.getForeground());
        this.doocsPlotAxisX.paintComponent(g);
        this.doocsPlotAxisY.paintComponent(g);
        long t1 = System.nanoTime();
        if (this.fastCanvas != null) {
            this.fastCanvas.drawCanvas(g, this.dataAreaX0 + 1, this.dataAreaY0 + 1, this);
        }
        this.doocsAdrList.paintComponent(g, this.doocsPlotAxisX, this.doocsPlotAxisY);
        long t2 = System.nanoTime();
        this.drawTimeMs = (t2 - t1) / 1000000L;
        if (this.drawTimeMs > 500L) {
            g2d.setColor(Color.RED);
            g2d.drawString("T=" + this.drawTimeMs, 10, height);
        }
        g2d.setColor(this.getTitleColor());
        g2d.setTransform(saveTransform);
        g2d.setFont(this.doocsPlotAxisY.getFont());
        if (this.spaceForTitle && this.showTitle) {
            int e1 = this.doocsAdrList.paintEGU(g2d, 0, this.yPosTitle, width, this.dataAreaY0) + 10;
            g2d.setFont(this.titleFont);
            int w1 = g2d.getFontMetrics().stringWidth(this.titleText);
            int b2 = (this.dataAreaX0 + this.dataAreaX1 - w1) / 2;
            int tPos = Math.max(e1, b2);
            g2d.drawString(this.titleText, tPos, this.yPosTitle);
        }
        if (this.doocsPlotLegend.isVisible()) {
            this.doocsPlotLegend.paintComponent(g);
        }
        if (this.doocsPlotSelection.isActive()) {
            if (this.doocsPlotSelection.isVisible()) {
                this.doocsPlotSelection.paintComponent(g);
            }
            this.doocsAdrList.paintMathFct(g, this.doocsPlotAxisX, this.doocsPlotAxisY);
        }
        if (this.dragX != 0 && this.isDragging) {
            g2d.setStroke(new BasicStroke());
            this.drawRectRubberband(g, this.dragX, this.dragY, this.mouseX, this.mouseY);
        }
    }

    @Override
    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        return change;
    }

    public DOOCSPlotCanvas getCanvas() {
        return this.fastCanvas;
    }

    public boolean getFastDrawMode() {
        return this.fastCanvas != null;
    }

    public void setFastDrawMode(boolean fm) {
        if (fm && this.fastCanvas == null) {
            this.fastCanvas = new DOOCSPlotCanvas(this.dataAreaX1 - this.dataAreaX0, Math.abs(this.dataAreaY0 - this.dataAreaY1), Color.CYAN, this.overwriteMode, this);
        } else if (!fm && this.fastCanvas != null) {
            this.fastCanvas = null;
        }
    }

    public boolean getOverwriteMode() {
        return this.overwriteMode;
    }

    public void setOverwriteMode(boolean om) {
        if (om) {
            this.setFastDrawMode(true);
        }
        this.overwriteMode = om;
    }

    public double selectionYMin() {
        if (this.doocsPlotSelection.isVisible()) {
            return this.doocsPlotSelection.getYMin();
        }
        return this.doocsPlotAxisY.getMin();
    }

    public double selectionYMax() {
        if (this.doocsPlotSelection.isVisible()) {
            return this.doocsPlotSelection.getYMax();
        }
        return this.doocsPlotAxisY.getMax();
    }

    public double selectionXMin() {
        if (this.doocsPlotSelection.isVisible()) {
            return this.doocsPlotSelection.getXMin();
        }
        return this.doocsPlotAxisX.getMin();
    }

    public double selectionXMax() {
        if (this.doocsPlotSelection.isVisible()) {
            return this.doocsPlotSelection.getXMax();
        }
        return this.doocsPlotAxisX.getMax();
    }

    private void createMathActionListener() {
        final DOOCSPlot pl = this;
        this.mathActListner = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String str = e.getActionCommand();
                if (!DOOCSPlot.this.doocsPlotSelection.isActive()) {
                    DOOCSPlot.this.doocsPlotSelection.setRange(pl.doocsPlotAxisX.p0X, pl.doocsPlotAxisY.p0Y, pl.doocsPlotAxisX.p1X, pl.doocsPlotAxisY.p1Y, true);
                    DOOCSPlot.this.doocsPlotSelection.setActive(true);
                    DOOCSPlot.this.doocsPlotSelection.setVisible(true);
                }
                if (str.startsWith("RMS")) {
                    DOOCSPlot.this.doocsPlotSelection.setMathFct(DOOCSPlotSelection.MathType.RMS);
                } else if (str.startsWith("Off")) {
                    DOOCSPlot.this.doocsPlotSelection.setMathFct(DOOCSPlotSelection.MathType.NULL);
                    DOOCSPlot.this.doocsPlotSelection.setActive(false);
                } else if (str.startsWith("Mean")) {
                    DOOCSPlot.this.doocsPlotSelection.setMathFct(DOOCSPlotSelection.MathType.MEAN);
                } else if (str.startsWith("MinMax")) {
                    DOOCSPlot.this.doocsPlotSelection.setMathFct(DOOCSPlotSelection.MathType.MINMAX);
                } else if (str.startsWith("Fit Line")) {
                    DOOCSPlot.this.doocsPlotSelection.setMathFct(DOOCSPlotSelection.MathType.FITLINE);
                } else if (str.startsWith("Set global Time Range")) {
                    DOOCSPlot.this.doocsPlotSelection.setGlobalTimeRange();
                } else if (str.startsWith("Set global Range of Samples")) {
                    DOOCSPlot.this.doocsPlotSelection.setGlobalSpectRange();
                } else if (str.startsWith("Fourier Transform")) {
                    DOOCSPlot.this.destinationPlot = new DOOCSPlotRefDFT(pl);
                    DOOCSPlot.this.destinationPlot.doocsPlotAxisX.autoScale = true;
                    DOOCSPlot.this.destinationPlot.doocsPlotAxisY.autoScale = true;
                    DOOCSPlot.this.destinationPlot.setTitle("Amplitude Spectrum");
                    JFrame tcomp = DOOCSParameter.getParentFrame(pl);
                    final JFrame frame = new JFrame();
                    frame.setDefaultCloseOperation(2);
                    frame.setLocation(tcomp.getX() + pl.getX() + 50, tcomp.getY() + pl.getY() + 50);
                    frame.setTitle("Fourier Transform");
                    Dimension d = new Dimension(DOOCSPlot.this.defaultWidth, DOOCSPlot.this.defaultHeight);
                    DOOCSPlot.this.destinationPlot.setSize(d);
                    DOOCSPlot.this.destinationPlot.setPreferredSize(d);
                    DOOCSPlot.this.destinationPlot.setMinimumSize(d);
                    frame.setMinimumSize(d);
                    frame.setSize(d);
                    final DOOCSLayeredPane panel = new DOOCSLayeredPane();
                    panel.setLayout(new ScaleLayout(d));
                    panel.setSize(d);
                    panel.setPreferredSize(d);
                    ScaleConstraints newConstraints = new ScaleConstraints(0, 0, DOOCSPlot.this.defaultWidth, DOOCSPlot.this.defaultHeight);
                    panel.add((Component)DOOCSPlot.this.destinationPlot, newConstraints);
                    frame.add(panel);
                    panel.setRunMode(true);
                    frame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent evt) {
                            panel.setRunMode(false);
                        }
                    });
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            frame.pack();
                            frame.setVisible(true);
                            DOOCSPlot.this.destinationPlot.destinationPlotUpdate = true;
                        }
                    });
                } else if (str.startsWith("Histogram")) {
                    DOOCSPlot.this.destinationPlot = new DOOCSPlotRefHistgram(pl);
                    DOOCSPlot.this.destinationPlot.doocsPlotAxisX.autoScale = true;
                    DOOCSPlot.this.destinationPlot.doocsPlotAxisY.autoScale = true;
                    DOOCSPlot.this.destinationPlot.doocsPlotAxisX.actMin = DOOCSPlot.this.selectionYMin();
                    DOOCSPlot.this.destinationPlot.doocsPlotAxisX.actMax = DOOCSPlot.this.selectionYMax();
                    JFrame tcomp = DOOCSParameter.getParentFrame(pl);
                    final JFrame frame = new JFrame();
                    frame.setDefaultCloseOperation(2);
                    frame.setLocation(tcomp.getX() + pl.getX() + 50, tcomp.getY() + pl.getY() + 50);
                    frame.setTitle("Histogram");
                    Dimension d = new Dimension(DOOCSPlot.this.defaultWidth, DOOCSPlot.this.defaultHeight);
                    DOOCSPlot.this.destinationPlot.setSize(d);
                    DOOCSPlot.this.destinationPlot.setPreferredSize(d);
                    DOOCSPlot.this.destinationPlot.setMinimumSize(d);
                    frame.setMinimumSize(d);
                    frame.setSize(d);
                    final DOOCSLayeredPane panel = new DOOCSLayeredPane();
                    panel.setLayout(new ScaleLayout(d));
                    panel.setSize(d);
                    panel.setPreferredSize(d);
                    ScaleConstraints newConstraints = new ScaleConstraints(0, 0, DOOCSPlot.this.defaultWidth, DOOCSPlot.this.defaultHeight);
                    panel.add((Component)DOOCSPlot.this.destinationPlot, newConstraints);
                    frame.add(panel);
                    panel.setRunMode(true);
                    frame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent evt) {
                            panel.setRunMode(false);
                        }
                    });
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            frame.pack();
                            frame.setVisible(true);
                            DOOCSPlot.this.destinationPlot.destinationPlotUpdate = true;
                        }
                    });
                }
            }
        };
    }

    private void createMenuAxis() {
        final DOOCSPlot pl = this;
        this.popupAxis = new JPopupMenu();
        this.popupAxis.setName("Scale Menu");
        ImageIcon autoScaleIcon = new ImageIcon(this.getClass().getResource("icons/autoscale.gif"));
        JMenuItem mi = new JMenuItem("Auto Scale", autoScaleIcon);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean flag = DOOCSPlot.this.autoScaleX();
                DOOCSPlot.this.doocsPlotAxisX.autoScale = true;
                DOOCSPlot.this.doocsPlotAxisY.autoScale = true;
                if (flag |= DOOCSPlot.this.autoScaleY()) {
                    DOOCSPlot.this.boundsNeedsUpdate = true;
                    DOOCSPlot.this.repaint();
                }
            }
        });
        this.popupAxis.add(mi);
        autoScaleIcon = new ImageIcon(this.getClass().getResource("icons/autoscaleY.gif"));
        mi = new JMenuItem("Auto Scale Y", autoScaleIcon);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean flag = DOOCSPlot.this.autoScaleY();
                DOOCSPlot.this.doocsPlotAxisY.autoScale = true;
                if (flag) {
                    DOOCSPlot.this.boundsNeedsUpdate = true;
                    DOOCSPlot.this.repaint();
                }
            }
        });
        this.popupAxis.add(mi);
        autoScaleIcon = new ImageIcon(this.getClass().getResource("icons/allX2this.gif"));
        mi = new JMenuItem("All X to this X", autoScaleIcon);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String xStr = String.format("%g %g", pl.doocsPlotAxisX.actMin, pl.doocsPlotAxisX.actMax);
                DOOCSParameter.setInAll(null, pl.getClass().getName(), "xMinMax", xStr);
            }
        });
        this.popupAxis.add(mi);
        ImageIcon plotScalesIcon = new ImageIcon(this.getClass().getResource("icons/plotscales.gif"));
        mi = new JMenuItem("Attribute Panel", plotScalesIcon);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DOOCSPlotContextMenu doocsContextMenu = new DOOCSPlotContextMenu(pl);
                doocsContextMenu.setDefaultCloseOperation(2);
                doocsContextMenu.setVisible(true);
            }
        });
        this.popupAxis.add(mi);
        mi = new JMenuItem("Print Panel...");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame tcomp = DOOCSParameter.getParentFrame(pl);
                PrintUtilities.printComponent(tcomp);
            }
        });
        this.popupAxis.add(mi);
        ImageIcon updateIcon = new ImageIcon(this.getClass().getResource("icons/update.gif"));
        mi = new JMenuItem("Update", updateIcon);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DOOCSPlot.this.doocsAdrList.update();
                DOOCSPlot.this.setBounds(pl.getX(), pl.getY(), pl.getWidth(), pl.getHeight());
                DOOCSPlot.this.repaint();
                if (DOOCSPlot.this.destinationPlot != null) {
                    DOOCSPlot.this.destinationPlotUpdate = true;
                }
            }
        });
        this.popupAxis.add(mi);
        ImageIcon dataTipIcon = new ImageIcon(this.getClass().getResource("icons/dataTip16.gif"));
        JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem("Show Data Tip's", dataTipIcon);
        cbmi.setState(this.getShowDataTip());
        cbmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DOOCSPlot.this.setShowDataTip(((JCheckBoxMenuItem)e.getSource()).getState());
            }
        });
        this.popupAxis.add(cbmi);
        ImageIcon toolTipIcon = new ImageIcon(this.getClass().getResource("icons/toolTip16.gif"));
        JCheckBoxMenuItem cbmi2 = new JCheckBoxMenuItem("Show Tool Tip", toolTipIcon);
        cbmi2.setState(this.showToolTip);
        cbmi2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean bl = DOOCSPlot.this.showToolTip = !DOOCSPlot.this.showToolTip;
                if (!DOOCSPlot.this.showToolTip) {
                    DOOCSPlot.this.toolTip.setToolTipText(null);
                }
            }
        });
        this.popupAxis.add(cbmi2);
        ImageIcon legendIcon = new ImageIcon(this.getClass().getResource("icons/legendIcon.gif"));
        cbmi = new JCheckBoxMenuItem("Show Legend", legendIcon);
        cbmi.setState(this.getShowLegend());
        cbmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean flag = ((JCheckBoxMenuItem)e.getSource()).getState();
                DOOCSPlot.this.setShowLegend(flag);
            }
        });
        this.popupAxis.add(cbmi);
        JMenu updateSubmenu = new JMenu("Update Time");
        ActionListener usal = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String str = e.getActionCommand();
                if (str.startsWith("Off")) {
                    pl.setDOOCSParameter("updateTime", "0");
                } else if (str.startsWith("10")) {
                    pl.setDOOCSParameter("updateTime", "10");
                } else if (str.startsWith("3")) {
                    pl.setDOOCSParameter("updateTime", "3");
                } else if (str.startsWith("1")) {
                    pl.setDOOCSParameter("updateTime", "1");
                } else if (str.startsWith("0.3")) {
                    pl.setDOOCSParameter("updateTime", "0.3");
                } else if (str.startsWith("0.1")) {
                    pl.setDOOCSParameter("updateTime", "0.1");
                }
                if (str.startsWith("Off")) {
                    if (DOOCSPlot.this.destinationPlot != null) {
                        DOOCSPlot.this.destinationPlotUpdate = false;
                    }
                } else if (DOOCSPlot.this.destinationPlot != null) {
                    DOOCSPlot.this.destinationPlotUpdate = true;
                }
            }
        };
        JMenuItem usi = new JMenuItem("Off");
        usi.addActionListener(usal);
        updateSubmenu.add(usi);
        usi = new JMenuItem("10 sec");
        usi.addActionListener(usal);
        updateSubmenu.add(usi);
        usi = new JMenuItem("3 sec");
        usi.addActionListener(usal);
        updateSubmenu.add(usi);
        usi = new JMenuItem("1 sec");
        usi.addActionListener(usal);
        updateSubmenu.add(usi);
        usi = new JMenuItem("0.3 sec");
        usi.addActionListener(usal);
        updateSubmenu.add(usi);
        usi = new JMenuItem("0.1 sec");
        usi.addActionListener(usal);
        updateSubmenu.add(usi);
        this.popupAxis.add(updateSubmenu);
        this.popupChannelEvt = new JMenuItem("Event Control Panel (DAQ)");
        this.popupChannelEvt.setForeground(Color.BLUE);
        this.popupChannelEvt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String str = e.getActionCommand();
                if (DOOCSPlot.this.evtPanel == null) {
                    DOOCSPlot.this.evtPanel = new EventNumberDialog((Frame)DOOCSParameter.getParentFrame(pl), false, pl);
                }
                pl.doocsPlotSelection.eventDialog = DOOCSPlot.this.evtPanel;
                DOOCSPlot.this.evtPanel.setDefaultCloseOperation(2);
                DOOCSPlot.this.evtPanel.setTitle("DAQ: set actual event/time");
                DOOCSPlot.this.evtPanel.setVisible(true);
            }
        });
        this.popupAxis.add(this.popupChannelEvt);
    }

    private void createMenuSelection() {
        final DOOCSPlot pl = this;
        this.popupSelection = new JPopupMenu();
        this.popupSelection.setName("Selection Menu");
        ImageIcon deleteIcon = new ImageIcon(this.getClass().getResource("icons/delete.gif"));
        JMenuItem mis = new JMenuItem("Delete Selection", deleteIcon);
        mis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean flag = DOOCSPlot.this.doocsPlotSelection.isActive();
                DOOCSPlot.this.doocsPlotSelection.setActive(false);
                if (flag) {
                    DOOCSPlot.this.doocsAdrList.paintMathFct(pl.getGraphics(), DOOCSPlot.this.doocsPlotAxisX, DOOCSPlot.this.doocsPlotAxisY);
                }
                DOOCSPlot.this.repaint();
            }
        });
        this.popupSelection.add(mis);
        ImageIcon mathIcon = new ImageIcon(this.getClass().getResource("icons/Math_icon.gif"));
        JMenu mmi = new JMenu("Math Functions");
        JMenuItem mmsi = new JMenuItem("Off");
        mmsi.addActionListener(this.mathActListner);
        mmi.add(mmsi);
        mmsi = new JMenuItem("RMS");
        mmsi.addActionListener(this.mathActListner);
        mmi.add(mmsi);
        mmsi = new JMenuItem("Mean, StdDiv.");
        mmsi.addActionListener(this.mathActListner);
        mmi.add(mmsi);
        mmsi = new JMenuItem("MinMax");
        mmsi.addActionListener(this.mathActListner);
        mmi.add(mmsi);
        mmsi = new JMenuItem("Fit Line");
        mmsi.addActionListener(this.mathActListner);
        mmi.add(mmsi);
        if (this.plotType == PlotType.PLOTSPECTRUM) {
            mmsi = new JMenuItem("Fourier Transform (selected X range)");
            mmsi.addActionListener(this.mathActListner);
            mmi.add(mmsi);
        }
        mmsi = new JMenuItem("Histogram");
        mmsi.addActionListener(this.mathActListner);
        mmi.add(mmsi);
        this.popupSelection.add(mmi);
        if (this.plotType == PlotType.PLOTHIST) {
            mmsi = new JMenuItem("Set global Time Range");
            mmsi.addActionListener(this.mathActListner);
            this.popupSelection.add(mmsi);
        }
        if (this.plotType == PlotType.PLOTSPECTRUM) {
            mmsi = new JMenuItem("Set global Range of Samples");
            mmsi.addActionListener(this.mathActListner);
            this.popupSelection.add(mmsi);
        }
    }

    protected void createMenuChannel() {
        this.popupChannel = new JPopupMenu();
        this.popupChannel.setLabel("Channel Menu:");
        final DOOCSPlot pl = this;
        ImageIcon autoScaleIcon = new ImageIcon(this.getClass().getResource("icons/autoscale.gif"));
        JMenuItem mi = new JMenuItem("Auto Scale", autoScaleIcon);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean flag = DOOCSPlot.this.autoScaleX();
                DOOCSPlot.this.doocsPlotAxisX.autoScale = true;
                DOOCSPlot.this.doocsPlotAxisY.autoScale = true;
                if (flag |= DOOCSPlot.this.autoScaleY()) {
                    DOOCSPlot.this.boundsNeedsUpdate = true;
                    DOOCSPlot.this.repaint();
                }
            }
        });
        this.popupChannel.add(mi);
        this.popupChannelMIAdr = new JMenuItem("Address");
        this.popupChannelMIAdr.setBackground(Color.LIGHT_GRAY);
        this.popupChannel.add(this.popupChannelMIAdr);
        this.popupChannelMIDescr = new JMenuItem("Description");
        this.popupChannelMIDescr.setBackground(Color.LIGHT_GRAY);
        this.popupChannel.add(this.popupChannelMIDescr);
        this.popupChannel.addSeparator();
        JMenu popupChannelMI3submenu = new JMenu("Colors");
        ActionListener colAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DOOCSPlot.this.selectedChannel != null) {
                    String str = e.getActionCommand();
                    if (str.startsWith("Blue")) {
                        DOOCSPlot.this.selectedChannel.setLineColor(Color.BLUE);
                    }
                    if (str.startsWith("Cyan")) {
                        DOOCSPlot.this.selectedChannel.setLineColor(Color.CYAN);
                    }
                    if (str.startsWith("Black")) {
                        DOOCSPlot.this.selectedChannel.setLineColor(Color.BLACK);
                    }
                    if (str.startsWith("Dark Gray")) {
                        DOOCSPlot.this.selectedChannel.setLineColor(Color.DARK_GRAY);
                    }
                    if (str.startsWith("Light Gray")) {
                        DOOCSPlot.this.selectedChannel.setLineColor(Color.LIGHT_GRAY);
                    }
                    if (str.startsWith("Gray")) {
                        DOOCSPlot.this.selectedChannel.setLineColor(Color.GRAY);
                    }
                    if (str.startsWith("Green")) {
                        DOOCSPlot.this.selectedChannel.setLineColor(Color.GREEN);
                    }
                    if (str.startsWith("Magenta")) {
                        DOOCSPlot.this.selectedChannel.setLineColor(Color.MAGENTA);
                    }
                    if (str.startsWith("Orange")) {
                        DOOCSPlot.this.selectedChannel.setLineColor(Color.ORANGE);
                    }
                    if (str.startsWith("Pink")) {
                        DOOCSPlot.this.selectedChannel.setLineColor(Color.PINK);
                    }
                    if (str.startsWith("Red")) {
                        DOOCSPlot.this.selectedChannel.setLineColor(Color.RED);
                    }
                    if (str.startsWith("White")) {
                        DOOCSPlot.this.selectedChannel.setLineColor(Color.WHITE);
                    }
                    if (str.startsWith("Yellow")) {
                        DOOCSPlot.this.selectedChannel.setLineColor(Color.YELLOW);
                    }
                    DOOCSPlot.this.repaint();
                }
            }
        };
        JMenuItem cmi = new JMenuItem("Blue");
        cmi.addActionListener(colAction);
        popupChannelMI3submenu.add(cmi);
        cmi = new JMenuItem("Cyan");
        cmi.addActionListener(colAction);
        popupChannelMI3submenu.add(cmi);
        cmi = new JMenuItem("Black");
        cmi.addActionListener(colAction);
        popupChannelMI3submenu.add(cmi);
        cmi = new JMenuItem("Dark Gray");
        cmi.addActionListener(colAction);
        popupChannelMI3submenu.add(cmi);
        cmi = new JMenuItem("Light Gray");
        cmi.addActionListener(colAction);
        popupChannelMI3submenu.add(cmi);
        cmi = new JMenuItem("Gray");
        cmi.addActionListener(colAction);
        popupChannelMI3submenu.add(cmi);
        cmi = new JMenuItem("Green");
        cmi.addActionListener(colAction);
        popupChannelMI3submenu.add(cmi);
        cmi = new JMenuItem("Magenta");
        cmi.addActionListener(colAction);
        popupChannelMI3submenu.add(cmi);
        cmi = new JMenuItem("Orange");
        cmi.addActionListener(colAction);
        popupChannelMI3submenu.add(cmi);
        cmi = new JMenuItem("Pink");
        cmi.addActionListener(colAction);
        popupChannelMI3submenu.add(cmi);
        cmi = new JMenuItem("Red");
        cmi.addActionListener(colAction);
        popupChannelMI3submenu.add(cmi);
        cmi = new JMenuItem("White");
        cmi.addActionListener(colAction);
        popupChannelMI3submenu.add(cmi);
        cmi = new JMenuItem("Yellow");
        cmi.addActionListener(colAction);
        popupChannelMI3submenu.add(cmi);
        this.popupChannel.add(popupChannelMI3submenu);
        JMenu popupChannelMI4 = new JMenu("Stroke size");
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DOOCSPlot.this.selectedChannel != null) {
                    DOOCSPlot.this.selectedChannel.setStrokeSize(IntegerParser.parseInt(e.getActionCommand()));
                }
                DOOCSPlot.this.repaint();
            }
        };
        cmi = new JMenuItem("1");
        ((Container)popupChannelMI4).add(cmi);
        cmi.addActionListener(al);
        cmi = new JMenuItem("2");
        ((Container)popupChannelMI4).add(cmi);
        cmi.addActionListener(al);
        cmi = new JMenuItem("3");
        ((Container)popupChannelMI4).add(cmi);
        cmi.addActionListener(al);
        cmi = new JMenuItem("4");
        ((Container)popupChannelMI4).add(cmi);
        cmi.addActionListener(al);
        cmi = new JMenuItem("6");
        ((Container)popupChannelMI4).add(cmi);
        cmi.addActionListener(al);
        cmi = new JMenuItem("8");
        ((Container)popupChannelMI4).add(cmi);
        cmi.addActionListener(al);
        this.popupChannel.add(popupChannelMI4);
        JMenu popupChannelMI5 = new JMenu("Math (all visible data points)");
        JMenuItem mathMenu = new JMenuItem("Off");
        mathMenu.addActionListener(this.mathActListner);
        popupChannelMI5.add(mathMenu);
        mathMenu = new JMenuItem("RMS");
        mathMenu.addActionListener(this.mathActListner);
        popupChannelMI5.add(mathMenu);
        mathMenu = new JMenuItem("Mean, StdDiv.");
        mathMenu.addActionListener(this.mathActListner);
        popupChannelMI5.add(mathMenu);
        mathMenu = new JMenuItem("MinMax");
        mathMenu.addActionListener(this.mathActListner);
        popupChannelMI5.add(mathMenu);
        mathMenu = new JMenuItem("Fit Line");
        mathMenu.addActionListener(this.mathActListner);
        popupChannelMI5.add(mathMenu);
        if (this.plotType == PlotType.PLOTSPECTRUM) {
            mathMenu = new JMenuItem("Fourier Transform");
            mathMenu.addActionListener(this.mathActListner);
            popupChannelMI5.add(mathMenu);
        }
        mathMenu = new JMenuItem("Histogram");
        mathMenu.addActionListener(this.mathActListner);
        popupChannelMI5.add(mathMenu);
        this.popupChannel.add(popupChannelMI5);
        ImageIcon dataTipIcon = new ImageIcon(this.getClass().getResource("icons/dataTip16.gif"));
        JMenuItem dataTipMenu = new JMenuItem("add a Data Tip (not saved!)", dataTipIcon);
        dataTipMenu.setForeground(Color.GRAY);
        dataTipMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String inputValue = JOptionPane.showInputDialog("Please enter a message for the data point");
                if (DOOCSPlot.this.selectedChannel != null && inputValue != null) {
                    DOOCSPlot.this.selectedChannel.infoTip.add(DOOCSPlot.this.mouseClosestRealX, DOOCSPlot.this.mouseClosestRealY, inputValue);
                }
                DOOCSPlot.this.setShowDataTip(true);
                DOOCSPlot.this.repaint();
            }
        });
        this.popupChannel.add(dataTipMenu);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("icons/print.jpg"));
        JMenuItem printMenu = new JMenuItem("Print data --> console", icon);
        printMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DOOCSPlot.this.selectedChannel != null) {
                    DOOCSPlot.this.selectedChannel.print("dummy");
                }
            }
        });
        this.popupChannel.add(printMenu);
        this.popupChannel.addSeparator();
        this.popupChannelDaq = new JMenu("DAQ Menu");
        JMenuItem popupChannelDaqItem = new JMenuItem("Plot TimeDomain from DAQ");
        this.popupChannelDaq.add(popupChannelDaqItem);
        if (this.doocsPlotSelection.isGlobalTimeRangeDefined()) {
            popupChannelDaqItem.setForeground(Color.BLUE);
        } else {
            popupChannelDaqItem.setForeground(Color.LIGHT_GRAY);
            popupChannelDaqItem.setText("Plot from DAQ: set time Range first!");
            popupChannelDaqItem.setEnabled(false);
        }
        popupChannelDaqItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DOOCSPlotWindow.showDaq("daq:" + DOOCSPlot.this.daqAddress, pl);
            }
        });
        popupChannelDaqItem = new JMenuItem("Plot channel History");
        this.popupChannelDaq.add(popupChannelDaqItem);
        if (this.doocsPlotSelection.isGlobalTimeRangeDefined()) {
            popupChannelDaqItem.setForeground(Color.BLUE);
        } else {
            popupChannelDaqItem.setForeground(Color.LIGHT_GRAY);
            popupChannelDaqItem.setText("Plot History from DAQ: set time Range first!");
            popupChannelDaqItem.setEnabled(false);
        }
        popupChannelDaqItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DOOCSPlotWindow.showDaqHist("daq:" + DOOCSPlot.this.daqAddress, pl);
            }
        });
        if (this.selectedChannel != null && this.selectedChannel.dataContainer != null && this.selectedChannel.dataContainer.chDataType == 11) {
            ButtonGroup typeGroup = new ButtonGroup();
            ActionListener daqItemAL = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().startsWith("Default")) {
                        DOOCSPlot.this.selectedChannel.dataContainer.dispMode = DOOCSDataContainer.ChanDisplayMode.DISP_DEFAULT;
                    } else if (e.getActionCommand().startsWith("Amplitude")) {
                        DOOCSPlot.this.selectedChannel.dataContainer.dispMode = DOOCSDataContainer.ChanDisplayMode.DISP_AMPL;
                    } else if (e.getActionCommand().startsWith("Phase")) {
                        DOOCSPlot.this.selectedChannel.dataContainer.dispMode = DOOCSDataContainer.ChanDisplayMode.DISP_PHASE;
                    } else if (e.getActionCommand().startsWith("I")) {
                        DOOCSPlot.this.selectedChannel.dataContainer.dispMode = DOOCSDataContainer.ChanDisplayMode.DISP_I;
                    } else if (e.getActionCommand().startsWith("Q")) {
                        DOOCSPlot.this.selectedChannel.dataContainer.dispMode = DOOCSDataContainer.ChanDisplayMode.DISP_Q;
                    }
                }
            };
            boolean flagA = this.selectedChannel.dataContainer.dispMode == DOOCSDataContainer.ChanDisplayMode.DISP_AMPL;
            boolean flagP = this.selectedChannel.dataContainer.dispMode == DOOCSDataContainer.ChanDisplayMode.DISP_PHASE;
            boolean flagQ = this.selectedChannel.dataContainer.dispMode == DOOCSDataContainer.ChanDisplayMode.DISP_Q;
            boolean flagI = !(flagP | flagA | flagQ);
            popupChannelDaqItem = new JRadioButtonMenuItem("Amplitude", flagA);
            typeGroup.add(popupChannelDaqItem);
            this.popupChannel.add(popupChannelDaqItem);
            popupChannelDaqItem.addActionListener(daqItemAL);
            popupChannelDaqItem = new JRadioButtonMenuItem("Phase", flagP);
            typeGroup.add(popupChannelDaqItem);
            this.popupChannel.add(popupChannelDaqItem);
            popupChannelDaqItem.addActionListener(daqItemAL);
            popupChannelDaqItem = new JRadioButtonMenuItem("I", flagI);
            typeGroup.add(popupChannelDaqItem);
            this.popupChannel.add(popupChannelDaqItem);
            popupChannelDaqItem.addActionListener(daqItemAL);
            popupChannelDaqItem = new JRadioButtonMenuItem("Q", flagQ);
            typeGroup.add(popupChannelDaqItem);
            this.popupChannel.add(popupChannelDaqItem);
            popupChannelDaqItem.addActionListener(daqItemAL);
        }
        this.popupChannelEvt = new JMenuItem("Event Control Panel");
        this.popupChannelDaq.add(this.popupChannelEvt);
        this.popupChannelEvt.setForeground(Color.BLUE);
        this.popupChannelEvt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String str = e.getActionCommand();
                if (DOOCSPlot.this.evtPanel == null) {
                    DOOCSPlot.this.evtPanel = new EventNumberDialog((Frame)DOOCSParameter.getParentFrame(pl), false, pl);
                }
                pl.doocsPlotSelection.eventDialog = DOOCSPlot.this.evtPanel;
                DOOCSPlot.this.evtPanel.setDefaultCloseOperation(2);
                DOOCSPlot.this.evtPanel.setTitle("DAQ: set actual event/time");
                DOOCSPlot.this.evtPanel.setVisible(true);
            }
        });
        this.popupChannel.add(this.popupChannelDaq);
    }

    public static enum PlotType {
        PLOTUNDEF,
        PLOTSPECTRUM,
        PLOTHIST,
        PLOTLOCATION,
        PLOTXY,
        PLOTDFTREF,
        PLOTHISTOGRAMREF;

    }

    public static enum MouseStatus {
        OUTSIDE,
        ONDATA,
        ONLEGEND,
        ONSELECTION,
        ONSELECTION_N,
        ONSELECTION_S,
        ONSELECTION_W,
        ONSELECTION_E,
        ONTITLE,
        ONXAXIS,
        ONYAXIS,
        ATXAXIS,
        ATYAXIS,
        ONDATATIP;

    }
}

