/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSPlot.DOOCSChannel;
import DOOCSPlot.DOOCSDataContainer;
import DOOCSPlot.DOOCSPlotAxis;
import daq.DAQeqData;
import daq.DAQeqResult;
import daq.DAQgetOptions;
import daq.EqDataCache;
import daq.EqDataCacheEntry;
import daq.EventUtil;
import daq.time_stamp;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqData;
import ttf.doocs.clnt.time_t;

public class DOOCSDataContainerSpectDAQ
extends DOOCSDataContainer {
    protected EqAdr ea;
    protected EqData ed;
    protected String daqName;
    protected String expName = "Linac";
    protected String dirName = "";
    int maxLength = 0x100000;
    int defaultLength = 2048;
    float[] dataArray;
    float[] dataArray2;
    byte[] dataComment = new byte[80];
    int[] dataLength = new int[2];
    float[] dataInc = new float[2];
    int[] dataStatus = new int[1];
    time_t[] dataTime = new time_t[1];
    int startT = 0;
    int stopT = 0;
    protected Color bgColor;
    public static final double RAD2DEG = 57.29578;
    DAQeqData daqData;
    int daqStatus;
    int daqStatusOld;
    int actEventNo = 0;
    int prevEventNo = 0;
    double oldActualTime = 0.0;
    int dataAccessMode;
    time_stamp time = new time_stamp();
    boolean cacheReady;
    private boolean initDone = false;
    private static Integer lock = 0;
    private int localLock = 0;
    EventUtil ev_util;

    public DOOCSDataContainerSpectDAQ(DOOCSChannel ch, String name) {
        super(ch);
        this.channel = ch;
        this.daqName = name;
        this.color = new Color(0, 0, 0);
        this.bgColor = new Color(128, 128, 128, 60);
        this.pt = new Point();
        this.ea = new EqAdr(ch.doocsAdr);
        this.ed = new EqData();
        this.data = new EqData();
        this.eq = new EqCall();
        this.dataLength[0] = 80;
        this.dataLength[1] = this.defaultLength;
        this.dataTime[0] = new time_t();
        this.dataInc[0] = 0.0f;
        this.dataInc[1] = 1.0f;
        this.errorMsg = "DAQ: waiting ...";
    }

    private void createDataCache(int startT, int stopT, String exp) {
        String[] chans = new String[]{this.daqName};
        String badSolution = "/daq/ttf2_ext/LINAC";
        this.daqData = new DAQeqData(chans, startT, stopT, exp, badSolution);
        this.cacheReady = false;
        this.prevEventNo = this.channel.plot.doocsPlotSelection.getEventActual();
        this.ev_util = new EventUtil();
        this.dataAccessMode = 2;
        this.errorMsg = "DAQ: waiting for data...";
        this.channel.chanErrorMsg = "DAQ: waiting for data...";
        if (this.daqData.start_receiver()) {
            this.errorMsg = "Problems with start_receiver():";
        }
    }

    public void readEGU() {
        if (this.channel.doocsReadEGU) {
            String xeguText = "";
            this.descriptionMsg = this.daqName;
            this.channel.plot.doocsPlotAxisX.eguText = xeguText;
        }
    }

    @Override
    public boolean update() {
        boolean wait = true;
        if (this.channel == null) {
            this.channel.chanErrorMsg = this.errorMsg = "Internal ERROR! No channel defined";
            return false;
        }
        if (!this.initDone) {
            if (this.channel.plot.doocsPlotSelection.isGlobalTimeRangeDefined()) {
                this.startT = (int)this.channel.plot.doocsPlotSelection.getGlobalTimeRangeMin();
                this.stopT = (int)this.channel.plot.doocsPlotSelection.getGlobalTimeRangeMax();
                this.createDataCache(this.startT, this.stopT, "linac");
                this.initDone = true;
            }
            this.hasData = false;
            return false;
        }
        if (this.startT != (int)this.channel.plot.doocsPlotSelection.getGlobalTimeRangeMin() || this.stopT != (int)this.channel.plot.doocsPlotSelection.getGlobalTimeRangeMax()) {
            this.hasData = false;
            this.initDone = false;
        }
        if (this.firstRead) {
            this.readEGU();
            this.firstRead = false;
        }
        int status = this.daqData.status();
        if (status == 3) {
            this.errorMsg = this.daqData.get_reply();
            this.hasData = false;
        } else if (status == 5) {
            this.errorMsg = this.daqData.connect_status_string();
            this.hasData = false;
        } else if (status == 4) {
            this.errorMsg = "Error: Status unknown";
            this.hasData = false;
        } else if (status == 1) {
            this.errorMsg = "...";
            this.hasData = false;
        } else if (status == 2) {
            this.errorMsg = "DAQ: receiving data...";
            this.hasData = true;
        } else if (status == 0) {
            this.channel.chanErrorMsg = null;
            this.hasData = true;
        } else {
            this.hasData = false;
        }
        if (this.hasData) {
            if (!this.cacheReady) {
                int[] ev_num;
                boolean hasNoCache;
                if (status != 2 && !(hasNoCache = this.daqData.get_monitor(ev_num = new int[2], 0))) {
                    this.channel.plot.doocsPlotSelection.setEventFirst(ev_num[0]);
                    this.daqData.get_monitor(ev_num, 1);
                    this.channel.plot.doocsPlotSelection.setEventLast(ev_num[0]);
                    this.cacheReady = true;
                    this.dataAccessMode = 4;
                    int evt = this.channel.plot.doocsPlotSelection.getEventActual();
                    if (evt == 0) {
                        this.channel.plot.doocsPlotSelection.setEventActual((this.channel.plot.doocsPlotSelection.getEventFirst() + this.channel.plot.doocsPlotSelection.getEventLast()) / 2);
                    }
                }
            }
            if (this.dataAccessMode != 4 || this.prevEventNo == 0 || this.channel.plot.doocsPlotSelection.getEventActual() != this.prevEventNo) {
                int optext;
                DAQgetOptions opt = new DAQgetOptions();
                int evt = this.channel.plot.doocsPlotSelection.getEventActual();
                if (evt != 0 && evt != this.prevEventNo) {
                    optext = 1024;
                    opt.set_evnum(evt);
                } else {
                    optext = 512;
                    double d = this.channel.plot.doocsPlotSelection.getGlobalTimeActual();
                    double dUp = Math.floor(d);
                    this.time.set_time((int)dUp, (int)(d - dUp) * 1000);
                    opt.set_time(this.time);
                }
                opt.access = this.dataAccessMode | optext;
                DAQeqResult out = null;
                int subch = 1;
                int devtype = 0;
                opt.set_channel(this.daqName);
                out = this.daqData.get_monitor(opt);
                if ((out.status & 1) != 0 && out.rec != null) {
                    if (out.rec.size() > 0) {
                        EqDataCacheEntry cacheEntry = (EqDataCacheEntry)out.rec.entry.get(0);
                        this.data = cacheEntry.data.data;
                        this.chDataType = cacheEntry.data.dtype;
                        devtype = cacheEntry.data.devtype;
                        int i = this.data.error();
                        int len = this.data.array_length();
                        if (len > this.maxLength) {
                            len = this.maxLength;
                        }
                        try {
                            this.actEventNo = out.rec.event_number;
                            String evtTime = out.rec.get_time_string();
                            String comm = "No comment";
                            switch (this.data.type()) {
                                case 1013: {
                                    subch = this.ev_util.get_channel_number(this.chDataType) - 1;
                                    subch = 0;
                                    int l = this.data.array_length(0);
                                    this.dataArray = new float[l];
                                    int code = this.data.get_ts_spectrum(this.dataComment, this.dataLength, this.dataInc, this.dataStatus, this.dataTime, this.dataArray, subch);
                                    comm = new String(this.dataComment).trim();
                                    if (this.chDataType != 11) break;
                                    l = this.data.array_length(1);
                                    this.dataArray2 = new float[l];
                                    code = this.data.get_ts_spectrum(this.dataComment, this.dataLength, this.dataInc, this.dataStatus, this.dataTime, this.dataArray2, 1);
                                    break;
                                }
                                case 103: {
                                    subch = 1;
                                    comm = this.data.get_string_arg(0);
                                    this.dataComment = comm.getBytes();
                                    this.dataLength[0] = comm.length();
                                    this.dataLength[1] = 1;
                                    this.dataInc[0] = 1.0f;
                                    this.dataInc[0] = 1.0f;
                                    this.dataStatus[0] = this.data.error();
                                    long tm = this.data.get_time(0) / 1000L;
                                    this.dataTime[0] = new time_t((int)tm);
                                    this.dataArray = new float[1];
                                    this.dataArray[0] = this.data.get_float(1);
                                }
                            }
                            switch (this.dispMode) {
                                case DISP_AMPL: {
                                    this.descriptionMsg = this.daqName + " Ampl; T=" + evtTime;
                                    break;
                                }
                                case DISP_PHASE: {
                                    this.descriptionMsg = this.daqName + " Phase; T=" + evtTime;
                                    break;
                                }
                                case DISP_Q: {
                                    this.descriptionMsg = this.daqName + " " + this.ev_util.get_chan_name(this.chDataType, 1) + " T=" + evtTime;
                                    break;
                                }
                                default: {
                                    this.descriptionMsg = this.daqName + " " + this.ev_util.get_chan_name(this.chDataType, 0) + " T=" + evtTime;
                                }
                            }
                            if (this.actEventNo != this.prevEventNo) {
                                this.prevEventNo = this.actEventNo;
                                if (this.dataAccessMode == 4) {
                                    this.channel.plot.doocsPlotSelection.setGlobalTimeActual((double)out.rec.get_time().timeup + (double)out.rec.get_time().timelow / EqDataCache.DAQ_DATA_TIME_LOW_SCALE);
                                    this.channel.plot.doocsPlotSelection.setEventActual(this.actEventNo);
                                }
                                this.channel.plot.repaint();
                            }
                        }
                        catch (Exception e) {
                            boolean ixxx = false;
                        }
                        this.hasData = true;
                        this.errorMsg = "";
                        if ((out.status & 4) != 0 && out.rec != null && this.dataLength[0] > 0) {
                            double Tmin = this.channel.plot.doocsPlotSelection.getGlobalTimeRangeMin();
                            double Tmax = this.channel.plot.doocsPlotSelection.getGlobalTimeRangeMax();
                            double T = this.channel.plot.doocsPlotSelection.getGlobalTimeActual();
                            if (T <= Tmax && T >= Tmin) {
                                this.dataAccessMode = 4;
                            }
                            this.hasData = true;
                        }
                    } else {
                        this.hasData = false;
                        this.errorMsg = "No DAQ data";
                    }
                } else {
                    this.hasData = false;
                }
            }
        }
        this.channel.chanErrorMsg = this.errorMsg;
        this.hasNewData = this.hasData;
        return this.hasData;
    }

    @Override
    public void autoScaleX(DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        if (this.hasData && this.data.error() == 0) {
            if ((double)this.dataInc[0] < xaxis.actMin) {
                xaxis.actMin = this.dataInc[0];
            }
            try {
                if ((double)(this.dataInc[1] * (float)this.getDataLength() + this.dataInc[0]) > xaxis.actMax) {
                    xaxis.actMax = this.dataInc[1] * (float)this.getDataLength() + this.dataInc[0];
                }
            }
            catch (Exception e) {
                boolean ixxx = false;
            }
        }
    }

    @Override
    public void autoScaleY(DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        double xMin = xaxis.actMin;
        double xMax = xaxis.actMax;
        if (this.hasData && this.data.error() == 0 && this.getDataLength() > 0) {
            for (int i = 0; i < this.getDataLength(); ++i) {
                double x = this.dataInc[0] + this.dataInc[1] * (float)i;
                if (x < xMin || x > xMax || yaxis.isLog && (double)((float)this.getYData(i)) <= 0.0) continue;
                if ((double)((float)this.getYData(i)) > yaxis.actMax) {
                    yaxis.actMax = (float)this.getYData(i);
                }
                if (!((double)((float)this.getYData(i)) < yaxis.actMin)) continue;
                yaxis.actMin = (float)this.getYData(i);
            }
        }
    }

    @Override
    public float[] getSelectedData() {
        return this.dataArray;
    }

    @Override
    public int getDataLength() {
        if (this.hasData && this.dataArray != null) {
            return this.dataArray.length;
        }
        return 0;
    }

    @Override
    public double getDataInc() {
        return this.dataInc[1];
    }

    @Override
    public double getDataOffset() {
        return this.dataInc[0];
    }

    @Override
    public double getYData(int idx) {
        switch (this.dispMode) {
            case DISP_Q: {
                return this.dataArray2[idx];
            }
            case DISP_AMPL: {
                double d = this.dataArray[idx] * this.dataArray[idx] + this.dataArray2[idx] * this.dataArray2[idx];
                if (d > 0.0) {
                    return Math.sqrt(d);
                }
                return 0.0;
            }
            case DISP_PHASE: {
                if ((idx & 1) == 1) {
                    return Math.atan2(-this.dataArray2[idx], -this.dataArray[idx]) * 57.29578;
                }
                return Math.atan2(this.dataArray2[idx], this.dataArray[idx]) * 57.29578;
            }
        }
        return this.dataArray[idx];
    }

    @Override
    public double getXData(int idx) {
        return this.dataInc[0] + this.dataInc[1] * (float)idx;
    }

    @Override
    public boolean hasValidData() {
        return this.hasData && this.data.error() == 0;
    }

    private void drawResult(Graphics2D g2d, String tmp, int x, int y) {
        g2d.setColor(this.color);
        g2d.drawString(tmp, x, y);
    }

    @Override
    void paintComponent(Graphics g, DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        int x2 = 0;
        int y2 = 0;
        int x0 = 0;
        double xmin = xaxis.actMin;
        double xmax = xaxis.actMax;
        Point2D.Double po = new Point2D.Double();
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform tr = this.channel.plot.doocsAdrList.transformer;
        g2d.setColor(this.channel.lineColor);
        g2d.setStroke(this.channel.strokeSize);
        Color col = this.channel.lineColor;
        int intColorFg = this.prepareDraw(g, col, tr, xaxis, yaxis);
        Rectangle clip = g.getClipBounds();
        if (this.hasData && this.data.error() == 0) {
            boolean n = false;
            if (this.getDataLength() > 0) {
                double x = this.dataInc[0];
                double y = yaxis.isLog ? Math.log10(yaxis.actMin) : 0.0;
                ((Point2D)po).setLocation(x, y);
                tr.transform(po, this.pt);
                int y0 = (int)this.pt.getY();
                if (xaxis.isLog) {
                    x = x <= 0.0 ? -20.0 : Math.log10(x);
                }
                y = this.getYData(0);
                if (yaxis.isLog) {
                    y = y <= 0.0 ? -20.0 : Math.log10(y);
                }
                this.pt_s = new Point2D.Double();
                this.pt_s.setLocation(x, y);
                tr.transform(this.pt_s, this.pt);
                int x1 = (int)this.pt.getX();
                int y1 = (int)this.pt.getY();
                for (int i = 1; i < this.getDataLength(); ++i) {
                    x = this.dataInc[0] + this.dataInc[1] * (float)i;
                    if (xaxis.isLog) {
                        x = x <= 0.0 ? -20.0 : Math.log10(x);
                    }
                    y = this.getYData(i);
                    if (yaxis.isLog) {
                        y = y <= 0.0 ? -20.0 : Math.log10(y);
                    }
                    this.pt_s.setLocation(x, y);
                    tr.transform(this.pt_s, this.pt);
                    x2 = (int)this.pt.getX();
                    y2 = (int)this.pt.getY();
                    if (!(x1 < clip.x && x2 < clip.x || x1 > clip.x + clip.width && x2 > clip.x + clip.width)) {
                        this.drawDataPoint(g2d, x1, y1, x2, y2, y0, intColorFg, false);
                    }
                    x1 = x2;
                    y1 = y2;
                    x0 = x2 - x1;
                }
                this.drawDataPoint(g2d, x1, y1, x2 + x0, y2, y0, intColorFg, false);
            }
        }
    }
}

