/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSPlot.DOOCSChannel;
import DOOCSPlot.DOOCSDataContainer;
import DOOCSPlot.DOOCSPlotAxis;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqData;
import ttf.doocs.clnt.time_t;

public class DOOCSDataContainerSpect
extends DOOCSDataContainer {
    protected EqAdr ea;
    protected EqData ed;
    int maxLength = 0x100000;
    int defaultLength = 2048;
    float[] dataArray;
    byte[] dataComment = new byte[80];
    int[] dataLength = new int[2];
    float[] dataInc = new float[2];
    int[] dataStatus = new int[1];
    time_t[] dataTime = new time_t[1];
    protected Color bgColor;

    public DOOCSDataContainerSpect(DOOCSChannel ch) {
        super(ch);
        this.channel = ch;
        this.color = new Color(0, 0, 0);
        this.bgColor = new Color(128, 128, 128, 60);
        this.pt = new Point();
        this.ea = new EqAdr(ch.doocsAdr);
        this.ed = new EqData();
        this.data = new EqData();
        this.eq = new EqCall();
        this.dataArray = new float[this.defaultLength];
        this.dataLength[0] = 80;
        this.dataLength[1] = this.defaultLength;
        this.dataTime[0] = new time_t();
        this.dataInc[0] = 0.0f;
        this.dataInc[1] = 1.0f;
    }

    public void readEGU() {
        if (this.channel.doocsReadEGU) {
            String xeguText = "";
            EqAdr eaa = new EqAdr(this.channel.doocsAdr + ".EGU");
            super.readEGU(eaa);
            this.descriptionMsg = this.channel.doocsAdr;
            eaa.adr(this.channel.doocsAdr + ".COMMENT");
            try {
                this.data.init();
                this.eq.get(eaa, this.ed, this.data);
                if (this.data.error() == 0) {
                    this.descriptionMsg = this.data.get_string_arg().trim();
                    if (this.descriptionMsg.length() < 2) {
                        this.descriptionMsg = this.channel.doocsAdr;
                    }
                } else {
                    String adr = this.ea.show_adr();
                    adr = adr.substring(adr.indexOf("/"));
                    this.descriptionMsg = adr.substring(adr.indexOf("/"));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            eaa.adr(this.channel.doocsAdr + ".XEGU");
            try {
                this.data.init();
                this.eq.get(eaa, this.ed, this.data);
                xeguText = this.data.error() == 0 ? "[" + this.data.get_string_arg().trim() + "]" : "";
            }
            catch (Exception e) {
                xeguText = "";
            }
            this.channel.plot.doocsPlotAxisX.eguText = xeguText;
        }
    }

    @Override
    public boolean update() {
        if (this.channel == null) {
            this.errorMsg = "Internal ERROR! No channel defined";
            return false;
        }
        if (this.firstRead) {
            this.readEGU();
            this.firstRead = false;
        }
        try {
            this.data.init();
            this.data.set_type(19);
            int sysMask = this.channel.plot.sysMask;
            if (sysMask != 0) {
                this.ed.set(sysMask);
            }
            int xmin = (int)this.channel.plot.doocsPlotAxisX.actMin;
            int xmax = (int)(this.channel.plot.doocsPlotAxisX.actMax + 0.5);
            int l = this.channel.plot.doocsPlotAxisX.pixelLength;
            int inc = 1;
            if ((xmax - xmin) / l > 10) {
                inc = 16;
            } else if ((xmax - xmin) / l > 2) {
                inc = 4;
            }
            int n = this.maxLength;
            if (xmax - xmin < n) {
                n = xmax - xmin + 1;
            }
            this.ed.set(-1, xmin, inc, n);
            this.eq.get(this.ea, this.ed, this.data);
            int i = this.data.error();
            int len = this.data.array_length();
            if (len > this.maxLength) {
                len = this.maxLength;
            }
            if (this.dataLength[1] < len) {
                this.dataArray = new float[len];
            }
            try {
                int code = this.data.get_spectrum(this.dataComment, this.dataLength, this.dataInc, this.dataStatus, this.dataTime, this.dataArray);
                this.channel.plot.repaint(this.channel.plot.dataAreaX0, this.channel.plot.dataAreaY0, this.channel.plot.dataAreaX1 - this.channel.plot.dataAreaX0, this.channel.plot.dataAreaY1 - this.channel.plot.dataAreaY0);
            }
            catch (Exception e) {
                boolean ixxx = false;
            }
            this.hasData = true;
            this.errorMsg = "";
        }
        catch (Exception e) {
            this.errorMsg = "Read ERROR!" + e.toString();
            this.hasData = false;
        }
        this.hasNewData = this.hasData;
        return this.hasData;
    }

    @Override
    public void autoScaleX(DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        if (this.hasData && this.data.error() == 0) {
            if ((double)this.dataInc[0] < xaxis.actMin) {
                xaxis.actMin = this.dataInc[0];
            }
            try {
                if ((double)(this.dataInc[1] * (float)this.dataLength[1] + this.dataInc[0]) > xaxis.actMax) {
                    xaxis.actMax = this.dataInc[1] * (float)this.dataLength[1] + this.dataInc[0];
                }
            }
            catch (Exception e) {
                boolean ixxx = false;
            }
        }
    }

    @Override
    public void autoScaleY(DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        double xMin = xaxis.actMin;
        double xMax = xaxis.actMax;
        if (this.hasData && this.data.error() == 0 && this.dataLength[1] > 0) {
            for (int i = 0; i < this.dataLength[1]; ++i) {
                double x = this.dataInc[0] + this.dataInc[1] * (float)i;
                if (x < xMin || x > xMax || yaxis.isLog && (double)this.dataArray[i] <= 0.0) continue;
                if ((double)this.dataArray[i] > yaxis.actMax) {
                    yaxis.actMax = this.dataArray[i];
                }
                if (!((double)this.dataArray[i] < yaxis.actMin)) continue;
                yaxis.actMin = this.dataArray[i];
            }
        }
    }

    @Override
    public float[] getSelectedData() {
        return this.dataArray;
    }

    @Override
    public int getDataLength() {
        return this.dataLength[1];
    }

    @Override
    public double getDataInc() {
        return this.dataInc[1];
    }

    @Override
    public double getDataOffset() {
        return this.dataInc[0];
    }

    @Override
    public double getYData(int idx) {
        return this.dataArray[idx];
    }

    @Override
    public double getXData(int idx) {
        return this.dataInc[0] + this.dataInc[1] * (float)idx;
    }

    @Override
    public boolean hasValidData() {
        return this.hasData && this.data.error() == 0;
    }

    private void drawResult(Graphics2D g2d, String tmp, int x, int y) {
        g2d.setColor(this.color);
        g2d.drawString(tmp, x, y);
    }

    @Override
    void paintComponent(Graphics g, DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        int x2 = 0;
        int y2 = 0;
        int x0 = 0;
        double xmin = xaxis.actMin;
        double xmax = xaxis.actMax;
        Point2D.Double po = new Point2D.Double();
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform tr = this.channel.plot.doocsAdrList.transformer;
        g2d.setColor(this.channel.lineColor);
        g2d.setStroke(this.channel.strokeSize);
        Color col = this.channel.lineColor;
        int intColorFg = this.prepareDraw(g, col, tr, xaxis, yaxis);
        Rectangle clip = g.getClipBounds();
        if (this.hasData && this.data.error() == 0) {
            String tmp;
            if (this.dataLength[0] > 0 && (tmp = new String(this.dataComment).substring(0, this.dataLength[0] - 1).trim()).length() > 0) {
                this.descriptionMsg = new String(this.dataComment).substring(0, this.dataLength[0] - 1);
            }
            boolean n = false;
            if (this.dataLength[1] > 0) {
                double x = this.dataInc[0];
                double y = yaxis.isLog ? Math.log10(yaxis.actMin) : 0.0;
                ((Point2D)po).setLocation(x, y);
                tr.transform(po, this.pt);
                int y0 = (int)this.pt.getY();
                if (xaxis.isLog) {
                    x = x <= 0.0 ? -20.0 : Math.log10(x);
                }
                y = this.dataArray[0];
                if (yaxis.isLog) {
                    y = y <= 0.0 ? -20.0 : Math.log10(y);
                }
                this.pt_s = new Point2D.Double();
                this.pt_s.setLocation(x, y);
                tr.transform(this.pt_s, this.pt);
                int x1 = (int)this.pt.getX();
                int y1 = (int)this.pt.getY();
                for (int i = 1; i < this.dataLength[1]; ++i) {
                    x = this.dataInc[0] + this.dataInc[1] * (float)i;
                    if (xaxis.isLog) {
                        x = x <= 0.0 ? -20.0 : Math.log10(x);
                    }
                    y = this.dataArray[i];
                    if (yaxis.isLog) {
                        y = y <= 0.0 ? -20.0 : Math.log10(y);
                    }
                    this.pt_s.setLocation(x, y);
                    tr.transform(this.pt_s, this.pt);
                    x2 = (int)this.pt.getX();
                    y2 = (int)this.pt.getY();
                    if (!(x1 < clip.x && x2 < clip.x || x1 > clip.x + clip.width && x2 > clip.x + clip.width)) {
                        this.drawDataPoint(g2d, x1, y1, x2, y2, y0, intColorFg, false);
                    }
                    x1 = x2;
                    y1 = y2;
                    x0 = x2 - x1;
                }
                this.drawDataPoint(g2d, x1, y1, x2 + x0, y2, y0, intColorFg, false);
            }
        }
    }
}

